/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.VirtualInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.PopupChart;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.StringUtil;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TreeSet;
import java.util.concurrent.LinkedBlockingQueue;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.Line;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.Mixer;
import javax.sound.sampled.TargetDataLine;
import javax.swing.Timer;

public class DeviceSoundcardInput
extends DeviceInterface {
    private static final String idName = "HKJ,Soundcard input,";
    private static final String longName = "Soundcard input";
    private static final String handleName = "SI";
    private NumberFormat nf;
    private final double VOLTAGE_SCALE = 1.3741;

    public DeviceSoundcardInput(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats.add(new ValueFormat("Frequency", "Hz", ValueFormat.formatD1));
        this.valueFormats.add(new ValueFormat("Vrms", "", ValueFormat.formatD3));
        this.valueFormats.add(new ValueFormat("Vpp", "", ValueFormat.formatD3));
        this.nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(5);
        this.setHandleName(handleName);
    }

    public static String name() {
        return idName;
    }

    public static String deviceName() {
        return longName;
    }

    public static String handleName() {
        return handleName;
    }

    @Override
    public String getDeviceName() {
        return longName;
    }

    @Override
    public String getDeviceId() {
        return idName;
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        this.valueNames = new ArrayList();
        this.valueNames.add("Frequency");
        this.valueNames.add("Vrms");
        this.valueNames.add("Vpp");
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUES?");
    }

    @Override
    public void resetTime() {
        ((VirtualComm)this.dt.cPort).resetTime();
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        return new VirtualComm();
    }

    public static void resetForReload() {
        VirtualInterface.idNoSeq = 0;
    }

    static enum InputPort {
        Mono,
        Left,
        Right;

    }

    private class VirtualComm
    extends VirtualInterface
    implements ActionListener {
        private long startTimeStamp = 0L;
        private int[] SupportedSampleRates = new int[]{16000, 32000, 44100, 48000, 96000, 192000};
        private int[] SupportedBitSizes = new int[]{8, 16, 24, 32};
        private Mixer.Info selectedMixer = null;
        private List<Mixer.Info> mixerList = new ArrayList<Mixer.Info>();
        private int selectedBits = 16;
        private int selectedSampleRate = 44100;
        private InputPort inputPort = InputPort.Left;
        private Recorder recorder = null;
        private Analyzer analyzer = null;
        private int overload = 0;
        private int measurementSpeed = 6;
        private boolean done = false;
        private Timer timer = null;

        VirtualComm() {
            Mixer.Info[] infoArray = AudioSystem.getMixerInfo();
            int n = infoArray.length;
            int n2 = 0;
            while (n2 < n) {
                Mixer.Info mixerInfo = infoArray[n2];
                if (this.getAudioFormat(mixerInfo).size() >= 1) {
                    this.mixerList.add(mixerInfo);
                }
                ++n2;
            }
            if (this.mixerList.size() > 0) {
                this.selectedMixer = this.mixerList.get(0);
            }
            this.timer = new Timer(100, this);
            this.timer.start();
            this.recorder = new Recorder();
            this.analyzer = new Analyzer();
            this.recordSample();
        }

        private int channels() {
            if (this.inputPort.equals((Object)InputPort.Mono)) {
                return 1;
            }
            return 2;
        }

        @Override
        public String getName() {
            return "Virtual";
        }

        @Override
        public void open() {
            super.open();
            this.resetTime();
        }

        @Override
        public void close() {
            this.done = true;
            this.analyzer.interrupt();
            this.timer.stop();
            this.timer = null;
            PopupChart.closeAll();
        }

        private int entrySize() {
            int entrySize = 0;
            switch (this.selectedBits) {
                case 8: {
                    entrySize = 1;
                    break;
                }
                case 16: {
                    entrySize = 2;
                    break;
                }
                case 24: {
                    entrySize = 3;
                    break;
                }
                case 32: {
                    entrySize = 4;
                }
            }
            if (!this.inputPort.equals((Object)InputPort.Mono)) {
                entrySize *= 2;
            }
            return entrySize;
        }

        private void sleep100() {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }

        private void recordSample() {
            this.recorder.recordConfig();
        }

        public String getAudioDeviceList() {
            StringBuilder sb = new StringBuilder();
            for (Mixer.Info mixerInfo : this.mixerList) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append("\"");
                sb.append(mixerInfo.getName());
                sb.append("\"");
            }
            return sb.toString();
        }

        public String getBitList() {
            TreeSet<Integer> audioFormats = new TreeSet<Integer>();
            for (AudioFormat af : this.getAudioFormat(this.selectedMixer)) {
                if (af.getSampleSizeInBits() == -1) continue;
                audioFormats.add(af.getSampleSizeInBits());
            }
            if (audioFormats.size() == 0) {
                int[] nArray = this.SupportedBitSizes;
                int n = this.SupportedBitSizes.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    audioFormats.add(i);
                    ++n2;
                }
            }
            StringBuilder sb = new StringBuilder();
            for (Integer i : audioFormats) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(i);
            }
            return sb.toString();
        }

        public String getSampleRateList() {
            TreeSet<Integer> sampleRates = new TreeSet<Integer>();
            for (AudioFormat af : this.getAudioFormat(this.selectedMixer)) {
                if (af.getSampleRate() == -1.0f) continue;
                sampleRates.add((int)af.getSampleRate());
            }
            if (sampleRates.size() == 0) {
                int[] nArray = this.SupportedSampleRates;
                int n = this.SupportedSampleRates.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    try {
                        if (AudioSystem.getTargetDataLine(new AudioFormat(i, this.selectedBits, this.channels(), true, true), this.selectedMixer) != null) {
                            sampleRates.add(i);
                        }
                    }
                    catch (LineUnavailableException lineUnavailableException) {}
                    ++n2;
                }
            }
            StringBuilder sb = new StringBuilder();
            for (Integer i : sampleRates) {
                if (sb.length() > 0) {
                    sb.append(" ");
                }
                sb.append(StringUtil.formatDoubleEE(i.intValue(), false));
            }
            return sb.toString();
        }

        public int getSampleRate() {
            return this.selectedSampleRate;
        }

        public void setSampleRate(int rate) {
            if (this.findFormat(rate, this.selectedBits) != null) {
                this.selectedSampleRate = rate;
                this.recordSample();
            }
        }

        public String getSelectedAudioDevice() {
            if (this.selectedMixer == null) {
                return "None";
            }
            return this.selectedMixer.getName();
        }

        public void setSelectedAudioDevice(String device) {
            for (Mixer.Info mixerInfo : this.mixerList) {
                if (!mixerInfo.getName().startsWith(device)) continue;
                this.selectedMixer = mixerInfo;
                this.recordSample();
                return;
            }
        }

        private AudioFormat findFormat(int sampleRate, int bits) {
            for (AudioFormat af : this.getAudioFormat(this.selectedMixer)) {
                if (af.getSampleSizeInBits() != -1 && af.getSampleSizeInBits() != bits || af.getSampleRate() != -1.0f && af.getSampleRate() != (float)sampleRate) continue;
                return af;
            }
            return null;
        }

        public String getBit() {
            return Integer.toString(this.selectedBits);
        }

        public void setBit(int bits) {
            if (this.findFormat(this.selectedSampleRate, bits) != null) {
                this.selectedBits = bits;
                this.recordSample();
            }
        }

        private void setinputPort(String port) {
            InputPort[] inputPortArray = InputPort.values();
            int n = inputPortArray.length;
            int n2 = 0;
            while (n2 < n) {
                InputPort op = inputPortArray[n2];
                if (op.name().equalsIgnoreCase(port)) {
                    this.inputPort = op;
                    this.recordSample();
                    return;
                }
                ++n2;
            }
        }

        private void showPopup() {
            long[] buf = this.analyzer.getLastBuffer();
            if (buf == null) {
                return;
            }
            PopupChart chart = PopupChart.getPopup("Sound input data", "Time (ms)", "Sample value");
            if (chart != null && chart.isVisible()) {
                double[][] series = new double[2][buf.length];
                int i = 0;
                while (i < buf.length) {
                    series[0][i] = (double)i / (double)this.selectedSampleRate * 1000.0;
                    series[1][i] = buf[i];
                    ++i;
                }
                chart.showData(series);
            }
        }

        private List<AudioFormat> getAudioFormat(Mixer.Info mixerInfo) {
            ArrayList<AudioFormat> list = new ArrayList<AudioFormat>();
            Line.Info[] infoArray = AudioSystem.getMixer(mixerInfo).getTargetLineInfo();
            int n = infoArray.length;
            int n2 = 0;
            while (n2 < n) {
                Line.Info lineInfo = infoArray[n2];
                if (lineInfo instanceof DataLine.Info) {
                    AudioFormat[] audioFormatArray = ((DataLine.Info)lineInfo).getFormats();
                    int n3 = audioFormatArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        AudioFormat af = audioFormatArray[n4];
                        if (!(af.getEncoding() != AudioFormat.Encoding.PCM_SIGNED || !af.isBigEndian() && af.getSampleSizeInBits() != 8 || af.getSampleSizeInBits() != 8 && af.getSampleSizeInBits() != 16 && af.getSampleSizeInBits() != 24 && af.getSampleSizeInBits() != 32)) {
                            list.add(af);
                        }
                        ++n4;
                    }
                }
                ++n2;
            }
            return list;
        }

        private synchronized void resetTime() {
            this.startTimeStamp = System.currentTimeMillis();
        }

        @Override
        public synchronized boolean write(String msg) {
            String[] items = msg.split("[ ;]");
            if (items.length == 0) {
                return true;
            }
            try {
                int i = 0;
                while (i < items.length) {
                    items[i] = items[i].trim();
                    ++i;
                }
                String cmd = items[0].toUpperCase();
                if (cmd.equals("VALUES?")) {
                    double[] v = this.analyzer.getData();
                    this.message.add(String.valueOf(DeviceSoundcardInput.this.nf.format(v[0])) + " " + DeviceSoundcardInput.this.nf.format(v[1]) + " " + DeviceSoundcardInput.this.nf.format(v[2]));
                } else if (cmd.equals("AUDIODEVICES?")) {
                    this.message.add(this.getAudioDeviceList());
                } else if (cmd.equals("SAMPLERATES?")) {
                    this.message.add(this.getSampleRateList());
                } else if (cmd.equals("SAMPLERATE?")) {
                    this.message.add(StringUtil.formatDoubleEE(this.getSampleRate(), false));
                } else if (cmd.equals("SAMPLERATE") && items.length >= 2) {
                    this.setSampleRate((int)StringUtil.parseDoubleEE(items[1]));
                } else if (cmd.equals("BITS?")) {
                    this.message.add(this.getBitList());
                } else if (cmd.equals("BIT?")) {
                    this.message.add(this.getBit());
                } else if (cmd.equals("BIT") && items.length >= 2) {
                    this.setBit(StringUtil.parseInt(items[1]));
                } else if (cmd.equals("AUDIODEVICE?")) {
                    this.message.add(this.getSelectedAudioDevice());
                } else if (cmd.equals("AUDIODEVICE") && items.length >= 2) {
                    this.setSelectedAudioDevice(items[1]);
                    this.recordSample();
                } else if (cmd.equals("VOLUME") && items.length >= 2) {
                    this.recorder.setVolume(StringUtil.parseDoubleEE(items[1]));
                } else if (cmd.equals("VOLUME?")) {
                    this.message.add(StringUtil.formatDoubleEE(this.recorder.getVolume()));
                } else if (cmd.equals("HASVOLUME?")) {
                    this.message.add(this.recorder.hasVolume() ? "1" : "0");
                } else if (cmd.equals("CHANNEL") && items.length >= 2) {
                    this.setinputPort(items[1]);
                } else if (cmd.equals("CHANNEL?")) {
                    this.message.add(this.inputPort.name());
                } else if (cmd.equals("POPUP")) {
                    this.showPopup();
                } else if (cmd.equals("SAMPLING?")) {
                    this.message.add(this.recorder.isRecording() ? "1" : "0");
                } else if (cmd.equals("OVERLOAD?")) {
                    this.message.add(Integer.toString(this.overload));
                } else if (cmd.equals("SPEED?")) {
                    this.message.add(Integer.toString(this.measurementSpeed));
                } else if (cmd.equals("SPEED") && items.length >= 2) {
                    int i2 = StringUtil.parseInt(items[1]);
                    if (i2 < 1) {
                        i2 = 1;
                    }
                    if (i2 > 20) {
                        i2 = 20;
                    }
                    this.measurementSpeed = i2;
                    this.recorder.recordConfig();
                } else if (cmd.equals("*IDN?")) {
                    this.message.add(DeviceSoundcardInput.idName);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
        }

        private class Analyzer
        extends Thread {
            private LinkedBlockingQueue<byte[]> queue = new LinkedBlockingQueue();
            private double vrms = 0.0;
            private double vpp = 0.0;
            private double vfreq = 0.0;
            private long[] lastBuffer = null;

            Analyzer() {
                this.setDaemon(true);
                this.setPriority(6);
                this.setName("SI Analyzer");
                this.start();
            }

            public void addData(byte[] buffer) {
                this.queue.clear();
                this.queue.add(buffer);
            }

            private long[] sampleToLong(byte[] record) {
                int entrySize = VirtualComm.this.entrySize();
                long[] buffer = new long[record.length / entrySize];
                int i = 0;
                int j = 0;
                while (j < record.length / entrySize) {
                    long v = 0L;
                    block0 : switch (VirtualComm.this.selectedBits) {
                        case 8: {
                            switch (VirtualComm.this.inputPort) {
                                case Mono: {
                                    v = record[i++];
                                    break;
                                }
                                case Left: {
                                    v = record[i++];
                                    ++i;
                                    break;
                                }
                                case Right: {
                                    int n = ++i;
                                    ++i;
                                    v = record[n];
                                }
                            }
                            break;
                        }
                        case 16: {
                            switch (VirtualComm.this.inputPort) {
                                case Mono: {
                                    v = record[i++] << 8 | record[i++] & 0xFF;
                                    break;
                                }
                                case Left: {
                                    v = record[i++] << 8 | record[i++] & 0xFF;
                                    i += 2;
                                    break;
                                }
                                case Right: {
                                    i += 2;
                                    v = record[i++] << 8 | record[i++] & 0xFF;
                                }
                            }
                            break;
                        }
                        case 24: {
                            switch (VirtualComm.this.inputPort) {
                                case Mono: {
                                    v = (long)record[i++] << 16 | (long)((record[i++] & 0xFF) << 8) | (long)(record[i++] & 0xFF);
                                    break;
                                }
                                case Left: {
                                    v = (long)record[i++] << 16 | (long)((record[i++] & 0xFF) << 8) | (long)(record[i++] & 0xFF);
                                    i += 3;
                                    break;
                                }
                                case Right: {
                                    i += 3;
                                    v = (long)record[i++] << 16 | (long)((record[i++] & 0xFF) << 8) | (long)(record[i++] & 0xFF);
                                }
                            }
                            break;
                        }
                        case 32: {
                            switch (VirtualComm.this.inputPort) {
                                case Mono: {
                                    v = (long)record[i++] << 24 | (long)((record[i++] & 0xFF) << 16) | (long)((record[i++] & 0xFF) << 8) | (long)(record[i++] & 0xFF);
                                    break block0;
                                }
                                case Left: {
                                    v = (long)record[i++] << 24 | (long)((record[i++] & 0xFF) << 16) | (long)((record[i++] & 0xFF) << 8) | (long)(record[i++] & 0xFF);
                                    i += 4;
                                    break block0;
                                }
                                case Right: {
                                    i += 4;
                                    v = (long)record[i++] << 24 | (long)((record[i++] & 0xFF) << 16) | (long)((record[i++] & 0xFF) << 8) | (long)(record[i++] & 0xFF);
                                }
                            }
                        }
                    }
                    buffer[j] = v;
                    ++j;
                }
                return buffer;
            }

            private synchronized void setData(double vfreq, double vrms, double vpp) {
                this.vfreq = vfreq;
                this.vrms = vrms;
                this.vpp = vpp;
            }

            public synchronized double[] getData() {
                return new double[]{this.vfreq, this.vrms, this.vpp};
            }

            private synchronized void setLastBuffer(long[] lastBuffer) {
                this.lastBuffer = lastBuffer;
            }

            public synchronized long[] getLastBuffer() {
                return this.lastBuffer;
            }

            private void processData(long[] data) {
                this.setLastBuffer(data);
                long min = Long.MAX_VALUE;
                long max = Long.MIN_VALUE;
                long range = (long)(Math.pow(2.0, VirtualComm.this.selectedBits - 1) - 1.0);
                double sq = 0.0;
                int i = 0;
                while (i < data.length) {
                    long v = data[i];
                    if (v < min) {
                        min = v;
                    }
                    if (v > max) {
                        max = v;
                    }
                    ++i;
                }
                long m = (min + max) / 2L;
                long r = (max - min) / 10L;
                if (r < 3L) {
                    r = 3L;
                }
                long low = m - r;
                long high = m + r;
                ArrayList<Integer> zeros = new ArrayList<Integer>();
                boolean arm = false;
                int i2 = 0;
                while (i2 < data.length) {
                    long v = data[i2];
                    if (v < low) {
                        arm = true;
                    }
                    if (v > high) {
                        if (arm) {
                            zeros.add(i2);
                        }
                        arm = false;
                    }
                    ++i2;
                }
                double vfreq = 0.0;
                if (zeros.size() > 2) {
                    int first = (Integer)zeros.get(0);
                    int last = (Integer)zeros.get(zeros.size() - 1);
                    int i3 = first;
                    while (i3 < last) {
                        long v = data[i3];
                        sq += (double)v * (double)v;
                        ++i3;
                    }
                    sq /= (double)(last - first);
                    double period = (double)(last - first) / (double)(zeros.size() - 1);
                    vfreq = (double)VirtualComm.this.selectedSampleRate / period;
                } else {
                    int i4 = 0;
                    while (i4 < data.length) {
                        long v = data[i4];
                        sq += (double)v * (double)v;
                        ++i4;
                    }
                    sq /= (double)data.length;
                }
                if ((double)max > (double)range * 0.95 || (double)min < (double)(-range) * 0.95) {
                    VirtualComm.this.overload = 2;
                } else if ((double)max > (double)range * 0.8 || (double)min < (double)(-range) * 0.8) {
                    VirtualComm.this.overload = 1;
                } else {
                    VirtualComm.this.overload = 0;
                }
                double vpp = (double)(max - min) / (double)range * 1.3741;
                double vrms = Math.sqrt(sq) / (double)range * 1.3741;
                this.setData(vfreq, vrms, vpp);
            }

            @Override
            public void run() {
                while (!VirtualComm.this.done) {
                    try {
                        byte[] data = this.queue.take();
                        this.processData(this.sampleToLong(data));
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        private class Recorder
        extends Thread {
            private byte[] inputByteData = null;
            private TargetDataLine line = null;
            private int bufferIndex = 0;
            private int currentBits = 0;
            private int currentSampleRate = 0;
            private int currentChannels = 1;
            private Mixer.Info currentMixer = null;
            private boolean failed = false;
            private double volume = 0.0;
            private boolean hasVolume = false;
            private int currentMeasurementSpeed = 0;
            private long lastSample;

            Recorder() {
                this.setDaemon(true);
                this.setPriority(10);
                this.setName("SI Recorder");
                this.start();
            }

            public boolean hasVolume() {
                return this.hasVolume;
            }

            public boolean isRecording() {
                return this.line != null && this.line.isOpen() && !this.failed;
            }

            public synchronized void setVolume(double volume) {
                this.volume = volume;
                try {
                    if (this.line != null && this.line.isOpen()) {
                        Mixer mixer;
                        FloatControl control = (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
                        if (control == null && (mixer = AudioSystem.getMixer(VirtualComm.this.selectedMixer)) != null && mixer.isOpen()) {
                            control = (FloatControl)mixer.getControl(FloatControl.Type.MASTER_GAIN);
                        }
                        if (control != null) {
                            control.setValue((float)volume);
                        }
                        this.hasVolume = control != null;
                    }
                }
                catch (Exception exception) {}
            }

            public synchronized double getVolume() {
                try {
                    if (this.line != null && this.line.isOpen()) {
                        Mixer mixer;
                        FloatControl control = (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
                        if (control == null && (mixer = AudioSystem.getMixer(VirtualComm.this.selectedMixer)) != null && mixer.isOpen()) {
                            control = (FloatControl)mixer.getControl(FloatControl.Type.MASTER_GAIN);
                        }
                        if (control != null) {
                            this.volume = control.getValue();
                        }
                        this.hasVolume = control != null;
                    }
                }
                catch (Exception exception) {}
                return this.volume;
            }

            void recordConfig() {
                if ((VirtualComm.this.selectedSampleRate != this.currentSampleRate || VirtualComm.this.selectedBits != this.currentBits || VirtualComm.this.channels() != this.currentChannels || !VirtualComm.this.selectedMixer.equals(this.currentMixer) || this.currentMeasurementSpeed != VirtualComm.this.measurementSpeed) && this.line != null && this.line.isOpen()) {
                    this.line.close();
                }
                this.failed = false;
            }

            private void fillBuffer() {
                try {
                    int n = this.line.available();
                    if (n > 0) {
                        this.lastSample = System.currentTimeMillis();
                        if (this.bufferIndex + n > this.inputByteData.length) {
                            n = this.inputByteData.length - this.bufferIndex;
                        }
                        this.line.read(this.inputByteData, this.bufferIndex, n);
                        this.bufferIndex += n;
                        if (this.bufferIndex >= this.inputByteData.length) {
                            VirtualComm.this.analyzer.addData(this.inputByteData);
                            this.inputByteData = new byte[this.inputByteData.length];
                            this.bufferIndex = 0;
                        }
                    } else {
                        Thread.sleep(10L);
                    }
                    if (System.currentTimeMillis() - this.lastSample > 2000L) {
                        this.line.close();
                    }
                }
                catch (Exception e) {
                    this.bufferIndex = 0;
                    e.printStackTrace(System.out);
                }
            }

            private synchronized void setup() {
                AudioFormat af = new AudioFormat(VirtualComm.this.selectedSampleRate, VirtualComm.this.selectedBits, VirtualComm.this.channels(), true, true);
                this.currentBits = VirtualComm.this.selectedBits;
                this.currentSampleRate = VirtualComm.this.selectedSampleRate;
                this.currentChannels = VirtualComm.this.channels();
                this.currentMixer = VirtualComm.this.selectedMixer;
                this.inputByteData = new byte[VirtualComm.this.selectedSampleRate / VirtualComm.this.measurementSpeed * VirtualComm.this.entrySize()];
                this.currentMeasurementSpeed = VirtualComm.this.measurementSpeed;
                try {
                    if (this.line != null && this.line.isOpen()) {
                        this.line.close();
                    }
                    this.line = AudioSystem.getTargetDataLine(af, VirtualComm.this.selectedMixer);
                    this.line.open();
                    this.setVolume(this.volume);
                    this.line.start();
                    this.bufferIndex = 0;
                    this.lastSample = System.currentTimeMillis();
                }
                catch (Exception e) {
                    this.failed = true;
                    VirtualComm.this.analyzer.setData(0.0, 0.0, 0.0);
                    VirtualComm.this.sleep100();
                    e.printStackTrace(System.out);
                    if (this.line != null && this.line.isOpen()) {
                        this.line.close();
                    }
                    this.line = null;
                }
            }

            @Override
            public void run() {
                while (!VirtualComm.this.done) {
                    try {
                        if (this.line == null || !this.line.isOpen()) {
                            if (this.failed) {
                                VirtualComm.this.sleep100();
                                continue;
                            }
                            this.setup();
                            continue;
                        }
                        this.fillBuffer();
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
                if (this.line != null) {
                    this.line.close();
                }
            }
        }
    }
}

