/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.DummyInterface;
import dk.hkj.comm.StreamingInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.SCPICommand;
import dk.hkj.util.StringUtil;

public class DeviceSingleValue
extends DeviceInterface {
    private StreamingInterface ci;
    private String selectedMode = "";
    private int overflowCounter = 0;
    private double lastValue = 0.0;
    private String lastMessage = "";
    private String outputMessage = "";
    private long lastTime = 0L;
    private long rate = 0L;
    private String currentMode = "";

    public DeviceSingleValue(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats = def.getValueFormats();
        this.setHandleName(def.getHandleName());
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        if (this.askModeCommand.isDebug()) {
            InterfaceThreads.logDebug("Mode reported: <" + this.selectedMode + ">");
        }
        super.initColumns();
        this.valueNames = this.def.getValueNames(this.selectedMode);
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUE?");
    }

    public static String deviceName() {
        return "DMM";
    }

    @Override
    public String getDeviceName() {
        return this.def.getDeviceName();
    }

    @Override
    public String getDeviceId() {
        return this.def.getIdName();
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        super.getCommInterface(ci);
        String s = this.def.getItem("#subDriver");
        if (s == null) {
            s = "0";
        }
        switch (Integer.parseInt(s)) {
            case 0: {
                this.ci = new Interface1(ci);
            }
        }
        return ci instanceof DummyInterface ? null : this.ci;
    }

    private class Interface1
    extends StreamingInterface {
        private long lastWriteTime;

        protected Interface1(CommInterface ci) {
            super(ci);
            this.lastWriteTime = 0L;
            this.debugLog = ci.debugLog;
            this.idnResponse = DeviceSingleValue.this.def.getIdName();
        }

        @Override
        protected synchronized void setMessage(String msg) {
            StringBuilder value = new StringBuilder();
            StringBuilder mode = new StringBuilder();
            boolean lastWasNumber = false;
            boolean noNumber = false;
            boolean foundNumber = false;
            this.lastWriteTime = 0L;
            String txt = "";
            int k = -1;
            while (k < 1000) {
                txt = DeviceSingleValue.this.def.getItem("#valueText" + (k >= 0 ? " " + k : ""));
                if (txt == null) break;
                int i = txt.indexOf(32);
                String num = txt.substring(0, i);
                int j = msg.indexOf(txt = StringUtil.unQuote(txt.substring(i + 1)));
                if (j >= 0) {
                    String s = msg.substring(j + txt.length() + 1).trim();
                    msg = msg.substring(0, j);
                    if (s.length() > 0 && "MkKmunp\u00b5".indexOf(s.charAt(0)) >= 0) {
                        s = s.substring(1);
                    }
                    msg = String.valueOf(msg) + s;
                    noNumber = true;
                    if (num.equalsIgnoreCase("OL") || num.equalsIgnoreCase("+OL")) {
                        value.append(DeviceSingleValue.this.overflowValueString(true));
                        break;
                    }
                    if (num.equalsIgnoreCase("-OL")) {
                        value.append(DeviceSingleValue.this.overflowValueString(true));
                        break;
                    }
                    value.append(num);
                    break;
                }
                ++k;
            }
            if (noNumber) {
                k = -1;
                while (k < 1000) {
                    String txt1 = DeviceSingleValue.this.def.getItem("#noModeChange" + (k >= 0 ? " " + k : ""));
                    if (txt1 == null) break;
                    if (txt.equals(txt1 = StringUtil.unQuote(txt1))) {
                        super.setMessage(value.toString());
                        return;
                    }
                    ++k;
                }
            }
            int i = 0;
            while (i < msg.length()) {
                char c = msg.charAt(i);
                if (c >= '0' && c <= '9' || c == '-' || c == '.' || c == '+') {
                    if (!noNumber) {
                        value.append(c);
                    }
                    foundNumber = true;
                    lastWasNumber = true;
                } else if (lastWasNumber && c == 'E') {
                    if (!noNumber) {
                        value.append(c);
                    }
                } else if (lastWasNumber && "Mkmunp".indexOf(c) >= 0) {
                    value.append(c);
                    lastWasNumber = false;
                } else if (lastWasNumber && c == 'K') {
                    value.append('k');
                    lastWasNumber = false;
                } else if (lastWasNumber && c == '\u00b5') {
                    value.append('u');
                    lastWasNumber = false;
                } else if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z') {
                    mode.append(c);
                    if (foundNumber) {
                        noNumber = true;
                    }
                    lastWasNumber = false;
                }
                ++i;
            }
            if (mode.length() > 0) {
                String m = mode.toString();
                if (!DeviceSingleValue.this.selectedMode.equals(m)) {
                    DeviceSingleValue.this.selectedMode = m;
                    DeviceSingleValue.this.requestInitColumns();
                }
            }
            super.setMessage(value.toString());
        }

        @Override
        public synchronized boolean write(String msg) {
            String s;
            if (this.lastWriteTime + 1500L < System.currentTimeMillis() && (s = DeviceSingleValue.this.def.getItem("#askValues")) != null) {
                s = StringUtil.decodeEscape(s);
                this.originalCommInterface.write(s);
                this.lastWriteTime = System.currentTimeMillis();
            }
            return this.stdCommands(msg);
        }
    }
}

