/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.comm.LayerInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.comm.SerialPacketInterface;
import dk.hkj.devices.DecoderClass;
import dk.hkj.devices.DecoderUT382;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.Support;

public class DeviceSerial7Seg
extends DeviceInterface {
    private SimpleInterface ti;
    private String selectedMode = "";
    private int overflowCounter = 0;
    private String lastValue = "";
    private String currentMode = "";
    private String outputMessage = null;
    private String lastMessage = null;
    private long rate = 0L;
    private long lastTime = 0L;
    private DecoderClass decoder = null;

    public DeviceSerial7Seg(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats = def.getValueFormats();
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        this.selectedMode = this.currentMode;
        this.valueNames = this.def.getValueNames(this.selectedMode);
        super.initColumns();
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUE?");
    }

    public static String deviceName() {
        return "SimpleLux";
    }

    @Override
    public String getDeviceName() {
        return this.def.getDeviceName();
    }

    @Override
    public String getDeviceId() {
        return this.def.getIdName();
    }

    @Override
    protected boolean mayModifyColumns(String cmd) {
        return cmd.equalsIgnoreCase("modeset?");
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        if (!(ci instanceof SerialInterface)) {
            return null;
        }
        String subdrv = this.def.getItem("#subDriver").toLowerCase();
        if (subdrv.equals("ut382")) {
            this.decoder = new DecoderUT382();
        }
        this.ti = new SimpleInterface(((SerialInterface)ci).getDataInterface());
        return this.ti;
    }

    private class SimpleInterface
    extends LayerInterface {
        public SimpleInterface(SerialPacketInterface si) {
            super(si);
        }

        @Override
        public void open() {
            super.open();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        ((SerialPacketInterface)SimpleInterface.this.originalCommInterface).setPacketFormat(CommDataInterface.PacketFormat.HeaderFixedLength, (byte)DeviceSerial7Seg.this.decoder.prefix(), DeviceSerial7Seg.this.decoder.messageSize());
                        while (SimpleInterface.this.originalCommInterface.isOpen()) {
                            SimpleInterface.this.readFromSerialPort();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            new Thread(r).start();
        }

        private synchronized void setMessage(byte[] data) {
            if (!DeviceSerial7Seg.this.decoder.decode(data)) {
                return;
            }
            DeviceSerial7Seg.this.currentMode = ((DeviceSerial7Seg)DeviceSerial7Seg.this).decoder.mode;
            if (!DeviceSerial7Seg.this.selectedMode.equals(DeviceSerial7Seg.this.currentMode)) {
                DeviceSerial7Seg.this.requestInitColumns();
            }
            if (!Double.isFinite(((DeviceSerial7Seg)DeviceSerial7Seg.this).decoder.value)) {
                DeviceSerial7Seg deviceSerial7Seg = DeviceSerial7Seg.this;
                deviceSerial7Seg.overflowCounter = deviceSerial7Seg.overflowCounter + 1;
                if (DeviceSerial7Seg.this.overflowCounter <= Support.systemSettings.delayOverflow) {
                    return;
                }
                DeviceSerial7Seg.this.lastMessage = DeviceSerial7Seg.this.overflowValueString(((DeviceSerial7Seg)DeviceSerial7Seg.this).decoder.value >= 0.0);
                long t = System.currentTimeMillis();
                DeviceSerial7Seg.this.rate = t - DeviceSerial7Seg.this.lastTime;
                DeviceSerial7Seg.this.lastTime = t;
                return;
            }
            DeviceSerial7Seg.this.lastMessage = Double.toString(((DeviceSerial7Seg)DeviceSerial7Seg.this).decoder.value);
            long t = System.currentTimeMillis();
            DeviceSerial7Seg.this.rate = t - DeviceSerial7Seg.this.lastTime;
            DeviceSerial7Seg.this.lastTime = t;
            DeviceSerial7Seg.this.overflowCounter = 0;
        }

        protected void readFromSerialPort() {
            try {
                this.originalCommInterface.flush();
                byte[] data = ((SerialPacketInterface)this.originalCommInterface).readData(1000);
                if (data != null) {
                    this.setMessage(data);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }

        protected boolean stdCommands(String msg) {
            if (msg.equalsIgnoreCase("*idn?")) {
                DeviceSerial7Seg.this.outputMessage = DeviceSerial7Seg.this.def.getIdName();
                return true;
            }
            if (msg.equalsIgnoreCase("rate?")) {
                DeviceSerial7Seg.this.outputMessage = Long.toString(DeviceSerial7Seg.this.rate);
                return true;
            }
            if (msg.equalsIgnoreCase("mode?")) {
                DeviceSerial7Seg.this.outputMessage = DeviceSerial7Seg.this.currentMode;
                return true;
            }
            if (msg.equalsIgnoreCase("value?")) {
                DeviceSerial7Seg.this.outputMessage = System.currentTimeMillis() - DeviceSerial7Seg.this.lastTime < 2000L ? DeviceSerial7Seg.this.lastMessage : null;
                return true;
            }
            return false;
        }

        @Override
        public synchronized boolean write(String msg) {
            this.log("Tx", msg);
            return this.stdCommands(msg);
        }

        @Override
        public boolean isData() {
            return DeviceSerial7Seg.this.outputMessage != null;
        }

        @Override
        public String read() {
            return this.read(300);
        }

        @Override
        public synchronized String read(int timeout) {
            String s = DeviceSerial7Seg.this.outputMessage;
            DeviceSerial7Seg.this.outputMessage = null;
            return s;
        }
    }
}

