/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.GpibInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.comm.TranslatingInterface;
import dk.hkj.devices.DeviceSCPI;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.Support;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;

public class DeviceSCPIx
extends DeviceSCPI {
    private TranslatingCommInterface ci;
    private long nextCommandTime = 0L;
    private long delayTime = 0L;
    private boolean forceUpperCase = false;
    private int removePromptChars = 0;

    public DeviceSCPIx(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        super.getCommInterface(ci);
        this.forceUpperCase = this.def.getItemInt("#forceUpperCase") != 0;
        this.removePromptChars = this.def.getItemInt("#removePromptChars");
        this.delayTime = this.def.getItemInt("#cmdDelayTime");
        if (ci instanceof GpibInterface) {
            this.removePromptChars = 0;
        }
        this.ci = new TranslatingCommInterface(ci);
        if (this.def.getReadingDelay() > 0) {
            this.ci.setTimeout(this.def.getReadingDelay());
        }
        return this.ci;
    }

    class TranslatingCommInterface
    extends TranslatingInterface {
        protected TranslatingCommInterface(CommInterface ci) {
            super(ci);
        }

        private void waitDelayTime() {
            long t = System.currentTimeMillis();
            long dt = DeviceSCPIx.this.nextCommandTime - t;
            if (dt > 0L) {
                if (dt > 2000L) {
                    dt = 2000L;
                }
                CommInterface.sleep((int)dt);
            }
        }

        @Override
        public void setTimeout(int timeout) {
            super.setTimeout(timeout);
            this.originalCommInterface.setTimeout(timeout);
        }

        private void cmdIdn() {
            String answer = this.originalCommInterface.writeRead("*IDN?");
            String s = DeviceSCPIx.this.def.getItem("#modifyIDN");
            if (s != null && s.length() > 0) {
                DeviceSCPIx.this.getScript().addLocalVar("value", Var.createValue(answer));
                answer = DeviceSCPIx.this.getScript().execute(s).asString();
            }
            this.message.add(answer);
        }

        private String oWriteRead(String msg) {
            this.waitDelayTime();
            String answer = this.originalCommInterface.writeRead(msg);
            if (DeviceSCPIx.this.removePromptChars > 0) {
                this.originalCommInterface.readBin(DeviceSCPIx.this.removePromptChars, this.timeout);
            }
            return answer;
        }

        private boolean oWrite(String msg) {
            this.waitDelayTime();
            boolean answer = this.originalCommInterface.write(msg);
            if (DeviceSCPIx.this.removePromptChars > 0) {
                this.originalCommInterface.readBin(DeviceSCPIx.this.removePromptChars, this.timeout);
            }
            return answer;
        }

        private String oWriteReadLines(String cmd, int n) {
            this.waitDelayTime();
            String answer = this.originalCommInterface.writeReadLines(cmd, n);
            if (DeviceSCPIx.this.removePromptChars > 0) {
                this.originalCommInterface.readBin(DeviceSCPIx.this.removePromptChars, this.timeout);
            }
            return answer;
        }

        private String oWriteReadTimeout(String cmd, int timeout) {
            this.waitDelayTime();
            String answer = this.originalCommInterface.writeReadTimeout(cmd, timeout);
            if (DeviceSCPIx.this.removePromptChars > 0) {
                this.originalCommInterface.readBin(DeviceSCPIx.this.removePromptChars, timeout);
            }
            return answer;
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public synchronized boolean write(String msg) {
            try {
                if (!this.originalCommInterface.isOpen()) {
                    return false;
                }
                StringBuilder sb = new StringBuilder();
                this.log("vTx:", msg);
                msg = msg.trim();
                int i = msg.indexOf(32);
                if (i < 0) {
                    i = msg.length();
                }
                String cmd = msg.substring(0, i).toLowerCase();
                String[] lines = new String[]{};
                boolean requestAnswer = msg.indexOf(63) >= 0;
                String cmddef = DeviceSCPIx.this.def.getScpiDefine(cmd);
                String params = msg.substring(i).trim();
                if (cmddef != null) {
                    if (cmddef.substring(0, 5).equalsIgnoreCase("#pgm#")) {
                        msg = "none";
                        if (DeviceSCPIx.this.debugOtherComm) {
                            DeviceSCPIx.this.debugLog("Script start");
                        }
                        DeviceSCPIx.this.getPgmScript().addLocalVar("value", Var.createValue(params));
                        Var v = DeviceSCPIx.this.getPgmScript().execute(cmddef.substring(6));
                        if (v != null) {
                            sb.append(v.asString());
                        }
                        if (DeviceSCPIx.this.debugOtherComm) {
                            DeviceSCPIx.this.debugLog("Script end <" + sb.toString() + ">");
                        }
                    } else {
                        lines = cmddef.split("[\\n]");
                        if (lines.length > 1) {
                            cmddef = lines[0];
                        }
                        if (cmddef.contains("(value)")) {
                            cmddef = cmddef.replace("(value)", params);
                        }
                        if (cmddef.indexOf(40) >= 0) {
                            DeviceSCPIx.this.getScript().addLocalVar("value", Var.createValue(params));
                            cmddef = Support.processScriptInBrackets(DeviceSCPIx.this.getScript(), cmddef);
                        }
                        msg = cmddef;
                        if (requestAnswer && msg.indexOf(63) < 0) {
                            return false;
                        }
                        if (DeviceSCPIx.this.debugOtherComm) {
                            DeviceSCPIx.this.debugLog("Tx <" + msg + ">");
                        }
                    }
                }
                String[] stringArray = msg.split("[;\n]");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int charCount;
                    String v;
                    int lineCount;
                    String cmdx = stringArray[n2];
                    i = cmdx.indexOf(32);
                    if (i < 0) {
                        cmd = cmdx;
                        cmdx = "";
                    } else {
                        cmd = cmdx.substring(0, i);
                        cmdx = cmdx.substring(i + 1).trim();
                    }
                    if (DeviceSCPIx.this.forceUpperCase) {
                        cmd = cmd.toUpperCase();
                    }
                    if (cmd.equalsIgnoreCase("tx")) {
                        this.oWrite(cmdx);
                        DeviceSCPIx.this.nextCommandTime = DeviceSCPIx.this.delayTime + System.currentTimeMillis();
                    } else if (cmd.equalsIgnoreCase("txrx")) {
                        this.oWriteRead(cmdx);
                        DeviceSCPIx.this.nextCommandTime = DeviceSCPIx.this.delayTime + System.currentTimeMillis();
                    } else if (cmd.equalsIgnoreCase("txrx?")) {
                        String v2 = this.oWriteRead(cmdx);
                        DeviceSCPIx.this.nextCommandTime = DeviceSCPIx.this.delayTime + System.currentTimeMillis();
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        sb.append(v2);
                    } else if (cmd.equalsIgnoreCase("txrx2?")) {
                        String v3 = this.oWriteReadLines(cmdx, 2);
                        DeviceSCPIx.this.nextCommandTime = DeviceSCPIx.this.delayTime + System.currentTimeMillis();
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        sb.append(v3);
                    } else if (cmd.equalsIgnoreCase("txrxn?")) {
                        int j = cmdx.indexOf(32);
                        if (j < 0) {
                            j = cmdx.length();
                        }
                        lineCount = Integer.parseInt(cmdx.substring(0, j));
                        cmdx = cmdx.substring(j).trim();
                        v = lineCount > 0 ? this.oWriteReadLines(cmdx, lineCount) : "";
                        DeviceSCPIx.this.nextCommandTime = DeviceSCPIx.this.delayTime + System.currentTimeMillis();
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        sb.append(v);
                    } else if (cmd.equalsIgnoreCase("txrxTimeout?")) {
                        int j = cmdx.indexOf(32);
                        if (j < 0) {
                            j = cmdx.length();
                        }
                        int timeout = (int)(StringUtil.parseDoubleEE(cmdx.substring(0, j)) * 1000.0);
                        cmdx = cmdx.substring(j).trim();
                        v = this.oWriteReadTimeout(cmdx, timeout);
                        DeviceSCPIx.this.nextCommandTime = DeviceSCPIx.this.delayTime + System.currentTimeMillis();
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        sb.append(v);
                    } else if (cmd.equalsIgnoreCase("txrxn?")) {
                        int j = cmdx.indexOf(32);
                        if (j < 0) {
                            j = cmdx.length();
                        }
                        lineCount = Integer.parseInt(cmdx.substring(0, j));
                        cmdx = cmdx.substring(j).trim();
                        v = lineCount > 0 ? this.oWriteReadLines(cmdx, lineCount) : "";
                        DeviceSCPIx.this.nextCommandTime = DeviceSCPIx.this.delayTime + System.currentTimeMillis();
                        if (sb.length() > 0) {
                            sb.append(" ");
                        }
                        sb.append(v);
                    } else if (cmd.equalsIgnoreCase("txrx1Bin?")) {
                        byte[] b = this.originalCommInterface.writeReadBin(StringUtil.decodeEscape(cmdx), 1, this.timeout);
                        if (b != null && b.length >= 1) {
                            sb.append(Integer.toString(b[0] & 0xFF));
                        }
                        DeviceSCPIx.this.nextCommandTime = DeviceSCPIx.this.delayTime + System.currentTimeMillis();
                    } else if (cmd.equalsIgnoreCase("txrxnBin?")) {
                        int j = cmdx.indexOf(32);
                        if (j < 0) {
                            j = cmdx.length();
                        }
                        charCount = Integer.parseInt(cmdx.substring(0, j));
                        cmdx = cmdx.substring(j).trim();
                        byte[] b = this.originalCommInterface.writeReadBin(StringUtil.decodeEscape(cmdx), charCount, this.timeout);
                        if (charCount > 8) {
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            sb.append("$" + StringUtil.hexNN(b) + "$");
                        } else {
                            long l = 0L;
                            int k = 0;
                            while (k < Math.min(charCount, b.length)) {
                                l |= ((long)b[k] & 0xFFL) << 8 * k;
                                ++k;
                            }
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            sb.append(Long.toString(l));
                        }
                        DeviceSCPIx.this.nextCommandTime = DeviceSCPIx.this.delayTime + System.currentTimeMillis();
                    } else if (cmd.equalsIgnoreCase("txrx1Bin")) {
                        this.originalCommInterface.writeReadBin(StringUtil.decodeEscape(cmdx), 1, this.timeout);
                        DeviceSCPIx.this.nextCommandTime = DeviceSCPIx.this.delayTime + System.currentTimeMillis();
                    } else if (cmd.equalsIgnoreCase("txBin")) {
                        this.originalCommInterface.writeBin(StringUtil.decodeEscape(cmdx));
                        DeviceSCPIx.this.nextCommandTime = DeviceSCPIx.this.delayTime + System.currentTimeMillis();
                    } else if (cmd.equalsIgnoreCase("txrxnBin")) {
                        int j = cmdx.indexOf(32);
                        if (j < 0) {
                            j = cmdx.length();
                        }
                        charCount = Integer.parseInt(cmdx.substring(0, j));
                        cmdx = cmdx.substring(j).trim();
                        this.originalCommInterface.writeReadBin(StringUtil.decodeEscape(cmdx), charCount, this.timeout);
                        DeviceSCPIx.this.nextCommandTime = DeviceSCPIx.this.delayTime + System.currentTimeMillis();
                    } else if (!cmd.equalsIgnoreCase("none") && !cmd.equalsIgnoreCase("none?")) {
                        if (cmd.matches("\\[[0-9]{1,4}\\]")) {
                            int t = StringUtil.parseInt(cmd.substring(1, cmd.length() - 1));
                            if (t > 0) {
                                SerialInterface.sleep(t);
                            }
                        } else if (cmd.contains("?")) {
                            sb.append(this.oWriteRead(String.valueOf(cmd) + (cmdx.length() > 0 ? " " + cmdx : "")));
                        } else {
                            this.oWrite(String.valueOf(cmd) + (cmdx.length() > 0 ? " " + cmdx : ""));
                        }
                    }
                    ++n2;
                }
                if (lines.length > 1) {
                    DeviceSCPIx.this.getScript().addLocalVar("inputValue", Var.createValue(params));
                    int j = 1;
                    while (j < lines.length) {
                        String line = lines[j];
                        if (line.startsWith(":readmath:")) {
                            line = line.substring(":readmath:".length());
                            DeviceSCPIx.this.getScript().addLocalVar("value", Var.createValue(sb.toString()));
                            sb.setLength(0);
                            sb.append(DeviceSCPIx.this.getScript().execute(line).asString());
                        } else if (line.startsWith(":setvar:")) {
                            if (sb.length() > 0) {
                                DeviceSCPIx.this.getScript().addLocalVar("value", Var.createValue(sb.toString()));
                            }
                            line = line.substring(":setvar:".length());
                            DeviceSCPIx.this.getScript().execute("var " + line);
                        }
                        ++j;
                    }
                    DeviceSCPIx.this.getScript().removeLocalVar("inputValue");
                }
                if (sb.length() > 0) {
                    this.message.add(sb.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                return false;
            }
            return true;
        }
    }
}

