/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.Support;
import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.vars.Var;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class DeviceSCPI
extends DeviceInterface {
    private String mode = "";
    private double lastValue = 0.0;
    private int overflowCounter = 0;

    public DeviceSCPI(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
    }

    protected Script getPgmScript() {
        Script pgmScript = new Script(this.getScript());
        pgmScript.getLocalVars().set(this.getScript().getLocalVars().getValue());
        pgmScript.getLocalVars().addFunc(new Functions.Func("deviceWrite"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 2) {
                    1.invalidNumberOfParams(script, "device,string,...");
                }
                StringBuilder sb = new StringBuilder();
                int i = 1;
                while (i < params.size()) {
                    sb.append(params.get(i).asString());
                    ++i;
                }
                String deviceName = params.get(0).asString();
                if (!deviceName.isEmpty() && !deviceName.equals(DeviceSCPI.this.dt.getHandleName())) {
                    throw new InvalidHandleException("Only same device allowed from #scpiCmd");
                }
                DeviceSCPI.this.doCommand(sb.toString());
                return null;
            }
        });
        pgmScript.getLocalVars().addFunc(new Functions.Func("deviceRead"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() < 2) {
                    2.invalidNumberOfParams(script, "device,string,...");
                }
                StringBuilder sb = new StringBuilder();
                int i = 1;
                while (i < params.size()) {
                    sb.append(params.get(i).asString());
                    ++i;
                }
                String deviceName = params.get(0).asString();
                if (!deviceName.isEmpty() && !deviceName.equals(DeviceSCPI.this.dt.getHandleName())) {
                    throw new InvalidHandleException("Only same device allowed from #scpiCmd");
                }
                return Var.createValue(DeviceSCPI.this.doCommand(sb.toString().trim()));
            }
        });
        return pgmScript;
    }

    @Override
    public void threadStarted(InterfaceThreads.DeviceThread deviceThread) {
        super.threadStarted(deviceThread);
        this.valueFormats = this.def.getValueFormats();
        this.setHandleName(this.def.getHandleName());
        this.mode = this.def.getItem("#initialMode");
        if (this.mode != null && this.mode.length() > 0) {
            this.doCommand(this.def.getFunctionMode((String)this.mode).cmdsToSetup);
        }
    }

    @Override
    public String getDeviceName() {
        return this.def.getDeviceName();
    }

    @Override
    public synchronized List<Double> getValuesFromDevices() {
        List<Double> list = super.getValuesFromDevices();
        if (list.size() != 1) {
            return list;
        }
        double v = list.get(0);
        if (Double.isNaN(v)) {
            return list;
        }
        if (Double.isFinite(v) && Math.abs(v) < Support.systemSettings.overflowLimit) {
            this.lastValue = v;
            this.overflowCounter = 0;
            return list;
        }
        ++this.overflowCounter;
        if (this.overflowCounter <= Support.systemSettings.delayOverflow) {
            list = new ArrayList<Double>();
            list.add(this.lastValue);
            return list;
        }
        list = new ArrayList<Double>();
        list.add(DeviceSCPI.overflowValueDouble(v >= 0.0));
        return list;
    }

    @Override
    public synchronized void initColumns() {
        super.initColumns();
        if (this.valueNames != null) {
            return;
        }
        this.mode = this.getMode();
        this.noTimeoutBefore = (long)this.def.getModeChangeDelay() + System.currentTimeMillis();
        this.doCommand(this.def.getItem("#prepareSample"));
        this.valueNames = this.def.getValueNames(this.mode);
    }

    @Override
    public String getMode() {
        if (this.askModeCommand.isValid()) {
            return this.processModeString(this.askModeCommand.writeRead());
        }
        return "";
    }

    @Override
    public void close() {
        this.doCommand(this.def.getItem("#finalCmd"));
    }

    private BufferedImage readScreenDumpStandard(String cmd) {
        byte[] b = this.dt.cPort.readSCPIBinary(cmd);
        ByteArrayInputStream bis = new ByteArrayInputStream(b);
        try {
            BufferedImage img = ImageIO.read(bis);
            return img;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private BufferedImage readScreenDumpCA1() {
        byte[] palbytes = this.dt.cPort.readSCPIBinary("HCOP:DEV:CMAP?");
        byte[] data = this.dt.cPort.readSCPIBinary("HCOP:SDUM:IMM?");
        int ww = 240;
        int hh = 320;
        try {
            int[] pal = new int[16];
            int i = 0;
            while (i < 16) {
                int r = palbytes[i * 4] & 0xFF;
                int b = palbytes[i * 4 + 1] & 0xFF;
                int g = palbytes[i * 4 + 2] & 0xFF;
                pal[i] = r << 16 | b << 8 | g;
                ++i;
            }
            BufferedImage img = new BufferedImage(ww, hh, 1);
            int h = 0;
            while (h < hh) {
                int w = 0;
                while (w < ww) {
                    int p = (h & 1) != 0 ? data[(hh * w + h) / 2] & 0xF : data[(hh * w + h) / 2] >> 4 & 0xF;
                    img.setRGB(w, (hh - h - 1) % hh, pal[p]);
                    ++w;
                }
                ++h;
            }
            return img;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private BufferedImage readScreenDump(String format, String cmd) {
        if (format.equalsIgnoreCase("std")) {
            return this.readScreenDumpStandard(cmd);
        }
        if (format.equalsIgnoreCase("CA1")) {
            return this.readScreenDumpCA1();
        }
        return null;
    }

    @Override
    public boolean canScreenDump() {
        String s = this.def.getItem("#ScreenDump");
        if (s == null) {
            return false;
        }
        String cmd = s.trim();
        int i = cmd.indexOf(32);
        int j = cmd.indexOf(10);
        if (i < 0 || j >= 0 && j < i) {
            i = j;
        }
        return i >= 0;
    }

    @Override
    public BufferedImage readScreenDump() {
        String ss = this.def.getItem("#ScreenDump");
        if (ss == null) {
            return null;
        }
        String cmd = ss.trim();
        int i = cmd.indexOf(32);
        int j = cmd.indexOf(10);
        if (i < 0 || j >= 0 && j < i) {
            i = j;
        }
        if (i < 0) {
            return null;
        }
        String format = cmd.substring(0, i);
        String[] cmds = cmd.substring(i + 1).trim().split("[;]");
        if (cmds.length == 1) {
            return this.readScreenDump(format, cmds[0]);
        }
        BufferedImage img = null;
        SCPICommand scpi = new SCPICommand((DeviceInterface)this, cmd);
        String[] stringArray = cmds;
        int n = cmds.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (s.contains("?")) {
                img = this.readScreenDump(format, s);
            } else {
                scpi.setCmd(s);
                scpi.write();
            }
            ++n2;
        }
        return img;
    }

    public class InvalidHandleException
    extends RuntimeException {
        InvalidHandleException(String reason) {
            super(reason);
        }
    }
}

