/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.comm.SocketInterface;
import dk.hkj.comm.TranslatingInterface;
import dk.hkj.devices.DeviceSCPI;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Support;
import dk.hkj.util.ByteBuffer;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.util.Arrays;
import java.util.List;

public class DeviceModbus
extends DeviceSCPI {
    private TranslatingCommInterface ci;
    private CommDataInterface si;
    private int modbusAddress = 1;
    private boolean disableWriteSingle = false;
    private long nextCommandTime = 0L;
    private long delayTime = 0L;

    public DeviceModbus(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        CommInterface cii = null;
        if (this.def.getItem("#subDriver") != null && this.def.getItem("#subDriver").equalsIgnoreCase("ascii")) {
            cii = null;
        } else if (ci instanceof SerialInterface) {
            cii = ((SerialInterface)ci).getDataInterface();
        } else if (ci instanceof SocketInterface) {
            cii = ((SocketInterface)ci).getDataInterface();
        } else {
            return null;
        }
        if (cii != null) {
            this.si = (CommDataInterface)((Object)cii);
            this.si.setAnswerTimeout(this.def.getItemInt("#answerTimeout"));
            if (this.def.getReadingDelay() > 0) {
                cii.setTimeout(this.def.getReadingDelay());
            }
            this.ci = new TranslatingCommInterface(cii);
        } else {
            String eol = this.def.getItem("#eol");
            if (eol != null) {
                ci.setEOL(StringUtil.decodeEscape(eol.trim()));
            } else {
                ci.setEOL("\r\n");
            }
            if (this.def.getReadingDelay() > 0) {
                ci.setTimeout(this.def.getReadingDelay());
            }
            this.ci = new TranslatingCommInterface(ci);
        }
        this.ci.setModbusType(this.def.getItem("#subDriver"));
        this.disableWriteSingle = this.def.getItemInt("#disableWriteSingle") != 0;
        this.delayTime = this.def.getItemInt("#cmdDelayTime");
        return this.ci;
    }

    @Override
    public List<String> supportedCommands() {
        List<String> list = super.supportedCommands();
        if (list == null || list.size() == 0) {
            list = this.def.getScpiDefines();
            list.add("*idn?");
            list.sort(null);
            this.commandList = list;
        }
        return list;
    }

    @Override
    public String finalInit() {
        return "";
    }

    class TranslatingCommInterface
    extends TranslatingInterface {
        protected ModbusInterface modbus;

        protected TranslatingCommInterface(CommInterface ci) {
            super(ci);
            this.modbus = null;
            if (DeviceModbus.this.def.getReadingDelay() > 0) {
                this.timeout = DeviceModbus.this.def.getReadingDelay();
            }
        }

        public void setModbusType(String type) {
            if (type == null || type.length() == 0 || type.equalsIgnoreCase("RTU")) {
                DeviceModbus.this.si.setPacketFormat(CommDataInterface.PacketFormat.ModbusRTU);
                this.modbus = new ModbusRTUInterface(null, null);
            } else if (type.equalsIgnoreCase("TCP")) {
                DeviceModbus.this.si.setPacketFormat(CommDataInterface.PacketFormat.ModbusTCP);
                this.modbus = new ModbusTCPInterface();
            } else if (type.equalsIgnoreCase("Kunkin")) {
                DeviceModbus.this.si.setPacketFormat(CommDataInterface.PacketFormat.ModbusKunkin);
                this.modbus = new ModbusRTUInterfaceKunkin(null, null);
            } else if (type.equalsIgnoreCase("Kunkinx")) {
                DeviceModbus.this.si.setPacketFormat(CommDataInterface.PacketFormat.ModbusKunkin);
                this.modbus = new ModbusRTUInterfaceKunkinx();
            } else if (type.equalsIgnoreCase("ascii")) {
                this.modbus = new ModbusAsciiInterface();
            }
        }

        private void cmdIdn() {
            String s;
            StringBuilder sb = new StringBuilder();
            String verify = DeviceModbus.this.def.getItem("#verifyDevice");
            if (verify != null && verify.indexOf(32) >= 0) {
                int i = verify.indexOf(32);
                String value = verify.substring(0, i);
                String answer = this.writeRead(verify.substring(i + 1).trim()).replace(" ", "_").trim();
                if (!answer.equals(value)) {
                    answer = "**Device do not match** <" + answer + ">";
                    if (InterfaceThreads.debugAll) {
                        this.logLogAlways(answer);
                    }
                    this.message.add(answer);
                    return;
                }
            }
            sb.append(DeviceModbus.this.def.getIdName().trim());
            if (sb.charAt(sb.length() - 1) == ',') {
                sb.append(" ");
            } else {
                sb.append(", ");
            }
            if (DeviceModbus.this.def.getScpiDefine("getdevicesn?") != null && (s = this.writeRead("getDeviceSN?")) != null && s.length() > 0) {
                sb.append(s);
            }
            sb.append(", ");
            if (DeviceModbus.this.def.getScpiDefine("getdevicesw?") != null && (s = this.writeRead("getDeviceSW?")) != null && s.length() > 0) {
                sb.append(s);
            }
            this.message.add(sb.toString());
        }

        private String answerValues(long[] values, String scale) {
            StringBuilder sb = new StringBuilder();
            String[] scalex = scale.split(" ");
            if (scalex.length == 1) {
                double fac = 1.0;
                long mask = 0L;
                if (scale.startsWith("*")) {
                    fac = StringUtil.parseDoubleEE(scale.substring(1).trim());
                } else if (scale.startsWith("/")) {
                    fac = 1.0 / StringUtil.parseDoubleEE(scale.substring(1).trim());
                } else if (scale.startsWith("&")) {
                    mask = StringUtil.parseLong(scale.substring(1).trim());
                }
                long[] lArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    long v = lArray[n2];
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    if (fac != 1.0) {
                        sb.append((double)v * fac);
                    } else if (mask != 0L) {
                        sb.append(v & mask);
                    } else {
                        sb.append(v);
                    }
                    ++n2;
                }
            } else {
                int n = 0;
                long[] lArray = values;
                int n3 = values.length;
                int n4 = 0;
                while (n4 < n3) {
                    long v = lArray[n4];
                    double fac = 1.0;
                    long mask = 0L;
                    if (scalex[n].startsWith("*")) {
                        fac = StringUtil.parseDoubleEE(scalex[n].substring(1).trim());
                    } else if (scalex[n].startsWith("/")) {
                        fac = 1.0 / StringUtil.parseDoubleEE(scalex[n].substring(1).trim());
                    } else if (scalex[n].startsWith("&")) {
                        mask = StringUtil.parseLong(scalex[n].substring(1).trim());
                    }
                    ++n;
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    if (fac != 1.0) {
                        sb.append((double)v * fac);
                    } else if (mask != 0L) {
                        sb.append(v & mask);
                    } else {
                        sb.append(v);
                    }
                    ++n4;
                }
            }
            return sb.toString();
        }

        private String answerValues(byte[] values) {
            StringBuilder sb = new StringBuilder();
            byte[] byArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                byte v = byArray[n2];
                if (sb.length() == 0) {
                    sb.append("$");
                }
                sb.append(StringUtil.hex2(v));
                ++n2;
            }
            if (sb.length() > 0) {
                sb.append("$");
            }
            return sb.toString();
        }

        private String answerValuesF(double[] values, String scale) {
            StringBuilder sb = new StringBuilder();
            String[] scalex = scale.split(" ");
            if (scalex.length == 1) {
                double fac = 1.0;
                if (scale.startsWith("*")) {
                    fac = StringUtil.parseDoubleEE(scale.substring(1).trim());
                } else if (scale.startsWith("/")) {
                    fac = 1.0 / StringUtil.parseDoubleEE(scale.substring(1).trim());
                }
                double[] dArray = values;
                int n = values.length;
                int n2 = 0;
                while (n2 < n) {
                    double v = dArray[n2];
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(v * fac);
                    ++n2;
                }
            } else {
                int n = 0;
                double[] dArray = values;
                int n3 = values.length;
                int n4 = 0;
                while (n4 < n3) {
                    double v = dArray[n4];
                    double fac = 1.0;
                    if (scalex[n].startsWith("*")) {
                        fac = StringUtil.parseDoubleEE(scalex[n].substring(1).trim());
                    } else if (scalex[n].startsWith("/")) {
                        fac = 1.0 / StringUtil.parseDoubleEE(scalex[n].substring(1).trim());
                    }
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(v * fac);
                    ++n4;
                }
            }
            return sb.toString();
        }

        private long[] parseValuesLong(String[] data, int first) {
            int last = data.length - 1;
            double fac = 1.0;
            if (data[last].startsWith("*")) {
                fac = StringUtil.parseDoubleEE(data[last].substring(1).trim());
                --last;
            } else if (data[last].startsWith("/")) {
                fac = 1.0 / StringUtil.parseDoubleEE(data[last].substring(1).trim());
                --last;
            }
            long[] result = new long[last - first + 1];
            int i = first;
            while (i <= last) {
                double a = StringUtil.parseDoubleEE(data[i]) * fac;
                a = a < 0.0 ? (a -= 0.2) : (a += 0.2);
                result[i - first] = (long)a;
                ++i;
            }
            return result;
        }

        private double[] parseValuesFloat(String[] data, int first) {
            int last = data.length - 1;
            double fac = 1.0;
            if (data[last].startsWith("*")) {
                fac = StringUtil.parseDoubleEE(data[last].substring(1).trim());
                --last;
            } else if (data[last].startsWith("/")) {
                fac = 1.0 / StringUtil.parseDoubleEE(data[last].substring(1).trim());
                --last;
            }
            double[] result = new double[last - first + 1];
            int i = first;
            while (i <= last) {
                result[i - first] = StringUtil.parseDoubleEE(data[i]) * fac;
                ++i;
            }
            return result;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public synchronized boolean write(String msg) {
            try {
                if (!this.originalCommInterface.isOpen()) {
                    return false;
                }
                StringBuilder sb = new StringBuilder();
                this.log("vTx:", msg);
                msg = msg.trim();
                int i = msg.indexOf(32);
                if (i < 0) {
                    i = msg.length();
                }
                String cmd = msg.substring(0, i).toLowerCase();
                String[] lines = new String[]{};
                boolean requestAnswer = msg.indexOf(63) >= 0;
                String cmddef = DeviceModbus.this.def.getScpiDefine(cmd);
                String params = msg.substring(i).trim();
                if (cmddef != null) {
                    if (cmddef.substring(0, 5).equalsIgnoreCase("#pgm#")) {
                        msg = "none";
                        if (DeviceModbus.this.debugOtherComm) {
                            DeviceModbus.this.debugLog("Script start");
                        }
                        DeviceModbus.this.getPgmScript().addLocalVar("value", Var.createValue(params));
                        Var v = DeviceModbus.this.getPgmScript().execute(cmddef.substring(6));
                        if (v != null) {
                            sb.append(v.asString());
                        }
                        if (DeviceModbus.this.debugOtherComm) {
                            DeviceModbus.this.debugLog("Script end <" + sb.toString() + ">");
                        }
                    } else {
                        lines = cmddef.split("[\\n]");
                        if (lines.length > 1) {
                            cmddef = lines[0];
                        }
                        if (cmddef.contains("(value)")) {
                            cmddef = cmddef.replace("(value)", params);
                        }
                        if (cmddef.indexOf(40) >= 0) {
                            DeviceModbus.this.getScript().addLocalVar("value", Var.createValue(params));
                            cmddef = Support.processScriptInBrackets(DeviceModbus.this.getScript(), cmddef);
                        }
                        msg = cmddef;
                        if (requestAnswer && msg.indexOf(63) < 0) {
                            return false;
                        }
                        if (DeviceModbus.this.debugOtherComm) {
                            DeviceModbus.this.debugLog("Tx <" + msg + ">");
                        }
                    }
                }
                String[] stringArray = msg.split("[;]");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    block58: {
                        String[] ss;
                        block63: {
                            block62: {
                                block61: {
                                    block60: {
                                        block59: {
                                            block57: {
                                                String cmdx = stringArray[n2];
                                                ss = cmdx.split("[ ]+");
                                                cmd = ss[0].toLowerCase();
                                                if (!cmd.equals("*idn?")) break block57;
                                                this.cmdIdn();
                                                break block58;
                                            }
                                            if (!cmd.equals("unitid")) break block59;
                                            this.modbus.setUnitId(StringUtil.parseInt(ss[1]));
                                            break block58;
                                        }
                                        if (!cmd.equals("coil")) break block60;
                                        this.modbus.writeCoil(StringUtil.parseInt(ss[1]), StringUtil.parseInt(ss[2]) != 0);
                                        break block58;
                                    }
                                    if (!cmd.equals("coil?")) break block61;
                                    long v = this.modbus.readCoilInput(false, StringUtil.parseInt(ss[1]), ss.length <= 2 ? 1 : StringUtil.parseInt(ss[2]));
                                    if (sb.length() > 0) {
                                        sb.append(" ");
                                    }
                                    sb.append(v);
                                    break block58;
                                }
                                if (!cmd.equals("dinput?")) break block62;
                                long v = this.modbus.readCoilInput(true, StringUtil.parseInt(ss[1]), ss.length <= 2 ? 1 : StringUtil.parseInt(ss[2]));
                                if (sb.length() > 0) {
                                    sb.append(" ");
                                }
                                sb.append(v);
                                break block58;
                            }
                            if (!cmd.equals("holding")) break block63;
                            long[] values = this.parseValuesLong(ss, 2);
                            if (DeviceModbus.this.disableWriteSingle || values.length > 1) {
                                this.modbus.writeHolding(StringUtil.parseInt(ss[1]), values);
                                break block58;
                            } else if (values.length == 1) {
                                this.modbus.writeHolding(StringUtil.parseInt(ss[1]), values[0]);
                            }
                            break block58;
                        }
                        if (cmd.equals("holding?")) {
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            AskParams p = new AskParams(ss);
                            sb.append(this.answerValues(this.modbus.readHoldingInput(false, p.address, p.count), p.fac));
                        } else if (cmd.equals("holdings?")) {
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            AskParams p = new AskParams(ss);
                            sb.append(this.answerValues(this.modbus.readHoldingInputS(false, p.address, p.count), p.fac));
                        } else if (cmd.equals("holdingbytes?")) {
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            AskParams p = new AskParams(ss);
                            sb.append(this.answerValues(this.modbus.readHoldingInputBytes(false, p.address, p.count)));
                        } else if (cmd.equals("input?")) {
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            AskParams p = new AskParams(ss);
                            sb.append(this.answerValues(this.modbus.readHoldingInput(true, p.address, p.count), p.fac));
                        } else if (cmd.equals("holdingl") || cmd.equals("holdingsl")) {
                            long[] values = this.parseValuesLong(ss, 2);
                            this.modbus.writeHoldingL(StringUtil.parseInt(ss[1]), values);
                        } else if (cmd.equals("holdingl?")) {
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            AskParams p = new AskParams(ss);
                            sb.append(this.answerValues(this.modbus.readHoldingInputL(false, p.address, p.count), p.fac));
                        } else if (cmd.equals("holdingsl?")) {
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            AskParams p = new AskParams(ss);
                            sb.append(this.answerValues(this.modbus.readHoldingInputSL(false, p.address, p.count), p.fac));
                        } else if (cmd.equals("holdingf")) {
                            double[] values = this.parseValuesFloat(ss, 2);
                            this.modbus.writeHoldingF(StringUtil.parseInt(ss[1]), values);
                        } else if (cmd.equals("holdingf?")) {
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            AskParams p = new AskParams(ss);
                            sb.append(this.answerValuesF(this.modbus.readHoldingInputF(false, p.address, p.count), p.fac));
                        } else if (!cmd.equals("none") && !cmd.equals("none?")) {
                            if (cmd.equals("address")) {
                                DeviceModbus.this.modbusAddress = StringUtil.parseInt(ss[1]);
                            } else if (cmd.equals("address?")) {
                                if (sb.length() > 0) {
                                    sb.append(" ");
                                }
                                sb.append(DeviceModbus.this.modbusAddress);
                            }
                        }
                    }
                    ++n2;
                }
                if (lines.length > 1) {
                    DeviceModbus.this.getScript().addLocalVar("inputValue", Var.createValue(params));
                    int j = 1;
                    while (j < lines.length) {
                        String line = lines[j];
                        if (line.startsWith(":readmath:")) {
                            line = line.substring(":readmath:".length());
                            DeviceModbus.this.getScript().addLocalVar("value", Var.createValue(sb.toString()));
                            sb.setLength(0);
                            sb.append(DeviceModbus.this.getScript().expression(line).asString());
                        } else if (line.startsWith(":setvar:")) {
                            if (sb.length() > 0) {
                                DeviceModbus.this.getScript().addLocalVar("value", Var.createValue(sb.toString()));
                            }
                            line = line.substring(":setvar:".length());
                            DeviceModbus.this.getScript().execute("var " + line);
                        }
                        ++j;
                    }
                    DeviceModbus.this.getScript().removeLocalVar("inputValue");
                }
                if (sb.length() <= 0) return true;
                this.message.add(sb.toString());
                return true;
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                return false;
            }
        }

        private class AskParams {
            int address;
            int count;
            String fac;

            AskParams(String[] params) {
                block2: {
                    String s;
                    block3: {
                        this.address = 0;
                        this.count = 1;
                        this.fac = "";
                        this.address = StringUtil.parseInt(params[1]);
                        if (params.length < 3) break block2;
                        s = params[2];
                        if (!s.startsWith("/") && !s.startsWith("*") && !s.startsWith("&")) break block3;
                        this.fac = s;
                        int i = 3;
                        while (i < params.length) {
                            this.fac = String.valueOf(this.fac) + ' ' + params[i];
                            ++i;
                        }
                        break block2;
                    }
                    this.count = StringUtil.parseInt(s);
                    if (params.length < 4) break block2;
                    this.fac = params[3];
                    int i = 4;
                    while (i < params.length) {
                        this.fac = String.valueOf(this.fac) + ' ' + params[i];
                        ++i;
                    }
                }
            }
        }

        private class ModbusAsciiInterface
        extends ModbusRTUInterface {
            private ModbusAsciiInterface() {
            }

            protected byte checksum(ByteBuffer buf) {
                int sum = 0;
                int i = 0;
                while (i < buf.getSize()) {
                    sum += buf.byteAt(i);
                    ++i;
                }
                return (byte)(-sum & 0xFF);
            }

            protected int toByte(char c) {
                if (c >= '0' && c <= '9') {
                    return (byte)c - 48;
                }
                if (c >= 'A' && c <= 'F') {
                    return (byte)c - 65 + 10;
                }
                if (c >= 'a' && c <= 'f') {
                    return (byte)c - 97 + 10;
                }
                return 0;
            }

            protected byte[] toBytes(String buffer) {
                int n = (buffer.length() - 1) / 2;
                byte[] buf = new byte[n];
                int i = 0;
                while (i < n) {
                    buf[i] = (byte)(this.toByte(buffer.charAt(i * 2 + 1)) << 4 | this.toByte(buffer.charAt(i * 2 + 2)));
                    ++i;
                }
                return buf;
            }

            @Override
            synchronized byte[] communicate(ByteBuffer bb) {
                long t = System.currentTimeMillis();
                long dt = DeviceModbus.this.nextCommandTime - t;
                if (dt > 0L) {
                    if (dt > 2000L) {
                        dt = 2000L;
                    }
                    CommInterface.sleep((int)dt);
                }
                bb.append(this.checksum(bb));
                StringBuffer sb = new StringBuffer(bb.getSize() * 2 + 1);
                sb.append(':');
                int i = 0;
                while (i < bb.getSize()) {
                    sb.append(StringUtil.hex2(bb.byteAt(i)));
                    ++i;
                }
                if (TranslatingCommInterface.this.debugLog) {
                    TranslatingCommInterface.this.logLog("Tx: " + sb.toString());
                }
                TranslatingCommInterface.this.originalCommInterface.flush();
                String answer = TranslatingCommInterface.this.originalCommInterface.writeRead(sb.toString(), TranslatingCommInterface.this.timeout);
                if (answer == null || answer.isEmpty()) {
                    CommInterface.sleep(5);
                    ((CommInterface)((Object)DeviceModbus.this.si)).flush();
                    answer = TranslatingCommInterface.this.originalCommInterface.writeRead(sb.toString(), TranslatingCommInterface.this.timeout);
                }
                if (TranslatingCommInterface.this.debugLog) {
                    TranslatingCommInterface.this.logLog("Rx: " + answer);
                }
                DeviceModbus.this.nextCommandTime = DeviceModbus.this.delayTime + System.currentTimeMillis();
                return this.toBytes(answer);
            }
        }

        private abstract class ModbusInterface {
            protected int unitId = 0;

            private ModbusInterface() {
            }

            void setUnitId(int id) {
                this.unitId = id;
            }

            abstract byte[] communicate(ByteBuffer var1);

            abstract void writeCoil(int var1, boolean var2);

            abstract long readCoilInput(boolean var1, int var2, int var3);

            abstract void writeHolding(int var1, long var2);

            abstract void writeHolding(int var1, long[] var2);

            abstract void writeHoldingL(int var1, long[] var2);

            abstract void writeHoldingF(int var1, double[] var2);

            abstract byte[] readHoldingInputBytes(boolean var1, int var2, int var3);

            abstract long[] readHoldingInput(boolean var1, int var2, int var3);

            abstract long[] readHoldingInputS(boolean var1, int var2, int var3);

            abstract long[] readHoldingInputL(boolean var1, int var2, int var3);

            abstract long[] readHoldingInputSL(boolean var1, int var2, int var3);

            abstract double[] readHoldingInputF(boolean var1, int var2, int var3);
        }

        private class ModbusRTUInterface
        extends ModbusInterface {
            private ModbusRTUInterface() {
            }

            protected long ModRTU_CRC(byte[] buf) {
                long crc = 65535L;
                int pos = 0;
                while (pos < buf.length) {
                    crc ^= (long)(buf[pos] & 0xFF);
                    int i = 8;
                    while (i != 0) {
                        if ((crc & 1L) != 0L) {
                            crc >>= 1;
                            crc ^= 0xA001L;
                        } else {
                            crc >>= 1;
                        }
                        --i;
                    }
                    ++pos;
                }
                return crc;
            }

            @Override
            synchronized byte[] communicate(ByteBuffer bb) {
                long t = System.currentTimeMillis();
                long dt = DeviceModbus.this.nextCommandTime - t;
                if (dt > 0L) {
                    if (dt > 2000L) {
                        dt = 2000L;
                    }
                    CommInterface.sleep((int)dt);
                }
                long crc = this.ModRTU_CRC(bb.getAsArray());
                bb.append((byte)(crc & 0xFFL));
                bb.append((byte)(crc >> 8));
                if (TranslatingCommInterface.this.debugLog) {
                    TranslatingCommInterface.this.logLog("Tx: " + StringUtil.hexN(bb.getAsArray()));
                }
                ((CommInterface)((Object)DeviceModbus.this.si)).flush();
                DeviceModbus.this.si.writeData(bb.getAsArray());
                byte[] answer = DeviceModbus.this.si.readData(TranslatingCommInterface.this.timeout);
                if (answer == null) {
                    CommInterface.sleep(5);
                    ((CommInterface)((Object)DeviceModbus.this.si)).flush();
                    DeviceModbus.this.si.writeData(bb.getAsArray());
                    answer = DeviceModbus.this.si.readData(TranslatingCommInterface.this.timeout);
                }
                if (TranslatingCommInterface.this.debugLog) {
                    TranslatingCommInterface.this.logLog("Rx: " + StringUtil.hexN(answer));
                }
                DeviceModbus.this.nextCommandTime = DeviceModbus.this.delayTime + System.currentTimeMillis();
                return answer;
            }

            @Override
            void writeCoil(int address, boolean value) {
                ByteBuffer bb = new ByteBuffer();
                bb.append((byte)DeviceModbus.this.modbusAddress);
                bb.append((byte)5);
                bb.append((byte)(address >> 8));
                bb.append((byte)(address & 0xFF));
                bb.append((byte)(value ? 255 : 0));
                bb.append((byte)0);
                this.communicate(bb);
            }

            @Override
            long readCoilInput(boolean dInput, int address, int count) {
                if (count > 64) {
                    count = 64;
                }
                ByteBuffer bb = new ByteBuffer();
                bb.append((byte)DeviceModbus.this.modbusAddress);
                bb.append((byte)(dInput ? 2 : 1));
                bb.append((byte)(address >> 8));
                bb.append((byte)(address & 0xFF));
                bb.append((byte)(count >> 8));
                bb.append((byte)(count & 0xFF));
                byte[] answer = this.communicate(bb);
                if ((answer[1] & 0x80) != 0) {
                    long value = -(answer[2] & 0xFF);
                    return value;
                }
                long mask = 0L;
                int i = 0;
                while (i < count) {
                    mask = mask << 1 | 1L;
                    ++i;
                }
                long value = 0L;
                int i2 = 0;
                while (i2 < answer[2]) {
                    value = value << 8 | (long)(answer[3 + i2] & 0xFF);
                    ++i2;
                }
                return value & mask;
            }

            @Override
            void writeHolding(int address, long value) {
                ByteBuffer bb = new ByteBuffer();
                bb.append((byte)DeviceModbus.this.modbusAddress);
                bb.append((byte)6);
                bb.append((byte)(address >> 8));
                bb.append((byte)(address & 0xFF));
                bb.append((byte)(value >> 8));
                bb.append((byte)(value & 0xFFL));
                this.communicate(bb);
            }

            @Override
            void writeHolding(int address, long[] values) {
                ByteBuffer bb = new ByteBuffer();
                int n = values.length;
                if (n > 123) {
                    n = 123;
                }
                bb.append((byte)DeviceModbus.this.modbusAddress);
                bb.append((byte)16);
                bb.append((byte)(address >> 8));
                bb.append((byte)(address & 0xFF));
                bb.append((byte)(n >> 8));
                bb.append((byte)(n & 0xFF));
                bb.append((byte)(n * 2));
                int i = 0;
                while (i < n) {
                    bb.append((byte)(values[i] >> 8));
                    bb.append((byte)(values[i] & 0xFFL));
                    ++i;
                }
                this.communicate(bb);
            }

            @Override
            void writeHoldingL(int address, long[] values) {
                ByteBuffer bb = new ByteBuffer();
                int n = values.length;
                if (n > 61) {
                    n = 61;
                }
                bb.append((byte)DeviceModbus.this.modbusAddress);
                bb.append((byte)16);
                bb.append((byte)(address >> 8));
                bb.append((byte)(address & 0xFF));
                bb.append((byte)(n * 2 >> 8));
                bb.append((byte)(n * 2 & 0xFF));
                bb.append((byte)(n * 4));
                int i = 0;
                while (i < n) {
                    bb.append((byte)(values[i] >> 24));
                    bb.append((byte)(values[i] >> 16));
                    bb.append((byte)(values[i] >> 8));
                    bb.append((byte)(values[i] & 0xFFL));
                    ++i;
                }
                this.communicate(bb);
            }

            @Override
            void writeHoldingF(int address, double[] values) {
                long[] lvalues = new long[values.length];
                int i = 0;
                while (i < values.length) {
                    lvalues[i] = Float.floatToIntBits((float)values[i]);
                    ++i;
                }
                this.writeHoldingL(address, lvalues);
            }

            byte[] readHoldingInputByte(boolean input, int address, int count) {
                if (count > 125) {
                    count = 125;
                }
                ByteBuffer bb = new ByteBuffer();
                bb.append((byte)DeviceModbus.this.modbusAddress);
                bb.append((byte)(input ? 4 : 3));
                bb.append((byte)(address >> 8));
                bb.append((byte)(address & 0xFF));
                bb.append((byte)(count >> 8));
                bb.append((byte)(count & 0xFF));
                return this.communicate(bb);
            }

            @Override
            byte[] readHoldingInputBytes(boolean input, int address, int count) {
                byte[] answer = this.readHoldingInputByte(input, address, count);
                return Arrays.copyOfRange(answer, 3, answer.length - 2);
            }

            @Override
            long[] readHoldingInput(boolean input, int address, int count) {
                byte[] answer = this.readHoldingInputByte(input, address, count);
                if ((answer[1] & 0x80) != 0) {
                    long value = -(answer[2] & 0xFF);
                    return new long[]{value};
                }
                long[] data = new long[answer[2] / 2];
                int i = 0;
                while (i < answer[2]) {
                    long value;
                    data[i / 2] = value = (long)((answer[3 + i] & 0xFF) << 8 | answer[4 + i] & 0xFF);
                    i += 2;
                }
                return data;
            }

            @Override
            long[] readHoldingInputS(boolean input, int address, int count) {
                byte[] answer = this.readHoldingInputByte(input, address, count);
                if ((answer[1] & 0x80) != 0) {
                    long value = -(answer[2] & 0xFF);
                    return new long[]{value};
                }
                long[] data = new long[answer[2] / 2];
                int i = 0;
                while (i < answer[2]) {
                    long value = (answer[3 + i] & 0xFF) << 8 | answer[4 + i] & 0xFF;
                    if (value > 32767L) {
                        value = 0xFFFFFFFFFFFF0000L | value;
                    }
                    data[i / 2] = value;
                    i += 2;
                }
                return data;
            }

            @Override
            long[] readHoldingInputL(boolean input, int address, int count) {
                byte[] answer = this.readHoldingInputByte(input, address, count * 2);
                if ((answer[1] & 0x80) != 0) {
                    long value = -(answer[2] & 0xFF);
                    return new long[]{value};
                }
                long[] data = new long[answer[2] / 4];
                int i = 0;
                while (i < answer[2]) {
                    long value;
                    data[i / 4] = value = ((long)answer[3 + i] & 0xFFL) << 24 | ((long)answer[4 + i] & 0xFFL) << 16 | ((long)answer[5 + i] & 0xFFL) << 8 | (long)(answer[6 + i] & 0xFF);
                    i += 4;
                }
                return data;
            }

            @Override
            long[] readHoldingInputSL(boolean input, int address, int count) {
                byte[] answer = this.readHoldingInputByte(input, address, count * 2);
                if ((answer[1] & 0x80) != 0) {
                    long value = -(answer[2] & 0xFF);
                    return new long[]{value};
                }
                long[] data = new long[answer[2] / 4];
                int i = 0;
                while (i < answer[2]) {
                    long value;
                    data[i / 4] = value = (long)((answer[3 + i] & 0xFF) << 24 | (answer[4 + i] & 0xFF) << 16 | (answer[5 + i] & 0xFF) << 8 | answer[6 + i] & 0xFF);
                    i += 4;
                }
                return data;
            }

            @Override
            double[] readHoldingInputF(boolean input, int address, int count) {
                byte[] answer = this.readHoldingInputByte(input, address, count * 2);
                if ((answer[1] & 0x80) != 0) {
                    long value = -(answer[2] & 0xFF);
                    return new double[]{value};
                }
                double[] data = new double[answer[2] / 4];
                int i = 0;
                while (i < answer[2]) {
                    long value = ((long)answer[3 + i] & 0xFFL) << 24 | ((long)answer[4 + i] & 0xFFL) << 16 | ((long)answer[5 + i] & 0xFFL) << 8 | (long)(answer[6 + i] & 0xFF);
                    data[i / 4] = Float.intBitsToFloat((int)value);
                    i += 4;
                }
                return data;
            }

            /* synthetic */ ModbusRTUInterface(ModbusRTUInterface modbusRTUInterface, ModbusRTUInterface modbusRTUInterface2) {
                this();
            }
        }

        private class ModbusRTUInterfaceKunkin
        extends ModbusRTUInterface {
            private ModbusRTUInterfaceKunkin() {
            }

            @Override
            synchronized byte[] communicate(ByteBuffer bb) {
                long t = System.currentTimeMillis();
                long dt = DeviceModbus.this.nextCommandTime - t;
                if (dt > 0L) {
                    if (dt > 2000L) {
                        dt = 2000L;
                    }
                    CommInterface.sleep((int)dt);
                }
                long crc = this.ModRTU_CRC(bb.getAsArray());
                bb.append((byte)(crc >> 8));
                bb.append((byte)(crc & 0xFFL));
                if (TranslatingCommInterface.this.debugLog) {
                    TranslatingCommInterface.this.logLog("Tx: " + StringUtil.hexN(bb.getAsArray()));
                }
                ((CommInterface)((Object)DeviceModbus.this.si)).flush();
                DeviceModbus.this.si.writeData(bb.getAsArray());
                byte[] answer = DeviceModbus.this.si.readData(TranslatingCommInterface.this.timeout);
                if (answer == null) {
                    CommInterface.sleep(5);
                    ((CommInterface)((Object)DeviceModbus.this.si)).flush();
                    DeviceModbus.this.si.writeData(bb.getAsArray());
                    answer = DeviceModbus.this.si.readData(TranslatingCommInterface.this.timeout);
                }
                if (TranslatingCommInterface.this.debugLog) {
                    TranslatingCommInterface.this.logLog("Rx: " + StringUtil.hexN(answer));
                }
                DeviceModbus.this.nextCommandTime = DeviceModbus.this.delayTime + System.currentTimeMillis();
                return answer;
            }

            void writeKunkin(int address, int bytesWord, long value) {
                ByteBuffer bb = new ByteBuffer();
                bb.append((byte)DeviceModbus.this.modbusAddress);
                bb.append((byte)6);
                bb.append((byte)(address >> 8));
                bb.append((byte)(address & 0xFF));
                bb.append((byte)0);
                bb.append((byte)1);
                bb.append((byte)bytesWord);
                switch (bytesWord) {
                    case 1: {
                        bb.append((byte)(value & 0xFFL));
                        break;
                    }
                    case 2: {
                        bb.append((byte)(value >> 8 & 0xFFL));
                        bb.append((byte)(value & 0xFFL));
                        break;
                    }
                    case 4: {
                        bb.append((byte)(value >> 24 & 0xFFL));
                        bb.append((byte)(value >> 16 & 0xFFL));
                        bb.append((byte)(value >> 8 & 0xFFL));
                        bb.append((byte)(value & 0xFFL));
                    }
                }
                this.communicate(bb);
            }

            @Override
            void writeHolding(int address, long value) {
                this.writeKunkin(address, 1, value);
            }

            @Override
            void writeHolding(int address, long[] values) {
            }

            @Override
            void writeHoldingL(int address, long[] values) {
                this.writeKunkin(address, 4, values[0]);
            }

            @Override
            long[] readHoldingInput(boolean input, int address, int count) {
                byte[] answer = this.readHoldingInputByte(input, address, count * 2);
                if ((answer[1] & 0x80) != 0) {
                    long value = -(answer[2] & 0xFF);
                    return new long[]{value};
                }
                if (address == 768) {
                    long[] data = new long[2];
                    int i = 0;
                    while (i < 2) {
                        long value;
                        data[i] = value = ((long)answer[5 + i * 3] & 0xFFL) << 16 | ((long)answer[6 + i * 3] & 0xFFL) << 8 | (long)answer[7 + i * 3] & 0xFFL;
                        ++i;
                    }
                    return data;
                }
                if (address == 769) {
                    long value;
                    long[] data = new long[4];
                    int i = 0;
                    while (i < 2) {
                        data[i] = value = ((long)answer[5 + i * 3] & 0xFFL) << 16 | ((long)answer[6 + i * 3] & 0xFFL) << 8 | (long)answer[7 + i * 3] & 0xFFL;
                        ++i;
                    }
                    i = 0;
                    while (i < 2) {
                        data[i + 2] = value = ((long)answer[27 + i * 4] & 0xFFL) << 24 | ((long)answer[28 + i * 4] & 0xFFL) << 16 | ((long)answer[29 + i * 4] & 0xFFL) << 8 | (long)(answer[30 + i * 4] & 0xFF);
                        ++i;
                    }
                    return data;
                }
                int bytes = answer[2];
                if (bytes > answer.length - 5) {
                    bytes = answer.length - 5;
                }
                long[] data = new long[bytes / 2];
                int i = 0;
                while (i < bytes) {
                    long value;
                    data[i / 2] = value = (long)((answer[3 + i] & 0xFF) << 8 | answer[4 + i] & 0xFF);
                    i += 2;
                }
                return data;
            }

            @Override
            long[] readHoldingInputL(boolean input, int address, int count) {
                byte[] answer = this.readHoldingInputByte(input, address, count * 4);
                if ((answer[1] & 0x80) != 0) {
                    long value = -(answer[2] & 0xFF);
                    return new long[]{value};
                }
                if (address == 768) {
                    long[] data = new long[2];
                    int i = 0;
                    while (i < 2) {
                        long value;
                        data[i] = value = ((long)answer[5 + i * 3] & 0xFFL) << 16 | ((long)answer[6 + i * 3] & 0xFFL) << 8 | (long)answer[7 + i * 3] & 0xFFL;
                        ++i;
                    }
                    return data;
                }
                if (address == 769) {
                    long value;
                    long[] data = new long[4];
                    int i = 0;
                    while (i < 2) {
                        data[i] = value = ((long)answer[5 + i * 3] & 0xFFL) << 16 | ((long)answer[6 + i * 3] & 0xFFL) << 8 | (long)answer[7 + i * 3] & 0xFFL;
                        ++i;
                    }
                    i = 0;
                    while (i < 2) {
                        data[i + 2] = value = ((long)answer[27 + i * 4] & 0xFFL) << 24 | ((long)answer[28 + i * 4] & 0xFFL) << 16 | ((long)answer[29 + i * 4] & 0xFFL) << 8 | (long)(answer[30 + i * 4] & 0xFF);
                        ++i;
                    }
                    return data;
                }
                int bytes = answer[2];
                if (bytes > answer.length - 5) {
                    bytes = answer.length - 7;
                }
                long[] data = new long[bytes / 4];
                int i = 0;
                while (i < bytes) {
                    long value;
                    data[i / 4] = value = ((long)answer[3 + i] & 0xFFL) << 24 | ((long)answer[4 + i] & 0xFFL) << 16 | ((long)answer[5 + i] & 0xFFL) << 8 | (long)(answer[6 + i] & 0xFF);
                    i += 4;
                }
                return data;
            }

            /* synthetic */ ModbusRTUInterfaceKunkin(ModbusRTUInterfaceKunkin modbusRTUInterfaceKunkin, ModbusRTUInterfaceKunkin modbusRTUInterfaceKunkin2) {
                this();
            }
        }

        private class ModbusRTUInterfaceKunkinx
        extends ModbusRTUInterfaceKunkin {
            private ModbusRTUInterfaceKunkinx() {
            }

            @Override
            synchronized byte[] communicate(ByteBuffer bb) {
                long t = System.currentTimeMillis();
                long dt = DeviceModbus.this.nextCommandTime - t;
                if (dt > 0L) {
                    if (dt > 2000L) {
                        dt = 2000L;
                    }
                    CommInterface.sleep((int)dt);
                }
                long crc = this.ModRTU_CRC(bb.getAsArray());
                bb.append((byte)(crc & 0xFFL));
                bb.append((byte)(crc >> 8));
                if (TranslatingCommInterface.this.debugLog) {
                    TranslatingCommInterface.this.logLog("Tx: " + StringUtil.hexN(bb.getAsArray()));
                }
                ((CommInterface)((Object)DeviceModbus.this.si)).flush();
                DeviceModbus.this.si.writeData(bb.getAsArray());
                byte[] answer = DeviceModbus.this.si.readData(TranslatingCommInterface.this.timeout);
                if (answer == null) {
                    CommInterface.sleep(5);
                    ((CommInterface)((Object)DeviceModbus.this.si)).flush();
                    DeviceModbus.this.si.writeData(bb.getAsArray());
                    answer = DeviceModbus.this.si.readData(TranslatingCommInterface.this.timeout);
                }
                if (TranslatingCommInterface.this.debugLog) {
                    TranslatingCommInterface.this.logLog("Rx: " + StringUtil.hexN(answer));
                }
                DeviceModbus.this.nextCommandTime = DeviceModbus.this.delayTime + System.currentTimeMillis();
                return answer;
            }
        }

        private class ModbusTCPInterface
        extends ModbusInterface {
            int transactionId = 0;

            private ModbusTCPInterface() {
            }

            @Override
            synchronized byte[] communicate(ByteBuffer bb) {
                long t = System.currentTimeMillis();
                long dt = DeviceModbus.this.nextCommandTime - t;
                if (dt > 0L) {
                    if (dt > 2000L) {
                        dt = 2000L;
                    }
                    CommInterface.sleep((int)dt);
                }
                int l = bb.getSize() - 6;
                bb.change(4, (byte)(l >> 8));
                bb.change(5, (byte)(l & 0xFF));
                if (TranslatingCommInterface.this.debugLog) {
                    TranslatingCommInterface.this.logLog("Tx: " + StringUtil.hexN(bb.getAsArray()));
                }
                ((CommInterface)((Object)DeviceModbus.this.si)).flush();
                DeviceModbus.this.si.writeData(bb.getAsArray());
                byte[] answer = DeviceModbus.this.si.readData(TranslatingCommInterface.this.timeout);
                if (answer == null) {
                    CommInterface.sleep(5);
                    ((CommInterface)((Object)DeviceModbus.this.si)).flush();
                    DeviceModbus.this.si.writeData(bb.getAsArray());
                    answer = DeviceModbus.this.si.readData(TranslatingCommInterface.this.timeout);
                }
                if (TranslatingCommInterface.this.debugLog) {
                    TranslatingCommInterface.this.logLog("Rx: " + StringUtil.hexN(answer));
                }
                DeviceModbus.this.nextCommandTime = DeviceModbus.this.delayTime + System.currentTimeMillis();
                return answer;
            }

            private void makeHeader(ByteBuffer bb) {
                ++this.transactionId;
                bb.append((byte)(this.transactionId >> 8));
                bb.append((byte)(this.transactionId & 0xFF));
                bb.append((byte)0);
                bb.append((byte)0);
                bb.append((byte)0);
                bb.append((byte)0);
                bb.append((byte)this.unitId);
            }

            @Override
            void writeCoil(int address, boolean value) {
                ByteBuffer bb = new ByteBuffer();
                this.makeHeader(bb);
                bb.append((byte)5);
                bb.append((byte)(address >> 8));
                bb.append((byte)(address & 0xFF));
                bb.append((byte)(value ? 255 : 0));
                bb.append((byte)0);
                this.communicate(bb);
            }

            @Override
            long readCoilInput(boolean dInput, int address, int count) {
                if (count > 64) {
                    count = 64;
                }
                ByteBuffer bb = new ByteBuffer();
                this.makeHeader(bb);
                bb.append((byte)(dInput ? 2 : 1));
                bb.append((byte)(address >> 8));
                bb.append((byte)(address & 0xFF));
                bb.append((byte)(count >> 8));
                bb.append((byte)(count & 0xFF));
                byte[] answer = this.communicate(bb);
                if ((answer[1] & 0x80) != 0) {
                    long value = -(answer[2] & 0xFF);
                    return value;
                }
                long mask = 0L;
                int i = 0;
                while (i < count) {
                    mask = mask << 1 | 1L;
                    ++i;
                }
                long value = 0L;
                int i2 = 0;
                while (i2 < answer[2]) {
                    value = value << 8 | (long)(answer[3 + i2] & 0xFF);
                    ++i2;
                }
                return value & mask;
            }

            @Override
            void writeHolding(int address, long value) {
                ByteBuffer bb = new ByteBuffer();
                this.makeHeader(bb);
                bb.append((byte)6);
                bb.append((byte)(address >> 8));
                bb.append((byte)(address & 0xFF));
                bb.append((byte)(value >> 8));
                bb.append((byte)(value & 0xFFL));
                this.communicate(bb);
            }

            @Override
            void writeHolding(int address, long[] values) {
                ByteBuffer bb = new ByteBuffer();
                this.makeHeader(bb);
                int n = values.length;
                if (n > 63) {
                    n = 63;
                }
                bb.append((byte)16);
                bb.append((byte)(address >> 8));
                bb.append((byte)(address & 0xFF));
                bb.append((byte)(n >> 8));
                bb.append((byte)(n & 0xFF));
                bb.append((byte)(n * 2));
                int i = 0;
                while (i < n) {
                    bb.append((byte)(values[i] >> 8));
                    bb.append((byte)(values[i] & 0xFFL));
                    ++i;
                }
                this.communicate(bb);
            }

            @Override
            void writeHoldingL(int address, long[] values) {
                ByteBuffer bb = new ByteBuffer();
                this.makeHeader(bb);
                int n = values.length;
                if (n > 31) {
                    n = 31;
                }
                bb.append((byte)16);
                bb.append((byte)(address >> 8));
                bb.append((byte)(address & 0xFF));
                bb.append((byte)(n * 2 >> 8));
                bb.append((byte)(n * 2 & 0xFF));
                bb.append((byte)(n * 4));
                int i = 0;
                while (i < n) {
                    bb.append((byte)(values[i] >> 24));
                    bb.append((byte)(values[i] >> 16));
                    bb.append((byte)(values[i] >> 8));
                    bb.append((byte)(values[i] & 0xFFL));
                    ++i;
                }
                this.communicate(bb);
            }

            @Override
            void writeHoldingF(int address, double[] values) {
                long[] lvalues = new long[values.length];
                int i = 0;
                while (i < values.length) {
                    lvalues[i] = Float.floatToIntBits((float)values[i]);
                    ++i;
                }
                this.writeHoldingL(address, lvalues);
            }

            byte[] readHoldingInputByte(boolean input, int address, int count) {
                if (count > 125) {
                    count = 125;
                }
                ByteBuffer bb = new ByteBuffer();
                this.makeHeader(bb);
                bb.append((byte)(input ? 4 : 3));
                bb.append((byte)(address >> 8));
                bb.append((byte)(address & 0xFF));
                bb.append((byte)(count >> 8));
                bb.append((byte)(count & 0xFF));
                return this.communicate(bb);
            }

            @Override
            byte[] readHoldingInputBytes(boolean input, int address, int count) {
                byte[] answer = this.readHoldingInputByte(input, address, count);
                return Arrays.copyOfRange(answer, 9, answer.length);
            }

            @Override
            long[] readHoldingInput(boolean input, int address, int count) {
                byte[] answer = this.readHoldingInputByte(input, address, count);
                if ((answer[7] & 0x80) != 0) {
                    long value = -(answer[8] & 0xFF);
                    return new long[]{value};
                }
                long[] data = new long[answer[8] / 2];
                int i = 0;
                while (i < answer[8]) {
                    long value;
                    data[i / 2] = value = (long)((answer[9 + i] & 0xFF) << 8 | answer[10 + i] & 0xFF);
                    i += 2;
                }
                return data;
            }

            @Override
            long[] readHoldingInputS(boolean input, int address, int count) {
                byte[] answer = this.readHoldingInputByte(input, address, count);
                if ((answer[7] & 0x80) != 0) {
                    long value = -(answer[8] & 0xFF);
                    return new long[]{value};
                }
                long[] data = new long[answer[8] / 2];
                int i = 0;
                while (i < answer[8]) {
                    long value = (answer[9 + i] & 0xFF) << 8 | answer[10 + i] & 0xFF;
                    if (value > 32767L) {
                        value = 0xFFFFFFFFFFFF0000L | value;
                    }
                    data[i / 2] = value;
                    i += 2;
                }
                return data;
            }

            @Override
            long[] readHoldingInputL(boolean input, int address, int count) {
                byte[] answer = this.readHoldingInputByte(input, address, count * 2);
                if ((answer[7] & 0x80) != 0) {
                    long value = -(answer[8] & 0xFF);
                    return new long[]{value};
                }
                long[] data = new long[answer[8] / 4];
                int i = 0;
                while (i < answer[8]) {
                    long value;
                    data[i / 4] = value = ((long)answer[9 + i] & 0xFFL) << 24 | ((long)answer[10 + i] & 0xFFL) << 16 | ((long)answer[11 + i] & 0xFFL) << 8 | (long)(answer[12 + i] & 0xFF);
                    i += 4;
                }
                return data;
            }

            @Override
            long[] readHoldingInputSL(boolean input, int address, int count) {
                byte[] answer = this.readHoldingInputByte(input, address, count * 2);
                if ((answer[7] & 0x80) != 0) {
                    long value = -(answer[8] & 0xFF);
                    return new long[]{value};
                }
                long[] data = new long[answer[8] / 4];
                int i = 0;
                while (i < answer[8]) {
                    long value;
                    data[i / 4] = value = (long)((answer[9 + i] & 0xFF) << 24 | (answer[10 + i] & 0xFF) << 16 | (answer[11 + i] & 0xFF) << 8 | answer[12 + i] & 0xFF);
                    i += 4;
                }
                return data;
            }

            @Override
            double[] readHoldingInputF(boolean input, int address, int count) {
                byte[] answer = this.readHoldingInputByte(input, address, count * 2);
                if ((answer[7] & 0x80) != 0) {
                    long value = -(answer[8] & 0xFF);
                    return new double[]{value};
                }
                double[] data = new double[answer[8] / 4];
                int i = 0;
                while (i < answer[8]) {
                    long value = ((long)answer[9 + i] & 0xFFL) << 24 | ((long)answer[10 + i] & 0xFFL) << 16 | ((long)answer[11 + i] & 0xFFL) << 8 | (long)(answer[12 + i] & 0xFF);
                    data[i / 4] = Float.intBitsToFloat((int)value);
                    i += 4;
                }
                return data;
            }
        }
    }
}

