/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.comm.SerialPacketInterface;
import dk.hkj.comm.TranslatingInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.StringUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;

public class DeviceIT85xx
extends DeviceInterface {
    private CommInterface ci;
    private String idName = "Itech";
    private String longName = "Itech";
    private NumberFormat nf;
    private final byte SetRemoteControl = (byte)32;
    private final byte SetLoadOn = (byte)33;
    private final byte SetMaxVoltage = (byte)34;
    private final byte GetMaxVoltage = (byte)35;
    private final byte SetMaxCurrent = (byte)36;
    private final byte GetMaxCurrent = (byte)37;
    private final byte SetMaxPower = (byte)38;
    private final byte GetMaxPower = (byte)39;
    private final byte SetMode = (byte)40;
    private final byte GetMode = (byte)41;
    private final byte SetCVVoltage = (byte)44;
    private final byte GetCVVoltage = (byte)45;
    private final byte SetCCCurrent = (byte)42;
    private final byte GetCCCurrent = (byte)43;
    private final byte SetCWPower = (byte)46;
    private final byte GetCWPower = (byte)47;
    private final byte SetCRResistance = (byte)48;
    private final byte GetCRResistance = (byte)49;
    private final byte SetVonMode = (byte)14;
    private final byte GetVonMode = (byte)15;
    private final byte SetVon = (byte)16;
    private final byte GetVon = (byte)17;
    private final byte SetLocalKey = (byte)85;
    private final byte SetSense = (byte)86;
    private final byte GetSense = (byte)87;
    private final byte SetAdvancedMode = (byte)93;
    private final byte GetAdvancedMode = (byte)94;
    private final byte GetActualInput = (byte)95;
    private final byte GetModel = (byte)106;
    private final byte GetLimits = 1;
    private final byte SetHardwareOPP = (byte)2;
    private final byte GetHardwareOPP = (byte)3;
    private final byte SetOPP = (byte)-122;
    private final byte GetOPP = (byte)-121;
    private final byte SetDelayOPP = (byte)-120;
    private final byte GetDelayOPP = (byte)-119;
    private final byte GetOCP = (byte)-127;
    private final byte SetOCP = (byte)-128;
    private final byte SetEnableOCP = (byte)-124;
    private final byte GetEnableOCP = (byte)-123;
    private final byte SetDelayOCP = (byte)-126;
    private final byte GetDelayOCP = (byte)-125;
    private final byte ClearProtection = (byte)-112;
    private double capacity = 0.0;
    private double energy = 0.0;
    private long timeStamp = 0L;
    private static final byte packetStart = -86;

    public DeviceIT85xx(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats.add(new ValueFormat("Voltage", "V", ValueFormat.formatD4));
        this.valueFormats.add(new ValueFormat("Current", "A", ValueFormat.formatD3));
        this.valueFormats.add(new ValueFormat("Power", "W", ValueFormat.formatD3));
        this.valueFormats.add(new ValueFormat("Capacity", "Ah", ValueFormat.formatD3));
        this.valueFormats.add(new ValueFormat("Energy", "Wh", ValueFormat.formatD3));
        this.nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(4);
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        this.valueNames = new ArrayList();
        this.valueNames.add("Voltage");
        this.valueNames.add("Current");
        this.valueNames.add("Power");
        this.valueNames.add("Capacity");
        this.valueNames.add("Energy");
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUES?");
    }

    @Override
    public void threadStarted(InterfaceThreads.DeviceThread deviceThread) {
        super.threadStarted(deviceThread);
    }

    public static String deviceName() {
        return "IT85xx";
    }

    @Override
    public String getDeviceName() {
        return this.longName;
    }

    @Override
    public String getDeviceId() {
        return this.def.getIdName();
    }

    private static int answerLong(byte[] answer, int ofs) {
        return (answer[ofs] & 0xFF) + (answer[ofs + 1] & 0xFF) * 256 + (answer[ofs + 2] & 0xFF) * 256 * 256 + (answer[ofs + 3] & 0xFF) * 256 * 256 * 256;
    }

    private static int answerInt(byte[] answer, int ofs) {
        return (answer[ofs] & 0xFF) + (answer[ofs + 1] & 0xFF) * 256;
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        SerialPacketInterface si = ((SerialInterface)ci).getDataInterface();
        si.setPacketFormat(CommDataInterface.PacketFormat.HeaderFixedLength, (byte)-86, 26);
        this.ci = new TranslatingCommInterface(si);
        return this.ci;
    }

    class TranslatingCommInterface
    extends TranslatingInterface {
        protected TranslatingCommInterface(CommInterface ci) {
            super(ci);
        }

        private byte[] communicate(int cmd) {
            return this.communicate(cmd, null);
        }

        private byte[] communicate(int cmd, int param) {
            byte[] p = new byte[]{(byte)(param & 0xFF), (byte)(param / 256 & 0xFF)};
            return this.communicate(cmd, p);
        }

        private byte[] communicate(int cmd, long param) {
            byte[] p = new byte[]{(byte)(param & 0xFFL), (byte)(param / 256L & 0xFFL), (byte)(param / 65536L & 0xFFL), (byte)(param / 0x1000000L & 0xFFL)};
            return this.communicate(cmd, p);
        }

        private synchronized byte[] communicate(int cmd, byte[] params) {
            try {
                byte[] packet = new byte[26];
                int i = 0;
                while (i < packet.length) {
                    packet[i] = 0;
                    ++i;
                }
                packet[0] = -86;
                packet[1] = 0;
                packet[2] = (byte)cmd;
                if (params != null) {
                    i = 0;
                    while (i < params.length) {
                        packet[3 + i] = params[i];
                        ++i;
                    }
                }
                byte sum = 0;
                int i2 = 0;
                while (i2 < packet.length - 1) {
                    sum = (byte)(sum + packet[i2]);
                    ++i2;
                }
                packet[25] = sum;
                ((SerialPacketInterface)this.originalCommInterface).writeData(packet);
                return this.getAnswer(cmd);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                return null;
            }
        }

        private byte[] getAnswer(int cmd) {
            byte[] answer = ((SerialPacketInterface)this.originalCommInterface).readData();
            if (answer == null) {
                this.log("No answer received");
                return null;
            }
            byte sum = 0;
            int i = 0;
            while (i < answer.length - 1) {
                sum = (byte)(sum + answer[i]);
                ++i;
            }
            if (answer[25] != sum) {
                this.log("Checksum error");
                return null;
            }
            if (answer[2] == 18) {
                switch (answer[3]) {
                    case -112: {
                        this.log("checksum incorrect");
                        break;
                    }
                    case -96: {
                        this.log("parameter incorrect");
                        break;
                    }
                    case -80: {
                        this.log("unreconized command");
                        break;
                    }
                    case -64: {
                        this.log("invalid command");
                    }
                }
                return null;
            }
            if (answer[2] != cmd) {
                this.log("Answer do not match command");
                return null;
            }
            return answer;
        }

        private void cmdIdn() {
            String version;
            byte[] answer = this.communicate(106);
            if (answer == null) {
                return;
            }
            String model = String.valueOf(String.valueOf((char)answer[3])) + String.valueOf((char)answer[4]) + String.valueOf((char)answer[5]) + String.valueOf((char)answer[6]);
            if (answer[7] != 0) {
                model = String.valueOf(model) + String.valueOf((char)answer[7]);
            }
            if ((version = String.valueOf(StringUtil.hex2(answer[9])) + "." + StringUtil.hex2(answer[8])).charAt(0) == '0') {
                version = version.substring(1);
            }
            StringBuilder sn = new StringBuilder();
            int i = 10;
            while (i <= 20) {
                sn.append((char)answer[i]);
                ++i;
            }
            DeviceIT85xx.this.idName = "ITECH Ltd, IT" + model + ",";
            DeviceIT85xx.this.longName = "Itech IT" + model + "+";
            if (DeviceIT85xx.this.getHandleName() == null || DeviceIT85xx.this.getHandleName().length() == 0) {
                DeviceIT85xx.this.setHandleName("IT" + model);
            }
            DeviceIT85xx.this.setSerialNumber(sn.toString());
            this.message.add(String.valueOf(DeviceIT85xx.this.idName) + sn.toString() + "," + version);
        }

        private void cmdValues() {
            byte[] answer = this.communicate(95);
            if (answer == null) {
                return;
            }
            double volt = (double)DeviceIT85xx.answerLong(answer, 3) / 1000.0;
            double current = (double)DeviceIT85xx.answerLong(answer, 7) / 10000.0;
            double power = (double)DeviceIT85xx.answerLong(answer, 11) / 1000.0;
            long time = System.currentTimeMillis();
            long dt = time - DeviceIT85xx.this.timeStamp;
            DeviceIT85xx.this.timeStamp = time;
            double deltaHours = (double)dt / 3600000.0;
            if (dt < 30000L) {
                DeviceIT85xx deviceIT85xx = DeviceIT85xx.this;
                deviceIT85xx.capacity = deviceIT85xx.capacity + current * deltaHours;
                DeviceIT85xx deviceIT85xx2 = DeviceIT85xx.this;
                deviceIT85xx2.energy = deviceIT85xx2.energy + power * deltaHours;
            } else {
                DeviceIT85xx.this.capacity = 0.0;
                DeviceIT85xx.this.energy = 0.0;
            }
            this.message.add(String.valueOf(DeviceIT85xx.this.nf.format(volt)) + " " + DeviceIT85xx.this.nf.format(current) + " " + DeviceIT85xx.this.nf.format(power) + " " + DeviceIT85xx.this.nf.format(DeviceIT85xx.this.capacity) + " " + DeviceIT85xx.this.nf.format(DeviceIT85xx.this.energy));
        }

        private void cmdOn(boolean on) {
            if (on) {
                DeviceIT85xx.this.capacity = 0.0;
                DeviceIT85xx.this.energy = 0.0;
                DeviceIT85xx.this.timeStamp = System.currentTimeMillis();
            }
            this.communicate(33, on ? 1 : 0);
        }

        private void cmdOn() {
            byte[] answer = this.communicate(95);
            if (answer == null) {
                return;
            }
            this.message.add((answer[15] & 8) != 0 ? "1" : "0");
        }

        private void cmdVoltage(double voltage) {
            this.communicate(93, 0);
            this.communicate(40, 1);
            this.communicate(44, (long)(voltage * 1000.0));
        }

        private void cmdCurrent(double current) {
            this.communicate(93, 0);
            this.communicate(40, 0);
            this.communicate(42, (long)(current * 10000.0));
        }

        private void cmdPower(double power) {
            this.communicate(93, 0);
            this.communicate(40, 2);
            this.communicate(46, (long)(power * 1000.0));
        }

        private void cmdResistance(double resistance) {
            this.communicate(93, 0);
            this.communicate(40, 3);
            this.communicate(48, (long)(resistance * 1000.0));
        }

        private void cmdVoltage() {
            byte[] answer = this.communicate(45);
            if (answer == null) {
                return;
            }
            double volt = (double)DeviceIT85xx.answerLong(answer, 3) / 1000.0;
            this.message.add(DeviceIT85xx.this.nf.format(volt));
        }

        private void cmdCurrent() {
            byte[] answer = this.communicate(43);
            double volt = (double)DeviceIT85xx.answerLong(answer, 3) / 10000.0;
            this.message.add(DeviceIT85xx.this.nf.format(volt));
        }

        private void cmdPower() {
            byte[] answer = this.communicate(47);
            if (answer == null) {
                return;
            }
            double volt = (double)DeviceIT85xx.answerLong(answer, 3) / 1000.0;
            this.message.add(DeviceIT85xx.this.nf.format(volt));
        }

        private void cmdResistance() {
            byte[] answer = this.communicate(49);
            if (answer == null) {
                return;
            }
            double volt = (double)DeviceIT85xx.answerLong(answer, 3) / 1000.0;
            this.message.add(DeviceIT85xx.this.nf.format(volt));
        }

        private void cmdMaxVoltage(double voltage) {
            this.communicate(34, (long)(voltage * 1000.0));
        }

        private void cmdMaxCurrent(double current) {
            this.communicate(36, (long)(current * 10000.0));
        }

        private void cmdMaxPower(double power) {
            this.communicate(38, (long)(power * 1000.0));
        }

        private void cmdMaxVoltage() {
            byte[] answer = this.communicate(35);
            if (answer == null) {
                return;
            }
            double volt = (double)DeviceIT85xx.answerLong(answer, 3) / 1000.0;
            this.message.add(DeviceIT85xx.this.nf.format(volt));
        }

        private void cmdMaxCurrent() {
            byte[] answer = this.communicate(37);
            if (answer == null) {
                return;
            }
            double current = (double)DeviceIT85xx.answerLong(answer, 3) / 10000.0;
            this.message.add(DeviceIT85xx.this.nf.format(current));
        }

        private void cmdMaxPower() {
            byte[] answer = this.communicate(39);
            if (answer == null) {
                return;
            }
            double power = (double)DeviceIT85xx.answerLong(answer, 3) / 1000.0;
            this.message.add(DeviceIT85xx.this.nf.format(power));
        }

        private void cmdMode(int mode) {
            this.communicate(93, 0);
            this.communicate(40, mode & 0xA);
            if (mode >= 10) {
                this.communicate(93, mode / 10);
            }
        }

        private void cmdMode() {
            byte[] answer = this.communicate(41);
            if (answer == null) {
                return;
            }
            byte mode = answer[3];
            answer = this.communicate(94);
            if (answer == null) {
                return;
            }
            byte amode = answer[3];
            StringBuilder sb = new StringBuilder();
            sb.append(mode + amode * 10);
            sb.append(" ");
            switch (mode) {
                case 0: {
                    sb.append("CC");
                    break;
                }
                case 1: {
                    sb.append("CV");
                    break;
                }
                case 2: {
                    sb.append("CW");
                    break;
                }
                case 3: {
                    sb.append("CR");
                }
            }
            switch (amode) {
                case 0: {
                    break;
                }
                case 1: {
                    sb.append(" Short");
                    break;
                }
                case 2: {
                    sb.append(" Transistion");
                    break;
                }
                case 3: {
                    sb.append(" List");
                    break;
                }
                case 5: {
                    sb.append(" Battery");
                }
            }
            this.message.add(sb.toString());
        }

        private void cmdSense(boolean on) {
            this.communicate(86, on ? 1 : 0);
        }

        private void cmdSense() {
            byte[] answer = this.communicate(87);
            if (answer == null) {
                return;
            }
            this.message.add(answer[3] != 0 ? "1" : "0");
        }

        private void cmdRemote(boolean on) {
            this.communicate(32, 1);
            this.communicate(85, on ? 0 : 1);
            if (!on) {
                this.communicate(32, 0);
            }
        }

        private void cmdRemote() {
            byte[] answer = this.communicate(95);
            if (answer == null) {
                return;
            }
            this.message.add((answer[15] & 4) != 0 ? "1" : "0");
        }

        private void cmdLimits() {
            byte[] answer = this.communicate(1);
            if (answer == null) {
                return;
            }
            StringBuilder sb = new StringBuilder();
            sb.append(DeviceIT85xx.this.nf.format((double)DeviceIT85xx.answerLong(answer, 3) / 10000.0));
            sb.append(' ');
            sb.append(DeviceIT85xx.this.nf.format((double)DeviceIT85xx.answerLong(answer, 7) / 1000.0));
            sb.append(' ');
            sb.append(DeviceIT85xx.this.nf.format((double)DeviceIT85xx.answerLong(answer, 11) / 1000.0));
            sb.append(' ');
            sb.append(DeviceIT85xx.this.nf.format((double)DeviceIT85xx.answerLong(answer, 15) / 1000.0));
            sb.append(' ');
            sb.append(DeviceIT85xx.this.nf.format((double)DeviceIT85xx.answerLong(answer, 19) / 1000.0));
            sb.append(' ');
            sb.append(DeviceIT85xx.this.nf.format((double)DeviceIT85xx.answerInt(answer, 23) / 1000.0));
            sb.append(' ');
            this.message.add(sb.toString());
        }

        private void cmdHardwareOPP(double power) {
            this.communicate(2, (long)(power * 1000.0));
        }

        private void cmdHardwareOPP() {
            byte[] answer = this.communicate(3);
            if (answer == null) {
                return;
            }
            this.message.add(DeviceIT85xx.this.nf.format((double)DeviceIT85xx.answerLong(answer, 3) / 1000.0));
        }

        private void cmdOPP(double power) {
            this.communicate(-122, (long)(power * 1000.0));
        }

        private void cmdOPP() {
            byte[] answer = this.communicate(-121);
            if (answer == null) {
                return;
            }
            this.message.add(DeviceIT85xx.this.nf.format((double)DeviceIT85xx.answerLong(answer, 3) / 1000.0));
        }

        private void cmdDelayOPP(double time) {
            this.communicate(-120, Math.min((int)time, 255));
        }

        int unsigned(byte b) {
            return b < 0 ? 256 + b : b;
        }

        private void cmdDelayOPP() {
            byte[] answer = this.communicate(-119);
            if (answer == null) {
                return;
            }
            this.message.add(Integer.toString(this.unsigned(answer[3])));
        }

        private void cmdOCP(double current) {
            this.communicate(-128, (long)(current * 10000.0));
        }

        private void cmdOCP() {
            byte[] answer = this.communicate(-127);
            if (answer == null) {
                return;
            }
            this.message.add(DeviceIT85xx.this.nf.format((double)DeviceIT85xx.answerLong(answer, 3) / 10000.0));
        }

        private void cmdDelayOCP(double time) {
            this.communicate(-126, Math.min((int)time, 255));
        }

        private void cmdDelayOCP() {
            byte[] answer = this.communicate(-125);
            if (answer == null) {
                return;
            }
            this.message.add(Integer.toString(this.unsigned(answer[3])));
        }

        private void cmdEnableOCP(boolean enable) {
            this.communicate(-124, enable ? 1 : 0);
        }

        private void cmdEnableOCP() {
            byte[] answer = this.communicate(-123);
            if (answer == null) {
                return;
            }
            this.message.add(answer[3] != 0 ? "1" : "0");
        }

        private void cmdVonMode(boolean on) {
            this.communicate(14, (byte)(on ? 1 : 0));
        }

        private void cmdVonMode() {
            byte[] answer = this.communicate(15);
            if (answer == null) {
                return;
            }
            this.message.add((answer[3] & 1) != 0 ? "1" : "0");
        }

        private void cmdVon(double von) {
            this.communicate(16, (long)(von * 1000.0));
        }

        private void cmdVon() {
            byte[] answer = this.communicate(17);
            if (answer == null) {
                return;
            }
            this.message.add(DeviceIT85xx.this.nf.format((double)DeviceIT85xx.answerLong(answer, 3) / 1000.0));
        }

        private void cmdClearProtection() {
            this.communicate(-112);
        }

        @Override
        public boolean write(String msg) {
            if (!this.originalCommInterface.isOpen()) {
                return false;
            }
            this.log("vTx:", msg);
            String[] ss = msg.trim().split("[ ]");
            String cmd = ss[0].toLowerCase().trim();
            if (cmd.equals("*idn?")) {
                this.cmdIdn();
            } else if (cmd.equals("values?")) {
                this.cmdValues();
            } else if (cmd.equals("on")) {
                this.cmdOn(StringUtil.parseInt(ss[1]) != 0);
            } else if (cmd.equals("voltage")) {
                this.cmdVoltage(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("current")) {
                this.cmdCurrent(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("resistance")) {
                this.cmdResistance(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("power")) {
                this.cmdPower(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("on?")) {
                this.cmdOn();
            } else if (cmd.equals("voltage?")) {
                this.cmdVoltage();
            } else if (cmd.equals("current?")) {
                this.cmdCurrent();
            } else if (cmd.equals("resistance?")) {
                this.cmdResistance();
            } else if (cmd.equals("power?")) {
                this.cmdPower();
            } else if (cmd.equals("maxvoltage")) {
                this.cmdMaxVoltage(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("maxcurrent")) {
                this.cmdMaxCurrent(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("maxpower")) {
                this.cmdMaxPower(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("maxvoltage?")) {
                this.cmdMaxVoltage();
            } else if (cmd.equals("maxcurrent?")) {
                this.cmdMaxCurrent();
            } else if (cmd.equals("maxpower?")) {
                this.cmdMaxPower();
            } else if (cmd.equals("mode")) {
                this.cmdMode(StringUtil.parseInt(ss[1]));
            } else if (cmd.equals("mode?")) {
                this.cmdMode();
            } else if (cmd.equals("sense")) {
                this.cmdSense(StringUtil.parseInt(ss[1]) != 0);
            } else if (cmd.equals("sense?")) {
                this.cmdSense();
            } else if (cmd.equals("remote")) {
                this.cmdRemote(StringUtil.parseInt(ss[1]) != 0);
            } else if (cmd.equals("remote?")) {
                this.cmdRemote();
            } else if (cmd.equals("limits?")) {
                this.cmdLimits();
            } else if (cmd.equals("hardwareopp?")) {
                this.cmdHardwareOPP();
            } else if (cmd.equals("opp?")) {
                this.cmdOPP();
            } else if (cmd.equals("delayopp?")) {
                this.cmdDelayOPP();
            } else if (cmd.equals("ocp?")) {
                this.cmdOCP();
            } else if (cmd.equals("delayocp?")) {
                this.cmdDelayOCP();
            } else if (cmd.equals("enableocp?")) {
                this.cmdEnableOCP();
            } else if (cmd.equals("hardwareopp")) {
                this.cmdHardwareOPP(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("opp")) {
                this.cmdOPP(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("delayopp")) {
                this.cmdDelayOPP(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("ocp")) {
                this.cmdOCP(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("delayocp")) {
                this.cmdDelayOCP(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("enableocp")) {
                this.cmdEnableOCP(StringUtil.parseInt(ss[1]) != 0);
            } else if (cmd.equals("clearprotection")) {
                this.cmdClearProtection();
            } else if (cmd.equals("vonmode")) {
                this.cmdVonMode(StringUtil.parseInt(ss[1]) != 0);
            } else if (cmd.equals("vonmode?")) {
                this.cmdVonMode();
            } else if (cmd.equals("von")) {
                this.cmdVon(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("von?")) {
                this.cmdVon();
            }
            return true;
        }
    }
}

