/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.comm.TranslatingInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Main;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import java.util.ArrayList;

public class DeviceFlukeDMM
extends DeviceInterface {
    private String idName = "Fluke,xxx";
    private String longName = "Fluke xxx";
    private FlukeCommInterface ci;
    private int overflowCounter = 0;
    private String lastValue = "";
    private String selectedMode = "";
    private final int FlukeRetries = 10;

    public DeviceFlukeDMM(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats.add(new ValueFormat("Voltage", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("VoltageDC", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("VoltageAC", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("VoltageACDC", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Current", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("CurrentDC", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("CurrentAC", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("CurrentACDC", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Resistance", "ohm", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Capacitance", "F", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Temperature", "\u00b0C", ValueFormat.formatD1));
        this.valueFormats.add(new ValueFormat("Conductance", "S", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Frequency", "Hz", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("dBm", "", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("dBV", "", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("dB", "", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("CrestFactor", "", ValueFormat.formatD1));
        this.valueFormats.add(new ValueFormat("DutyCycle", "%", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("Pulse", "s", ValueFormat.formatSI));
    }

    private void selectMode(String mode) {
        this.valueNames = new ArrayList();
        this.selectedMode = mode;
        if (mode.equals("V")) {
            this.valueNames.add("Voltage");
        } else if (mode.equalsIgnoreCase("V DC") || mode.equals("VDC")) {
            this.valueNames.add("VoltageDC");
        } else if (mode.equalsIgnoreCase("V AC") || mode.equals("VAC")) {
            this.valueNames.add("VoltageAC");
        } else if (mode.equalsIgnoreCase("V AC+DC") || mode.equals("VAC_PLUS_DC")) {
            this.valueNames.add("VoltageACDC");
        } else if (mode.equals("A")) {
            this.valueNames.add("Current");
        } else if (mode.equalsIgnoreCase("A DC") || mode.equals("ADC")) {
            this.valueNames.add("CurrentDC");
        } else if (mode.equalsIgnoreCase("A AC") || mode.equals("AAC")) {
            this.valueNames.add("CurrentAC");
        } else if (mode.equalsIgnoreCase("A AC+DC") || mode.equals("AAC_PLUS_DC")) {
            this.valueNames.add("CurrentACDC");
        } else if (mode.equalsIgnoreCase("Ohms") || mode.equals("OHM")) {
            this.valueNames.add("Resistance");
        } else if (mode.equalsIgnoreCase("nS") || mode.equals("SIE")) {
            this.valueNames.add("Conductance");
        } else if (mode.equalsIgnoreCase("Farads") || mode.equals("F")) {
            this.valueNames.add("Capacitance");
        } else if (mode.equalsIgnoreCase("Deg C") || mode.equals("CEL")) {
            this.valueNames.add("Temperature");
        } else if (mode.equalsIgnoreCase("Deg F") || mode.equals("FAR")) {
            this.valueNames.add("Temperature");
        } else if (mode.equalsIgnoreCase("dBm")) {
            this.valueNames.add("dBm");
        } else if (mode.equalsIgnoreCase("dBV")) {
            this.valueNames.add("dBV");
        } else if (mode.equalsIgnoreCase("dB")) {
            this.valueNames.add("dB");
        } else if (mode.equalsIgnoreCase("Hz")) {
            this.valueNames.add("Frequency");
        } else if (mode.equalsIgnoreCase("%") || mode.equalsIgnoreCase("PCT")) {
            this.valueNames.add("DutyCycle");
        } else if (mode.equalsIgnoreCase("ms") || mode.equalsIgnoreCase("S")) {
            this.valueNames.add("Pulse");
        } else if (mode.equalsIgnoreCase("CREST_FACTOR")) {
            this.valueNames.add("CrestFactor");
        } else {
            this.selectedMode = "";
            System.out.println("Mode not found " + mode);
        }
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        super.initColumns();
        this.selectMode(this.ci.getMode());
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUE?");
    }

    public static String deviceName() {
        return "Fluke xxx";
    }

    @Override
    public String getDeviceName() {
        return this.longName;
    }

    @Override
    public String getDeviceId() {
        return this.idName;
    }

    @Override
    protected boolean mayModifyColumns(String cmd) {
        return cmd.equalsIgnoreCase("modeset?");
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        if (!(ci instanceof SerialInterface)) {
            return null;
        }
        ((SerialInterface)ci).setTimeout(1000);
        ((SerialInterface)ci).setEOL("\r");
        switch (Integer.parseInt(this.def.getItem("#subDriver"))) {
            case 1: {
                this.ci = new Fluke1CommInterface(ci);
                break;
            }
            case 2: {
                this.ci = new Fluke2CommInterface(ci);
            }
        }
        return this.ci;
    }

    class Fluke1CommInterface
    extends FlukeCommInterface {
        Fluke1CommInterface(CommInterface ci) {
            super(ci);
        }

        @Override
        void cmdIdn() {
            String answer = this.flukeComm("ID");
            if (answer == null || !answer.startsWith("0\nFLUKE")) {
                return;
            }
            String[] ss = answer.substring(2).trim().split("[,]");
            String model = ss[0].replace("FLUKE", "Fluke");
            String version = ss[1];
            String sn = ss[2];
            while (sn.length() > 0 && sn.charAt(0) == '0') {
                sn = sn.substring(1);
            }
            DeviceFlukeDMM.this.idName = "Fluke," + model + ",";
            DeviceFlukeDMM.this.longName = model;
            if (DeviceFlukeDMM.this.getHandleName() == null || DeviceFlukeDMM.this.getHandleName().length() == 0) {
                DeviceFlukeDMM.this.setHandleName(model.replace("Fluke", "F"));
            }
            DeviceFlukeDMM.this.setSerialNumber(sn);
            this.message.add(String.valueOf(DeviceFlukeDMM.this.idName) + sn + "," + version);
        }

        private String toModeString(String answer) {
            if ((answer = answer.trim()).equals("nS")) {
                return answer;
            }
            if (answer.equals("ms")) {
                return answer;
            }
            if (answer.equals("mS")) {
                return "ms";
            }
            if ("Mkmun".indexOf(answer.charAt(0)) >= 0) {
                answer = answer.substring(1);
            }
            return answer;
        }

        private void checkModeChange(String answer) {
            if (!InterfaceThreads.isLogging()) {
                String mode = this.toModeString(answer);
                if (!DeviceFlukeDMM.this.selectedMode.equals(mode)) {
                    DeviceFlukeDMM.this.selectMode(mode);
                    Main.changeDevicesOrTable(Support.UpdateType.ColumnsSource);
                }
            }
        }

        @Override
        void cmdValue() {
            String answer = this.flukeComm("QM");
            if (answer == null || !answer.startsWith("0\nQM,")) {
                return;
            }
            answer = answer.substring(5).trim();
            String sign = answer.substring(0, 1);
            answer = answer.substring(1);
            int i = answer.indexOf(32);
            if (answer.contains("Out of range")) {
                DeviceFlukeDMM deviceFlukeDMM = DeviceFlukeDMM.this;
                deviceFlukeDMM.overflowCounter = deviceFlukeDMM.overflowCounter + 1;
                if (DeviceFlukeDMM.this.overflowCounter <= Support.systemSettings.delayOverflow) {
                    this.message.add(DeviceFlukeDMM.this.lastValue);
                    return;
                }
                this.checkModeChange(answer.substring(14));
                this.message.add(DeviceFlukeDMM.this.overflowValueString(!sign.equals("-")));
                return;
            }
            String vv = answer.substring(0, i);
            while (vv.length() > 2 && vv.charAt(0) == '0' && vv.charAt(1) != '.') {
                vv = vv.substring(1);
            }
            if ("Mkmun".indexOf((answer = answer.substring(i + 1)).charAt(0)) >= 0) {
                vv = String.valueOf(vv) + answer.charAt(0);
            }
            DeviceFlukeDMM.this.lastValue = String.valueOf(sign) + vv;
            if (answer.equals("Deg F")) {
                DeviceFlukeDMM.this.lastValue = Double.toString((Double.parseDouble(DeviceFlukeDMM.this.lastValue) - 32.0) / 1.8);
            }
            this.checkModeChange(answer);
            DeviceFlukeDMM.this.overflowCounter = 0;
            this.message.add(DeviceFlukeDMM.this.lastValue);
        }

        @Override
        String getMode() {
            String answer = this.flukeComm("QM");
            if (answer == null || !answer.startsWith("0\nQM,")) {
                return "";
            }
            answer = answer.substring(5).trim();
            int i = answer.indexOf(32);
            if (answer.contains("Out of range")) {
                i = answer.indexOf(46) + 1;
            }
            return this.toModeString(answer.substring(i + 1));
        }
    }

    class Fluke2CommInterface
    extends FlukeCommInterface {
        Fluke2CommInterface(CommInterface ci) {
            super(ci);
        }

        @Override
        void cmdIdn() {
            String answer = this.flukeComm("ID");
            if (answer == null || !answer.startsWith("0\nFLUKE")) {
                return;
            }
            String[] ss = answer.substring(2).trim().split("[,]");
            String model = ss[0].replace("FLUKE", "Fluke");
            String version = ss[1];
            String sn = ss[2];
            while (sn.length() > 0 && sn.charAt(0) == '0') {
                sn = sn.substring(1);
            }
            DeviceFlukeDMM.this.idName = "Fluke," + model + ",";
            DeviceFlukeDMM.this.longName = model;
            if (DeviceFlukeDMM.this.getHandleName() == null || DeviceFlukeDMM.this.getHandleName().length() == 0) {
                DeviceFlukeDMM.this.setHandleName(model.replace("Fluke", "F"));
            }
            DeviceFlukeDMM.this.setSerialNumber(sn);
            this.message.add(String.valueOf(DeviceFlukeDMM.this.idName) + sn + "," + version);
        }

        private void checkModeChange(String mode) {
            if (!InterfaceThreads.isLogging() && !DeviceFlukeDMM.this.selectedMode.equals(mode)) {
                DeviceFlukeDMM.this.selectMode(mode);
                Main.changeDevicesOrTable(Support.UpdateType.ColumnsSource);
            }
        }

        @Override
        String getMode() {
            String answer = this.flukeComm("QM");
            if (answer == null || !answer.startsWith("0\n")) {
                return "";
            }
            answer = answer.substring(2).trim();
            String[] aa = answer.split("[,]");
            String mode = aa[1];
            return mode;
        }

        @Override
        void cmdValue() {
            String answer = this.flukeComm("QM");
            if (answer == null || !answer.startsWith("0\n")) {
                return;
            }
            answer = answer.substring(2).trim();
            String[] aa = answer.split("[,]");
            this.checkModeChange(aa[1]);
            if (!aa[2].equals("NORMAL")) {
                DeviceFlukeDMM deviceFlukeDMM = DeviceFlukeDMM.this;
                deviceFlukeDMM.overflowCounter = deviceFlukeDMM.overflowCounter + 1;
                if (DeviceFlukeDMM.this.overflowCounter <= Support.systemSettings.delayOverflow) {
                    this.message.add(DeviceFlukeDMM.this.lastValue);
                    return;
                }
                this.message.add(DeviceFlukeDMM.this.overflowValueString(!aa[2].equals("OL_MINUS")));
                return;
            }
            DeviceFlukeDMM.this.overflowCounter = 0;
            DeviceFlukeDMM.this.lastValue = aa[0];
            if (aa[1].equals("FAR")) {
                DeviceFlukeDMM.this.lastValue = Double.toString((Double.parseDouble(DeviceFlukeDMM.this.lastValue) - 32.0) / 1.8);
            }
            this.message.add(DeviceFlukeDMM.this.lastValue);
        }
    }

    abstract class FlukeCommInterface
    extends TranslatingInterface {
        FlukeCommInterface(CommInterface ci) {
            super(ci);
        }

        synchronized String flukeComm(String msg) {
            String answer = "";
            int n = 0;
            do {
                ++n;
                answer = this.originalCommInterface.writeRead(msg);
                if (answer != null) continue;
                answer = this.originalCommInterface.writeRead(msg);
            } while (!answer.equals("0") && n <= 10);
            if (n <= 10) {
                answer = String.valueOf(answer) + "\n" + this.originalCommInterface.read();
            }
            return answer;
        }

        abstract String getMode();

        abstract void cmdValue();

        abstract void cmdIdn();

        private void cmdMode() {
            this.message.add(this.getMode());
        }

        private void cmdModeSet() {
            DeviceFlukeDMM.this.requestInitColumns();
        }

        @Override
        public boolean write(String msg) {
            if (!this.originalCommInterface.isOpen()) {
                return false;
            }
            this.log("vTx:", msg);
            String[] ss = msg.trim().split("[ ]");
            String cmd = ss[0].toLowerCase().trim();
            if (cmd.equals("*idn?")) {
                this.cmdIdn();
            } else if (cmd.equals("value?")) {
                this.cmdValue();
            } else if (cmd.equals("mode?")) {
                this.cmdMode();
            } else if (cmd.equals("modeSet?")) {
                this.cmdModeSet();
            } else {
                return false;
            }
            return true;
        }
    }
}

