/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.ValueFormat;
import java.util.ArrayList;
import java.util.List;

public class DeviceDischarger
extends DeviceInterface {
    private static final String idName = "HKJ,Discharger,";
    private static final String longName = "HKJ Discharger";
    private static final String handleName = "D";

    public DeviceDischarger(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats.add(new ValueFormat("Current", "A", ValueFormat.formatD3));
        this.valueFormats.add(new ValueFormat("Voltage", "V", ValueFormat.formatD3));
        this.valueFormats.add(new ValueFormat("Capacity", "Ah", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("Energy", "Wh", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("Temp", "\u00b0C", ValueFormat.formatD1));
        this.valueFormats.add(new ValueFormat("TempInternal", "\u00b0C", ValueFormat.formatD1));
        this.setHandleName(handleName);
    }

    public static String name() {
        return idName;
    }

    public static String deviceName() {
        return longName;
    }

    public static String handleName() {
        return handleName;
    }

    @Override
    public String getDeviceName() {
        return longName;
    }

    @Override
    public String getDeviceId() {
        return idName;
    }

    @Override
    protected boolean mayModifyColumns(String cmd) {
        return cmd.equalsIgnoreCase("ENABLE");
    }

    @Override
    protected synchronized void getValuesEdit(List<Double> list) {
        if (list.get(0) > list.get(1)) {
            list.remove(1);
        } else {
            list.remove(0);
        }
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        this.valueNames = new ArrayList();
        this.valueNames.add("Current");
        this.valueNames.add("Voltage");
        this.valueNames.add("Capacity");
        this.valueNames.add("Energy");
        this.valueNames.add("Temp");
        this.valueNames.add("TempInternal");
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUES?");
    }

    @Override
    public int getId() {
        String answer = this.dt.cPort.writeRead("ID?");
        return Integer.valueOf(answer);
    }
}

