/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.comm.LayerInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.comm.SerialPacketInterface;
import dk.hkj.devices.DecoderBrymen525;
import dk.hkj.devices.DecoderBrymen829;
import dk.hkj.devices.DecoderBrymen869;
import dk.hkj.devices.DecoderBrymenBM190;
import dk.hkj.devices.DecoderBrymenBM250;
import dk.hkj.devices.DecoderBrymenBM350;
import dk.hkj.devices.DecoderCEMDT1309;
import dk.hkj.devices.DecoderClass;
import dk.hkj.devices.DecoderDefinition;
import dk.hkj.devices.DecoderGM1020;
import dk.hkj.devices.DecoderMastechMS8218;
import dk.hkj.devices.DecoderPeaktech2025A;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import java.util.ArrayList;

public class DeviceDMM2
extends DeviceInterface {
    private DecoderClass decoder;
    private LayerInterface ci;
    private String selectedMode = "";
    private int overflowCounter = 0;
    private double lastValue = 0.0;
    private String lastMessage = "";
    private String outputMessage = "";
    private long lastTime = 0L;
    private long rate = 0L;
    private String currentMode = "";

    public DeviceDMM2(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats.add(new ValueFormat("VoltageDC", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("VoltageAC", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("VoltageACDC", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("CurrentDC", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("CurrentAC", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("CurrentACDC", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Resistance", "ohm", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Siemens", "S", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Capacitance", "F", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Frequency", "Hz", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("DutyCycle", "%", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("Power", "W", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("PowerDC", "W", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("PowerAC", "W", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Apparent power", "VA", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Reactive power", "VAR", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Energy", "Wh", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("EnergyDC", "Wh", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("EnergyAC", "Wh", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Temperature", "\u00b0C", ValueFormat.formatD1));
        this.valueFormats.add(new ValueFormat("DeltaTemp", "\u00b0C", ValueFormat.formatD1));
        this.valueFormats.add(new ValueFormat("dB", "", ValueFormat.formatX8));
        this.valueFormats.add(new ValueFormat("dBm", "", ValueFormat.formatX8));
        this.valueFormats.add(new ValueFormat("mA4_20", "%", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("Illuminance", "Lux", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("CrestFactor", "", ValueFormat.formatD1));
        this.valueFormats.add(new ValueFormat("hFE", "*", ValueFormat.formatD0));
        this.valueFormats.add(new ValueFormat("Value", "_", ValueFormat.formatD0));
    }

    private void selectMode() {
        this.valueNames = new ArrayList();
        this.selectedMode = this.currentMode;
        if (this.currentMode.equals("VDC") || this.currentMode.equals("V") || this.currentMode.length() == 0) {
            this.valueNames.add("VoltageDC");
        } else if (this.currentMode.equals("VAC")) {
            this.valueNames.add("VoltageAC");
        } else if (this.currentMode.equals("VACDC")) {
            this.valueNames.add("VoltageACDC");
        } else if (this.currentMode.equals("ADC") || this.currentMode.equals("A")) {
            this.valueNames.add("CurrentDC");
        } else if (this.currentMode.equals("AAC")) {
            this.valueNames.add("CurrentAC");
        } else if (this.currentMode.equals("AACDC")) {
            this.valueNames.add("CurrentACDC");
        } else if (this.currentMode.equals("W")) {
            this.valueNames.add("Power");
        } else if (this.currentMode.equals("WDC")) {
            this.valueNames.add("PowerDC");
        } else if (this.currentMode.equals("WAC")) {
            this.valueNames.add("PowerAC");
        } else if (this.currentMode.equals("VA") || this.currentMode.equals("VAAC")) {
            this.valueNames.add("Apparent power");
        } else if (this.currentMode.equals("VAR") || this.currentMode.equals("VARAC")) {
            this.valueNames.add("Reactive power");
        } else if (this.currentMode.equals("Wh")) {
            this.valueNames.add("Energy");
        } else if (this.currentMode.equals("WhDC")) {
            this.valueNames.add("EnergyDC");
        } else if (this.currentMode.equals("WhAC")) {
            this.valueNames.add("EnergyAC");
        } else if (this.currentMode.equalsIgnoreCase("Ohm")) {
            this.valueNames.add("Resistance");
        } else if (this.currentMode.equalsIgnoreCase("Siemens")) {
            this.valueNames.add("Conductance");
        } else if (this.currentMode.equals("F")) {
            this.valueNames.add("Capacitance");
        } else if (this.currentMode.equalsIgnoreCase("Hz")) {
            this.valueNames.add("Frequency");
        } else if (this.currentMode.equalsIgnoreCase("%")) {
            this.valueNames.add("DutyCycle");
        } else if (this.currentMode.equalsIgnoreCase("TempF") || this.currentMode.equalsIgnoreCase("TempC") || this.currentMode.equalsIgnoreCase("T1") || this.currentMode.equals("T2") || this.currentMode.equals("Temp")) {
            this.valueNames.add("Temperature");
        } else if (this.currentMode.equalsIgnoreCase("T2-T1")) {
            this.valueNames.add("DeltaTemp");
        } else if (this.currentMode.equalsIgnoreCase("%mA")) {
            this.valueNames.add("mA4_20");
        } else if (this.currentMode.equalsIgnoreCase("dB")) {
            this.valueNames.add("dBm");
        } else if (this.currentMode.equalsIgnoreCase("dBm")) {
            this.valueNames.add("dBm");
        } else if (this.currentMode.equalsIgnoreCase("Lux")) {
            this.valueNames.add("Illuminance");
        } else if (this.currentMode.equalsIgnoreCase("*")) {
            this.valueNames.add("hFE");
        } else if (this.currentMode.equalsIgnoreCase("_")) {
            this.valueNames.add("Value");
        } else {
            System.out.println("Mode not found <" + this.currentMode + ">");
        }
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        super.initColumns();
        this.selectMode();
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUE?");
    }

    public static String deviceName() {
        return "DMM";
    }

    @Override
    public String getDeviceName() {
        return this.def.getDeviceName();
    }

    @Override
    public String getDeviceId() {
        return this.def.getIdName();
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        if (!(ci instanceof SerialInterface)) {
            return null;
        }
        ((SerialInterface)ci).setTimeout(1000);
        ((SerialInterface)ci).setEOL("\r");
        String sd = this.def.getItem("#subDriver");
        if (sd.equalsIgnoreCase("MastechMS8218")) {
            this.decoder = new DecoderMastechMS8218();
        } else if (sd.equalsIgnoreCase("BrymenBM190")) {
            this.decoder = new DecoderBrymenBM190();
        } else if (sd.equalsIgnoreCase("BrymenBM350")) {
            this.decoder = new DecoderBrymenBM350();
        } else if (sd.equalsIgnoreCase("Definition")) {
            this.decoder = new DecoderDefinition(this.def);
        } else if (sd.equalsIgnoreCase("CEMDT1309")) {
            this.decoder = new DecoderCEMDT1309();
        } else if (sd.equalsIgnoreCase("GM1020")) {
            this.decoder = new DecoderGM1020();
        } else if (sd.equalsIgnoreCase("Peaktech2025A")) {
            this.decoder = new DecoderPeaktech2025A();
        } else if (sd.equalsIgnoreCase("BrymenBM869S")) {
            this.decoder = new DecoderBrymen869(true);
        } else if (sd.equalsIgnoreCase("BrymenBM829S")) {
            this.decoder = new DecoderBrymen829(true);
        } else if (sd.equalsIgnoreCase("BrymenBM525S")) {
            this.decoder = new DecoderBrymen525(true);
        } else if (sd.equalsIgnoreCase("BrymenBM250")) {
            this.decoder = new DecoderBrymenBM250();
        }
        this.ci = new DriverInterface(((SerialInterface)ci).getDataInterface());
        return this.ci;
    }

    private class DriverInterface
    extends LayerInterface {
        public DriverInterface(SerialPacketInterface p) {
            super(p);
            DeviceDMM2.this.decoder.setupPacketFormat(p);
        }

        @Override
        public void open() {
            super.open();
            DeviceDMM2.this.decoder.init((CommDataInterface)((Object)this.originalCommInterface));
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    while (DriverInterface.this.originalCommInterface.isOpen()) {
                        DriverInterface.this.readFromSerialPort();
                    }
                }
            };
            Thread t = new Thread(r);
            t.setDaemon(true);
            t.start();
        }

        @Override
        public void close() {
            DeviceDMM2.this.decoder.deinit((CommDataInterface)((Object)this.originalCommInterface));
        }

        private synchronized void setMessage(byte[] msg) {
            DeviceDMM2.this.lastValue = this.decodeData(msg);
            if (Double.isNaN(DeviceDMM2.this.lastValue)) {
                return;
            }
            long t = System.currentTimeMillis();
            DeviceDMM2.this.rate = t - DeviceDMM2.this.lastTime;
            DeviceDMM2.this.lastTime = t;
        }

        protected void readFromSerialPort() {
            try {
                byte[] data = ((SerialPacketInterface)this.originalCommInterface).readData(500);
                if (data != null) {
                    this.setMessage(data);
                } else if (System.currentTimeMillis() - DeviceDMM2.this.lastTime > (long)(DeviceDMM2.this.def.getReadingDelay() * 2)) {
                    DeviceDMM2.this.lastValue = Double.NaN;
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
            CommInterface.sleep(50);
        }

        private double decodeData(byte[] data) {
            if (!DeviceDMM2.this.decoder.decode(data)) {
                return Double.NaN;
            }
            DeviceDMM2.this.currentMode = ((DeviceDMM2)DeviceDMM2.this).decoder.mode;
            if (!DeviceDMM2.this.selectedMode.equals(DeviceDMM2.this.currentMode)) {
                DeviceDMM2.this.requestInitColumns();
            }
            return ((DeviceDMM2)DeviceDMM2.this).decoder.value;
        }

        protected boolean stdCommands(String msg) {
            if (msg.equalsIgnoreCase("*idn?")) {
                DeviceDMM2.this.outputMessage = DeviceDMM2.this.def.getIdName();
                return true;
            }
            if (msg.equalsIgnoreCase("rate?")) {
                DeviceDMM2.this.outputMessage = Long.toString(DeviceDMM2.this.rate);
                return true;
            }
            if (msg.equalsIgnoreCase("mode?")) {
                DeviceDMM2.this.outputMessage = DeviceDMM2.this.currentMode;
                return true;
            }
            if (msg.equalsIgnoreCase("value?")) {
                if (System.currentTimeMillis() - DeviceDMM2.this.lastTime > (long)DeviceDMM2.this.def.getReadingDelay()) {
                    DeviceDMM2.this.outputMessage = null;
                }
                if (DeviceDMM2.this.decoder.usePoll()) {
                    DeviceDMM2.this.decoder.poll((CommDataInterface)((Object)this.originalCommInterface));
                }
                if (!Double.isFinite(DeviceDMM2.this.lastValue)) {
                    DeviceDMM2 deviceDMM2 = DeviceDMM2.this;
                    deviceDMM2.overflowCounter = deviceDMM2.overflowCounter + 1;
                    if (DeviceDMM2.this.overflowCounter <= Support.systemSettings.delayOverflow) {
                        DeviceDMM2.this.outputMessage = DeviceDMM2.this.lastMessage;
                    } else {
                        DeviceDMM2.this.outputMessage = DeviceDMM2.this.overflowValueString(DeviceDMM2.this.lastValue >= 0.0);
                    }
                    return true;
                }
                DeviceDMM2.this.lastMessage = Double.toString(DeviceDMM2.this.lastValue);
                DeviceDMM2.this.overflowCounter = 0;
                DeviceDMM2.this.outputMessage = DeviceDMM2.this.lastMessage;
                return true;
            }
            return false;
        }

        @Override
        public synchronized boolean write(String msg) {
            this.log("Tx", msg);
            return this.stdCommands(msg);
        }

        @Override
        public boolean isData() {
            return DeviceDMM2.this.outputMessage != null;
        }

        @Override
        public String read() {
            return this.read(300);
        }

        @Override
        public synchronized String read(int timeout) {
            String s = DeviceDMM2.this.outputMessage;
            DeviceDMM2.this.outputMessage = null;
            return s;
        }
    }
}

