/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.comm.SocketInterface;
import dk.hkj.comm.TranslatingInterface;
import dk.hkj.devices.ChecksumGenerator;
import dk.hkj.devices.DeviceSCPI;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Support;
import dk.hkj.script.Script;
import dk.hkj.util.ByteBuffer;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.io.UnsupportedEncodingException;
import java.util.Arrays;
import java.util.List;

public class DeviceBlock
extends DeviceSCPI {
    private TranslatingCommInterface ci;
    private CommDataInterface cid;
    private long nextCommandTime = 0L;
    private long delayTime = 0L;
    private byte[] poll = null;
    private ChecksumGenerator checksumGenerator = null;
    private String terminator = "";

    public DeviceBlock(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        if (ci instanceof SerialInterface) {
            this.ci = new TranslatingCommInterface(((SerialInterface)ci).getDataInterface());
        } else if (ci instanceof SocketInterface) {
            this.ci = new TranslatingCommInterface(((SocketInterface)ci).getDataInterface());
        }
        this.delayTime = this.def.getItemInt("#cmdDelayTime");
        String s = this.def.getItem("#checksum");
        if (s != null && !s.trim().isEmpty()) {
            this.checksumGenerator = new ChecksumGenerator(s);
        }
        this.terminator = StringUtil.decodeEscape(this.def.getItem("#eol"));
        return this.ci;
    }

    @Override
    public List<String> supportedCommands() {
        List<String> list = super.supportedCommands();
        if (this.commandList == null || this.commandList.size() == 0) {
            list = this.def.getScpiDefines();
            list.add("*idn?");
            if (this.ci.async) {
                list.add("Values?");
            }
            list.sort(null);
            this.commandList = list;
        }
        return list;
    }

    @Override
    public String finalInit() {
        return "";
    }

    class TranslatingCommInterface
    extends TranslatingInterface {
        protected byte[] rxStart;
        protected int rxLength;
        protected int pollPause;
        protected byte[] lastValue;
        protected String rxFormat;
        protected boolean async;
        protected long timestamp;

        protected TranslatingCommInterface(CommInterface ci) {
            super(ci);
            this.rxStart = null;
            this.rxLength = 0;
            this.pollPause = 50;
            this.lastValue = null;
            this.rxFormat = null;
            this.async = false;
            this.timestamp = 0L;
            DeviceBlock.this.cid = (CommDataInterface)((Object)ci);
        }

        private synchronized void setLastValue(byte[] lastValue) {
            this.lastValue = lastValue;
        }

        private synchronized byte[] getLastValue() {
            return this.lastValue;
        }

        @Override
        public void open() {
            super.open();
            String s = DeviceBlock.this.def.getItem("#rxStart");
            this.rxLength = DeviceBlock.this.def.getItemInt("#rxLength");
            this.rxFormat = DeviceBlock.this.def.getItem("#rxFormat");
            String ss = DeviceBlock.this.def.getItem("#poll", "");
            this.pollPause = DeviceBlock.this.def.getItemInt("#pollPause", 50);
            if (!ss.isEmpty()) {
                DeviceBlock.this.poll = this.parseWriteString(ss, false);
            }
            if (s != null && s.length() > 0 && this.rxLength > 0) {
                ByteBuffer bb = new ByteBuffer();
                bb.appendAscii(StringUtil.decodeEscape(s.trim()));
                this.rxStart = bb.getAsArray();
                boolean bl = this.async = this.rxStart.length > 0;
                if (this.async) {
                    new RxValues();
                }
            }
        }

        private void cmdIdn() {
            String s;
            StringBuilder sb = new StringBuilder();
            if (this.async) {
                long t = System.currentTimeMillis();
                while (System.currentTimeMillis() - t < 2000L && this.lastValue == null) {
                    TranslatingCommInterface.sleep(50);
                }
                if (this.lastValue != null) {
                    this.message.add(DeviceBlock.this.def.getIdName().trim());
                }
                return;
            }
            String verify = DeviceBlock.this.def.getItem("#verifyDevice");
            if (verify != null && verify.length() > 0) {
                String answer;
                int i;
                String value = "";
                if (verify.charAt(0) == '(' || verify.charAt(0) == '\"') {
                    i = Support.scriptEndPosition(verify);
                    if (i > 0) {
                        Script script = new Script();
                        value = script.expression(verify.substring(0, i)).asString();
                        verify = verify.substring(i).trim();
                    }
                } else {
                    i = verify.indexOf(32);
                    value = verify.substring(0, i);
                    verify = verify.substring(i + 1).trim();
                }
                if (!(answer = this.writeRead(verify).replace(" ", "_").trim()).equals(value)) {
                    answer = "**Device do not match** <" + answer + ">";
                    if (InterfaceThreads.debugAll) {
                        this.logLogAlways(answer);
                    }
                    this.message.add(answer);
                    return;
                }
            }
            sb.append(DeviceBlock.this.def.getIdName().trim());
            if (sb.charAt(sb.length() - 1) == ',') {
                sb.append(" ");
            } else {
                sb.append(", ");
            }
            if (DeviceBlock.this.def.getScpiDefine("getdevicesn?") != null && (s = this.writeRead("getDeviceSN?")) != null && s.length() > 0) {
                sb.append(s);
            }
            sb.append(", ");
            if (DeviceBlock.this.def.getScpiDefine("getdevicesw?") != null && (s = this.writeRead("getDeviceSW?")) != null && s.length() > 0) {
                sb.append(s);
            }
            this.message.add(sb.toString());
        }

        private void waitDelayTime() {
            long t = System.currentTimeMillis();
            long dt = DeviceBlock.this.nextCommandTime - t;
            if (dt > 0L) {
                if (dt > 2000L) {
                    dt = 2000L;
                }
                CommInterface.sleep((int)dt);
            }
        }

        private byte[] parseWriteString(String str, boolean addFinal) {
            ByteBuffer bb = new ByteBuffer();
            boolean inString = false;
            boolean inNumber = false;
            int startPos = 0;
            int i = 0;
            while (i < str.length()) {
                char c = str.charAt(i);
                if (c == '\"') {
                    inString = !inString;
                } else if (inString) {
                    bb.append((byte)c);
                } else if (inNumber) {
                    if (c <= ' ') {
                        inNumber = false;
                        bb.append((byte)StringUtil.parseInt(str.substring(startPos, i)));
                    }
                } else if (c >= '0' && c <= '9' || c == '-') {
                    inNumber = true;
                    startPos = i;
                }
                ++i;
            }
            if (inNumber) {
                bb.append((byte)StringUtil.parseInt(str.substring(startPos)));
            }
            if (addFinal) {
                if (DeviceBlock.this.checksumGenerator != null) {
                    DeviceBlock.this.checksumGenerator.addCheck(bb);
                }
                if (DeviceBlock.this.terminator != null) {
                    bb.append(DeviceBlock.this.terminator);
                }
            }
            return bb.getAsArray();
        }

        private long bcdBytes(byte[] b) {
            long l = 0L;
            int i = 0;
            while (i < b.length) {
                int c1 = b[i] >> 4 & 0xF;
                if (c1 > 9) {
                    c1 = 0;
                    return 0;
                }
                int c2 = b[i] & 0xF;
                if (c2 > 9) {
                    c2 = 0;
                    return 0;
                }
                l = l * 100L + (long)(c1 * 10) + (long)c2;
                ++i;
            }
            return l;
        }

        private long unsignedBytes(byte[] b) {
            long l = 0L;
            int i = 0;
            while (i < b.length) {
                l |= ((long)b[i] & 0xFFL) << i * 8;
                ++i;
            }
            return l;
        }

        private long signedBytes(byte[] b) {
            long l = this.unsignedBytes(b);
            if ((b[b.length - 1] & 0x80) != 0) {
                int i = b.length;
                while (i < 8) {
                    l |= 255L << i * 8;
                    ++i;
                }
            }
            return l;
        }

        private double floatBytes(byte[] b) {
            long l = this.unsignedBytes(b);
            if (b.length == 4) {
                return Float.intBitsToFloat((int)l);
            }
            if (b.length == 8) {
                return Double.longBitsToDouble(l);
            }
            return 0.0;
        }

        private String stringBytes(byte[] b) {
            String s = "";
            try {
                s = new String(b, "ISO-8859-1");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                s = new String(b);
            }
            if (s.indexOf(32) >= 0) {
                s = "\"" + s + "\"";
            }
            return s;
        }

        private int asciiIntBytes(byte[] b) {
            String s = new String(b);
            s = s.replace("+", "");
            boolean sign = s.contains("-");
            if ((s = s.replace("-", "")).isEmpty()) {
                return 0;
            }
            return Integer.parseInt(s.trim()) * (sign ? -1 : 1);
        }

        private double asciiFloatBytes(byte[] b) {
            String s = new String(b);
            if (s.isEmpty()) {
                return 0.0;
            }
            return Double.parseDouble(s.trim());
        }

        private int hexBytes(byte[] b) {
            String s = new String(b);
            s = s.replace("+", "");
            boolean sign = s.contains("-");
            if ((s = s.replace("-", "")).isEmpty()) {
                return 0;
            }
            return Integer.parseInt(s.trim(), 16) * (sign ? -1 : 1);
        }

        private int booleanBytes(byte b, int bytes) {
            if (bytes >= 8) {
                return 0;
            }
            return (b & 1 << bytes) != 0 ? 1 : 0;
        }

        /*
         * Unable to fully structure code
         */
        private void parseFormat(byte[] b, String format, StringBuilder sb) {
            if (b == null) {
                return;
            }
            i = 0;
            ** GOTO lbl202
            {
                if (++i >= format.length()) {
                    return;
                }
                do {
                    if (format.charAt(i) == ' ') continue block12;
                    byteIndex = 0;
                    while (format.charAt(i) >= '0' && format.charAt(i) <= '9') {
                        byteIndex = byteIndex * 10 + format.charAt(i) - 48;
                        ++i;
                    }
                    dataType = Character.toLowerCase(format.charAt(i++));
                    reverse = false;
                    invert = false;
                    reverseBits = false;
                    swapNipples = false;
                    zeroBits = 255;
                    while ("zrxn!".indexOf(Character.toLowerCase(format.charAt(i))) >= 0) {
                        c = Character.toLowerCase(format.charAt(i));
                        if (c == 'r') {
                            reverse = true;
                        }
                        if (c == '!') {
                            invert = true;
                        }
                        if (c == 'x') {
                            reverseBits = true;
                        }
                        if (c == 'n') {
                            swapNipples = true;
                        }
                        if (c == 'z') {
                            zeroBits >>= 1;
                        }
                        ++i;
                    }
                    bytes = 0;
                    while (i < format.length() && format.charAt(i) >= '0' && format.charAt(i) <= '9') {
                        bytes = bytes * 10 + format.charAt(i) - 48;
                        ++i;
                    }
                    mult = 1.0;
                    if (i < format.length() && (format.charAt(i) == '*' || format.charAt(i) == '/')) {
                        div = format.charAt(i) == '/';
                        j = ++i;
                        while (i < format.length() && format.charAt(i) != ' ' && format.charAt(i) != '+' && format.charAt(i) != '-') {
                            ++i;
                        }
                        mult = StringUtil.parseDoubleEE(format.substring(j, i));
                        if (div) {
                            mult = 1.0 / mult;
                        }
                    }
                    add = 0.0;
                    if (i < format.length() && (format.charAt(i) == '+' || format.charAt(i) == '-')) {
                        sub = format.charAt(i) == '-';
                        j = ++i;
                        while (i < format.length() && format.charAt(i) != ' ') {
                            ++i;
                        }
                        add = StringUtil.parseDoubleEE(format.substring(j, i));
                        if (sub) {
                            add = -add;
                        }
                    }
                    bb = null;
                    bb = "bB".indexOf(dataType) >= 0 ? Arrays.copyOfRange(b, byteIndex, byteIndex + 1) : Arrays.copyOfRange(b, byteIndex, byteIndex + bytes);
                    if (reverse) {
                        bbb = new byte[bb.length];
                        j = 0;
                        while (j < bb.length) {
                            bbb[j] = bb[bb.length - j - 1];
                            ++j;
                        }
                        bb = bbb;
                    }
                    if (invert) {
                        j = 0;
                        while (j < bb.length) {
                            bb[j] = ~bb[j];
                            ++j;
                        }
                    }
                    if (reverseBits) {
                        j = 0;
                        while (j < bb.length) {
                            x = 0;
                            if ((bb[j] & 1) != 0) {
                                x = (byte)(x | 128);
                            }
                            if ((bb[j] & 2) != 0) {
                                x = (byte)(x | 64);
                            }
                            if ((bb[j] & 4) != 0) {
                                x = (byte)(x | 32);
                            }
                            if ((bb[j] & 8) != 0) {
                                x = (byte)(x | 16);
                            }
                            if ((bb[j] & 16) != 0) {
                                x = (byte)(x | 8);
                            }
                            if ((bb[j] & 32) != 0) {
                                x = (byte)(x | 4);
                            }
                            if ((bb[j] & 64) != 0) {
                                x = (byte)(x | 2);
                            }
                            if ((bb[j] & 128) != 0) {
                                x = (byte)(x | 1);
                            }
                            bb[j] = x;
                            ++j;
                        }
                    }
                    if (swapNipples) {
                        j = 0;
                        while (j < bb.length) {
                            bb[j] = (byte)(bb[j] >> 4 & 15 | bb[j] << 4 & 240);
                            ++j;
                        }
                    }
                    switch (Character.toLowerCase(dataType)) {
                        case 'i': {
                            if (sb.length() > 0) {
                                sb.append(' ');
                            }
                            bb[bb.length - 1] = (byte)(bb[bb.length - 1] & zeroBits);
                            if (mult != 1.0 || add != 0.0) {
                                sb.append((double)this.signedBytes(bb) * mult + add);
                                break;
                            }
                            sb.append(this.signedBytes(bb));
                            break;
                        }
                        case 'u': {
                            if (sb.length() > 0) {
                                sb.append(' ');
                            }
                            bb[bb.length - 1] = (byte)(bb[bb.length - 1] & zeroBits);
                            if (mult != 1.0 || add != 0.0) {
                                sb.append((double)this.unsignedBytes(bb) * mult + add);
                                break;
                            }
                            sb.append(this.unsignedBytes(bb));
                            break;
                        }
                        case 'd': {
                            if (sb.length() > 0) {
                                sb.append(' ');
                            }
                            bb[0] = (byte)(bb[0] & zeroBits);
                            if (mult != 1.0 || add != 0.0) {
                                sb.append((double)this.bcdBytes(bb) * mult + add);
                                break;
                            }
                            sb.append(this.bcdBytes(bb));
                            break;
                        }
                        case 'h': {
                            if (sb.length() > 0) {
                                sb.append(' ');
                            }
                            if (mult != 1.0 || add != 0.0) {
                                sb.append((double)this.hexBytes(bb) * mult + add);
                                break;
                            }
                            sb.append(this.hexBytes(bb));
                            break;
                        }
                        case 'a': {
                            if (sb.length() > 0) {
                                sb.append(' ');
                            }
                            if (mult != 1.0 || add != 0.0) {
                                sb.append((double)this.asciiIntBytes(bb) * mult + add);
                                break;
                            }
                            sb.append(this.asciiIntBytes(bb));
                            break;
                        }
                        case 'e': {
                            if (sb.length() > 0) {
                                sb.append(' ');
                            }
                            if (mult != 1.0 || add != 0.0) {
                                sb.append(this.asciiFloatBytes(bb) * mult + add);
                                break;
                            }
                            sb.append(this.asciiFloatBytes(bb));
                            break;
                        }
                        case 'f': {
                            if (sb.length() > 0) {
                                sb.append(' ');
                            }
                            sb.append(this.floatBytes(bb) * mult + add);
                            break;
                        }
                        case 's': {
                            if (sb.length() > 0) {
                                sb.append(' ');
                            }
                            sb.append(this.stringBytes(bb));
                            break;
                        }
                        case 'b': {
                            if (sb.length() > 0) {
                                sb.append(' ');
                            }
                            sb.append(this.booleanBytes(bb[0], bytes));
                            break;
                        }
                        case '#': {
                            j = 0;
                            while (j < bb.length) {
                                b[j + byteIndex] = bb[j];
                                ++j;
                            }
                            break block0;
                        }
                    }
lbl202:
                    // 18 sources

                } while (i < format.length());
            }
            if (InterfaceThreads.debugAll) {
                InterfaceThreads.logDebug("Rx " + sb.toString());
            }
        }

        private boolean writeRead(int n, StringBuilder sb, String data) {
            this.waitDelayTime();
            int j = data.indexOf(47);
            String format = null;
            if (j > 0) {
                format = data.substring(j + 1);
                data = data.substring(0, j);
            }
            if (n == 0) {
                DeviceBlock.this.cid.writeData(this.parseWriteString(data, true));
            } else {
                DeviceBlock.this.cid.setPacketFormat(CommDataInterface.PacketFormat.FixedLength, n);
                DeviceBlock.this.cid.flush();
                byte[] b = DeviceBlock.this.cid.writeReadData(this.parseWriteString(data, true));
                if (format == null) {
                    if (sb != null) {
                        sb.append(this.unsignedBytes(b));
                    }
                } else if (sb != null) {
                    this.parseFormat(b, format, sb);
                }
            }
            DeviceBlock.this.nextCommandTime = DeviceBlock.this.delayTime + System.currentTimeMillis();
            return true;
        }

        @Override
        public synchronized boolean write(String msg) {
            String params;
            String[] lines;
            String cmd;
            int i;
            StringBuilder sb;
            block47: {
                block46: {
                    if (this.originalCommInterface.isOpen()) break block46;
                    return false;
                }
                sb = new StringBuilder();
                this.log("vTx:", msg);
                msg = msg.trim();
                i = msg.indexOf(32);
                if (i < 0) {
                    i = msg.length();
                }
                cmd = msg.substring(0, i).toLowerCase();
                lines = new String[]{};
                boolean requestAnswer = msg.indexOf(63) >= 0;
                String cmddef = DeviceBlock.this.def.getScpiDefine(cmd);
                params = msg.substring(i).trim();
                if (cmddef == null) break block47;
                if (cmddef.substring(0, 5).equalsIgnoreCase("#pgm#")) {
                    msg = "none";
                    if (DeviceBlock.this.debugOtherComm) {
                        DeviceBlock.this.debugLog("Script start");
                    }
                    DeviceBlock.this.getPgmScript().addLocalVar("value", Var.createValue(params));
                    Var v = DeviceBlock.this.getPgmScript().execute(cmddef.substring(6));
                    if (v != null) {
                        sb.append(v.asString());
                    }
                    if (DeviceBlock.this.debugOtherComm) {
                        DeviceBlock.this.debugLog("Script end <" + sb.toString() + ">");
                    }
                    break block47;
                }
                lines = cmddef.split("[\\n]");
                if (lines.length > 1) {
                    cmddef = lines[0];
                }
                if (cmddef.indexOf(40) >= 0) {
                    DeviceBlock.this.getScript().addLocalVar("value", Var.createValue(params));
                    cmddef = Support.processScriptInBrackets(DeviceBlock.this.getScript(), cmddef);
                }
                msg = cmddef;
                if (!requestAnswer || msg.indexOf(63) >= 0) break block47;
                return false;
            }
            try {
                String[] stringArray = msg.split("[;]");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int n3;
                    String cmdx = stringArray[n2];
                    i = cmdx.indexOf(32);
                    if (i < 0) {
                        cmd = cmdx.toLowerCase();
                        cmdx = "";
                    } else {
                        cmd = cmdx.substring(0, i).toLowerCase();
                        cmdx = cmdx.substring(i + 1).trim();
                    }
                    if (cmd.equals("*idn?")) {
                        this.cmdIdn();
                    } else if (this.async && cmd.equals("values?")) {
                        if (this.rxFormat == null) {
                            if (sb != null) {
                                sb.append(this.lastValue);
                            }
                        } else if (sb != null) {
                            this.parseFormat(this.getLastValue(), this.rxFormat, sb);
                        }
                    } else if (cmd.equals("tx")) {
                        this.writeRead(0, null, cmdx);
                    } else if (cmd.equals("txrx1")) {
                        this.writeRead(1, null, cmdx);
                    } else if (cmd.equals("txrx2")) {
                        this.writeRead(2, null, cmdx);
                    } else if (cmd.equals("txrxn")) {
                        i = cmdx.indexOf(32);
                        n3 = 0;
                        if (i > 0) {
                            n3 = StringUtil.parseInt(cmdx.substring(0, i).trim());
                            cmdx = cmdx.substring(i + 1).trim();
                        } else {
                            n3 = StringUtil.parseInt(cmdx);
                            cmdx = "";
                        }
                        this.writeRead(n3, null, cmdx);
                    } else if (cmd.equals("txrx1?")) {
                        this.writeRead(1, sb, cmdx);
                    } else if (cmd.equals("txrx2?")) {
                        this.writeRead(2, sb, cmdx);
                    } else if (!cmd.equals("none") && !cmd.equals("none?") && cmd.equals("txrxn?")) {
                        i = cmdx.indexOf(32);
                        n3 = 0;
                        if (i > 0) {
                            n3 = StringUtil.parseInt(cmdx.substring(0, i).trim());
                            cmdx = cmdx.substring(i + 1).trim();
                        } else {
                            n3 = StringUtil.parseInt(cmdx);
                            cmdx = "";
                        }
                        this.writeRead(n3, sb, cmdx);
                    }
                    ++n2;
                }
                if (lines.length > 1) {
                    DeviceBlock.this.getScript().addLocalVar("inputValue", Var.createValue(params));
                    int j = 1;
                    while (j < lines.length) {
                        String line = lines[j];
                        if (line.startsWith(":readmath:")) {
                            line = line.substring(":readmath:".length());
                            DeviceBlock.this.getScript().addLocalVar("value", Var.createValue(sb.toString()));
                            sb.setLength(0);
                            sb.append(DeviceBlock.this.getScript().expression(line).asString());
                        } else if (line.startsWith(":setvar:")) {
                            if (sb.length() > 0) {
                                DeviceBlock.this.getScript().addLocalVar("value", Var.createValue(sb.toString()));
                            }
                            line = line.substring(":setvar:".length());
                            DeviceBlock.this.getScript().execute("var " + line);
                        }
                        ++j;
                    }
                    DeviceBlock.this.getScript().removeLocalVar("inputValue");
                }
                if (sb.length() > 0) {
                    this.message.add(sb.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                return false;
            }
            return true;
        }

        class RxValues
        extends Thread {
            RxValues() {
                this.setDaemon(true);
                this.setName("RxValues");
                this.start();
            }

            @Override
            public void run() {
                DeviceBlock.this.cid.flush();
                TranslatingCommInterface.this.timestamp = System.currentTimeMillis();
                while (DeviceBlock.this.ci.isOpen()) {
                    byte[] b = null;
                    if (DeviceBlock.this.poll != null) {
                        CommInterface.sleep(TranslatingCommInterface.this.pollPause);
                        DeviceBlock.this.cid.setPacketFormat(CommDataInterface.PacketFormat.LongHeaderFixedLength, TranslatingCommInterface.this.rxStart, TranslatingCommInterface.this.rxLength);
                        b = DeviceBlock.this.cid.writeReadData(DeviceBlock.this.poll);
                    } else {
                        DeviceBlock.this.cid.setPacketFormat(CommDataInterface.PacketFormat.LongHeaderFixedLength, TranslatingCommInterface.this.rxStart, TranslatingCommInterface.this.rxLength);
                        b = DeviceBlock.this.cid.readData();
                    }
                    if (b != null) {
                        TranslatingCommInterface.this.setLastValue(b);
                        TranslatingCommInterface.this.timestamp = System.currentTimeMillis();
                        continue;
                    }
                    long dt = System.currentTimeMillis() - TranslatingCommInterface.this.timestamp;
                    if (dt <= 2000L) continue;
                    TranslatingCommInterface.this.setLastValue(null);
                }
                TranslatingCommInterface.this.setLastValue(null);
            }
        }
    }
}

