/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.comm.SerialPacketInterface;
import dk.hkj.comm.TranslatingInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.StringUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Locale;

public class DeviceBK85xx
extends DeviceInterface {
    private CommInterface ci;
    private String idName = "BK";
    private String longName = "BK";
    private NumberFormat nf;
    private final byte SetRemoteControl = (byte)32;
    private final byte SetLoadOn = (byte)33;
    private final byte SetMaxVoltage = (byte)34;
    private final byte GetMaxVoltage = (byte)35;
    private final byte SetMaxCurrent = (byte)36;
    private final byte GetMaxCurrent = (byte)37;
    private final byte SetMaxPower = (byte)38;
    private final byte GetMaxPower = (byte)39;
    private final byte SetMode = (byte)40;
    private final byte GetMode = (byte)41;
    private final byte SetCVVoltage = (byte)44;
    private final byte GetCVVoltage = (byte)45;
    private final byte SetCCCurrent = (byte)42;
    private final byte GetCCCurrent = (byte)43;
    private final byte SetCWPower = (byte)46;
    private final byte GetCWPower = (byte)47;
    private final byte SetCRResistance = (byte)48;
    private final byte GetCRResistance = (byte)49;
    private final byte SetMinBattery = (byte)78;
    private final byte GetMinBattery = (byte)79;
    private final byte SetLocalKey = (byte)85;
    private final byte SetSense = (byte)86;
    private final byte GetSense = (byte)87;
    private final byte SetVonMode = (byte)14;
    private final byte GetVonMode = (byte)15;
    private final byte SetVon = (byte)16;
    private final byte GetVon = (byte)17;
    private final byte SetAdvancedMode = (byte)93;
    private final byte GetAdvancedMode = (byte)94;
    private final byte GetActualInput = (byte)95;
    private final byte GetModel = (byte)106;
    private double capacity = 0.0;
    private double energy = 0.0;
    private long timeStamp = 0L;
    private boolean batteryMode = false;
    private static final byte packetStart = -86;

    public DeviceBK85xx(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats.add(new ValueFormat("Voltage", "V", ValueFormat.formatD4));
        this.valueFormats.add(new ValueFormat("Current", "A", ValueFormat.formatD3));
        this.valueFormats.add(new ValueFormat("Power", "W", ValueFormat.formatD3));
        this.valueFormats.add(new ValueFormat("Capacity", "Ah", ValueFormat.formatD3));
        this.valueFormats.add(new ValueFormat("Energy", "Wh", ValueFormat.formatD3));
        this.nf = NumberFormat.getNumberInstance(Locale.ENGLISH);
        this.nf.setGroupingUsed(false);
        this.nf.setMaximumFractionDigits(4);
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        this.valueNames = new ArrayList();
        this.valueNames.add("Voltage");
        this.valueNames.add("Current");
        this.valueNames.add("Power");
        this.valueNames.add("Capacity");
        this.valueNames.add("Energy");
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUES?");
    }

    @Override
    public void threadStarted(InterfaceThreads.DeviceThread deviceThread) {
        super.threadStarted(deviceThread);
    }

    public static String deviceName() {
        return "IT85xx";
    }

    @Override
    public String getDeviceName() {
        return this.longName;
    }

    @Override
    public String getDeviceId() {
        return this.idName;
    }

    private static int answerLong(byte[] answer, int ofs) {
        return (answer[ofs] & 0xFF) + (answer[ofs + 1] & 0xFF) * 256 + (answer[ofs + 2] & 0xFF) * 256 * 256 + (answer[ofs + 3] & 0xFF) * 256 * 256 * 256;
    }

    private static int answerInt(byte[] answer, int ofs) {
        return (answer[ofs] & 0xFF) + (answer[ofs + 1] & 0xFF) * 256;
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        SerialPacketInterface si = ((SerialInterface)ci).getDataInterface();
        si.setPacketFormat(CommDataInterface.PacketFormat.HeaderFixedLength, (byte)-86, 26);
        this.ci = new TranslatingCommInterface(si);
        return this.ci;
    }

    class TranslatingCommInterface
    extends TranslatingInterface {
        protected TranslatingCommInterface(CommInterface ci) {
            super(ci);
        }

        private byte[] communicate(int cmd) {
            return this.communicate(cmd, null);
        }

        private byte[] communicate(int cmd, int param) {
            byte[] p = new byte[]{(byte)(param & 0xFF), (byte)(param / 256 & 0xFF)};
            return this.communicate(cmd, p);
        }

        private byte[] communicate(int cmd, long param) {
            byte[] p = new byte[]{(byte)(param & 0xFFL), (byte)(param / 256L & 0xFFL), (byte)(param / 65536L & 0xFFL), (byte)(param / 0x1000000L & 0xFFL)};
            return this.communicate(cmd, p);
        }

        private synchronized byte[] communicate(int cmd, byte[] params) {
            try {
                byte[] packet = new byte[26];
                int i = 0;
                while (i < packet.length) {
                    packet[i] = 0;
                    ++i;
                }
                packet[0] = -86;
                packet[1] = 0;
                packet[2] = (byte)cmd;
                if (params != null) {
                    i = 0;
                    while (i < params.length) {
                        packet[3 + i] = params[i];
                        ++i;
                    }
                }
                byte sum = 0;
                int i2 = 0;
                while (i2 < packet.length - 1) {
                    sum = (byte)(sum + packet[i2]);
                    ++i2;
                }
                packet[25] = sum;
                ((SerialPacketInterface)this.originalCommInterface).writeData(packet);
                return this.getAnswer(cmd);
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                return null;
            }
        }

        private byte[] getAnswer(int cmd) {
            byte[] answer = ((SerialPacketInterface)this.originalCommInterface).readData();
            if (answer == null) {
                this.log("No answer received");
                return null;
            }
            byte sum = 0;
            int i = 0;
            while (i < answer.length - 1) {
                sum = (byte)(sum + answer[i]);
                ++i;
            }
            if (answer[25] != sum) {
                this.log("Checksum error");
                return null;
            }
            if (answer[2] == 18) {
                switch (answer[3]) {
                    case -112: {
                        this.log("checksum incorrect");
                        break;
                    }
                    case -96: {
                        this.log("parameter incorrect");
                        break;
                    }
                    case -80: {
                        this.log("unreconized command");
                        break;
                    }
                    case -64: {
                        this.log("invalid command");
                    }
                }
                return null;
            }
            if (answer[2] != cmd) {
                this.log("Answer do not match command");
                return null;
            }
            return answer;
        }

        private void cmdIdn() {
            String version;
            byte[] answer = this.communicate(106);
            if (answer == null) {
                return;
            }
            String model = String.valueOf(String.valueOf((char)answer[3])) + String.valueOf((char)answer[4]) + String.valueOf((char)answer[5]) + String.valueOf((char)answer[6]);
            if (answer[7] != 0) {
                model = String.valueOf(model) + String.valueOf((char)answer[7]);
            }
            if ((version = String.valueOf(StringUtil.hex2(answer[9])) + "." + StringUtil.hex2(answer[8])).charAt(0) == '0') {
                version = version.substring(1);
            }
            StringBuilder sn = new StringBuilder();
            int i = 10;
            while (i <= 20) {
                sn.append((char)answer[i]);
                ++i;
            }
            DeviceBK85xx.this.idName = "B&K PRECISION, BK" + model + ",";
            DeviceBK85xx.this.longName = "B&K Precision BK" + model;
            if (DeviceBK85xx.this.getHandleName() == null || DeviceBK85xx.this.getHandleName().length() == 0) {
                DeviceBK85xx.this.setHandleName("BK" + model);
            }
            DeviceBK85xx.this.setSerialNumber(sn.toString());
            this.message.add(String.valueOf(DeviceBK85xx.this.idName) + sn.toString() + "," + version);
        }

        private void cmdValues() {
            byte[] answer = this.communicate(95);
            if (answer == null) {
                return;
            }
            double volt = (double)DeviceBK85xx.answerLong(answer, 3) / 1000.0;
            double current = (double)DeviceBK85xx.answerLong(answer, 7) / 10000.0;
            double power = (double)DeviceBK85xx.answerLong(answer, 11) / 1000.0;
            long time = System.currentTimeMillis();
            long dt = time - DeviceBK85xx.this.timeStamp;
            DeviceBK85xx.this.timeStamp = time;
            double deltaHours = (double)dt / 3600000.0;
            if (dt < 30000L) {
                DeviceBK85xx deviceBK85xx = DeviceBK85xx.this;
                deviceBK85xx.capacity = deviceBK85xx.capacity + current * deltaHours;
                DeviceBK85xx deviceBK85xx2 = DeviceBK85xx.this;
                deviceBK85xx2.energy = deviceBK85xx2.energy + power * deltaHours;
            } else {
                DeviceBK85xx.this.capacity = 0.0;
                DeviceBK85xx.this.energy = 0.0;
            }
            this.message.add(String.valueOf(DeviceBK85xx.this.nf.format(volt)) + " " + DeviceBK85xx.this.nf.format(current) + " " + DeviceBK85xx.this.nf.format(power) + " " + DeviceBK85xx.this.nf.format(DeviceBK85xx.this.capacity) + " " + DeviceBK85xx.this.nf.format(DeviceBK85xx.this.energy));
        }

        private void cmdOn(boolean on) {
            if (on) {
                DeviceBK85xx.this.capacity = 0.0;
                DeviceBK85xx.this.energy = 0.0;
                DeviceBK85xx.this.timeStamp = System.currentTimeMillis();
            }
            if (on && DeviceBK85xx.this.batteryMode) {
                this.communicate(93, 0);
                this.communicate(40, 0);
                this.communicate(93, 4);
            } else {
                this.communicate(33, on ? 1 : 0);
            }
        }

        private void cmdOn() {
            byte[] answer = this.communicate(95);
            if (answer == null) {
                return;
            }
            this.message.add((answer[15] & 8) != 0 ? "1" : "0");
        }

        private void cmdVoltage(double voltage) {
            DeviceBK85xx.this.batteryMode = false;
            this.communicate(93, 0);
            this.communicate(40, 1);
            this.communicate(44, (long)(voltage * 1000.0));
        }

        private void cmdCurrent(double current) {
            DeviceBK85xx.this.batteryMode = false;
            this.communicate(93, 0);
            this.communicate(40, 0);
            this.communicate(42, (long)(current * 10000.0));
        }

        private void cmdPower(double power) {
            DeviceBK85xx.this.batteryMode = false;
            this.communicate(93, 0);
            this.communicate(40, 2);
            this.communicate(46, (long)(power * 1000.0));
        }

        private void cmdResistance(double resistance) {
            DeviceBK85xx.this.batteryMode = false;
            this.communicate(93, 0);
            this.communicate(40, 3);
            this.communicate(48, (long)(resistance * 1000.0));
        }

        private void cmdVoltage() {
            byte[] answer = this.communicate(45);
            if (answer == null) {
                return;
            }
            double volt = (double)DeviceBK85xx.answerLong(answer, 3) / 1000.0;
            this.message.add(DeviceBK85xx.this.nf.format(volt));
        }

        private void cmdCurrent() {
            byte[] answer = this.communicate(43);
            double volt = (double)DeviceBK85xx.answerLong(answer, 3) / 10000.0;
            this.message.add(DeviceBK85xx.this.nf.format(volt));
        }

        private void cmdPower() {
            byte[] answer = this.communicate(47);
            if (answer == null) {
                return;
            }
            double volt = (double)DeviceBK85xx.answerLong(answer, 3) / 1000.0;
            this.message.add(DeviceBK85xx.this.nf.format(volt));
        }

        private void cmdResistance() {
            byte[] answer = this.communicate(49);
            if (answer == null) {
                return;
            }
            double volt = (double)DeviceBK85xx.answerLong(answer, 3) / 1000.0;
            this.message.add(DeviceBK85xx.this.nf.format(volt));
        }

        private void cmdMaxVoltage(double voltage) {
            this.communicate(34, (long)(voltage * 1000.0));
        }

        private void cmdMaxCurrent(double current) {
            this.communicate(36, (long)(current * 10000.0));
        }

        private void cmdMaxPower(double power) {
            this.communicate(38, (long)(power * 1000.0));
        }

        private void cmdVonMode(boolean on) {
            this.communicate(14, (byte)(on ? 1 : 0));
        }

        private void cmdVonMode() {
            byte[] answer = this.communicate(15);
            if (answer == null) {
                return;
            }
            this.message.add((answer[3] & 1) != 0 ? "1" : "0");
        }

        private void cmdVon(double von) {
            this.communicate(16, (long)(von * 1000.0));
        }

        private void cmdVon() {
            byte[] answer = this.communicate(17);
            if (answer == null) {
                return;
            }
            this.message.add(DeviceBK85xx.this.nf.format((double)DeviceBK85xx.answerLong(answer, 3) / 1000.0));
        }

        private void cmdMaxVoltage() {
            byte[] answer = this.communicate(35);
            if (answer == null) {
                return;
            }
            double volt = (double)DeviceBK85xx.answerLong(answer, 3) / 1000.0;
            this.message.add(DeviceBK85xx.this.nf.format(volt));
        }

        private void cmdMaxCurrent() {
            byte[] answer = this.communicate(37);
            if (answer == null) {
                return;
            }
            double current = (double)DeviceBK85xx.answerLong(answer, 3) / 10000.0;
            this.message.add(DeviceBK85xx.this.nf.format(current));
        }

        private void cmdMaxPower() {
            byte[] answer = this.communicate(39);
            if (answer == null) {
                return;
            }
            double power = (double)DeviceBK85xx.answerLong(answer, 3) / 1000.0;
            this.message.add(DeviceBK85xx.this.nf.format(power));
        }

        private void cmdMinBattery(double voltage) {
            DeviceBK85xx.this.batteryMode = true;
            this.communicate(40, 0);
            this.communicate(78, (long)(voltage * 1000.0));
        }

        private void cmdMinBattery() {
            byte[] answer = this.communicate(79);
            if (answer == null) {
                return;
            }
            double voltage = (double)DeviceBK85xx.answerLong(answer, 3) / 1000.0;
            this.message.add(DeviceBK85xx.this.nf.format(voltage));
        }

        private void cmdMode(int mode) {
            this.communicate(93, 0);
            this.communicate(40, mode % 10);
            if (mode >= 10) {
                this.communicate(93, mode / 10);
            }
        }

        private void cmdMode() {
            byte[] answer = this.communicate(41);
            if (answer == null) {
                return;
            }
            byte mode = answer[3];
            answer = this.communicate(94);
            if (answer == null) {
                return;
            }
            byte amode = answer[3];
            StringBuilder sb = new StringBuilder();
            sb.append(mode + amode * 10);
            sb.append(" ");
            switch (mode) {
                case 0: {
                    sb.append("CC");
                    break;
                }
                case 1: {
                    sb.append("CV");
                    break;
                }
                case 2: {
                    sb.append("CW");
                    break;
                }
                case 3: {
                    sb.append("CR");
                }
            }
            DeviceBK85xx.this.batteryMode = false;
            switch (amode) {
                case 0: {
                    break;
                }
                case 1: {
                    sb.append(" Short");
                    break;
                }
                case 2: {
                    sb.append(" Transistion");
                    break;
                }
                case 3: {
                    sb.append(" List");
                    break;
                }
                case 4: {
                    DeviceBK85xx.this.batteryMode = true;
                    sb.append(" Battery");
                    if (mode == 0) break;
                    sb.append(" not active");
                }
            }
            this.message.add(sb.toString());
        }

        private void cmdSense(boolean on) {
            this.communicate(86, on ? 1 : 0);
        }

        private void cmdSense() {
            byte[] answer = this.communicate(87);
            if (answer == null) {
                return;
            }
            this.message.add(answer[3] != 0 ? "1" : "0");
        }

        private void cmdRemote(boolean on) {
            this.communicate(32, 1);
            this.communicate(85, on ? 0 : 1);
            if (!on) {
                this.communicate(32, 0);
            }
        }

        private void cmdRemote() {
            byte[] answer = this.communicate(95);
            if (answer == null) {
                return;
            }
            this.message.add((answer[15] & 4) != 0 ? "1" : "0");
        }

        @Override
        public boolean write(String msg) {
            if (!this.originalCommInterface.isOpen()) {
                return false;
            }
            this.log("vTx:", msg);
            String[] ss = msg.trim().split("[ ]");
            String cmd = ss[0].toLowerCase().trim();
            if (cmd.equals("*idn?")) {
                this.cmdIdn();
            } else if (cmd.equals("values?")) {
                this.cmdValues();
            } else if (cmd.equals("on")) {
                this.cmdOn(StringUtil.parseInt(ss[1]) != 0);
            } else if (cmd.equals("voltage")) {
                this.cmdVoltage(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("current")) {
                this.cmdCurrent(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("resistance")) {
                this.cmdResistance(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("power")) {
                this.cmdPower(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("on?")) {
                this.cmdOn();
            } else if (cmd.equals("voltage?")) {
                this.cmdVoltage();
            } else if (cmd.equals("current?")) {
                this.cmdCurrent();
            } else if (cmd.equals("resistance?")) {
                this.cmdResistance();
            } else if (cmd.equals("power?")) {
                this.cmdPower();
            } else if (cmd.equals("maxvoltage")) {
                this.cmdMaxVoltage(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("maxcurrent")) {
                this.cmdMaxCurrent(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("maxpower")) {
                this.cmdMaxPower(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("maxvoltage?")) {
                this.cmdMaxVoltage();
            } else if (cmd.equals("maxcurrent?")) {
                this.cmdMaxCurrent();
            } else if (cmd.equals("maxpower?")) {
                this.cmdMaxPower();
            } else if (cmd.equals("minbattery")) {
                this.cmdMinBattery(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("minbattery?")) {
                this.cmdMinBattery();
            } else if (cmd.equals("mode")) {
                this.cmdMode(StringUtil.parseInt(ss[1]));
            } else if (cmd.equals("mode?")) {
                this.cmdMode();
            } else if (cmd.equals("vonmode")) {
                this.cmdVonMode(StringUtil.parseInt(ss[1]) != 0);
            } else if (cmd.equals("vonmode?")) {
                this.cmdVonMode();
            } else if (cmd.equals("von")) {
                this.cmdVon(StringUtil.parseDoubleEE(ss[1]));
            } else if (cmd.equals("von?")) {
                this.cmdVon();
            } else if (cmd.equals("sense")) {
                this.cmdSense(StringUtil.parseInt(ss[1]) != 0);
            } else if (cmd.equals("sense?")) {
                this.cmdSense();
            } else if (cmd.equals("remote")) {
                this.cmdRemote(StringUtil.parseInt(ss[1]) != 0);
            } else if (cmd.equals("remote?")) {
                this.cmdRemote();
            } else if (cmd.equals("e?")) {
                this.message.add("\"" + ss[1] + "\"");
            }
            return true;
        }
    }
}

