/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.comm.SocketInterface;
import dk.hkj.comm.TranslatingInterface;
import dk.hkj.devices.ChecksumGenerator;
import dk.hkj.devices.DeviceSCPI;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Support;
import dk.hkj.script.Script;
import dk.hkj.util.ByteBuffer;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.io.UnsupportedEncodingException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DeviceAsciiBlock
extends DeviceSCPI {
    private TranslatingCommInterface ci;
    private CommDataInterface cid;
    private long nextCommandTime = 0L;
    private long delayTime = 0L;
    private String poll = null;
    private String rxEol = "\r\n";
    private ChecksumGenerator checksumGenerator = null;
    private String terminator = "";

    static String trimspc(String s) {
        if (s.isEmpty()) {
            return "";
        }
        int i = 0;
        while (i < s.length() && s.charAt(i) == ' ') {
            ++i;
        }
        int j = s.length();
        while (j > i && s.charAt(j - 1) == ' ') {
            --j;
        }
        if (j < i) {
            j = i;
        }
        return s.substring(i, j);
    }

    public DeviceAsciiBlock(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        if (ci instanceof SerialInterface) {
            this.ci = new TranslatingCommInterface(((SerialInterface)ci).getDataInterface());
        } else if (ci instanceof SocketInterface) {
            this.ci = new TranslatingCommInterface(((SocketInterface)ci).getDataInterface());
        }
        String ss = this.def.getItem("#charset");
        if (ss != null && !ss.isEmpty()) {
            this.ci.charset = ss;
        }
        this.delayTime = this.def.getItemInt("#cmdDelayTime");
        this.rxEol = StringUtil.decodeEscape(this.def.getItem("#rxEol", "\r\n"));
        this.terminator = StringUtil.decodeEscape(this.def.getItem("#eol", "\r\n"));
        String s = this.def.getItem("#checksum");
        if (s != null && !s.trim().isEmpty()) {
            this.checksumGenerator = new ChecksumGenerator(s);
        }
        return this.ci;
    }

    @Override
    public List<String> supportedCommands() {
        List<String> list = super.supportedCommands();
        if (this.commandList == null || this.commandList.size() == 0) {
            list = this.def.getScpiDefines();
            list.add("*idn?");
            if (this.ci.async) {
                list.add("Values?");
            }
            list.sort(null);
            this.commandList = list;
        }
        return list;
    }

    @Override
    public String finalInit() {
        return "";
    }

    class TranslatingCommInterface
    extends TranslatingInterface {
        protected byte[] rxStart;
        protected byte[] rxEnd;
        protected byte[] lastValue;
        protected int blockCount;
        protected Pattern rxFormat;
        protected String charset;
        protected boolean async;
        protected long timestamp;

        private synchronized void setLastValue(byte[] lastValue) {
            this.lastValue = lastValue;
        }

        private synchronized byte[] getLastValue() {
            return this.lastValue;
        }

        protected TranslatingCommInterface(CommInterface ci) {
            super(ci);
            this.rxStart = null;
            this.rxEnd = null;
            this.lastValue = null;
            this.blockCount = 1;
            this.rxFormat = null;
            this.charset = "ISO-8859-1";
            this.async = false;
            this.timestamp = 0L;
            DeviceAsciiBlock.this.cid = (CommDataInterface)((Object)ci);
        }

        private Pattern compileFormat(String format) {
            if (format.contains("(")) {
                return Pattern.compile(format, 32);
            }
            StringBuilder regEx = new StringBuilder();
            int i = 0;
            while (i < format.length()) {
                switch (format.charAt(i)) {
                    case '*': 
                    case 'X': 
                    case 'x': {
                        regEx.append(".*?[+-]?[0-9]+[.]?[0-9]*E?[+-]?[0-9]*");
                        break;
                    }
                    case 'F': 
                    case 'U': 
                    case 'f': 
                    case 'u': {
                        regEx.append(".*?([+-]?[0-9]+[.]?[0-9]*E?[+-]?[0-9]*)");
                        break;
                    }
                    case 'S': 
                    case 's': {
                        regEx.append(".*?([+-]?[0-9]+[.]?[0-9]*[pnumkMG]?)");
                    }
                }
                ++i;
            }
            return Pattern.compile(regEx.toString(), 32);
        }

        @Override
        public void open() {
            super.open();
            String s1 = DeviceAsciiBlock.this.def.getItem("#rxStart");
            String s2 = DeviceAsciiBlock.this.def.getItem("#rxEnd");
            String rxForm = DeviceAsciiBlock.this.def.getItem("#rxFormat");
            DeviceAsciiBlock.this.poll = StringUtil.decodeEscape(DeviceAsciiBlock.this.def.getItem("#poll", ""));
            this.blockCount = DeviceAsciiBlock.this.def.getItemInt("#rxCount", 1);
            if (s2 != null && s2.length() > 0) {
                ByteBuffer bb = new ByteBuffer();
                bb.append(StringUtil.decodeEscape(s1 == null ? "" : s1.trim()));
                this.rxStart = bb.getAsArray();
                bb = new ByteBuffer();
                bb.append(StringUtil.decodeEscape(s2.trim()));
                this.rxEnd = bb.getAsArray();
                this.rxFormat = this.compileFormat(rxForm);
                boolean bl = this.async = this.rxEnd.length > 0;
                if (this.async) {
                    new RxValues();
                }
            }
        }

        private void cmdIdn() {
            String s;
            StringBuilder sb = new StringBuilder();
            if (this.async) {
                long t = System.currentTimeMillis();
                while (System.currentTimeMillis() - t < 2000L && this.lastValue == null) {
                    TranslatingCommInterface.sleep(50);
                }
                if (this.lastValue != null) {
                    this.message.add(DeviceAsciiBlock.this.def.getIdName().trim());
                }
                return;
            }
            String verify = DeviceAsciiBlock.this.def.getItem("#verifyDevice");
            if (verify != null && verify.length() > 0) {
                String answer;
                int i;
                String value = "";
                if (verify.charAt(0) == '(' || verify.charAt(0) == '\"') {
                    i = Support.scriptEndPosition(verify);
                    if (i > 0) {
                        Script script = new Script();
                        value = script.expression(verify.substring(0, i)).asString();
                        verify = verify.substring(i).trim();
                    }
                } else {
                    i = verify.indexOf(32);
                    value = verify.substring(0, i);
                    verify = verify.substring(i + 1).trim();
                }
                if (!(answer = this.writeRead(verify).replace(" ", "_").trim()).equals(value)) {
                    answer = "**Device do not match** <" + answer + ">";
                    if (InterfaceThreads.debugAll) {
                        this.logLogAlways(answer);
                    }
                    this.message.add(answer);
                    return;
                }
            }
            sb.append(DeviceAsciiBlock.this.def.getIdName().trim());
            if (sb.charAt(sb.length() - 1) == ',') {
                sb.append(" ");
            } else {
                sb.append(", ");
            }
            if (DeviceAsciiBlock.this.def.getScpiDefine("getdevicesn?") != null && (s = this.writeRead("getDeviceSN?")) != null && s.length() > 0) {
                sb.append(s);
            }
            sb.append(", ");
            if (DeviceAsciiBlock.this.def.getScpiDefine("getdevicesw?") != null && (s = this.writeRead("getDeviceSW?")) != null && s.length() > 0) {
                sb.append(s);
            }
            this.message.add(sb.toString());
        }

        private void waitDelayTime() {
            long t = System.currentTimeMillis();
            long dt = DeviceAsciiBlock.this.nextCommandTime - t;
            if (dt > 0L) {
                if (dt > 2000L) {
                    dt = 2000L;
                }
                CommInterface.sleep((int)dt);
            }
        }

        private byte[] parseWriteString(String str) {
            ByteBuffer bb = new ByteBuffer();
            bb.append(StringUtil.decodeEscape(str));
            if (DeviceAsciiBlock.this.checksumGenerator != null) {
                DeviceAsciiBlock.this.checksumGenerator.addCheck(bb);
            }
            if (DeviceAsciiBlock.this.terminator != null) {
                bb.append(DeviceAsciiBlock.this.terminator);
            }
            return bb.getAsArray();
        }

        private void parseFormat(byte[] b, Pattern format, StringBuilder sb) {
            String s = null;
            try {
                s = new String(b, this.charset);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                s = new String(b);
            }
            Matcher m = format.matcher(s);
            if (m.lookingAt()) {
                int i = 1;
                while (i <= m.groupCount()) {
                    if (sb.length() > 0) {
                        sb.append(' ');
                    }
                    sb.append(m.group(i));
                    ++i;
                }
            }
        }

        private boolean writeRead(int n, StringBuilder sb, String data) {
            this.waitDelayTime();
            int j = data.indexOf(47);
            String format = null;
            if (j > 0) {
                format = data.substring(j + 1);
                if (!format.isEmpty() && format.charAt(0) == ' ') {
                    format = format.substring(1);
                }
                data = data.substring(0, j);
            }
            if (n == 0) {
                DeviceAsciiBlock.this.cid.writeData(this.parseWriteString(data));
            } else {
                DeviceAsciiBlock.this.cid.setPacketFormat(CommDataInterface.PacketFormat.HeaderAndEnd, new byte[0], DeviceAsciiBlock.this.rxEol.getBytes(), n);
                DeviceAsciiBlock.this.cid.flush();
                byte[] b = DeviceAsciiBlock.this.cid.writeReadData(this.parseWriteString(data));
                if (InterfaceThreads.debugAll) {
                    InterfaceThreads.logDebug("Rx <" + new String(b) + ">");
                }
                if (format == null) {
                    if (sb != null) {
                        String s = "";
                        try {
                            s = new String(b, this.charset);
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            s = new String(b);
                        }
                        sb.append(s);
                    }
                } else if (sb != null) {
                    this.parseFormat(b, this.compileFormat(format), sb);
                }
            }
            DeviceAsciiBlock.this.nextCommandTime = DeviceAsciiBlock.this.delayTime + System.currentTimeMillis();
            return true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public synchronized boolean write(String msg) {
            try {
                int j;
                if (!this.originalCommInterface.isOpen()) {
                    return false;
                }
                StringBuilder sb = new StringBuilder();
                this.log("vTx:", msg);
                msg = msg.trim();
                int i = msg.indexOf(32);
                if (i < 0) {
                    i = msg.length();
                }
                String cmd = msg.substring(0, i).toLowerCase();
                String[] lines = new String[]{};
                boolean requestAnswer = msg.indexOf(63) >= 0;
                String cmddef = DeviceAsciiBlock.this.def.getScpiDefine(cmd);
                String params = DeviceAsciiBlock.trimspc(msg.substring(i));
                if (cmddef != null) {
                    if (cmddef.substring(0, 5).equalsIgnoreCase("#pgm#")) {
                        msg = "none";
                        if (DeviceAsciiBlock.this.debugOtherComm) {
                            DeviceAsciiBlock.this.debugLog("Script start");
                        }
                        DeviceAsciiBlock.this.getPgmScript().addLocalVar("value", Var.createValue(params));
                        Var v = DeviceAsciiBlock.this.getPgmScript().execute(cmddef.substring(6));
                        if (v != null) {
                            sb.append(v.asString());
                        }
                        if (DeviceAsciiBlock.this.debugOtherComm) {
                            DeviceAsciiBlock.this.debugLog("Script end <" + sb.toString() + ">");
                        }
                    } else {
                        int r;
                        lines = cmddef.split("[\\n]");
                        if (lines.length > 1) {
                            cmddef = lines[0];
                        }
                        if ((r = cmddef.indexOf("/")) < 0) {
                            r = cmddef.length();
                        }
                        if ((j = cmddef.indexOf(40)) >= 0 && j < r) {
                            DeviceAsciiBlock.this.getScript().addLocalVar("value", Var.createValue(params));
                            String regex = cmddef.substring(r);
                            cmddef = String.valueOf(Support.processScriptInBrackets(DeviceAsciiBlock.this.getScript(), StringUtil.decodeEscape(cmddef.substring(0, r)))) + "/" + regex;
                        } else {
                            cmddef = StringUtil.decodeEscape(cmddef);
                        }
                        msg = cmddef;
                        if (requestAnswer && msg.indexOf(63) < 0) {
                            return false;
                        }
                        if (this.debugLog) {
                            this.logLog("Tx <" + msg + ">");
                        }
                    }
                }
                String[] stringArray = msg.split("[;]");
                int n = stringArray.length;
                j = 0;
                while (j < n) {
                    block47: {
                        int n2;
                        String cmdx;
                        block48: {
                            block46: {
                                cmdx = stringArray[j];
                                i = cmdx.indexOf(32);
                                if (i < 0) {
                                    cmd = cmdx.toLowerCase();
                                    cmdx = "";
                                } else {
                                    cmd = cmdx.substring(0, i).toLowerCase();
                                    cmdx = cmdx.substring(i + 1);
                                }
                                if (!cmd.equals("*idn?")) break block46;
                                this.cmdIdn();
                                break block47;
                            }
                            if (!this.async || !cmd.equals("values?")) break block48;
                            if (this.rxFormat == null) {
                                if (sb != null) {
                                    sb.append(this.lastValue);
                                }
                                break block47;
                            } else if (sb != null) {
                                this.parseFormat(this.getLastValue(), this.rxFormat, sb);
                            }
                            break block47;
                        }
                        if (cmd.equals("tx")) {
                            this.writeRead(0, null, cmdx);
                        } else if (cmd.equals("txrx1")) {
                            this.writeRead(1, null, cmdx);
                        } else if (cmd.equals("txrx2")) {
                            this.writeRead(2, null, cmdx);
                        } else if (cmd.equals("txrxn")) {
                            i = cmdx.indexOf(32);
                            n2 = 0;
                            if (i > 0) {
                                n2 = StringUtil.parseInt(cmdx.substring(0, i).trim());
                                cmdx = DeviceAsciiBlock.trimspc(cmdx.substring(i + 1));
                            } else {
                                n2 = StringUtil.parseInt(cmdx);
                                cmdx = "";
                            }
                            this.writeRead(n2, null, cmdx);
                        } else if (cmd.equals("txrx1?")) {
                            this.writeRead(1, sb, cmdx);
                        } else if (cmd.equals("txrx2?")) {
                            this.writeRead(2, sb, cmdx);
                        } else if (!cmd.equals("none") && !cmd.equals("none?") && cmd.equals("txrxn?")) {
                            i = cmdx.indexOf(32);
                            n2 = 0;
                            if (i > 0) {
                                n2 = StringUtil.parseInt(cmdx.substring(0, i).trim());
                                cmdx = DeviceAsciiBlock.trimspc(cmdx.substring(i + 1));
                            } else {
                                n2 = StringUtil.parseInt(cmdx);
                                cmdx = "";
                            }
                            this.writeRead(n2, sb, cmdx);
                        }
                    }
                    ++j;
                }
                if (lines.length > 1) {
                    DeviceAsciiBlock.this.getScript().addLocalVar("inputValue", Var.createValue(params));
                    int j2 = 1;
                    while (j2 < lines.length) {
                        String line = lines[j2];
                        if (line.startsWith(":readmath:")) {
                            line = line.substring(":readmath:".length());
                            DeviceAsciiBlock.this.getScript().addLocalVar("value", Var.createValue(sb.toString()));
                            sb.setLength(0);
                            sb.append(DeviceAsciiBlock.this.getScript().expression(line).asString());
                        } else if (line.startsWith(":setvar:")) {
                            if (sb.length() > 0) {
                                DeviceAsciiBlock.this.getScript().addLocalVar("value", Var.createValue(sb.toString()));
                            }
                            line = line.substring(":setvar:".length());
                            DeviceAsciiBlock.this.getScript().execute("var " + line);
                        }
                        ++j2;
                    }
                    DeviceAsciiBlock.this.getScript().removeLocalVar("inputValue");
                }
                if (sb.length() <= 0) return true;
                this.message.add(sb.toString());
                return true;
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                return false;
            }
        }

        class RxValues
        extends Thread {
            RxValues() {
                this.setDaemon(true);
                this.setName("RxValues");
                this.start();
            }

            @Override
            public void run() {
                DeviceAsciiBlock.this.cid.setPacketFormat(CommDataInterface.PacketFormat.HeaderAndEnd, TranslatingCommInterface.this.rxStart, TranslatingCommInterface.this.rxEnd, TranslatingCommInterface.this.blockCount);
                DeviceAsciiBlock.this.cid.flush();
                TranslatingCommInterface.this.timestamp = System.currentTimeMillis();
                while (DeviceAsciiBlock.this.ci.isOpen()) {
                    byte[] b = null;
                    if (!DeviceAsciiBlock.this.poll.isEmpty()) {
                        CommInterface.sleep(50);
                        try {
                            DeviceAsciiBlock.this.cid.setPacketFormat(CommDataInterface.PacketFormat.HeaderAndEnd, TranslatingCommInterface.this.rxStart, TranslatingCommInterface.this.rxEnd, TranslatingCommInterface.this.blockCount);
                            b = DeviceAsciiBlock.this.cid.writeReadData(DeviceAsciiBlock.this.poll.getBytes("ISO-8859-1"));
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {
                            DeviceAsciiBlock.this.cid.setPacketFormat(CommDataInterface.PacketFormat.HeaderAndEnd, TranslatingCommInterface.this.rxStart, TranslatingCommInterface.this.rxEnd, TranslatingCommInterface.this.blockCount);
                            b = DeviceAsciiBlock.this.cid.writeReadData(DeviceAsciiBlock.this.poll.getBytes());
                        }
                    } else {
                        b = DeviceAsciiBlock.this.cid.readData();
                    }
                    if (b != null) {
                        TranslatingCommInterface.this.setLastValue(b);
                        if (InterfaceThreads.debugAll) {
                            InterfaceThreads.logDebug("Rx <" + new String(b) + ">");
                        }
                        TranslatingCommInterface.this.timestamp = System.currentTimeMillis();
                        continue;
                    }
                    long dt = System.currentTimeMillis() - TranslatingCommInterface.this.timestamp;
                    if (dt <= 2000L) continue;
                    TranslatingCommInterface.this.setLastValue(null);
                }
                TranslatingCommInterface.this.setLastValue(null);
            }
        }
    }
}

