/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.comm.GpibInterface;
import dk.hkj.devices.DeviceAscii;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.util.ByteBuffer;
import java.util.Arrays;
import java.util.List;

public class DeviceAsciiBin
extends DeviceAscii {
    protected CommDataInterface originalCommDataInterface = null;
    protected CommDataInterface.PacketFormat packetFormat = null;

    public DeviceAsciiBin(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        ci = (CommInterface)((Object)ci.getDataInterface());
        ci.setEOL("");
        super.getCommInterface(ci);
        this.originalCommDataInterface = (CommDataInterface)((Object)ci);
        this.ci = new TranslatingCommDataInterface(ci);
        ci.setTimeout(this.def.getReadingDelay());
        String packetFormatName = this.def.getItem("#packetFormat");
        CommDataInterface.PacketFormat[] packetFormatArray = CommDataInterface.PacketFormat.values();
        int n = packetFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            CommDataInterface.PacketFormat pf = packetFormatArray[n2];
            if (pf.name().equalsIgnoreCase(packetFormatName)) {
                this.packetFormat = pf;
                this.originalCommDataInterface.setPacketFormat(pf);
            }
            ++n2;
        }
        this.delayTime = this.def.getItemInt("#cmdDelayTime");
        return this.ci;
    }

    @Override
    public List<String> supportedCommands() {
        List<String> list = super.supportedCommands();
        if (list == null || list.size() == 0) {
            list = this.def.getScpiDefines();
            list.add("*idn?");
            list.sort(null);
            this.commandList = list;
        }
        return list;
    }

    @Override
    public String finalInit() {
        return "";
    }

    class TranslatingCommDataInterface
    extends DeviceAscii.TranslatingCommInterface {
        protected TranslatingCommDataInterface(CommInterface ci) {
            super(ci);
        }

        @Override
        public void open() {
            super.open();
        }

        @Override
        protected void oWrite(String cmd) {
            if (cmd.toUpperCase().matches("\\[(CLR|LLO|LOC|TRG)\\]")) {
                if (DeviceAsciiBin.this.originalCommDataInterface instanceof GpibInterface) {
                    ((GpibInterface)this.originalCommInterface).writeControl(cmd.substring(1, cmd.length() - 1).toUpperCase());
                }
                return;
            }
            DeviceAsciiBin.this.originalCommDataInterface.writeData(this.encode(cmd));
        }

        @Override
        protected String oRead() {
            String msg = this.decode(DeviceAsciiBin.this.originalCommDataInterface.readData());
            return msg;
        }

        @Override
        protected String oWriteRead(String cmd) {
            if (cmd.toUpperCase().matches("\\[(CLR|LLO|TRG)\\]")) {
                if (DeviceAsciiBin.this.originalCommDataInterface instanceof GpibInterface) {
                    ((GpibInterface)((Object)DeviceAsciiBin.this.originalCommDataInterface)).writeControl(cmd.substring(1, cmd.length() - 1).toUpperCase());
                }
                return "";
            }
            String answer = this.decode(DeviceAsciiBin.this.originalCommDataInterface.writeReadData(this.encode(cmd)));
            if (answer != null && this.async && this.rxMaskPattern.matcher(answer).matches()) {
                this.setLastValues(answer);
                answer = this.decode(DeviceAsciiBin.this.originalCommDataInterface.writeReadData(this.encode(cmd)));
            }
            return answer;
        }

        private String decode(byte[] b) {
            switch (DeviceAsciiBin.this.packetFormat) {
                case Length7: {
                    return new String(Arrays.copyOfRange(b, 1, b.length), this.originalCommInterface.getCharset()).trim();
                }
                case Length15: {
                    return new String(Arrays.copyOfRange(b, 2, b.length), this.originalCommInterface.getCharset()).trim();
                }
                case Length31: {
                    return new String(Arrays.copyOfRange(b, 4, b.length), this.originalCommInterface.getCharset()).trim();
                }
            }
            return null;
        }

        private byte[] encode(String cmd) {
            ByteBuffer b = new ByteBuffer();
            int n = cmd.length();
            cmd = String.valueOf(cmd) + this.originalCommInterface.getEOL();
            switch (DeviceAsciiBin.this.packetFormat) {
                case Length7: {
                    b.append((byte)(0x80 | n));
                    b.append(cmd.getBytes(this.originalCommInterface.getCharset()));
                    break;
                }
                case Length15: {
                    b.append((byte)(0x80 | n >> 8));
                    b.append((byte)n);
                    b.append(cmd.getBytes(this.originalCommInterface.getCharset()));
                    break;
                }
                case Length31: {
                    b.append((byte)(0x80 | n >> 24));
                    b.append((byte)(n >> 16));
                    b.append((byte)(n >> 8));
                    b.append((byte)n);
                    b.append(cmd.getBytes(this.originalCommInterface.getCharset()));
                    break;
                }
            }
            return b.getAsArray();
        }

        @Override
        protected String oWriteReadLines(String cmd, int n) {
            return null;
        }

        @Override
        protected String oWriteReadTimeout(String cmd, int timeout) {
            String answer = this.decode(DeviceAsciiBin.this.originalCommDataInterface.writeReadData(this.encode(cmd), timeout));
            return answer;
        }

        @Override
        protected byte[] oWriteReadBin(String cmd, int count, int timeout) {
            byte[] answer = DeviceAsciiBin.this.originalCommDataInterface.writeReadData(this.encode(cmd), timeout);
            return answer;
        }
    }
}

