/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.GpibInterface;
import dk.hkj.comm.TranslatingInterface;
import dk.hkj.devices.DeviceSCPI;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Support;
import dk.hkj.script.Script;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.util.List;
import java.util.regex.Pattern;

public class DeviceAscii
extends DeviceSCPI {
    protected TranslatingCommInterface ci;
    protected long nextCommandTime = 0L;
    protected long delayTime = 0L;

    public DeviceAscii(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        super.getCommInterface(ci);
        this.ci = new TranslatingCommInterface(ci);
        ci.setTimeout(this.def.getReadingDelay());
        this.delayTime = this.def.getItemInt("#cmdDelayTime");
        return this.ci;
    }

    @Override
    public List<String> supportedCommands() {
        List<String> list = super.supportedCommands();
        if (list == null || list.size() == 0) {
            list = this.def.getScpiDefines();
            list.add("*idn?");
            list.sort(null);
            this.commandList = list;
        }
        return list;
    }

    @Override
    public String finalInit() {
        return "";
    }

    class TranslatingCommInterface
    extends TranslatingInterface {
        protected Pattern rxMaskPattern;
        protected String lastValues;
        protected boolean async;

        protected TranslatingCommInterface(CommInterface ci) {
            super(ci);
            this.rxMaskPattern = null;
            this.lastValues = "";
            this.async = false;
        }

        @Override
        public void open() {
            super.open();
            String rxMask = DeviceAscii.this.def.getItem("#rxMask");
            if (rxMask != null && rxMask.length() > 0) {
                this.rxMaskPattern = Pattern.compile(rxMask);
                this.async = this.rxMaskPattern != null;
                new RxValues();
            }
        }

        protected synchronized void setLastValues(String answer) {
            this.lastValues = answer;
        }

        protected void oWrite(String cmd) {
            if (cmd.toUpperCase().matches("\\[(CLR|LLO|LOC|TRG)\\]")) {
                if (this.originalCommInterface instanceof GpibInterface) {
                    ((GpibInterface)this.originalCommInterface).writeControl(cmd.substring(1, cmd.length() - 1).toUpperCase());
                }
                return;
            }
            this.originalCommInterface.write(cmd);
        }

        protected String oRead() {
            String msg = this.originalCommInterface.read();
            return msg;
        }

        protected String oRead(int timeout) {
            String msg = this.originalCommInterface.read(timeout);
            return msg;
        }

        protected String oWriteRead(String cmd) {
            if (cmd.toUpperCase().matches("\\[(CLR|LLO|TRG)\\]")) {
                if (this.originalCommInterface instanceof GpibInterface) {
                    ((GpibInterface)this.originalCommInterface).writeControl(cmd.substring(1, cmd.length() - 1).toUpperCase());
                }
                return "";
            }
            String answer = this.originalCommInterface.writeRead(cmd);
            if (answer != null && this.async && this.rxMaskPattern.matcher(answer).matches()) {
                this.setLastValues(answer);
                answer = this.originalCommInterface.writeRead(cmd);
            }
            return answer;
        }

        protected String oWriteReadLines(String cmd, int n) {
            String answer = this.originalCommInterface.writeReadLines(cmd, n);
            return answer;
        }

        protected String oWriteReadTimeout(String cmd, int timeout) {
            String answer = this.originalCommInterface.writeReadTimeout(cmd, timeout);
            return answer;
        }

        protected byte[] oWriteReadBin(String cmd, int count, int timeout) {
            byte[] answer = this.originalCommInterface.writeReadBin(cmd, count, timeout);
            return answer;
        }

        private void cmdIdn() {
            String s;
            StringBuilder sb = new StringBuilder();
            String verify = DeviceAscii.this.def.getItem("#verifyDevice");
            if (verify != null && verify.length() > 0) {
                String answer;
                int i;
                String value = "";
                if (verify.charAt(0) == '(' || verify.charAt(0) == '\"') {
                    i = Support.scriptEndPosition(verify);
                    if (i > 0) {
                        Script script = new Script();
                        value = script.expression(verify.substring(0, i)).asString();
                        verify = verify.substring(i).trim();
                    }
                } else {
                    i = verify.indexOf(32);
                    value = verify.substring(0, i);
                    verify = verify.substring(i + 1).trim();
                }
                if (!(answer = this.writeRead(verify).trim()).replace(" ", "_").equals(value.replace(" ", "_"))) {
                    answer = "**Device do not match** <" + answer + ">";
                    if (InterfaceThreads.debugAll) {
                        this.logLogAlways(answer);
                    }
                    this.message.add(answer);
                    return;
                }
            }
            sb.append(DeviceAscii.this.def.getIdName().trim());
            if (sb.charAt(sb.length() - 1) == ',') {
                sb.append(" ");
            } else {
                sb.append(", ");
            }
            if (DeviceAscii.this.def.getScpiDefine("getdevicesn?") != null && (s = this.writeRead("getDeviceSN?")) != null && s.length() > 0) {
                sb.append(s);
            }
            sb.append(", ");
            if (DeviceAscii.this.def.getScpiDefine("getdevicesw?") != null && (s = this.writeRead("getDeviceSW?")) != null && s.length() > 0) {
                sb.append(s);
            }
            this.message.add(sb.toString());
        }

        private void waitDelayTime() {
            long t = System.currentTimeMillis();
            long dt = DeviceAscii.this.nextCommandTime - t;
            if (dt > 0L) {
                if (dt > 2000L) {
                    dt = 2000L;
                }
                CommInterface.sleep((int)dt);
            }
        }

        /*
         * Enabled aggressive exception aggregation
         */
        @Override
        public synchronized boolean write(String msg) {
            try {
                if (!this.originalCommInterface.isOpen()) {
                    return false;
                }
                StringBuilder sb = new StringBuilder();
                this.log("vTx:", msg);
                msg = msg.trim();
                int i = msg.indexOf(32);
                if (i < 0) {
                    i = msg.length();
                }
                String cmd = msg.substring(0, i).toLowerCase();
                String[] lines = new String[]{};
                boolean requestAnswer = (msg = msg.replace(";", "\n")).indexOf(63) >= 0;
                String cmddef = DeviceAscii.this.def.getScpiDefine(cmd);
                String params = msg.substring(i).trim();
                if (cmddef != null) {
                    if (cmddef.substring(0, 5).equalsIgnoreCase("#pgm#")) {
                        msg = "none";
                        if (DeviceAscii.this.debugOtherComm) {
                            DeviceAscii.this.debugLog("Script start");
                        }
                        DeviceAscii.this.getPgmScript().addLocalVar("value", Var.createValue(params));
                        Var v = DeviceAscii.this.getPgmScript().execute(cmddef.substring(6));
                        if (v != null) {
                            sb.append(v.asString());
                        }
                        if (DeviceAscii.this.debugOtherComm) {
                            DeviceAscii.this.debugLog("Script end <" + sb.toString() + ">");
                        }
                    } else {
                        msg = cmddef;
                        if (requestAnswer && msg.indexOf(63) < 0) {
                            return false;
                        }
                        if (DeviceAscii.this.debugOtherComm) {
                            DeviceAscii.this.debugLog("Tx <" + msg + ">");
                        }
                    }
                }
                lines = msg.split("[\n]");
                String[] stringArray = msg.split("[\n]");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String cmdx = stringArray[n2];
                    if (!cmdx.matches(":[^ ]+:.*")) {
                        int charCount;
                        Script script;
                        int j;
                        if (cmdx.contains("(value)")) {
                            cmdx = cmdx.replace("(value)", params);
                        }
                        if (cmdx.indexOf(40) >= 0) {
                            DeviceAscii.this.getScript().addLocalVar("value", Var.createValue(params));
                            cmdx = Support.processScriptInBrackets(DeviceAscii.this.getScript(), cmdx);
                        }
                        if ((i = cmdx.indexOf(32)) < 0) {
                            cmd = cmdx.toLowerCase();
                            cmdx = "";
                        } else {
                            cmd = cmdx.substring(0, i).toLowerCase();
                            cmdx = cmdx.substring(i + 1).trim();
                        }
                        if (cmd.equals("*idn?")) {
                            this.cmdIdn();
                        } else if (this.async && cmd.equals("values?")) {
                            sb.append(this.lastValues);
                        } else if (cmd.equals("tx")) {
                            this.waitDelayTime();
                            this.oWrite(cmdx);
                            DeviceAscii.this.nextCommandTime = DeviceAscii.this.delayTime + System.currentTimeMillis();
                        } else if (cmd.equals("txrx")) {
                            this.waitDelayTime();
                            this.oWriteRead(cmdx);
                            DeviceAscii.this.nextCommandTime = DeviceAscii.this.delayTime + System.currentTimeMillis();
                        } else if (cmd.equals("rxalluntil?")) {
                            String v = "";
                            j = cmdx.indexOf(32);
                            long timeout = System.currentTimeMillis() + (long)(Double.parseDouble(cmdx.substring(0, j)) * 1000.0);
                            cmdx = cmdx.substring(j + 1).trim();
                            script = new Script();
                            do {
                                String vv;
                                if ((vv = this.oRead()) != null) {
                                    v = String.valueOf(v) + vv;
                                }
                                script.addLocalVar("value", Var.createValue(v));
                            } while (!script.expression(cmdx).asBoolean() && timeout < System.currentTimeMillis());
                            if (v.length() > 0) {
                                if (sb.length() > 0) {
                                    sb.append(" ");
                                }
                                sb.append(v);
                            }
                        } else if (cmd.equals("rxuntil?")) {
                            String v = "";
                            j = cmdx.indexOf(32);
                            long timeout = System.currentTimeMillis() + (long)(Double.parseDouble(cmdx.substring(0, j)) * 1000.0);
                            cmdx = cmdx.substring(j + 1).trim();
                            script = new Script();
                            do {
                                if ((v = this.oRead()) == null) {
                                    v = "";
                                }
                                script.addLocalVar("value", Var.createValue(v));
                            } while (!script.expression(cmdx).asBoolean() && timeout < System.currentTimeMillis());
                            if (v.length() > 0) {
                                if (sb.length() > 0) {
                                    sb.append(" ");
                                }
                                sb.append(v);
                            }
                        } else if (cmd.equals("txrx?")) {
                            this.waitDelayTime();
                            String v = this.oWriteRead(cmdx);
                            DeviceAscii.this.nextCommandTime = DeviceAscii.this.delayTime + System.currentTimeMillis();
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            sb.append(v);
                        } else if (cmd.equals("txrxn?")) {
                            this.waitDelayTime();
                            int j2 = cmdx.indexOf(32);
                            if (j2 < 0) {
                                j2 = cmdx.length();
                            }
                            int lineCount = Integer.parseInt(cmdx.substring(0, j2));
                            cmdx = cmdx.substring(j2).trim();
                            String v = lineCount > 0 ? this.oWriteReadLines(cmdx, lineCount) : "";
                            DeviceAscii.this.nextCommandTime = DeviceAscii.this.delayTime + System.currentTimeMillis();
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            sb.append(v);
                        } else if (cmd.equals("txrxtimeout?")) {
                            this.waitDelayTime();
                            int j3 = cmdx.indexOf(32);
                            if (j3 < 0) {
                                j3 = cmdx.length();
                            }
                            int timeout = (int)(StringUtil.parseDoubleEE(cmdx.substring(0, j3)) * 1000.0);
                            cmdx = cmdx.substring(j3).trim();
                            String v = this.oWriteReadTimeout(cmdx, timeout);
                            DeviceAscii.this.nextCommandTime = DeviceAscii.this.delayTime + System.currentTimeMillis();
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            sb.append(v);
                        } else if (cmd.equalsIgnoreCase("txrxnBin?")) {
                            int j4 = cmdx.indexOf(32);
                            if (j4 < 0) {
                                j4 = cmdx.length();
                            }
                            charCount = Integer.parseInt(cmdx.substring(0, j4));
                            cmdx = cmdx.substring(j4).trim();
                            byte[] b = this.oWriteReadBin(StringUtil.decodeEscape(cmdx), charCount, this.timeout);
                            if (charCount > 8) {
                                if (sb.length() > 0) {
                                    sb.append(" ");
                                }
                                sb.append("$" + StringUtil.hexNN(b) + "$");
                            } else {
                                long l = 0L;
                                int k = 0;
                                while (k < Math.min(charCount, b.length)) {
                                    l |= ((long)b[k] & 0xFFL) << 8 * k;
                                    ++k;
                                }
                                if (sb.length() > 0) {
                                    sb.append(" ");
                                }
                                sb.append(Long.toString(l));
                            }
                            DeviceAscii.this.nextCommandTime = DeviceAscii.this.delayTime + System.currentTimeMillis();
                        } else if (cmd.equalsIgnoreCase("txrx1Bin?")) {
                            byte[] b = this.oWriteReadBin(StringUtil.decodeEscape(cmdx), 1, this.timeout);
                            if (b != null && b.length >= 1) {
                                sb.append(Integer.toString(b[0] & 0xFF));
                            }
                            DeviceAscii.this.nextCommandTime = DeviceAscii.this.delayTime + System.currentTimeMillis();
                        } else if (cmd.equalsIgnoreCase("txrxnBin")) {
                            int j5 = cmdx.indexOf(32);
                            if (j5 < 0) {
                                j5 = cmdx.length();
                            }
                            charCount = Integer.parseInt(cmdx.substring(0, j5));
                            cmdx = cmdx.substring(j5).trim();
                            this.oWriteReadBin(StringUtil.decodeEscape(cmdx), charCount, this.timeout);
                            DeviceAscii.this.nextCommandTime = DeviceAscii.this.delayTime + System.currentTimeMillis();
                        } else if (cmd.equalsIgnoreCase("txBin")) {
                            this.originalCommInterface.writeBin(StringUtil.decodeEscape(cmdx));
                            DeviceAscii.this.nextCommandTime = DeviceAscii.this.delayTime + System.currentTimeMillis();
                        } else if (cmd.equalsIgnoreCase("txrx1Bin")) {
                            this.oWriteReadBin(StringUtil.decodeEscape(cmdx), 1, this.timeout);
                            DeviceAscii.this.nextCommandTime = DeviceAscii.this.delayTime + System.currentTimeMillis();
                        } else if (cmd.equals("txrx2?")) {
                            this.waitDelayTime();
                            String v = this.oWriteReadLines(cmdx, 2);
                            DeviceAscii.this.nextCommandTime = DeviceAscii.this.delayTime + System.currentTimeMillis();
                            if (sb.length() > 0) {
                                sb.append(" ");
                            }
                            sb.append(v);
                        } else if (!cmd.equals("none")) {
                            cmd.equals("none?");
                        }
                    }
                    ++n2;
                }
                if (lines.length > 1) {
                    DeviceAscii.this.getScript().addLocalVar("inputValue", Var.createValue(params));
                    int j = 1;
                    while (j < lines.length) {
                        String line = lines[j];
                        if (line.startsWith(":readmath:")) {
                            line = line.substring(":readmath:".length());
                            DeviceAscii.this.getScript().addLocalVar("value", Var.createValue(sb.toString()));
                            sb.setLength(0);
                            sb.append(DeviceAscii.this.getScript().expression(line).asString());
                        } else if (line.startsWith(":setvar:")) {
                            if (sb.length() > 0) {
                                DeviceAscii.this.getScript().addLocalVar("value", Var.createValue(sb.toString()));
                            }
                            line = line.substring(":setvar:".length());
                            DeviceAscii.this.getScript().execute("var " + line);
                        }
                        ++j;
                    }
                    DeviceAscii.this.getScript().removeLocalVar("inputValue");
                }
                if (sb.length() > 0) {
                    this.message.add(sb.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                return false;
            }
            return true;
        }

        class RxValues
        extends Thread {
            RxValues() {
                this.setDaemon(true);
                this.setName("RxValues");
                this.start();
            }

            @Override
            public void run() {
                while (TranslatingCommInterface.this.originalCommInterface.isOpen()) {
                    try {
                        if (TranslatingCommInterface.this.originalCommInterface.isData()) {
                            String data = TranslatingCommInterface.this.oRead(100);
                            if (data == null || !TranslatingCommInterface.this.rxMaskPattern.matcher(data).matches()) continue;
                            TranslatingCommInterface.this.setLastValues(data);
                            continue;
                        }
                        CommInterface.sleep(50);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }
}

