/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.comm.LayerInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.comm.SerialPacketInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.SCPICommand;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.util.ByteBuffer;
import dk.hkj.util.StringUtil;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;

public class DeviceAppa
extends DeviceInterface {
    private AppaInterface ci;
    private CommDataInterface cii;
    private String modelBrand = null;
    private String modelName = null;
    private String serialNumber = null;
    private int modelId = 0;
    private int version = 0;
    private boolean idFound = false;
    private String selectedMode = "";
    private int overflowCounter = 0;
    private String currentMode = "";
    private String outputMessage = null;
    private String lastMessage = null;
    private long rate = 0L;
    private long lastTime = 0L;
    private boolean voltcraft = false;
    private static final String[] FunctionCode = new String[]{"None", "ACV", "DCV", "ACmV", "DCmV", "Resistor", "Continuity", "Diode", "Capacitor", "ACA", "DCA", "ACmA", "DCmA", "Temperature", "Temperature", "Frequency", "Duty", "Frequency", "Frequency", "Frequency", "Frequency", "AC+DC V", "AC+DC mV", "AC+DC A", "AC+DC mA", "ACV", "ACmV", "ACA", "ACmA", "ACuA", "DCuA", "DCA", "DCA", "DCA", "DCA", "DCA", "Loop", "Loop250", "Volt", "ACV", "ACmV", "ACA", "ACmA", "ACV", "DCV", "AC+DC V", "ACV", "Frequency", "ACV", "DCV", "ACW", "DCW", "PF", "Current", "Current", "Current", "Frequency", "Harmonics", "Current", "Harmonics", "ACuA", "ACuA", "Frequency", "Frequency", "Frequency", "Frequency", "Frequency", "DCV", "ACV", "ACV", "AC+DC V"};
    private static final String[] FunctionCodeVoltcraft = new String[]{"Temperature", "Temperature", "", "", "ACV", "DCV", "AC+DC V", "", "ACmV", "DCmV", "AC+DC mV", "", "Ohm", "Ohm", "Capacity", "DCV", "ACmA", "DCmA", "AC+DC mA", "", "ACA", "DCA", "AC+DC A", "", "Frequency", "Frequency", "", ""};

    public DeviceAppa(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
        this.valueFormats.add(new ValueFormat("VoltageDC", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("VoltageAC", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("VoltageACDC", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Voltage", "V", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("CurrentDC", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("CurrentAC", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("CurrentACDC", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Current", "A", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Resistance", "ohm", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Capacitance", "F", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("Frequency", "Hz", ValueFormat.formatSI));
        this.valueFormats.add(new ValueFormat("DutyCycle", "%", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("Temperature", "\u00b0C", ValueFormat.formatD1));
        this.valueFormats.add(new ValueFormat("dB", "", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("dBm", "", ValueFormat.formatD2));
        this.valueFormats.add(new ValueFormat("PowerFactor", "", ValueFormat.formatD3));
        this.valueFormats.add(new ValueFormat("WattDC", "W", ValueFormat.formatD3));
        this.valueFormats.add(new ValueFormat("WattAC", "W", ValueFormat.formatD3));
    }

    private void selectMode() {
        this.valueNames = new ArrayList();
        this.selectedMode = this.currentMode;
        if (this.currentMode.equals("DCV") || this.currentMode.equals("DCmV") || this.currentMode.equals("none") || this.currentMode.equals("Diode")) {
            this.valueNames.add("VoltageDC");
        } else if (this.currentMode.equals("ACV") || this.currentMode.equals("ACmV")) {
            this.valueNames.add("VoltageAC");
        } else if (this.currentMode.equals("AC+DC V") || this.currentMode.equals("AC+DC mV")) {
            this.valueNames.add("VoltageACDC");
        } else if (this.currentMode.equals("Voltage")) {
            this.valueNames.add("Voltage");
        } else if (this.currentMode.equals("DCA") || this.currentMode.equals("DCmA") || this.currentMode.equals("DCuA") || this.currentMode.equals("Current")) {
            this.valueNames.add("CurrentDC");
        } else if (this.currentMode.equals("ACA") || this.currentMode.equals("ACmA") || this.currentMode.equals("ACuA")) {
            this.valueNames.add("CurrentAC");
        } else if (this.currentMode.equals("AC+DC A") || this.currentMode.equals("AC+DC mA") || this.currentMode.equals("AC+DC uA")) {
            this.valueNames.add("CurrentACDC");
        } else if (this.currentMode.equals("Current")) {
            this.valueNames.add("Current");
        } else if (this.currentMode.equalsIgnoreCase("Resistor") || this.currentMode.equalsIgnoreCase("Continuity")) {
            this.valueNames.add("Resistance");
        } else if (this.currentMode.equals("Capacitor")) {
            this.valueNames.add("Capacitance");
        } else if (this.currentMode.equalsIgnoreCase("Frequency")) {
            this.valueNames.add("Frequency");
        } else if (this.currentMode.equalsIgnoreCase("Duty")) {
            this.valueNames.add("DutyCycle");
        } else if (this.currentMode.equalsIgnoreCase("DCW")) {
            this.valueNames.add("WattDC");
        } else if (this.currentMode.equalsIgnoreCase("ACW")) {
            this.valueNames.add("WattAC");
        } else if (this.currentMode.equalsIgnoreCase("Temperature")) {
            this.valueNames.add("Temperature");
        } else if (this.currentMode.equalsIgnoreCase("dBm")) {
            this.valueNames.add("dBm");
        } else if (this.currentMode.equalsIgnoreCase("dB")) {
            this.valueNames.add("dB");
        } else if (this.currentMode.equalsIgnoreCase("PF")) {
            this.valueNames.add("PowerFactor");
        } else {
            System.out.println("Mode not found " + this.currentMode);
        }
    }

    @Override
    public synchronized void initColumns() {
        if (this.valueNames != null) {
            return;
        }
        super.initColumns();
        this.selectMode();
        this.askValueCommand = new SCPICommand((DeviceInterface)this, "VALUE?");
    }

    public static String deviceName() {
        return "Appa";
    }

    @Override
    public String getDeviceName() {
        return this.def.getDeviceName();
    }

    @Override
    public String getDeviceId() {
        return this.def.getIdName();
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        if (!(ci instanceof SerialInterface)) {
            return null;
        }
        ((SerialInterface)ci).setTimeout(1000);
        this.ci = new AppaInterface(((SerialInterface)ci).getDataInterface());
        return this.ci;
    }

    private class AppaInterface
    extends LayerInterface {
        protected AppaInterface(CommInterface ci) {
            super(ci);
            DeviceAppa.this.cii = (SerialPacketInterface)ci;
            DeviceAppa.this.cii.setPacketFormat(CommDataInterface.PacketFormat.Appa);
        }

        @Override
        public void open() {
            super.open();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        AppaInterface.this.readModel();
                        while (AppaInterface.this.originalCommInterface.isOpen()) {
                            if (DeviceAppa.this.voltcraft) {
                                AppaInterface.this.readDisplayVoltcraft();
                                continue;
                            }
                            AppaInterface.this.readDisplayAppa();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            new Thread(r).start();
        }

        protected byte[] makePacket(int command) {
            return this.makePacket(command, null);
        }

        protected byte[] makePacket(int command, byte[] data) {
            ByteBuffer bb = new ByteBuffer();
            bb.append((byte)85);
            bb.append((byte)85);
            bb.append((byte)command);
            bb.append((byte)(data == null ? 0 : data.length));
            if (data != null && data.length > 0) {
                bb.append(data);
            }
            int sum = 0;
            int i = 0;
            while (i < bb.getSize()) {
                sum += bb.unsignedByteAt(i);
                ++i;
            }
            bb.append((byte)sum);
            return bb.getAsArray();
        }

        protected byte[] extractData(byte[] packet, int dataOffset, int dataLength) {
            byte[] bb = new byte[dataLength];
            int i = 0;
            while (i < dataLength) {
                bb[i] = packet[4 + dataOffset + i];
                ++i;
            }
            return bb;
        }

        protected String extractDataAsString(byte[] packet, int dataOffset, int dataLength) {
            byte[] bb = this.extractData(packet, dataOffset, dataLength);
            while (dataLength > 0 && bb[--dataLength] == 0) {
            }
            try {
                return new String(Arrays.copyOf(bb, dataLength), "ISO-8859-1").trim();
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(Arrays.copyOf(bb, dataLength)).trim();
            }
        }

        protected int extractDataInt2M(byte[] packet, int dataOffset) {
            byte[] bb = this.extractData(packet, dataOffset, 2);
            return (bb[1] & 0xFF) << 8 | bb[0] & 0xFF;
        }

        protected int extractDataInt2(byte[] packet, int dataOffset) {
            byte[] bb = this.extractData(packet, dataOffset, 2);
            return bb[1] & 0xFF | (bb[0] & 0xFF) << 8;
        }

        protected int extractDataInt1(byte[] packet, int dataOffset) {
            byte[] bb = this.extractData(packet, dataOffset, 1);
            return bb[0] & 0xFF;
        }

        protected void readModel() {
            byte[] bb = DeviceAppa.this.cii.writeReadData(this.makePacket(0));
            if (bb[3] == 52) {
                DeviceAppa.this.serialNumber = this.extractDataAsString(bb, 32, 16);
                DeviceAppa.this.modelId = this.extractDataInt2M(bb, 48);
                DeviceAppa.this.version = this.extractDataInt2M(bb, 50);
                String s = this.extractDataAsString(bb, 0, 32);
                int i = s.indexOf(32);
                if (i > 0) {
                    DeviceAppa.this.modelBrand = s.substring(0, i);
                    DeviceAppa.this.modelName = s.substring(i + 1);
                } else {
                    DeviceAppa.this.modelBrand = "APPA";
                    DeviceAppa.this.modelName = "ID" + DeviceAppa.this.modelId;
                }
                DeviceAppa.this.idFound = true;
            } else if (bb[3] == 54) {
                DeviceAppa.this.serialNumber = this.extractDataAsString(bb, 10, 8);
                DeviceAppa.this.modelId = 0;
                DeviceAppa.this.version = this.extractDataInt2M(bb, 18);
                String s = this.extractDataAsString(bb, 0, 10);
                DeviceAppa.this.voltcraft = true;
                if (s.equals("0008_")) {
                    DeviceAppa.this.modelBrand = "Voltcraft";
                    DeviceAppa.this.modelName = "VC950";
                } else {
                    DeviceAppa.this.modelBrand = "??";
                    DeviceAppa.this.modelName = s;
                }
                DeviceAppa.this.idFound = true;
            }
        }

        protected double decodeDisplay(byte[] display, boolean setupColumns) {
            int vv = display[2] << 16 & 0xFF0000 | display[1] << 8 & 0xFF00 | display[0] & 0xFF;
            if ((display[2] & 0x80) != 0) {
                vv |= 0xFF000000;
            }
            double v = vv;
            byte u = display[3];
            byte t = display[4];
            if (Math.abs(v) >= 7340032.0 && Math.abs(v) <= 8388607.0) {
                return Double.NaN;
            }
            if ((t & 0x80) != 0) {
                return (t & 0x20) != 0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            if ((t & 0x20) != 0) {
                v = -v;
            }
            switch (u & 7) {
                case 1: {
                    v /= 10.0;
                    break;
                }
                case 2: {
                    v /= 100.0;
                    break;
                }
                case 3: {
                    v /= 1000.0;
                    break;
                }
                case 4: {
                    v /= 10000.0;
                }
            }
            switch (u >> 3 & 0x1F) {
                case 9: 
                case 23: {
                    v *= 1.0E-9;
                    break;
                }
                case 8: 
                case 22: 
                case 24: {
                    v *= 1.0E-6;
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 21: {
                    v *= 0.001;
                    break;
                }
                case 12: 
                case 16: 
                case 26: {
                    v *= 1000.0;
                    break;
                }
                case 11: 
                case 15: {
                    v *= 1000000.0;
                    break;
                }
                case 10: {
                    v *= 1.0E9;
                    break;
                }
                case 18: {
                    break;
                }
                case 19: {
                    v = (v - 32.0) / 1.8;
                    break;
                }
                case 5: {
                    if (!setupColumns) break;
                    DeviceAppa.this.currentMode = "dB";
                    break;
                }
                case 6: {
                    if (!setupColumns) break;
                    DeviceAppa.this.currentMode = "dBm";
                }
            }
            return v;
        }

        protected String decodeUnit(byte[] display) {
            String u = FunctionCode[display[4] & 0x1F];
            int i = display[3] >> 3 & 0x1F;
            if (i == 5) {
                u = "dB";
            } else if (i == 6) {
                u = "dBm";
            }
            return u;
        }

        protected double decodeDisplayVoltcraft(byte[] display) {
            double v = display[0] << 16 | display[1] << 8 & 0xFF00 | display[2] & 0xFF;
            byte u = display[3];
            byte t = display[4];
            if ((t & 0x20) != 0) {
                return v < 0.0 ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            }
            switch (u & 7) {
                case 1: {
                    v /= 10.0;
                    break;
                }
                case 2: {
                    v /= 100.0;
                    break;
                }
                case 3: {
                    v /= 1000.0;
                    break;
                }
                case 4: {
                    v /= 10000.0;
                }
            }
            switch (u >> 3 & 0x1F) {
                case 9: 
                case 23: {
                    v *= 1.0E-9;
                    break;
                }
                case 8: 
                case 22: 
                case 24: {
                    v *= 1.0E-6;
                    break;
                }
                case 2: 
                case 4: 
                case 7: 
                case 21: {
                    v *= 0.001;
                    break;
                }
                case 12: 
                case 16: 
                case 26: {
                    v *= 1000.0;
                    break;
                }
                case 11: 
                case 15: {
                    v *= 1000000.0;
                    break;
                }
                case 10: {
                    v *= 1.0E9;
                    break;
                }
                case 18: {
                    break;
                }
                case 19: {
                    v = (v - 32.0) / 1.8;
                    break;
                }
                case 5: {
                    DeviceAppa.this.currentMode = "dB";
                    break;
                }
                case 6: {
                    DeviceAppa.this.currentMode = "dBm";
                }
            }
            return v;
        }

        protected void readDisplayVoltcraft() {
            byte[] bb;
            long dt = System.currentTimeMillis() - DeviceAppa.this.lastTime;
            if (dt >= 0L && dt < 500L) {
                CommInterface.sleep((int)(500L - dt));
            }
            if ((bb = DeviceAppa.this.cii.writeReadData(this.makePacket(0))) != null && bb.length > 4 && bb[3] == 54) {
                int function = this.extractDataInt1(bb, 20) << 2 | this.extractDataInt1(bb, 21) & 3;
                byte[] primaryDisplay = this.extractData(bb, 38, 5);
                DeviceAppa.this.currentMode = FunctionCodeVoltcraft[function & 0x7F];
                this.setMessage(this.decodeDisplayVoltcraft(primaryDisplay));
                if (!DeviceAppa.this.currentMode.equals(DeviceAppa.this.selectedMode)) {
                    DeviceAppa.this.requestInitColumns();
                }
            }
        }

        protected void readDisplayAppa() {
            byte[] bb;
            long dt = System.currentTimeMillis() - DeviceAppa.this.lastTime;
            if (dt >= 0L && dt < 50L) {
                CommInterface.sleep((int)(50L - dt));
            }
            if ((bb = DeviceAppa.this.cii.writeReadData(this.makePacket(1))) != null && bb.length > 4 && (bb[3] == 12 || bb[3] == 28)) {
                int function = this.extractDataInt1(bb, 0);
                byte[] primaryDisplay = this.extractData(bb, 2, 5);
                DeviceAppa.this.currentMode = FunctionCode[function & 0x7F];
                this.setMessage(this.decodeDisplay(primaryDisplay, true));
                if (!DeviceAppa.this.currentMode.equals(DeviceAppa.this.selectedMode)) {
                    DeviceAppa.this.requestInitColumns();
                }
            }
        }

        private int getMemoryCount() {
            byte[] byArray = new byte[4];
            byArray[1] = 14;
            byArray[3] = 2;
            byte[] bb = DeviceAppa.this.cii.writeReadData(this.makePacket(26, byArray));
            return this.extractDataInt2(bb, 0);
        }

        private int getLogCount() {
            byte[] byArray = new byte[4];
            byArray[1] = 12;
            byArray[3] = 2;
            byte[] bb = DeviceAppa.this.cii.writeReadData(this.makePacket(26, byArray));
            return this.extractDataInt2(bb, 0);
        }

        private int getLogRate() {
            byte[] byArray = new byte[4];
            byArray[1] = 10;
            byArray[3] = 2;
            byte[] bb = DeviceAppa.this.cii.writeReadData(this.makePacket(26, byArray));
            return this.extractDataInt2(bb, 0);
        }

        private String getMemData(int n) {
            int page = 0;
            if (n > 0) {
                --n;
            }
            while (n >= 500) {
                n -= 500;
                ++page;
            }
            int ofs = 1280 + n * 5;
            byte[] bb = DeviceAppa.this.cii.writeReadData(this.makePacket(26, new byte[]{(byte)page, (byte)ofs, (byte)(ofs >> 8), 5}));
            byte[] display = this.extractData(bb, 0, 5);
            return String.valueOf(StringUtil.formatDoubleEE(this.decodeDisplay(display, false), false)) + " " + this.decodeUnit(display);
        }

        private String getLogData(int n) {
            int page = 0;
            if (n > 0) {
                --n;
            }
            while (n >= 10000) {
                n -= 10000;
                ++page;
            }
            int ofs = 4096 + n * 5;
            byte[] bb = DeviceAppa.this.cii.writeReadData(this.makePacket(26, new byte[]{(byte)page, (byte)ofs, (byte)(ofs >> 8), 5}));
            byte[] display = this.extractData(bb, 0, 5);
            return String.valueOf(StringUtil.formatDoubleEE(this.decodeDisplay(display, false), false)) + " " + this.decodeUnit(display);
        }

        private synchronized void setMessage(double v) {
            DeviceAppa deviceAppa = DeviceAppa.this;
            deviceAppa.overflowCounter = deviceAppa.overflowCounter + 1;
            if (Double.isNaN(v)) {
                if (DeviceAppa.this.overflowCounter > Support.systemSettings.delayOverflow) {
                    DeviceAppa.this.lastMessage = "\ufffd";
                }
            } else if (Double.isInfinite(v)) {
                if (DeviceAppa.this.overflowCounter > Support.systemSettings.delayOverflow) {
                    DeviceAppa.this.lastMessage = v > 0.0 ? "\u221e" : "-\u221e";
                }
            } else {
                DeviceAppa.this.lastMessage = Double.toString(v);
            }
            long t = System.currentTimeMillis();
            DeviceAppa.this.rate = t - DeviceAppa.this.lastTime;
            DeviceAppa.this.lastTime = t;
            DeviceAppa.this.overflowCounter = 0;
        }

        private String idn() {
            long t = System.currentTimeMillis() + 1500L;
            while (!DeviceAppa.this.idFound && System.currentTimeMillis() < t && this.originalCommInterface.isOpen()) {
                CommInterface.sleep(10);
            }
            if (!DeviceAppa.this.idFound) {
                return "No valid answer";
            }
            return String.valueOf(DeviceAppa.this.modelBrand) + "," + DeviceAppa.this.modelName + "," + DeviceAppa.this.serialNumber + "," + DeviceAppa.this.version;
        }

        protected boolean stdCommands(String msg) {
            int i = msg.indexOf(32);
            String params = "";
            if (i >= 0) {
                params = msg.substring(i + 1).trim();
                msg = msg.substring(0, i);
            }
            if (msg.equalsIgnoreCase("*idn?")) {
                DeviceAppa.this.outputMessage = this.idn();
                return true;
            }
            if (msg.equalsIgnoreCase("rate?")) {
                DeviceAppa.this.outputMessage = Long.toString(DeviceAppa.this.rate);
                return true;
            }
            if (msg.equalsIgnoreCase("mode?")) {
                DeviceAppa.this.outputMessage = DeviceAppa.this.currentMode;
                return true;
            }
            if (msg.equalsIgnoreCase("value?")) {
                DeviceAppa.this.outputMessage = System.currentTimeMillis() - DeviceAppa.this.lastTime < 2000L ? DeviceAppa.this.lastMessage : null;
                return true;
            }
            if (msg.equalsIgnoreCase("memCount?")) {
                DeviceAppa.this.outputMessage = Integer.toString(this.getMemoryCount());
                return true;
            }
            if (msg.equalsIgnoreCase("logCount?")) {
                DeviceAppa.this.outputMessage = Integer.toString(this.getLogCount());
                return true;
            }
            if (msg.equalsIgnoreCase("logRate?")) {
                DeviceAppa.this.outputMessage = Integer.toString(this.getLogRate());
                return true;
            }
            if (msg.equalsIgnoreCase("logData?")) {
                DeviceAppa.this.outputMessage = this.getLogData(Integer.parseInt(params));
                return true;
            }
            if (msg.equalsIgnoreCase("memData?")) {
                DeviceAppa.this.outputMessage = this.getMemData(Integer.parseInt(params));
                return true;
            }
            return false;
        }

        @Override
        public synchronized boolean write(String msg) {
            this.log("Tx", msg);
            return this.stdCommands(msg);
        }

        @Override
        public boolean isData() {
            return DeviceAppa.this.outputMessage != null;
        }

        @Override
        public String read() {
            return this.read(300);
        }

        @Override
        public synchronized String read(int timeout) {
            String s = DeviceAppa.this.outputMessage;
            DeviceAppa.this.outputMessage = null;
            return s;
        }
    }
}

