/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.comm.SocketInterface;
import dk.hkj.comm.TranslatingInterface;
import dk.hkj.devices.DeviceSCPI;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.Support;
import dk.hkj.util.ByteBuffer;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DeviceATorchPX100
extends DeviceSCPI {
    private TranslatingCommInterface ci;
    private CommDataInterface si;
    private Map<Integer, Long> lastValue = new HashMap<Integer, Long>();
    private int pxVersion = 1;

    public DeviceATorchPX100(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        CommInterface cii = null;
        if (ci instanceof SerialInterface) {
            cii = ((SerialInterface)ci).getDataInterface();
        } else if (ci instanceof SocketInterface) {
            cii = ((SocketInterface)ci).getDataInterface();
        } else {
            return null;
        }
        this.si = (CommDataInterface)((Object)cii);
        this.si.setAnswerTimeout(this.def.getItemInt("#answerTimeout"));
        if (this.def.getReadingDelay() > 0) {
            cii.setTimeout(this.def.getReadingDelay());
            this.pxVersion = this.def.getItemInt("#PXVersion", 1);
        }
        this.ci = new TranslatingCommInterface(cii);
        return this.ci;
    }

    @Override
    public List<String> supportedCommands() {
        List<String> list = super.supportedCommands();
        if (list == null || list.size() == 0) {
            list = this.def.getScpiDefines();
            list.add("*idn?");
            list.sort(null);
            this.commandList = list;
        }
        return list;
    }

    @Override
    public String finalInit() {
        return "";
    }

    private static enum AnswerType {
        Unknown,
        P1,
        P2,
        P3;

    }

    class TranslatingCommInterface
    extends TranslatingInterface {
        protected TranslatingCommInterface(CommInterface ci) {
            super(ci);
        }

        synchronized byte[] communicate(byte cmd, int value) {
            boolean shortAnswer = (cmd & 0xF0) == 0;
            ByteBuffer bb = new ByteBuffer();
            bb.append((byte)-79);
            bb.append((byte)-78);
            bb.append(cmd);
            if (DeviceATorchPX100.this.pxVersion == 3) {
                bb.append((byte)(value >> 16 & 0xFF));
                bb.append((byte)(value >> 8 & 0xFF));
                bb.append((byte)(value & 0xFF));
                bb.append((byte)0);
                bb.append((byte)0);
            } else {
                bb.append((byte)(value >> 8 & 0xFF));
                bb.append((byte)(value & 0xFF));
            }
            bb.append((byte)-74);
            if (this.debugLog) {
                this.logLog("Tx: " + StringUtil.hexN(bb.getAsArray()));
            }
            if (shortAnswer) {
                DeviceATorchPX100.this.si.setPacketFormat(CommDataInterface.PacketFormat.FixedLength, 1);
            } else {
                DeviceATorchPX100.this.si.setPacketFormat(CommDataInterface.PacketFormat.HeaderFixedLength, new byte[]{-54, -53}, DeviceATorchPX100.this.pxVersion == 3 ? 10 : 7);
            }
            ((CommInterface)((Object)DeviceATorchPX100.this.si)).flush();
            byte[] answer = DeviceATorchPX100.this.si.writeReadData(bb.getAsArray());
            if (this.debugLog) {
                this.logLog("Rx: " + StringUtil.hexN(answer));
            }
            return answer;
        }

        void setValue(byte cmd, int value) {
            this.communicate(cmd, value);
        }

        private AnswerType checkAnswer(byte[] bb, int cmd) {
            if (DeviceATorchPX100.this.pxVersion == 3 && bb.length == 10 && bb[0] == -54 && bb[1] == -53 && bb[2] == (byte)cmd && bb[8] == -50) {
                return AnswerType.P3;
            }
            if (bb != null && bb.length == 7 && bb[0] == -54 && bb[1] == -53 && bb[6] == -49) {
                return AnswerType.P1;
            }
            if (bb != null && bb.length == 7 && bb[0] == -54 && bb[1] == -53 && bb[2] == (byte)cmd && bb[6] == -50) {
                return AnswerType.P2;
            }
            return AnswerType.Unknown;
        }

        long getValueInternal(byte cmd) {
            AnswerType a = AnswerType.Unknown;
            byte[] bb = new byte[]{};
            int n = 0;
            do {
                if ((a = this.checkAnswer(bb = this.communicate(cmd, 0), cmd)) == AnswerType.Unknown) {
                    CommInterface.sleep(5);
                }
                if (++n <= 3) continue;
                return 0L;
            } while (a == AnswerType.Unknown);
            switch (a) {
                case P1: {
                    long v = (bb[2] & 0xFF) << 16 | (bb[3] & 0xFF) << 8 | bb[4] & 0xFF;
                    return v;
                }
                case P2: {
                    long v = (bb[3] & 0xFF) << 16 | (bb[4] & 0xFF) << 8 | bb[5] & 0xFF;
                    return v;
                }
                case P3: {
                    long v = (bb[3] & 0xFF) << 16 | (bb[4] & 0xFF) << 8 | bb[5] & 0xFF;
                    return v;
                }
                case Unknown: {
                    return 0L;
                }
            }
            return 0L;
        }

        long getValue(byte cmd) {
            long v = this.getValueInternal(cmd);
            Long v1 = (Long)DeviceATorchPX100.this.lastValue.get(cmd);
            if (cmd == 18 && v1 != null && Math.abs(v - v1) > 20L) {
                CommInterface.sleep(5);
                v = this.getValueInternal(cmd);
            }
            DeviceATorchPX100.this.lastValue.put(Integer.valueOf(cmd), v);
            return v;
        }

        private String cmdIdn() {
            byte[] bb = this.communicate((byte)17, 0);
            if (this.checkAnswer(bb, 17) == AnswerType.Unknown) {
                return "Unknown";
            }
            return DeviceATorchPX100.this.def.getIdName();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public synchronized boolean write(String msg) {
            try {
                if (!this.originalCommInterface.isOpen()) {
                    return false;
                }
                StringBuilder sb = new StringBuilder();
                this.log("vTx:", msg);
                msg = msg.trim();
                int i = msg.indexOf(32);
                if (i < 0) {
                    i = msg.length();
                }
                String cmd = msg.substring(0, i).toLowerCase();
                String[] lines = new String[]{};
                boolean requestAnswer = msg.indexOf(63) >= 0;
                String cmddef = DeviceATorchPX100.this.def.getScpiDefine(cmd);
                String params = msg.substring(i).trim();
                if (cmddef != null) {
                    lines = cmddef.split("[\\n]");
                    if (lines.length > 1) {
                        cmddef = lines[0];
                    }
                    if (cmddef.contains("(value)")) {
                        cmddef = cmddef.replace("(value)", params);
                    }
                    if (cmddef.indexOf(40) >= 0) {
                        DeviceATorchPX100.this.getScript().addLocalVar("value", Var.createValue(params));
                        cmddef = Support.processScriptInBrackets(DeviceATorchPX100.this.getScript(), cmddef);
                    }
                    msg = cmddef;
                    if (requestAnswer && msg.indexOf(63) < 0) {
                        return false;
                    }
                    if (DeviceATorchPX100.this.debugOtherComm) {
                        DeviceATorchPX100.this.debugLog("Tx <" + msg + ">");
                    }
                }
                String[] stringArray = msg.split("[;]");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String cmdx = stringArray[n2];
                    String[] ss = cmdx.split("[ ]+");
                    cmd = ss[0].toLowerCase();
                    if (cmd.equals("*idn?")) {
                        sb.append(this.cmdIdn());
                    } else if (cmd.equals("tx")) {
                        int vi;
                        double v = StringUtil.parseDoubleEE(ss[2]);
                        if (ss.length >= 4 && ss[3].equalsIgnoreCase("*dd")) {
                            vi = (int)v;
                            v -= (double)vi;
                            vi = vi << 8 | (int)(v * 100.0);
                        } else {
                            vi = ss.length >= 4 && ss[3].equalsIgnoreCase("*10") ? (int)v * 10 : (ss.length >= 4 && ss[3].equalsIgnoreCase("*100") ? (int)v * 100 : (ss.length >= 4 && ss[3].equalsIgnoreCase("*1000") ? (int)v * 1000 : (int)v));
                        }
                        this.setValue((byte)StringUtil.parseInt(ss[1]), vi);
                    } else if (cmd.equals("rx?")) {
                        long v = this.getValue((byte)StringUtil.parseInt(ss[1]));
                        if (ss.length >= 3 && ss[2].equalsIgnoreCase("/10")) {
                            sb.append((double)v / 10.0);
                        } else if (ss.length >= 3 && ss[2].equalsIgnoreCase("/100")) {
                            sb.append((double)v / 100.0);
                        } else if (ss.length >= 3 && ss[2].equalsIgnoreCase("/1000")) {
                            sb.append((double)v / 1000.0);
                        } else if (ss.length >= 3 && ss[2].equalsIgnoreCase("/hms")) {
                            long sec = v & 0xFFL;
                            sec += (v >> 8 & 0xFFL) * 60L;
                            sb.append(sec += (v >> 16 & 0xFFL) * 60L * 60L);
                        } else {
                            sb.append(v);
                        }
                    }
                    ++n2;
                }
                if (lines.length > 1) {
                    DeviceATorchPX100.this.getScript().addLocalVar("inputValue", Var.createValue(params));
                    int j = 1;
                    while (j < lines.length) {
                        String line = lines[j];
                        if (line.startsWith(":readmath:")) {
                            line = line.substring(":readmath:".length());
                            DeviceATorchPX100.this.getScript().addLocalVar("value", Var.createValue(sb.toString()));
                            sb.setLength(0);
                            sb.append(DeviceATorchPX100.this.getScript().expression(line).asString());
                        } else if (line.startsWith(":setvar:")) {
                            if (sb.length() > 0) {
                                DeviceATorchPX100.this.getScript().addLocalVar("value", Var.createValue(sb.toString()));
                            }
                            line = line.substring(":setvar:".length());
                            DeviceATorchPX100.this.getScript().execute("var " + line);
                        }
                        ++j;
                    }
                    DeviceATorchPX100.this.getScript().removeLocalVar("inputValue");
                }
                if (sb.length() <= 0) return true;
                this.message.add(sb.toString());
                return true;
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
                return false;
            }
        }
    }
}

