/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.comm.LayerInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.comm.SerialPacketInterface;
import dk.hkj.devices.DeviceSCPI;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.util.StringUtil;

public class DeviceATorch
extends DeviceSCPI {
    private ATorchCommInterface ci;
    private String outputMessage = null;
    private long lastTime = 0L;
    private long rate = 0L;
    private double[] lastValue = null;
    private byte deviceType = 0;
    private byte backlightTimer = 0;
    private Checksum checksum = Checksum.SUM44;

    public DeviceATorch(ManageDeviceDefinitions.DeviceDefinition def) {
        super(def);
    }

    public static String deviceName() {
        return "Fluke xxx";
    }

    @Override
    public String getDeviceName() {
        return this.def.getDeviceName();
    }

    @Override
    public String getDeviceId() {
        return this.def.getIdName();
    }

    @Override
    public CommInterface getCommInterface(CommInterface ci) {
        String sub;
        if (!(ci instanceof SerialInterface)) {
            return null;
        }
        ((SerialInterface)ci).setTimeout(1000);
        ((SerialInterface)ci).setEOL("\r");
        String sum = this.def.getItem("#checksum");
        if (sum.equalsIgnoreCase("none")) {
            this.checksum = Checksum.None;
        }
        if (sum.equalsIgnoreCase("SUM44")) {
            this.checksum = Checksum.SUM44;
        }
        if ((sub = this.def.getItem("#subDriver")).equalsIgnoreCase("AC")) {
            this.ci = new ATorchACCommInterface(((SerialInterface)ci).getDataInterface());
        } else if (sub.equalsIgnoreCase("DC")) {
            this.ci = new ATorchDCCommInterface(((SerialInterface)ci).getDataInterface());
        } else if (sub.equalsIgnoreCase("DCLoad")) {
            this.ci = new ATorchDCLoadCommInterface(((SerialInterface)ci).getDataInterface());
        } else if (sub.equalsIgnoreCase("USB")) {
            this.ci = new ATorchUSBCommInterface(((SerialInterface)ci).getDataInterface());
        }
        return this.ci;
    }

    @Override
    public void resetTime() {
        ((ATorchCommInterface)this.dt.cPort).resetTime();
    }

    class ATorchACCommInterface
    extends ATorchCommInterface {
        ATorchACCommInterface(SerialPacketInterface pi) {
            super(pi);
        }

        @Override
        double[] decodeData(byte[] data) {
            double[] d = new double[9];
            if (data[3] != this.getType() || data.length != 36) {
                return null;
            }
            d[0] = this.get3(data, 4) / 10.0;
            d[1] = this.get3(data, 7) / 1000.0;
            d[2] = this.get3(data, 10) / 10.0;
            d[3] = this.get4(data, 13) / 100.0;
            d[4] = this.get3(data, 17) / 100.0;
            d[5] = this.get2(data, 20) / 10.0;
            d[6] = this.get2(data, 22) / 1000.0;
            d[7] = this.get2(data, 24);
            d[8] = this.getTime(data, 26);
            DeviceATorch.this.backlightTimer = data[30];
            return d;
        }

        @Override
        int getType() {
            return 1;
        }
    }

    abstract class ATorchCommInterface
    extends LayerInterface {
        double ah;
        double wh;
        double dt;

        public ATorchCommInterface(SerialPacketInterface pi) {
            super(pi);
            this.ah = 0.0;
            this.wh = 0.0;
            this.dt = 0.0;
            pi.setPacketFormat(CommDataInterface.PacketFormat.ATorch);
        }

        @Override
        public void open() {
            super.open();
            Runnable r = new Runnable(){

                @Override
                public void run() {
                    try {
                        ATorchCommInterface.this.resetTime();
                        while (ATorchCommInterface.this.originalCommInterface.isOpen()) {
                            ATorchCommInterface.this.readFromSerialPort();
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace(System.out);
                    }
                }
            };
            Thread t = new Thread(r);
            t.setPriority(8);
            t.setDaemon(true);
            t.start();
        }

        private synchronized void setMessage(byte[] msg) {
            switch (DeviceATorch.this.checksum) {
                case SUM44: {
                    if (this.calcChecksum2(msg) == msg[msg.length - 1]) break;
                    return;
                }
            }
            if (msg[2] == 1) {
                long t = System.currentTimeMillis();
                DeviceATorch.this.rate = t - DeviceATorch.this.lastTime;
                this.dt = (double)(t - DeviceATorch.this.lastTime) / 1000.0;
                DeviceATorch.this.lastValue = this.decodeData(msg);
                DeviceATorch.this.lastTime = t;
            }
        }

        protected void readFromSerialPort() {
            try {
                byte[] data = ((SerialPacketInterface)this.originalCommInterface).readData(500);
                if (data != null) {
                    if (data[2] == 1) {
                        DeviceATorch.this.deviceType = data[3];
                    }
                    this.setMessage(data);
                } else {
                    if (System.currentTimeMillis() - DeviceATorch.this.lastTime > (long)(DeviceATorch.this.def.getReadingDelay() * 2)) {
                        DeviceATorch.this.lastValue = null;
                    }
                    CommInterface.sleep(50);
                }
            }
            catch (Exception e) {
                e.printStackTrace(System.out);
            }
        }

        abstract double[] decodeData(byte[] var1);

        private void cmdIdn() {
            long t = System.currentTimeMillis();
            while (System.currentTimeMillis() - t < 2500L && DeviceATorch.this.deviceType == 0) {
                CommInterface.sleep(50);
            }
            if (DeviceATorch.this.deviceType == this.getType()) {
                DeviceATorch.this.outputMessage = DeviceATorch.this.def.getIdName();
            } else {
                DeviceATorch.this.outputMessage = "Device type " + DeviceATorch.this.deviceType;
            }
        }

        private void txCmd(String cmd) {
            byte[] buffer;
            String[] params = cmd.split("[,; ]+");
            byte c = (byte)StringUtil.parseInt(params[0]);
            int p = 0;
            if (params.length >= 2) {
                p = StringUtil.parseInt(params[1]);
            }
            switch (c) {
                case 1: {
                    this.wh = 0.0;
                    break;
                }
                case 2: {
                    this.ah = 0.0;
                    break;
                }
                case 5: {
                    this.ah = 0.0;
                    this.wh = 0.0;
                }
            }
            buffer = new byte[]{-1, 85, 17, DeviceATorch.this.deviceType, c, (byte)(p / 0x1000000), (byte)(p / 65536), (byte)(p / 256), (byte)p, this.calcChecksum(buffer)};
            ((SerialPacketInterface)this.originalCommInterface).writeData(buffer);
        }

        protected boolean stdCommands(String msg) {
            if (msg.equalsIgnoreCase("*idn?")) {
                this.cmdIdn();
                return true;
            }
            if (msg.equalsIgnoreCase("rate?")) {
                DeviceATorch.this.outputMessage = Long.toString(DeviceATorch.this.rate);
                return true;
            }
            if (msg.equalsIgnoreCase("backlightTimer?")) {
                DeviceATorch.this.outputMessage = Long.toString(DeviceATorch.this.backlightTimer);
                return true;
            }
            if (msg.equalsIgnoreCase("values?")) {
                if (System.currentTimeMillis() - DeviceATorch.this.lastTime > (long)DeviceATorch.this.def.getReadingDelay()) {
                    DeviceATorch.this.outputMessage = null;
                }
                StringBuilder sb = new StringBuilder();
                if (DeviceATorch.this.lastValue == null) {
                    DeviceATorch.this.outputMessage = "";
                    return false;
                }
                double[] dArray = DeviceATorch.this.lastValue;
                int n = dArray.length;
                int n2 = 0;
                while (n2 < n) {
                    double d = dArray[n2];
                    if (sb.length() > 0) {
                        sb.append(" ");
                    }
                    sb.append(d);
                    ++n2;
                }
                DeviceATorch.this.outputMessage = sb.toString();
                return true;
            }
            if (msg.toLowerCase().startsWith("tx ")) {
                this.txCmd(msg.substring(3));
                return true;
            }
            return false;
        }

        @Override
        public synchronized boolean write(String msg) {
            this.log("Tx", msg);
            return this.stdCommands(msg);
        }

        @Override
        public boolean isData() {
            return DeviceATorch.this.outputMessage != null;
        }

        @Override
        public String read() {
            return this.read(300);
        }

        @Override
        public synchronized String read(int timeout) {
            String s = DeviceATorch.this.outputMessage;
            DeviceATorch.this.outputMessage = null;
            return s;
        }

        long getTime(byte[] data, int offset) {
            long v = ((long)data[offset] & 0xFFL) * 3600L * 256L;
            v += ((long)data[offset + 1] & 0xFFL) * 3600L;
            v += ((long)data[offset + 2] & 0xFFL) * 60L;
            return v += (long)data[offset + 3] & 0xFFL;
        }

        double get2(byte[] data, int offset) {
            long v = ((long)data[offset] & 0xFFL) * 256L;
            return v += (long)data[offset + 1] & 0xFFL;
        }

        double get3(byte[] data, int offset) {
            long v = ((long)data[offset] & 0xFFL) * 256L * 256L;
            v += ((long)data[offset + 1] & 0xFFL) * 256L;
            return v += (long)data[offset + 2] & 0xFFL;
        }

        double get4(byte[] data, int offset) {
            long v = ((long)data[offset] & 0xFFL) * 256L * 256L * 256L;
            v += ((long)data[offset + 1] & 0xFFL) * 256L * 256L;
            v += ((long)data[offset + 2] & 0xFFL) * 256L;
            return v += (long)data[offset + 3] & 0xFFL;
        }

        abstract int getType();

        byte calcChecksum(byte[] data) {
            int sum = 0;
            int i = 2;
            while (i < data.length - 1) {
                sum += data[i];
                ++i;
            }
            return (byte)(sum ^= 0x44);
        }

        byte calcChecksum2(byte[] data) {
            int sum = 0;
            int i = 2;
            while (i < data.length - 1) {
                sum ^= data[i];
                ++i;
            }
            return (byte)sum;
        }

        public void resetTime() {
            DeviceATorch.this.lastTime = System.currentTimeMillis();
            this.ah = 0.0;
            this.wh = 0.0;
        }
    }

    class ATorchDCCommInterface
    extends ATorchCommInterface {
        ATorchDCCommInterface(SerialPacketInterface pi) {
            super(pi);
        }

        @Override
        double[] decodeData(byte[] data) {
            double[] d = new double[8];
            if (data[3] != this.getType()) {
                return null;
            }
            d[0] = this.get3(data, 4) / 10.0;
            d[1] = this.get3(data, 7) / 1000.0;
            d[2] = this.get3(data, 10) / 10.0;
            d[3] = this.get4(data, 13) / 100.0;
            d[4] = this.get3(data, 17) / 100.0;
            d[5] = this.get4(data, 20);
            d[6] = this.get2(data, 24);
            d[7] = this.getTime(data, 26);
            DeviceATorch.this.backlightTimer = data[30];
            return d;
        }

        @Override
        int getType() {
            return 2;
        }
    }

    class ATorchDCLoadCommInterface
    extends ATorchCommInterface {
        ATorchDCLoadCommInterface(SerialPacketInterface pi) {
            super(pi);
        }

        @Override
        double[] decodeData(byte[] data) {
            double[] d = new double[8];
            if (data[3] != this.getType()) {
                return null;
            }
            d[0] = this.get3(data, 4) / 10.0;
            d[1] = this.get3(data, 7) / 1000.0;
            d[2] = d[0] * d[1];
            this.ah += d[1] * this.dt / 3600.0;
            this.wh += d[2] * this.dt / 3600.0;
            d[3] = this.ah;
            d[4] = this.wh;
            d[5] = this.get2(data, 24);
            d[6] = this.getTime(data, 26);
            DeviceATorch.this.backlightTimer = data[30];
            return d;
        }

        @Override
        int getType() {
            return 2;
        }
    }

    class ATorchUSBCommInterface
    extends ATorchCommInterface {
        ATorchUSBCommInterface(SerialPacketInterface pi) {
            super(pi);
        }

        @Override
        double[] decodeData(byte[] data) {
            double[] d = new double[9];
            if (data[3] != this.getType()) {
                return null;
            }
            d[0] = this.get3(data, 4) / 100.0;
            d[1] = this.get3(data, 7) / 100.0;
            d[2] = this.get3(data, 10) / 1000.0;
            d[3] = this.get4(data, 13) / 100.0;
            d[4] = this.get2(data, 17) / 100.0;
            d[5] = this.get2(data, 19) / 100.0;
            d[6] = this.get2(data, 21);
            d[7] = this.getTime(data, 23);
            d[8] = d[0] * d[1];
            DeviceATorch.this.backlightTimer = data[27];
            return d;
        }

        @Override
        int getType() {
            return 3;
        }
    }

    private static enum Checksum {
        None,
        SUM44;

    }
}

