/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.devices.DecoderClass;

public class DecoderPeaktech2025A
extends DecoderClass {
    @Override
    public void setupPacketFormat(CommDataInterface cdi) {
        cdi.setPacketFormat(CommDataInterface.PacketFormat.EndCRLF);
    }

    @Override
    public boolean usePoll() {
        return false;
    }

    @Override
    public int messageSize() {
        return 0;
    }

    private boolean eq(byte[] data, byte[] match) {
        if (match.length + 9 != data.length) {
            return false;
        }
        data[7] = (byte)(data[7] | 0x20);
        match[0] = (byte)(match[0] | 0x20);
        data[8] = (byte)(data[8] & 0xFFFFFFCF);
        data[8] = (byte)(data[8] | 8);
        match[1] = (byte)(match[1] | 8);
        int i = 7;
        while (i < data.length - 2) {
            if (i != 11 && data[i] != match[i - 7]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public boolean decode(byte[] data) {
        this.value = Double.NaN;
        if (data[0] != 43 && data[0] != 45) {
            return false;
        }
        if (data[5] != 32) {
            return false;
        }
        this.value = data[2] == 79 && data[3] == 76 ? Double.POSITIVE_INFINITY : (double)((data[1] - 48) * 1000 + (data[2] - 48) * 100 + (data[3] - 48) * 10 + (data[4] - 48));
        if (data[0] == 45) {
            this.value = -this.value;
        }
        switch (data[6]) {
            case 48: {
                break;
            }
            case 49: {
                this.value /= 10.0;
                break;
            }
            case 50: {
                this.value /= 100.0;
                break;
            }
            case 51: {
                this.value /= 1000.0;
                break;
            }
            case 52: {
                this.value /= 10000.0;
            }
        }
        if (this.eq(data, new byte[]{33, 72, -128, 4, 34})) {
            this.mode = "F";
            this.value *= 1.0E-6;
        } else {
            byte[] byArray = new byte[5];
            byArray[0] = 33;
            byArray[1] = 74;
            byArray[3] = 4;
            if (this.eq(data, byArray)) {
                this.mode = "F";
                this.value *= 1.0E-9;
            } else {
                byte[] byArray2 = new byte[5];
                byArray2[0] = 33;
                byArray2[1] = 72;
                byArray2[3] = 8;
                byArray2[4] = 49;
                if (this.eq(data, byArray2)) {
                    this.mode = "Hz";
                } else if (this.eq(data, new byte[]{33, 72, 32, 8, 49})) {
                    this.mode = "Hz";
                    this.value *= 1000.0;
                } else if (this.eq(data, new byte[]{33, 72, 16, 8, 10})) {
                    this.mode = "Hz";
                    this.value *= 1000000.0;
                } else {
                    byte[] byArray3 = new byte[5];
                    byArray3[0] = 33;
                    byArray3[1] = 72;
                    byArray3[2] = 2;
                    byArray3[4] = 4;
                    if (this.eq(data, byArray3)) {
                        this.mode = "%";
                    } else {
                        byte[] byArray4 = new byte[5];
                        byArray4[0] = 33;
                        byArray4[1] = 72;
                        byArray4[3] = 2;
                        byArray4[4] = 2;
                        if (this.eq(data, byArray4)) {
                            this.mode = "TempC";
                        } else {
                            byte[] byArray5 = new byte[5];
                            byArray5[0] = 33;
                            byArray5[1] = 72;
                            byArray5[3] = 1;
                            byArray5[4] = 7;
                            if (this.eq(data, byArray5)) {
                                this.mode = "TempF";
                                this.value = (this.value - 32.0) / 1.8;
                            } else {
                                byte[] byArray6 = new byte[5];
                                byArray6[0] = 49;
                                byArray6[1] = 72;
                                byArray6[2] = -128;
                                byArray6[3] = 64;
                                if (this.eq(data, byArray6)) {
                                    this.mode = "ADC";
                                    this.value *= 1.0E-6;
                                } else {
                                    byte[] byArray7 = new byte[5];
                                    byArray7[0] = 49;
                                    byArray7[1] = 72;
                                    byArray7[2] = 64;
                                    byArray7[3] = 64;
                                    if (this.eq(data, byArray7)) {
                                        this.mode = "ADC";
                                        this.value *= 0.001;
                                    } else {
                                        byte[] byArray8 = new byte[5];
                                        byArray8[0] = 49;
                                        byArray8[1] = 72;
                                        byArray8[3] = 64;
                                        if (this.eq(data, byArray8)) {
                                            this.mode = "ADC";
                                        } else {
                                            byte[] byArray9 = new byte[5];
                                            byArray9[0] = 41;
                                            byArray9[1] = 72;
                                            byArray9[2] = -128;
                                            byArray9[3] = 64;
                                            if (this.eq(data, byArray9)) {
                                                this.mode = "AAC";
                                                this.value *= 1.0E-6;
                                            } else {
                                                byte[] byArray10 = new byte[5];
                                                byArray10[0] = 41;
                                                byArray10[1] = 72;
                                                byArray10[2] = 64;
                                                byArray10[3] = 64;
                                                if (this.eq(data, byArray10)) {
                                                    this.mode = "AAC";
                                                    this.value *= 0.001;
                                                } else {
                                                    byte[] byArray11 = new byte[5];
                                                    byArray11[0] = 41;
                                                    byArray11[1] = 72;
                                                    byArray11[3] = 64;
                                                    if (this.eq(data, byArray11)) {
                                                        this.mode = "AAC";
                                                    } else {
                                                        byte[] byArray12 = new byte[5];
                                                        byArray12[0] = 49;
                                                        byArray12[1] = 72;
                                                        byArray12[3] = -128;
                                                        byArray12[4] = 39;
                                                        if (this.eq(data, byArray12)) {
                                                            this.mode = "VDC";
                                                        } else {
                                                            byte[] byArray13 = new byte[5];
                                                            byArray13[0] = 49;
                                                            byArray13[1] = 72;
                                                            byArray13[2] = 64;
                                                            byArray13[3] = -128;
                                                            if (this.eq(data, byArray13)) {
                                                                this.mode = "VDC";
                                                                this.value *= 0.001;
                                                            } else {
                                                                byte[] byArray14 = new byte[5];
                                                                byArray14[0] = 1;
                                                                byArray14[1] = 72;
                                                                byArray14[3] = 16;
                                                                byArray14[4] = 6;
                                                                if (this.eq(data, byArray14) && data[11] != 2) {
                                                                    this.mode = "VAC";
                                                                } else {
                                                                    byte[] byArray15 = new byte[5];
                                                                    byArray15[0] = 41;
                                                                    byArray15[1] = 72;
                                                                    byArray15[3] = -128;
                                                                    byArray15[4] = 6;
                                                                    if (this.eq(data, byArray15)) {
                                                                        this.mode = "VAC";
                                                                    } else {
                                                                        byte[] byArray16 = new byte[5];
                                                                        byArray16[0] = 1;
                                                                        byArray16[1] = 72;
                                                                        byArray16[3] = 16;
                                                                        byArray16[4] = 2;
                                                                        if (this.eq(data, byArray16)) {
                                                                            this.mode = "*";
                                                                        } else {
                                                                            byte[] byArray17 = new byte[5];
                                                                            byArray17[0] = 33;
                                                                            byArray17[1] = 72;
                                                                            byArray17[3] = 32;
                                                                            byArray17[4] = 2;
                                                                            if (this.eq(data, byArray17)) {
                                                                                this.mode = "ohm";
                                                                            } else if (this.eq(data, new byte[]{33, 72, 32, 32, 6})) {
                                                                                this.mode = "ohm";
                                                                                this.value *= 1000.0;
                                                                            } else if (this.eq(data, new byte[]{33, 72, 16, 32, 10})) {
                                                                                this.mode = "ohm";
                                                                                this.value *= 1000000.0;
                                                                            } else if (this.eq(data, new byte[]{1, 72, 4, -128, 5})) {
                                                                                this.mode = "VDC";
                                                                            } else {
                                                                                byte[] byArray18 = new byte[5];
                                                                                byArray18[0] = 1;
                                                                                byArray18[1] = 72;
                                                                                byArray18[2] = 8;
                                                                                byArray18[3] = 32;
                                                                                this.mode = this.eq(data, byArray18) ? "ohm" : (this.eq(data, new byte[]{1, 72, 8, 32, 60}) ? "ohm" : "_");
                                                                            }
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return true;
    }
}

