/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.devices.DecoderClass;

public class DecoderMastechMS8218
extends DecoderClass {
    @Override
    public void setupPacketFormat(CommDataInterface cdi) {
        cdi.setPacketFormat(CommDataInterface.PacketFormat.HeaderFixedLength, (byte)-128, (byte)-128, this.messageSize());
    }

    @Override
    public int messageSize() {
        return 8;
    }

    @Override
    public boolean decode(byte[] data) {
        if (data == null) {
            return false;
        }
        double val = 0.0;
        int i = 3;
        while (i < 8) {
            val = val * 10.0 + (double)(data[i] & 0xF);
            ++i;
        }
        int f = data[0] & 0xF;
        double scaleModifier = (new double[]{1.0E-4, 0.001, 0.01, 0.1, 1.0, 10.0, 100.0, 1000.0, 10000.0, 100000.0})[f];
        if ((data[1] & 0x20) != 0) {
            val = Double.POSITIVE_INFINITY;
        }
        switch (data[1] & 0x1F) {
            case 0: {
                this.mode = "VAC";
                break;
            }
            case 1: {
                this.mode = "dBm";
                scaleModifier *= 100.0;
                break;
            }
            case 2: {
                this.mode = "VDC";
                if ((data[2] & 0x20) == 0) break;
                val = -val;
                break;
            }
            case 3: {
                this.mode = "VACDC";
                break;
            }
            case 4: {
                this.mode = "VDC";
                scaleModifier /= 100.0;
                if ((data[2] & 0x20) == 0) break;
                val = -val;
                break;
            }
            case 5: {
                this.mode = "VAC";
                scaleModifier /= 100.0;
                break;
            }
            case 6: {
                this.mode = "VACDC";
                scaleModifier /= 100.0;
                break;
            }
            case 7: {
                this.mode = "Hz";
                scaleModifier *= 10.0;
                break;
            }
            case 8: {
                this.mode = "%";
                scaleModifier = 0.01;
                break;
            }
            case 9: {
                this.mode = "VDC";
                scaleModifier = 1.0E-4;
                if ((data[2] & 0x20) == 0) break;
                val = -val;
                break;
            }
            case 10: 
            case 11: {
                this.mode = "Ohm";
                scaleModifier *= 100.0;
                break;
            }
            case 12: {
                this.mode = "C";
                scaleModifier *= 1.0E-7;
                break;
            }
            case 13: {
                this.mode = "ADC";
                scaleModifier *= 1.0E-4;
                if ((data[2] & 0x20) == 0) break;
                val = -val;
                break;
            }
            case 14: {
                this.mode = "AAC";
                scaleModifier *= 1.0E-4;
                break;
            }
            case 15: {
                this.mode = "AACDC";
                break;
            }
            case 16: {
                this.mode = "ADC";
                scaleModifier *= 0.01;
                if ((data[2] & 0x20) == 0) break;
                val = -val;
                break;
            }
            case 17: {
                this.mode = "ADC";
                scaleModifier *= 0.01;
                break;
            }
            case 18: {
                this.mode = "AACDC";
                scaleModifier *= 0.01;
                break;
            }
            case 19: {
                this.mode = "ADC";
                if ((data[2] & 0x20) == 0) break;
                val = -val;
                break;
            }
            case 20: {
                this.mode = "AAC";
                val = Math.abs(val);
                break;
            }
            case 21: {
                this.mode = "AACDC";
            }
        }
        this.value = val * scaleModifier;
        return true;
    }
}

