/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.devices.DecoderClass;

public class DecoderGM1020
extends DecoderClass {
    private byte[] StatusCmd;
    private byte[] LiveStart;
    private byte[] LiveStop;

    DecoderGM1020() {
        byte[] byArray = new byte[8];
        byArray[0] = 30;
        byArray[7] = 30;
        this.StatusCmd = byArray;
        byte[] byArray2 = new byte[8];
        byArray2[0] = 60;
        byArray2[1] = 1;
        byArray2[7] = 61;
        this.LiveStart = byArray2;
        byte[] byArray3 = new byte[8];
        byArray3[0] = 60;
        byArray3[1] = 2;
        byArray3[7] = 62;
        this.LiveStop = byArray3;
        this.mode = "Lux";
    }

    @Override
    public void init(CommDataInterface cdi) {
        cdi.setPacketFormat(CommDataInterface.PacketFormat.FixedLength, this.messageSize());
        byte[] data = cdi.writeReadData(this.StatusCmd);
        if (data.length != 8) {
            throw new RuntimeException("Not GM1020 device");
        }
        cdi.setPacketFormat(CommDataInterface.PacketFormat.HeaderFixedLength, (byte)51, this.messageSize());
        cdi.writeData(this.LiveStart);
    }

    @Override
    public int messageSize() {
        return 8;
    }

    @Override
    public void deinit(CommDataInterface cdi) {
        cdi.writeData(this.LiveStop);
        CommInterface.sleep(10);
    }

    @Override
    public boolean decode(byte[] data) {
        this.value = Double.NaN;
        if (data == null || data.length != 8 || data[0] != 51) {
            return false;
        }
        double v = (double)((data[2] & 0x3F) << 8 | data[3]) / 10.0;
        if ((data[2] & 0x40) != 0) {
            v *= 10.0;
        } else if ((data[2] & 0x80) != 0) {
            v *= 100.0;
        } else if ((data[2] & 0xC0) != 0) {
            v *= 1000.0;
        }
        this.value = v;
        return true;
    }
}

