/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.devices.DecoderClass;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.Support;
import dk.hkj.script.Script;
import dk.hkj.util.StringUtil;
import dk.hkj.vars.Var;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DecoderDefinition
extends DecoderClass {
    private DecoderClass.SegmentDecoder sd = null;
    private ManageDeviceDefinitions.DeviceDefinition def = null;
    private int dataLength = 0;
    private byte prefix = 0;
    private byte prefixMask = (byte)-1;
    private int firstDigit = 0;
    private int nDigits = 0;
    private Map<Integer, PointDef> points = new HashMap<Integer, PointDef>();
    private Map<String, ModifyDef> modifiers = new HashMap<String, ModifyDef>();
    private String defaultRange = "";
    private List<RangeDef> ranges = new ArrayList<RangeDef>();
    private List<MultDef> mults = new ArrayList<MultDef>();
    private MatchList rangeAc = null;
    private MatchList rangeDc = null;
    private MatchList sign = null;
    private MatchList overload = null;
    private RangeDef addDigit = null;
    private MatchList modify1 = null;
    private MatchList modify2 = null;
    private Script script = null;

    DecoderDefinition(ManageDeviceDefinitions.DeviceDefinition def) {
        this.def = def;
        this.setupDecoder();
        this.setupDataFormat();
        this.setupValue();
        this.setupRanges();
        this.setupModifiers();
    }

    private void setupModifiers() {
        int k = -1;
        while (k < 1000) {
            String txt = this.def.getItem("#modify" + (k >= 0 ? " " + k : ""));
            if (txt == null) break;
            ModifyDef md = new ModifyDef(txt);
            this.modifiers.put(md.range, md);
            ++k;
        }
        this.modify1 = new MatchList(this.def.getItem("#modify1"));
        this.modify2 = new MatchList(this.def.getItem("#modify2"));
    }

    private void setupRanges() {
        String txt;
        int k = -1;
        while (k < 1000) {
            txt = this.def.getItem("#range" + (k >= 0 ? " " + k : ""));
            if (txt == null) break;
            RangeDef rd = new RangeDef(txt);
            if (rd.size() == 0) {
                this.defaultRange = rd.range;
            } else {
                this.ranges.add(rd);
            }
            ++k;
        }
        k = -1;
        while (k < 1000) {
            txt = this.def.getItem("#mult" + (k >= 0 ? " " + k : ""));
            if (txt == null) break;
            MultDef md = new MultDef(txt);
            this.mults.add(md);
            ++k;
        }
        this.addDigit = new RangeDef(this.def.getItem("#addDigit"));
        this.rangeAc = new MatchList(this.def.getItem("#rangeAC"));
        this.rangeDc = new MatchList(this.def.getItem("#rangeDC"));
        this.sign = new MatchList(this.def.getItem("#sign"));
        this.overload = new MatchList(this.def.getItem("#overload"));
    }

    private void setupValue() {
        String[] v = this.def.getItem("#digits").trim().split("[ ]+");
        this.firstDigit = StringUtil.parseInt(v[0]);
        this.nDigits = StringUtil.parseInt(v[1]);
        int k = -1;
        while (k < 1000) {
            String txt = this.def.getItem("#point" + (k >= 0 ? " " + k : ""));
            if (txt == null) break;
            PointDef pd = new PointDef(txt);
            this.points.put(pd.digit, pd);
            ++k;
        }
    }

    private void setupDataFormat() {
        String[] df = this.def.getItem("#dataFormat").trim().split("[ ]+");
        this.dataLength = StringUtil.parseInt(df[0]);
        if (df.length == 2) {
            this.prefix = (byte)StringUtil.parseInt(df[1]);
            this.prefixMask = (byte)-1;
        } else if (df.length == 3) {
            this.prefix = (byte)StringUtil.parseInt(df[1]);
            this.prefixMask = (byte)StringUtil.parseInt(df[2]);
        }
    }

    private void setupDecoder() {
        String segmentsString = this.def.getItem("#segments");
        if (segmentsString == null) {
            this.sd = new DecoderClass.AsciiSegmentDecoder(this);
            return;
        }
        String[] segments = segmentsString.trim().split("[ ]+");
        if (segments.length == 1) {
            this.sd = new DecoderClass.RegularSegmentDecoder(this, StringUtil.unQuote(segments[0]));
        } else {
            DecoderClass.InterleavedSegmentDecoder isd = new DecoderClass.InterleavedSegmentDecoder(this);
            this.sd = isd;
            int i = 0;
            while (i < segments.length / 2) {
                isd.addDigit(i + 1, StringUtil.parseInt(segments[i * 2]), StringUtil.unQuote(segments[i * 2 + 1]));
                ++i;
            }
        }
    }

    @Override
    public void setupPacketFormat(CommDataInterface cdi) {
        cdi.setPacketFormat(CommDataInterface.PacketFormat.HeaderFixedLength, this.prefix, this.prefixMask, this.messageSize());
    }

    @Override
    public int messageSize() {
        return this.dataLength;
    }

    @Override
    public boolean decode(byte[] data) {
        ModifyDef md;
        boolean negative;
        this.value = Double.NaN;
        if (data == null || data.length != this.messageSize()) {
            return false;
        }
        this.sd.setupData(data);
        double multFactor = 0.0;
        String m = this.defaultRange;
        double mult = 1.0;
        for (RangeDef rd : this.ranges) {
            if (!rd.match()) continue;
            m = rd.range;
            mult = rd.mult;
            break;
        }
        if (m.length() == 0 || m.equals("-")) {
            return false;
        }
        if (m.equalsIgnoreCase("V") || m.equalsIgnoreCase("A") || m.equalsIgnoreCase("W") || m.equalsIgnoreCase("Wh")) {
            if (this.rangeAc != null && this.rangeAc.match()) {
                m = String.valueOf(m) + "AC";
            }
            if (this.rangeDc != null && this.rangeDc.match()) {
                m = String.valueOf(m) + "DC";
            }
        }
        for (MultDef md2 : this.mults) {
            if (!md2.match()) continue;
            mult *= md2.mult;
            multFactor = md2.mult;
            break;
        }
        boolean bl = negative = this.sign != null && this.sign.match();
        if (m.equals("dB") && multFactor == 0.001) {
            mult = 1.0;
            m = String.valueOf(m) + "m";
        }
        if (m.equals("Hz") || m.equals("%")) {
            negative = false;
        }
        String number = "";
        if (this.nDigits > 0) {
            number = this.sd.getNumber(this.firstDigit, this.nDigits);
        } else if (this.nDigits < 0) {
            number = this.sd.getNumberReverse(this.firstDigit, -this.nDigits);
        }
        while (number != null && number.length() > 0 && Character.isAlphabetic(number.charAt(number.length() - 1))) {
            number = number.substring(0, number.length() - 1);
        }
        if (number == null || number.length() == 0) {
            this.value = negative ? Double.NEGATIVE_INFINITY : Double.POSITIVE_INFINITY;
            return true;
        }
        int i = number.length();
        while (i >= 1) {
            PointDef pd = this.points.get(i);
            if (pd != null && pd.match()) {
                number = String.valueOf(number.substring(0, i)) + '.' + number.substring(i);
            }
            --i;
        }
        if (this.addDigit != null && this.addDigit.match()) {
            number = String.valueOf(this.addDigit.range) + number;
        }
        number = number.trim();
        double v = Double.POSITIVE_INFINITY;
        if (DecoderClass.SegmentDecoder.isNumeric(number) && (this.overload == null || !this.overload.match())) {
            v = Double.parseDouble(number);
            v *= mult;
            if (negative) {
                v = -v;
            }
        }
        if (m.equals("TempF")) {
            v = (v - 32.0) * 5.0 / 9.0;
        }
        if ((md = this.modifiers.get(m)) != null) {
            v = md.process(v, mult);
        }
        if (Support.devlop) {
            System.out.println("Mode: " + m + "  sign: " + (negative ? "-" : "+") + "  number: " + number + "  mult: " + mult + "  -> " + StringUtil.formatDoubleEE(v) + "   " + StringUtil.hexN(data));
        }
        this.mode = m;
        this.value = v;
        return true;
    }

    private class FailedFormat
    extends RuntimeException {
        public FailedFormat(String msg, String data) {
            super("Invalid format, " + msg + "  <" + data + ">");
        }
    }

    private class Match {
        MatchType mt = MatchType.Bits;
        int byteOfs = 0;
        String mask = "";
        boolean not = false;
        boolean and = false;

        public boolean match(boolean oldValue) {
            try {
                boolean m = false;
                switch (this.mt) {
                    case Bits: {
                        m = DecoderDefinition.this.sd.match(this.byteOfs, this.mask);
                        break;
                    }
                    case Segments: {
                        m = DecoderDefinition.this.sd.matchSegments(this.byteOfs, this.mask);
                        break;
                    }
                    case Char: {
                        m = DecoderDefinition.this.sd.matchDigit(this.byteOfs, this.mask.charAt(0));
                        break;
                    }
                    case Value: {
                        m = DecoderDefinition.this.sd.matchValue(this.byteOfs, StringUtil.parseInt(this.mask));
                    }
                }
                if (this.not) {
                    boolean bl = m = !m;
                }
                if (this.and) {
                    return oldValue & m;
                }
                return oldValue | m;
            }
            catch (Exception e) {
                System.out.println("Match specification: " + this.toString());
                throw e;
            }
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.and ? (char)'&' : '|');
            sb.append(' ');
            if (this.not) {
                sb.append('!');
            }
            switch (this.mt) {
                case Bits: {
                    sb.append('b');
                    break;
                }
                case Segments: {
                    sb.append('s');
                    break;
                }
                case Char: {
                    sb.append('c');
                    break;
                }
                case Value: {
                    sb.append('v');
                }
            }
            sb.append('(');
            sb.append(this.byteOfs);
            sb.append(',');
            sb.append("\"" + this.mask + "\") ");
            return sb.toString();
        }
    }

    private class MatchList {
        List<Match> list = new ArrayList<Match>();

        MatchList(String setting) {
            if (setting == null) {
                return;
            }
            this.parse(setting.trim());
        }

        MatchList() {
        }

        public int size() {
            return this.list.size();
        }

        public String parseEntry(String setting) {
            int i = 0;
            while (setting.charAt(i) == ' ') {
                ++i;
            }
            int j = i;
            while (j < setting.length() && setting.charAt(j) != ' ') {
                ++j;
            }
            if (setting.substring(j).trim().length() > 0) {
                this.parse(setting.substring(j));
            }
            return setting.substring(i, j);
        }

        public void parse(String setting) {
            try {
                int i = 0;
                do {
                    char c;
                    Match m = new Match();
                    while ((c = setting.charAt(i)) == ' ') {
                        ++i;
                    }
                    if (c == '&' || c == '|') {
                        m.and = c == '&';
                        ++i;
                        while ((c = setting.charAt(i)) == ' ') {
                            ++i;
                        }
                    }
                    if (c == '!') {
                        m.not = true;
                        ++i;
                        while ((c = setting.charAt(i)) == ' ') {
                            ++i;
                        }
                    }
                    if (c == 'b' || c == 'B') {
                        m.mt = MatchType.Bits;
                    } else if (c == 's' || c == 'S') {
                        m.mt = MatchType.Segments;
                        ++i;
                    } else if (c == 'c' || c == 'c') {
                        m.mt = MatchType.Char;
                        ++i;
                    } else if (c == 'v' || c == 'V') {
                        m.mt = MatchType.Value;
                        ++i;
                    } else {
                        throw new FailedFormat("expected b, s, c or v", setting);
                    }
                    int n = ++i;
                    ++i;
                    if (setting.charAt(n) != '(') {
                        throw new FailedFormat("expected (", setting);
                    }
                    String s = "";
                    while ((c = setting.charAt(i)) != ',') {
                        s = String.valueOf(s) + c;
                        ++i;
                    }
                    m.byteOfs = StringUtil.parseInt(s.trim());
                    ++i;
                    while ((c = setting.charAt(i)) == ' ') {
                        ++i;
                    }
                    s = "";
                    if (c == '\"') {
                        ++i;
                    }
                    while ((c = setting.charAt(i)) != ')' && c != '\"') {
                        s = String.valueOf(s) + c;
                        ++i;
                    }
                    while ((c = setting.charAt(i)) != ')') {
                        ++i;
                    }
                    ++i;
                    m.mask = s;
                    if (m.mt == MatchType.Bits && s.length() != 8) {
                        throw new FailedFormat("Length must be 8 chars <" + s + ">", setting);
                    }
                    if (m.mt == MatchType.Segments && (s.length() == 0 || s.length() > 7)) {
                        throw new FailedFormat("Length must be 1 to 7 chars <" + s + ">", setting);
                    }
                    if (m.mt == MatchType.Char && s.length() != 1) {
                        throw new FailedFormat("Length must be 1 char <" + s + ">", setting);
                    }
                    if (m.mt == MatchType.Value && !StringUtil.isInt(s)) {
                        throw new FailedFormat("Must be integer number <" + s + ">", setting);
                    }
                    this.list.add(m);
                    while (i < setting.length() && (setting.charAt(i) == ' ' || setting.charAt(i) == ';')) {
                        ++i;
                    }
                } while (i < setting.length());
            }
            catch (Exception e) {
                throw new FailedFormat(e.getMessage(), setting);
            }
        }

        public boolean match() {
            boolean isMatch = false;
            for (Match m : this.list) {
                isMatch = m.match(isMatch);
            }
            return isMatch;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("Match: ");
            for (Match m : this.list) {
                sb.append(m.toString());
            }
            return sb.toString();
        }
    }

    private static enum MatchType {
        Bits,
        Segments,
        Char,
        Value;

    }

    private class ModifyDef {
        String range = "";
        String expression = "";

        ModifyDef(String specification) {
            specification = specification.trim();
            int i = specification.indexOf(32);
            this.range = specification.substring(0, i);
            this.expression = specification.substring(i + 1);
            if (DecoderDefinition.this.script == null) {
                DecoderDefinition.this.script = new Script();
            }
        }

        double process(double value, double mult) {
            DecoderDefinition.this.script.addLocalVar("value", Var.createValue(value));
            DecoderDefinition.this.script.addLocalVar("mult", Var.createValue(mult));
            if (DecoderDefinition.this.modify1 != null && ((DecoderDefinition)DecoderDefinition.this).modify1.list.size() > 0) {
                DecoderDefinition.this.script.addLocalVar("modify1", Var.createValue(DecoderDefinition.this.modify1.match()));
            }
            if (DecoderDefinition.this.modify2 != null && ((DecoderDefinition)DecoderDefinition.this).modify2.list.size() > 0) {
                DecoderDefinition.this.script.addLocalVar("modify2", Var.createValue(DecoderDefinition.this.modify2.match()));
            }
            return DecoderDefinition.this.script.execute(this.expression).asDouble();
        }
    }

    private class MultDef {
        double mult = 1.0;
        MatchList list;

        public MultDef(String specification) {
            this.list = new MatchList();
            String m = this.list.parseEntry(specification);
            if (m.equals("T")) {
                this.mult = 1.0E12;
            } else if (m.equals("G")) {
                this.mult = 1.0E9;
            } else if (m.equals("M")) {
                this.mult = 1000000.0;
            } else if (m.equals("k")) {
                this.mult = 1000.0;
            } else if (m.equals("m")) {
                this.mult = 0.001;
            } else if (m.equals("u")) {
                this.mult = 1.0E-6;
            } else if (m.equals("n")) {
                this.mult = 1.0E-9;
            } else if (m.equals("p")) {
                this.mult = 1.0E-12;
            } else {
                this.mult = StringUtil.parseDoubleEE(m);
                if (Double.isNaN(this.mult)) {
                    throw new FailedFormat("Not a SI prefix or number <" + m + ">", specification);
                }
            }
        }

        public String toString() {
            return " *" + this.mult + " " + this.list.toString();
        }

        public boolean match() {
            return this.list.match();
        }
    }

    private class PointDef {
        int digit = 0;
        MatchList list;

        public PointDef(String specification) {
            this.list = new MatchList();
            this.digit = StringUtil.parseInt(this.list.parseEntry(specification));
        }

        public String toString() {
            return this.digit + " " + this.list.toString();
        }

        public boolean match() {
            return this.list.match();
        }
    }

    private class RangeDef {
        String range = "";
        double mult = 1.0;
        MatchList list;

        public int size() {
            return this.list.size();
        }

        public RangeDef(String specification) {
            this.list = new MatchList();
            if (specification == null) {
                return;
            }
            int i = 0;
            while (specification.charAt(i) == ' ') {
                ++i;
            }
            int j = i;
            while (j < specification.length() && specification.charAt(j) != ' ') {
                ++j;
            }
            this.range = specification.substring(i, j);
            while (j < specification.length() && specification.charAt(j) == ' ') {
                ++j;
            }
            if (j < specification.length() && (specification.charAt(j) == '/' || specification.charAt(j) == '*')) {
                char c = specification.charAt(j);
                i = ++j;
                while (j < specification.length() && specification.charAt(j) != ' ') {
                    ++j;
                }
                this.mult = StringUtil.parseDoubleEE(specification.substring(i, j));
                if (c == '/') {
                    this.mult = 1.0 / this.mult;
                }
            }
            while (j < specification.length() && specification.charAt(j) == ' ') {
                ++j;
            }
            if (specification.substring(j).trim().length() > 0) {
                this.list.parse(specification.substring(j));
            }
        }

        public String toString() {
            if (this.mult != 1.0) {
                return String.valueOf(this.range) + " *" + StringUtil.formatDoubleEE(this.mult) + " " + this.list.toString();
            }
            return String.valueOf(this.range) + " *" + this.mult + " " + this.list.toString();
        }

        public boolean match() {
            return this.list.match();
        }
    }
}

