/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class DecoderClass {
    protected String mode = "";
    protected double value = Double.NaN;

    public abstract boolean decode(byte[] var1);

    public double getValue() {
        return this.value;
    }

    public String getMode() {
        return this.mode;
    }

    public abstract int messageSize();

    public void setupPacketFormat(CommDataInterface cdi) {
    }

    public void init(CommDataInterface cdi) {
    }

    public void deinit(CommDataInterface cdi) {
        ((CommInterface)((Object)cdi)).close();
    }

    public int prefix() {
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.value);
        sb.append("  ");
        sb.append(this.mode);
        return sb.toString();
    }

    public boolean usePoll() {
        return false;
    }

    public void poll(CommDataInterface cdi) {
    }

    protected class AsciiSegmentDecoder
    extends SegmentDecoder {
        private RegularSegmentDecoder rsd;

        protected AsciiSegmentDecoder() {
            this.rsd = new RegularSegmentDecoder();
        }

        @Override
        public void setupData(byte[] data) {
            this.rsd.setupData(data);
        }

        @Override
        public String getNumber(int from, int length) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < length) {
                sb.append((char)this.rsd.data[i + from]);
                ++i;
            }
            return sb.toString();
        }

        @Override
        public String getNumberReverse(int from, int length) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < length) {
                sb.insert(0, (char)this.rsd.data[i + from]);
                ++i;
            }
            return sb.toString();
        }

        @Override
        public boolean match(int byteOfs, String mask) {
            return this.rsd.match(byteOfs, mask);
        }

        @Override
        public boolean matchSegments(int byteOfs, String segments) {
            return false;
        }

        @Override
        public boolean matchDigit(int byteOfs, char digit) {
            return this.rsd.data[byteOfs] == digit;
        }

        @Override
        public boolean matchValue(int byteOfs, int value) {
            return this.rsd.matchValue(byteOfs, value);
        }
    }

    protected class BCDSegmentDecoder
    extends SegmentDecoder {
        private String format;
        private int defaultByteOfs;

        public BCDSegmentDecoder(int byteOfs, String format) {
            this.format = format;
            this.defaultByteOfs = byteOfs;
        }

        public char getDigit(int digitNo) {
            char c = ' ';
            char digitNoChar = (char)(48 + digitNo);
            int formatIndex = this.format.indexOf(digitNoChar);
            if (formatIndex < 0) {
                return ' ';
            }
            int ofs = this.defaultByteOfs + formatIndex / 8;
            int bit = 7 - formatIndex % 8;
            int v = 0;
            while (formatIndex < this.format.length() && this.format.charAt(formatIndex) == digitNoChar) {
                v = v << 1 | this.data[ofs] >> bit & 1;
                ++formatIndex;
                if (--bit >= 0) continue;
                bit = 7;
                ++ofs;
            }
            c = (char)(v < 10 ? v + 48 : v + 65);
            return c;
        }

        @Override
        public String getNumber(int from, int length) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < length) {
                sb.append(this.getDigit(from + i));
                ++i;
            }
            return sb.toString();
        }

        @Override
        public String getNumberReverse(int from, int length) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < length) {
                sb.insert(0, this.getDigit(from + i));
                ++i;
            }
            return sb.toString();
        }

        @Override
        public boolean matchSegments(int byteOfs, String segments) {
            return false;
        }

        @Override
        public boolean matchDigit(int digitNo, char digit) {
            return this.getDigit(digitNo) == digit;
        }
    }

    private class FixedSegmentDecoder
    extends RegularSegmentDecoder {
        protected int defaultByteOfs;

        public FixedSegmentDecoder(int byteOfs, String segments) {
            super(segments);
            this.defaultByteOfs = byteOfs;
        }

        public boolean matchSegments(String segments) {
            return super.matchSegments(this.defaultByteOfs, segments);
        }

        public char getDigit() {
            return super.getDigit(this.defaultByteOfs);
        }
    }

    protected class InterleavedSegmentDecoder
    extends SegmentDecoder {
        private Map<Integer, FixedSegmentDecoder> digits = new HashMap<Integer, FixedSegmentDecoder>();
        private FixedSegmentDecoder rsd = null;

        public void addDigit(int digit, int byteOfs, String segments) {
            this.rsd = new FixedSegmentDecoder(byteOfs, segments);
            this.digits.put(digit, this.rsd);
        }

        @Override
        public String getNumber(int from, int length) {
            StringBuilder n = new StringBuilder();
            int i = 0;
            while (i < length) {
                n.append(this.digits.get(i + from).getDigit());
                ++i;
            }
            return n.toString();
        }

        @Override
        public String getNumberReverse(int from, int length) {
            StringBuilder n = new StringBuilder();
            int i = 0;
            while (i < length) {
                n.insert(0, this.digits.get(i + from).getDigit());
                ++i;
            }
            return n.toString();
        }

        @Override
        public boolean match(int byteOfs, String mask) {
            return this.rsd.match(byteOfs, mask);
        }

        @Override
        public boolean matchValue(int byteOfs, int value) {
            return this.rsd.matchValue(byteOfs, value);
        }

        @Override
        public boolean matchSegments(int byteOfs, String segments) {
            return this.digits.get(byteOfs).matchSegments(segments);
        }

        @Override
        public boolean matchDigit(int byteOfs, char digit) {
            for (FixedSegmentDecoder fsd : this.digits.values()) {
                if (fsd.defaultByteOfs != byteOfs) continue;
                return fsd.getDigit() == digit;
            }
            return false;
        }

        @Override
        public void setupData(byte[] data) {
            for (RegularSegmentDecoder regularSegmentDecoder : this.digits.values()) {
                regularSegmentDecoder.setupData(data);
            }
        }
    }

    protected class RegularSegmentDecoder
    extends SegmentDecoder {
        List<Digit> digits = new ArrayList<Digit>();
        private String segments = "";
        private long mask;
        private int segmentBytes = 1;

        public RegularSegmentDecoder() {
            this.segmentBytes = 0;
        }

        public RegularSegmentDecoder(String segments) {
            this.segmentBytes = (segments.length() + 7) / 8;
            if (this.segmentBytes > 8) {
                this.segmentBytes = 8;
            }
            this.segments = segments.toLowerCase();
            this.generateMask();
            this.digits.add(new Digit('0', "abcdef"));
            this.digits.add(new Digit('1', "bc"));
            this.digits.add(new Digit('2', "abged"));
            this.digits.add(new Digit('3', "abcdg"));
            this.digits.add(new Digit('4', "fgbc"));
            this.digits.add(new Digit('5', "afgcd"));
            this.digits.add(new Digit('6', "afedcg"));
            this.digits.add(new Digit('6', "fedcg"));
            this.digits.add(new Digit('7', "abc"));
            this.digits.add(new Digit('8', "abcdefg"));
            this.digits.add(new Digit('9', "abcdfg"));
            this.digits.add(new Digit('9', "abcfg"));
            this.digits.add(new Digit('L', "fed"));
            this.digits.add(new Digit('E', "agdfe"));
            this.digits.add(new Digit('F', "agfe"));
            this.digits.add(new Digit('C', "adef"));
            this.digits.add(new Digit('r', "eg"));
            this.digits.add(new Digit('-', "g"));
        }

        private void generateMask() {
            this.mask = 0L;
            String maskSegments = "abcdefg";
            byte[] byArray = maskSegments.getBytes();
            int n = byArray.length;
            int n2 = 0;
            while (n2 < n) {
                byte c = byArray[n2];
                int j = this.segments.indexOf((char)c);
                this.mask |= (long)(1 << this.segmentBytes * 8 - j - 1);
                ++n2;
            }
        }

        protected String listDigits() {
            StringBuilder sb = new StringBuilder();
            for (Digit d : this.digits) {
                sb.append(d.toString());
                sb.append(" ");
            }
            sb.append("  mask:");
            sb.append(StringUtil.hex(this.segmentBytes, this.mask));
            return sb.toString();
        }

        private long getDigitSegments(int byteOfs) {
            long value = 0L;
            int i = 0;
            while (i < Math.min(this.segmentBytes, this.data.length - byteOfs)) {
                value = value << 8 | (long)this.data[i + byteOfs] & 0xFFL;
                ++i;
            }
            return value &= this.mask;
        }

        public char getDigit(int byteOfs) {
            long value = this.getDigitSegments(byteOfs);
            for (Digit d : this.digits) {
                if (value != d.segments) continue;
                return d.digit;
            }
            return ' ';
        }

        @Override
        public String getNumber(int from, int length) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < length * this.segmentBytes) {
                sb.append(this.getDigit(i + from));
                i += this.segmentBytes;
            }
            return sb.toString();
        }

        @Override
        public String getNumberReverse(int from, int length) {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < length * this.segmentBytes) {
                sb.insert(0, this.getDigit(i + from));
                i += this.segmentBytes;
            }
            return sb.toString();
        }

        @Override
        public boolean matchSegments(int byteOfs, String segments) {
            Digit d = new Digit('x', segments);
            long displaySegments = this.getDigitSegments(byteOfs);
            return d.segments == displaySegments;
        }

        @Override
        public boolean matchDigit(int byteOfs, char digit) {
            long displaySegments = this.getDigitSegments(byteOfs);
            for (Digit d : this.digits) {
                if (d.digit != digit || d.segments != displaySegments) continue;
                return true;
            }
            return false;
        }

        class Digit {
            long segments;
            char digit;

            public Digit(char digit, String digitSegments) {
                this.digit = digit;
                digitSegments = digitSegments.toLowerCase();
                int i = 0;
                while (i < digitSegments.length()) {
                    int j = RegularSegmentDecoder.this.segments.indexOf(digitSegments.charAt(i));
                    this.segments |= (long)(1 << RegularSegmentDecoder.this.segmentBytes * 8 - j - 1);
                    ++i;
                }
                this.segments &= RegularSegmentDecoder.this.mask;
            }

            public String toString() {
                return String.valueOf(this.digit) + ":" + StringUtil.hex(RegularSegmentDecoder.this.segmentBytes, this.segments);
            }
        }
    }

    protected static abstract class SegmentDecoder {
        protected byte[] data;

        protected SegmentDecoder() {
        }

        public void setupData(byte[] data) {
            this.data = data;
        }

        public abstract String getNumber(int var1, int var2);

        public abstract String getNumberReverse(int var1, int var2);

        public boolean match(int byteOfs, String mask) {
            int i = 0;
            while (i < 8) {
                switch (mask.charAt(i)) {
                    case '0': {
                        if ((this.data[byteOfs] & 1 << 7 - i) == 0) break;
                        return false;
                    }
                    case '1': {
                        if ((this.data[byteOfs] & 1 << 7 - i) != 0) break;
                        return false;
                    }
                }
                ++i;
            }
            return true;
        }

        public boolean matchValue(int byteOfs, int value) {
            return this.data[byteOfs] == (byte)value;
        }

        public abstract boolean matchSegments(int var1, String var2);

        public abstract boolean matchDigit(int var1, char var2);

        public static boolean isNumeric(String s) {
            int p = 0;
            int d = 0;
            int o = 0;
            int i = 0;
            while (i < s.length()) {
                char c = s.charAt(i);
                if (c >= '0' && c <= '9') {
                    ++d;
                } else if (c == '.') {
                    ++p;
                } else {
                    ++o;
                }
                ++i;
            }
            return d > 0 && p <= 1 && o == 0;
        }

        public String checkPoint(int digit, int byteOfs, String mask, String number) {
            if (this.match(byteOfs, mask)) {
                return String.valueOf(number.substring(0, digit)) + '.' + number.substring(digit);
            }
            return number;
        }
    }
}

