/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.devices.DecoderClass;

public class DecoderCEMDT1309
extends DecoderClass {
    DecoderClass.BCDSegmentDecoder sd = new DecoderClass.BCDSegmentDecoder(this, 3, "1111222233334444");

    @Override
    public void setupPacketFormat(CommDataInterface cdi) {
        cdi.setPacketFormat(CommDataInterface.PacketFormat.HeaderFixedLength, (byte)-50, this.messageSize());
        new PollingThread(cdi).start();
    }

    @Override
    public void init(CommDataInterface cdi) {
        new PollingThread(cdi).start();
    }

    @Override
    public int messageSize() {
        return 5;
    }

    @Override
    public boolean decode(byte[] data) {
        if (data == null || data.length != this.messageSize()) {
            return false;
        }
        this.mode = "Lux";
        this.sd.setupData(data);
        int i = 1;
        while (i < 5) {
            if (this.sd.getDigit(i) > '9') {
                return false;
            }
            ++i;
        }
        String number = this.sd.getNumber(1, 4);
        number = this.sd.checkPoint(3, 1, "......01", number);
        number = this.sd.checkPoint(2, 1, "......10", number);
        boolean fc = this.sd.match(2, ".....1..");
        boolean overload = this.sd.match(2, "...1....");
        double v = Double.POSITIVE_INFINITY;
        if (!overload && DecoderClass.SegmentDecoder.isNumeric(number)) {
            v = Double.parseDouble(number);
        }
        if (this.sd.match(2, "....1...")) {
            v *= 1000.0;
        }
        if (fc) {
            v /= 0.0929030436;
        }
        this.value = v;
        return true;
    }

    private class PollingThread
    extends Thread {
        private CommDataInterface cdi = null;

        PollingThread(CommDataInterface cdi) {
            this.cdi = cdi;
            this.setDaemon(true);
            this.setName("CEM DT-1309 polling");
        }

        @Override
        public void run() {
            try {
                CommInterface.sleep(50);
                while (((CommInterface)((Object)this.cdi)).isOpen()) {
                    this.cdi.writeData(new byte[1]);
                    CommInterface.sleep(50);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

