/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.CommInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.devices.DecoderClass;

public class DecoderBrymenBM350
extends DecoderClass {
    private DecoderClass.RegularSegmentDecoder sd = new DecoderClass.RegularSegmentDecoder(this, "dcgb.efa");
    private long lastActive = 0L;

    @Override
    public void setupPacketFormat(CommDataInterface cdi) {
        cdi.setPacketFormat(CommDataInterface.PacketFormat.HeaderFixedLength, (byte)0, (byte)0, this.messageSize());
    }

    @Override
    public int messageSize() {
        return 20;
    }

    @Override
    public boolean usePoll() {
        return true;
    }

    @Override
    public void poll(CommDataInterface cdi) {
        if (cdi instanceof SerialInterface) {
            long t = System.currentTimeMillis();
            if (t - this.lastActive < 300L) {
                return;
            }
            SerialInterface si = (SerialInterface)((Object)cdi);
            si.flush();
            si.setRTS(false);
            CommInterface.sleep(1);
            si.setRTS(true);
            this.lastActive = t;
        }
    }

    @Override
    public boolean decode(byte[] data) {
        this.value = Double.NaN;
        if (data == null || data.length != this.messageSize()) {
            return false;
        }
        this.sd.setupData(data);
        String m = "";
        m = "V";
        double v = 1.0;
        String number = this.sd.getNumber(4, 4);
        number = this.sd.checkPoint(3, 7, "xxxx1xxx", number);
        number = this.sd.checkPoint(2, 6, "xxxx1xxx", number);
        number = this.sd.checkPoint(1, 5, "xxxx1xxx", number);
        if (number.charAt(3) == 'E') {
            switch (number.charAt(4)) {
                case '1': {
                    v = 10.0;
                    break;
                }
                case '2': {
                    v = 100.0;
                    break;
                }
                case '3': {
                    v = 1000.0;
                    break;
                }
                case '4': {
                    v = 10000.0;
                    break;
                }
                case '5': {
                    v = 100000.0;
                    break;
                }
                case '6': {
                    v = 1000000.0;
                    break;
                }
                case '7': {
                    v = 1.0E7;
                    break;
                }
                case '8': {
                    v = 1.0E8;
                    break;
                }
                case '9': {
                    v = 1.0E9;
                }
            }
            number = number.substring(0, 2);
        }
        v = DecoderClass.SegmentDecoder.isNumeric(number = number.trim()) ? (v *= Double.parseDouble(number)) : Double.POSITIVE_INFINITY;
        if (this.sd.match(9, "1xxxxxx0")) {
            m = "W";
        }
        if (this.sd.match(9, "xxx1xxx0")) {
            m = "Ohm";
        }
        if (this.sd.match(9, "xxxx0010")) {
            m = "V";
        }
        if (this.sd.match(9, "xxxx0100")) {
            m = "A";
        }
        if (this.sd.match(9, "xxxxx110")) {
            m = "VA";
        }
        if (this.sd.match(9, "xx100000")) {
            m = "Hz";
        }
        if (this.sd.match(9, "xxxx1110")) {
            m = "VAR";
        }
        if (this.sd.match(9, "1xxx0001")) {
            m = "Wh";
        }
        if (this.sd.match(3, "xxx1xxxx") || this.sd.match(3, "xx1xxxxx")) {
            m = String.valueOf(m) + "AC";
        }
        if (this.sd.matchSegments(1, "bcdg") && this.sd.matchSegments(2, "deg")) {
            m = String.valueOf(m) + "DC";
        }
        if (this.sd.match(8, "1xxxxxxx")) {
            v *= 1000.0;
        }
        if (this.sd.match(4, "xxxx1xxx")) {
            v = -v;
        }
        this.mode = m;
        this.value = v;
        return true;
    }
}

