/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.devices.DecoderClass;

public class DecoderBrymenBM250
extends DecoderClass {
    private DecoderClass.RegularSegmentDecoder sd = new DecoderClass.RegularSegmentDecoder(this, "....afe.....bgcd");

    @Override
    public void setupPacketFormat(CommDataInterface cdi) {
        cdi.setPacketFormat(CommDataInterface.PacketFormat.HeaderFixedLength, (byte)2, this.messageSize());
    }

    @Override
    public int messageSize() {
        return 15;
    }

    @Override
    public boolean decode(byte[] data) {
        double v;
        this.value = Double.NaN;
        if (data == null || data.length != this.messageSize()) {
            return false;
        }
        this.sd.setupData(data);
        if (this.sd.match(14, "xxxxx11x") || !this.sd.match(14, "1110xxxx")) {
            return false;
        }
        String m = "";
        String number = this.sd.getNumber(3, 4);
        number = this.sd.checkPoint(3, 9, "xxxxxxx1", number);
        number = this.sd.checkPoint(2, 7, "xxxxxxx1", number);
        number = this.sd.checkPoint(1, 5, "xxxxxxx1", number);
        if ((number = number.trim()).endsWith("C")) {
            m = "TempC";
            v = (number = number.substring(0, number.length() - 1)).equals("---") ? Double.POSITIVE_INFINITY : Double.parseDouble(number);
        } else if (number.endsWith("F")) {
            m = "TempF";
            v = (number = number.substring(0, number.length() - 1)).equals("---") ? Double.POSITIVE_INFINITY : Double.parseDouble(number);
            v = (v - 32.0) * 5.0 / 9.0;
        } else {
            v = DecoderClass.SegmentDecoder.isNumeric(number) ? Double.parseDouble(number) : Double.POSITIVE_INFINITY;
        }
        if (this.sd.match(3, "xxxxxxx1")) {
            v = -v;
        }
        if (this.sd.match(11, "xxxxxx1x")) {
            v *= 1000000.0;
        } else if (this.sd.match(11, "xxxxxxx1")) {
            v *= 1000.0;
        } else if (this.sd.match(13, "xxxxxxx1")) {
            v *= 0.001;
        } else if (this.sd.match(13, "xxxxxx1x")) {
            v *= 1.0E-6;
        } else if (this.sd.match(12, "xxxxxxx1")) {
            v *= 1.0E-9;
        }
        if (this.sd.match(11, "xxxxx1xx")) {
            m = "dBm";
        }
        if (this.sd.match(12, "xxxxxx1x")) {
            m = "Hz";
        }
        if (this.sd.match(12, "xxxxx1xx")) {
            m = "Ohm";
        }
        if (this.sd.match(13, "xxxxx1xx")) {
            m = "F";
        }
        if (this.sd.match(14, "xxxxx1xx")) {
            m = "V";
        }
        if (this.sd.match(14, "xxxxxx1x")) {
            m = "A";
        }
        if (this.sd.match(1, "xxxxxx1x")) {
            m = String.valueOf(m) + "AC";
        }
        if (this.sd.match(1, "xxxxx1xx")) {
            m = String.valueOf(m) + "DC";
        }
        this.mode = m;
        this.value = v;
        return true;
    }
}

