/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.devices.DecoderClass;

public class DecoderBrymenBM190
extends DecoderClass {
    private DecoderClass.RegularSegmentDecoder sd = new DecoderClass.RegularSegmentDecoder(".....fe......cda......bg");

    @Override
    public void setupPacketFormat(CommDataInterface cdi) {
        cdi.setPacketFormat(CommDataInterface.PacketFormat.HeaderFixedLength, (byte)1, this.messageSize());
    }

    @Override
    public int messageSize() {
        return 31;
    }

    @Override
    public boolean decode(byte[] data) {
        this.value = Double.NaN;
        if (data == null || data.length != this.messageSize()) {
            return false;
        }
        this.sd.setupData(data);
        String m = "";
        String number = this.sd.getNumber(1, 4);
        number = this.sd.checkPoint(3, 10, "xxxxxxx1", number);
        number = this.sd.checkPoint(2, 7, "xxxxxxx1", number);
        number = this.sd.checkPoint(1, 4, "xxxxxxx1", number);
        number = number.trim();
        double v = DecoderClass.SegmentDecoder.isNumeric(number) ? Double.parseDouble(number) : Double.POSITIVE_INFINITY;
        if (this.sd.match(1, "xxxxxxx1")) {
            v = -v;
        }
        if (this.sd.matchSegments(16, "adef")) {
            m = "TempC";
        }
        if (this.sd.matchSegments(16, "aefg")) {
            if (this.sd.matchSegments(19, "")) {
                m = "TempF";
                v = (v - 32.0) * 5.0 / 9.0;
            } else if (this.sd.matchSegments(19, "ceg")) {
                m = "F";
                v *= 1.0E-9;
            } else if (this.sd.matchSegments(19, "cde")) {
                m = "F";
                v *= 1.0E-6;
            }
        }
        if (this.sd.match(13, "xxxxxxx1")) {
            v *= 1000000.0;
        }
        if (this.sd.match(15, "xxxxxx1x")) {
            v *= 1000.0;
        }
        if (this.sd.match(13, "xxxxx1xx")) {
            m = "Hz";
        }
        if (this.sd.match(14, "xxxxx1xx")) {
            m = "Ohm";
        }
        if (this.sd.match(14, "xxxxxx1x")) {
            m = "V";
        }
        if (this.sd.match(15, "xxxxxxx1")) {
            m = "A";
        }
        if (this.sd.match(28, "xxxxxxx1")) {
            m = "V";
        }
        if (this.sd.match(29, "xxxxxx1x")) {
            m = String.valueOf(m) + "AC";
        }
        if (this.sd.match(29, "xxxxx1xx")) {
            m = String.valueOf(m) + "DC";
        }
        this.mode = m;
        this.value = v;
        return true;
    }
}

