/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.devices.DecoderClass;
import dk.hkj.util.ByteBuffer;

public class DecoderBrymen869
extends DecoderClass {
    private DecoderClass.RegularSegmentDecoder sd = new DecoderClass.RegularSegmentDecoder(this, "bgcdafe.");
    private boolean serial = false;

    DecoderBrymen869() {
    }

    DecoderBrymen869(boolean serial) {
        this.serial = serial;
    }

    @Override
    public void init(CommDataInterface cdi) {
        if (this.serial) {
            cdi.setPacketFormat(CommDataInterface.PacketFormat.FixedLengthTimeout, 20);
        }
    }

    @Override
    public int messageSize() {
        return this.serial ? 20 : 27;
    }

    @Override
    public boolean decode(byte[] data) {
        this.value = Double.NaN;
        if (data == null || data.length == 0) {
            return false;
        }
        if (this.serial && data.length == 20) {
            ByteBuffer bf = new ByteBuffer();
            bf.append((byte)0);
            bf.append((byte)0);
            bf.append(data);
            bf.insert(9, (byte)0);
            bf.insert(18, (byte)0);
            bf.insert(22, (byte)-122);
            bf.append((byte)0);
            bf.append((byte)0);
            data = bf.getAsArray();
        }
        if (data.length != 27 || data[22] != -122) {
            return false;
        }
        if (data[0] != 0 || data[9] != 0 || data[18] != 0) {
            return false;
        }
        this.sd.setupData(data);
        String m = "";
        if (this.sd.match(3, "xxxx1xxx")) {
            m = "T2";
        }
        if (this.sd.match(3, "xxxxxx1x")) {
            m = "T1";
        }
        if (this.sd.match(3, "xxxx111x")) {
            m = "T2-T1";
        }
        if (m.isEmpty() && this.sd.matchDigit(10, 'C')) {
            m = "T1";
        }
        if (this.sd.match(10, "xxxxxxx1")) {
            m = "V";
        }
        if (this.sd.match(16, "1xxxxxxx")) {
            m = "A";
        }
        if (this.sd.match(17, "xxxxx11x")) {
            m = "dBm";
        }
        if (this.sd.match(3, "xxxxxxx1")) {
            m = String.valueOf(m) + "AC";
        }
        if (this.sd.match(2, "xxx1xxxx")) {
            m = String.valueOf(m) + "DC";
        }
        if (m.isEmpty()) {
            if (this.sd.match(16, "xx1xxxxx")) {
                m = "F";
            }
            if (this.sd.match(17, "xxxxxxx1")) {
                m = "Hz";
            }
            if (this.sd.match(16, "x1x1xxxx")) {
                m = "Siemens";
            }
            if (this.sd.match(17, "1xxxxxxx")) {
                m = "DutyCycle";
            }
            if (this.sd.match(17, "xxx1xxxx")) {
                m = "ohm";
            }
        }
        String number = this.sd.getNumber(4, 5);
        if (this.sd.match(8, "xxxxxxx1")) {
            number = String.valueOf(number.substring(0, 4)) + '.' + number.substring(4);
        }
        if (this.sd.match(7, "xxxxxxx1")) {
            number = String.valueOf(number.substring(0, 3)) + '.' + number.substring(3);
        }
        if (this.sd.match(6, "xxxxxxx1")) {
            number = String.valueOf(number.substring(0, 2)) + '.' + number.substring(2);
        }
        if (this.sd.match(5, "xxxxxxx1")) {
            number = String.valueOf(number.substring(0, 1)) + '.' + number.substring(1);
        }
        if (m.equals("VDC")) {
            number = String.valueOf(number) + this.sd.getDigit(10);
        }
        number = number.trim();
        double v = 0.0;
        if (DecoderClass.SegmentDecoder.isNumeric(number)) {
            v = Double.parseDouble(number);
            if (this.sd.match(16, "x1xxxxxx")) {
                v *= 1.0E-9;
            } else if (this.sd.match(17, "xxxx1xxx")) {
                v *= 1.0E-6;
            } else if (this.sd.match(17, "xxxxx10x")) {
                v *= 0.001;
            } else if (this.sd.match(17, "x1xxxxxx")) {
                v *= 1000.0;
            } else if (this.sd.match(17, "xx1xxxxx")) {
                v *= 1000000.0;
            }
            if (this.sd.match(10, "1000111x")) {
                v = (v - 32.0) * 5.0 / 9.0;
            }
        } else {
            v = number.contains("0L") || number.contains("0.L") ? Double.POSITIVE_INFINITY : Double.NaN;
        }
        if (this.sd.match(3, "1xxxxxxx")) {
            v = -v;
        }
        this.mode = m;
        this.value = v;
        return true;
    }
}

