/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.devices.DecoderClass;
import dk.hkj.util.ByteBuffer;

public class DecoderBrymen829
extends DecoderClass {
    private DecoderClass.RegularSegmentDecoder sd = new DecoderClass.RegularSegmentDecoder(this, "bgc.afed");
    private boolean serial = false;

    DecoderBrymen829() {
    }

    DecoderBrymen829(boolean serial) {
        this.serial = serial;
    }

    @Override
    public void init(CommDataInterface cdi) {
        if (this.serial) {
            cdi.setPacketFormat(CommDataInterface.PacketFormat.FixedLengthTimeout, 20);
        }
    }

    @Override
    public int messageSize() {
        return this.serial ? 20 : 27;
    }

    @Override
    public boolean decode(byte[] data) {
        this.value = Double.NaN;
        if (data == null || data.length == 0) {
            return false;
        }
        if (this.serial && data.length == 20) {
            ByteBuffer bf = new ByteBuffer();
            bf.append((byte)0);
            bf.append((byte)0);
            bf.append(data);
            bf.insert(9, (byte)0);
            bf.insert(18, (byte)0);
            bf.insert(22, (byte)-126);
            bf.append((byte)0);
            bf.append((byte)0);
            data = bf.getAsArray();
        }
        if (data.length != 27 || data[22] != -126) {
            return false;
        }
        if (data[0] != 0 || data[9] != 0 || data[18] != 0) {
            return false;
        }
        this.sd.setupData(data);
        String m = "";
        if (this.sd.match(3, "xxxx1xxx")) {
            m = "T2";
        }
        if (this.sd.match(3, "xxxxxxx1")) {
            m = "T1";
        }
        if (this.sd.match(3, "xxxx1x11")) {
            m = "T2-T1";
        }
        if (this.sd.match(16, "xx1xxxxx")) {
            m = "V";
        }
        if (this.sd.match(16, "xxx1xxxx")) {
            m = "A";
        }
        if (this.sd.match(16, "xxxxxxx1")) {
            m = "F";
        }
        if (this.sd.match(16, "xxxx1x1x")) {
            m = "Siemens";
        }
        if (this.sd.match(16, "xxxxx1xx")) {
            m = "DutyCycle";
        }
        if (this.sd.match(15, "xx1xxxxx")) {
            m = "ohm";
        }
        if (this.sd.match(15, "xxx1xxxx")) {
            m = "Hz";
        }
        if (this.sd.match(7, "xxx1xxxx") && this.sd.match(16, "x1xxxxxx")) {
            m = "dBm";
        }
        if (this.sd.match(2, "xxx1xxxx")) {
            m = String.valueOf(m) + "AC";
        }
        if (this.sd.match(2, "xx1xxxxx")) {
            m = String.valueOf(m) + "DC";
        }
        String number = this.sd.getNumber(4, 4);
        if (this.sd.match(6, "xxx1xxxx")) {
            number = String.valueOf(number.substring(0, 3)) + '.' + number.substring(3);
        }
        if (this.sd.match(5, "xxx1xxxx")) {
            number = String.valueOf(number.substring(0, 2)) + '.' + number.substring(2);
        }
        if (this.sd.match(4, "xxx1xxxx")) {
            number = String.valueOf(number.substring(0, 1)) + '.' + number.substring(1);
        }
        number = number.trim();
        boolean fahrenheit = this.sd.match(13, "010x1110");
        if (number.endsWith("F")) {
            fahrenheit = true;
            number = number.substring(number.length() - 1);
        }
        double v = 0.0;
        if (DecoderClass.SegmentDecoder.isNumeric(number)) {
            v = Double.parseDouble(number);
            if (this.sd.match(16, "xxxx1xxx")) {
                v *= 1.0E-9;
            } else if (this.sd.match(16, "1xxxxxxx")) {
                v *= 1.0E-6;
            } else if (this.sd.match(16, "x1xxxxxx") && !m.equals("dBm")) {
                v *= 0.001;
            } else if (this.sd.match(15, "1xxxxxxx")) {
                v *= 1000.0;
            } else if (this.sd.match(15, "x1xxxxxx")) {
                v *= 1000000.0;
            }
            if (fahrenheit) {
                v = (v - 32.0) * 5.0 / 9.0;
            }
        } else {
            v = number.contains("0L") || number.contains("0.L") ? Double.POSITIVE_INFINITY : Double.NaN;
        }
        if (this.sd.match(3, "1xxxxxxx")) {
            v = -v;
        }
        this.mode = m;
        this.value = v;
        return true;
    }
}

