/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.devices;

import dk.hkj.util.ByteBuffer;
import dk.hkj.util.StringUtil;

public class ChecksumGenerator {
    private ChecksumMethod checksumMethod = ChecksumMethod.none;
    private AddMethod addMethod = AddMethod.none;
    private int firstByte = 0;
    private long initValue = 0L;
    private long crcPoly = 0L;
    private long xorout = 0L;

    public ChecksumGenerator(String format) {
        String[] ss = format.split("[;, ]+");
        if (ss.length <= 2) {
            return;
        }
        this.checksumMethod = this.findChecksumMethod(ss[0]);
        this.addMethod = this.findAddMethod(ss[1]);
        if (ss.length >= 3) {
            this.firstByte = (int)StringUtil.parseLong(ss[2]);
        }
        if (ss.length >= 4) {
            this.initValue = (int)StringUtil.parseLong(ss[3]);
        }
        if (ss.length >= 5) {
            String s = ss[4];
            this.crcPoly = s.startsWith("!") ? (long)this.reflect((int)StringUtil.parseLong(s.substring(1)), this.resultBytes() * 8) & this.maskBytes() : (long)((int)StringUtil.parseLong(s));
        }
        if (ss.length >= 6) {
            this.xorout = (int)StringUtil.parseLong(ss[5]);
        }
    }

    int reflect(int x, int bits) {
        x = (x & 0x55555555) << 1 | (x & 0xAAAAAAAA) >> 1;
        x = (x & 0x33333333) << 2 | (x & 0xCCCCCCCC) >> 2;
        x = (x & 0xF0F0F0F) << 4 | (x & 0xF0F0F0F0) >> 4;
        x = (x & 0xFF00FF) << 8 | (x & 0xFF00FF00) >> 8;
        x = (x & 0xFFFF) << 16 | (x & 0xFFFF0000) >> 16;
        return x >> 32 - bits;
    }

    private ChecksumMethod findChecksumMethod(String s) {
        ChecksumMethod[] checksumMethodArray = ChecksumMethod.values();
        int n = checksumMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            ChecksumMethod cm = checksumMethodArray[n2];
            if (cm.name().equalsIgnoreCase(s)) {
                return cm;
            }
            ++n2;
        }
        return ChecksumMethod.none;
    }

    private AddMethod findAddMethod(String s) {
        AddMethod[] addMethodArray = AddMethod.values();
        int n = addMethodArray.length;
        int n2 = 0;
        while (n2 < n) {
            AddMethod am = addMethodArray[n2];
            if (am.name().equalsIgnoreCase(s)) {
                return am;
            }
            ++n2;
        }
        return AddMethod.none;
    }

    public String addCheck(String data) {
        if (this.checksumMethod == ChecksumMethod.none) {
            return data;
        }
        ByteBuffer bb = new ByteBuffer();
        bb.append(data);
        this.addCheck(bb);
        return bb.toString();
    }

    private long funcSum(ByteBuffer data) {
        long sum = this.initValue;
        int i = this.firstByte;
        while (i < data.getSize()) {
            sum += (long)data.unsignedByteAt(i);
            ++i;
        }
        return sum;
    }

    private long funcXor(ByteBuffer data) {
        long sum = this.initValue;
        int i = this.firstByte;
        while (i < data.getSize()) {
            sum ^= (long)data.unsignedByteAt(i);
            ++i;
        }
        return sum;
    }

    private long crc8(ByteBuffer data) {
        long v = this.initValue;
        int i = this.firstByte;
        while (i < data.getSize()) {
            v ^= (long)data.unsignedByteAt(i);
            int j = 0;
            while (j < 8) {
                v = (v & 0x80L) != 0L ? v << 1 ^ this.crcPoly : (v <<= 1);
                ++j;
            }
            ++i;
        }
        return v & 0xFFL;
    }

    private long crc8r(ByteBuffer data) {
        long v = this.initValue;
        int i = this.firstByte;
        while (i < data.getSize()) {
            v ^= (long)data.unsignedByteAt(i);
            int j = 0;
            while (j < 8) {
                v = (v & 1L) != 0L ? v >> 1 ^ this.crcPoly : (v >>= 1);
                ++j;
            }
            ++i;
        }
        return v & 0xFFL;
    }

    private long crc16(ByteBuffer data) {
        long v = this.initValue;
        int i = this.firstByte;
        while (i < data.getSize()) {
            v ^= (long)(data.unsignedByteAt(i) << 8);
            int j = 0;
            while (j < 8) {
                v = (v & 0x8000L) != 0L ? v << 1 ^ this.crcPoly : (v <<= 1);
                ++j;
            }
            ++i;
        }
        return v & 0xFFFFL;
    }

    private long crc16r(ByteBuffer data) {
        long v = this.initValue;
        int i = this.firstByte;
        while (i < data.getSize()) {
            v ^= (long)data.unsignedByteAt(i);
            int j = 0;
            while (j < 8) {
                v = (v & 1L) != 0L ? v >> 1 ^ this.crcPoly : (v >>= 1);
                ++j;
            }
            ++i;
        }
        return v & 0xFFFFL;
    }

    private long crc32(ByteBuffer data) {
        long v = this.initValue;
        int i = this.firstByte;
        while (i < data.getSize()) {
            v ^= (long)(data.unsignedByteAt(i) << 24);
            int j = 0;
            while (j < 8) {
                v = (v & Integer.MIN_VALUE) != 0L ? v << 1 ^ this.crcPoly : (v <<= 1);
                ++j;
            }
            ++i;
        }
        return v & 0xFFFFFFFFFFFFFFFFL;
    }

    private long crc32r(ByteBuffer data) {
        long v = this.initValue;
        int i = this.firstByte;
        while (i < data.getSize()) {
            v ^= (long)data.unsignedByteAt(i);
            int j = 0;
            while (j < 8) {
                v = (v & 1L) != 0L ? v >> 1 ^ this.crcPoly : (v >>= 1);
                ++j;
            }
            ++i;
        }
        return v & 0xFFFFFFFFFFFFFFFFL;
    }

    private int resultBytes() {
        switch (this.checksumMethod) {
            case none: {
                return 0;
            }
            case crc8: {
                return 1;
            }
            case crc8r: {
                return 1;
            }
            case crc16: {
                return 2;
            }
            case crc16r: {
                return 2;
            }
            case crc32: {
                return 4;
            }
            case crc32r: {
                return 4;
            }
            case sum8: {
                return 1;
            }
            case sum16: {
                return 2;
            }
            case msum8: {
                return 1;
            }
            case msum16: {
                return 2;
            }
            case xor8: {
                return 1;
            }
        }
        return 0;
    }

    private long maskBytes() {
        switch (this.checksumMethod) {
            case none: {
                return 0L;
            }
            case crc8: {
                return 255L;
            }
            case crc8r: {
                return 255L;
            }
            case crc16: {
                return 65535L;
            }
            case crc16r: {
                return 65535L;
            }
            case crc32: {
                return -1L;
            }
            case crc32r: {
                return -1L;
            }
            case sum8: {
                return 255L;
            }
            case sum16: {
                return 65535L;
            }
            case msum8: {
                return 255L;
            }
            case msum16: {
                return 65535L;
            }
            case xor8: {
                return 255L;
            }
        }
        return 0L;
    }

    public ByteBuffer addCheck(ByteBuffer data) {
        if (this.checksumMethod == ChecksumMethod.none) {
            return data;
        }
        long sum = 0L;
        int bytes = 0;
        switch (this.checksumMethod) {
            case none: {
                break;
            }
            case crc8: {
                sum = this.crc8(data);
                bytes = 1;
                break;
            }
            case crc8r: {
                sum = this.crc8r(data);
                bytes = 1;
                break;
            }
            case crc16: {
                sum = this.crc16(data);
                bytes = 2;
                break;
            }
            case crc16r: {
                sum = this.crc16r(data);
                bytes = 2;
                break;
            }
            case crc32: {
                sum = this.crc32(data);
                bytes = 4;
                break;
            }
            case crc32r: {
                sum = this.crc32r(data);
                bytes = 4;
                break;
            }
            case sum8: {
                sum = this.funcSum(data) & 0xFFL;
                bytes = 1;
                break;
            }
            case sum16: {
                sum = this.funcSum(data) & 0xFFFFL;
                bytes = 2;
                break;
            }
            case msum8: {
                sum = -this.funcSum(data) & 0xFFL;
                bytes = 1;
                break;
            }
            case msum16: {
                sum = -this.funcSum(data) & 0xFFFFL;
                bytes = 2;
                break;
            }
            case xor8: {
                sum = this.funcXor(data) & 0xFFL;
                bytes = 1;
            }
        }
        sum ^= this.xorout;
        if (this.checksumMethod != ChecksumMethod.none) {
            switch (this.addMethod) {
                case none: {
                    break;
                }
                case binhl: {
                    if (bytes >= 4) {
                        data.append((byte)(sum >> 24));
                    }
                    if (bytes >= 3) {
                        data.append((byte)(sum >> 16));
                    }
                    if (bytes >= 2) {
                        data.append((byte)(sum >> 8));
                    }
                    if (bytes < 1) break;
                    data.append((byte)sum);
                    break;
                }
                case binlh: {
                    if (bytes >= 1) {
                        data.append((byte)sum);
                    }
                    if (bytes >= 2) {
                        data.append((byte)(sum >> 8));
                    }
                    if (bytes >= 3) {
                        data.append((byte)(sum >> 16));
                    }
                    if (bytes < 4) break;
                    data.append((byte)(sum >> 24));
                    break;
                }
                case hexhl: {
                    if (bytes >= 4) {
                        data.append(StringUtil.hex2((byte)(sum >> 24)));
                    }
                    if (bytes >= 3) {
                        data.append(StringUtil.hex2((byte)(sum >> 16)));
                    }
                    if (bytes >= 2) {
                        data.append(StringUtil.hex2((byte)(sum >> 8)));
                    }
                    if (bytes < 1) break;
                    data.append(StringUtil.hex2((byte)sum));
                    break;
                }
                case hexlh: {
                    if (bytes >= 1) {
                        data.append(StringUtil.hex2((byte)sum));
                    }
                    if (bytes >= 2) {
                        data.append(StringUtil.hex2((byte)(sum >> 8)));
                    }
                    if (bytes >= 3) {
                        data.append(StringUtil.hex2((byte)(sum >> 16)));
                    }
                    if (bytes < 4) break;
                    data.append(StringUtil.hex2((byte)(sum >> 24)));
                }
            }
        }
        return data;
    }

    static enum AddMethod {
        none,
        binhl,
        binlh,
        hexhl,
        hexlh;

    }

    static enum ChecksumMethod {
        none,
        crc8,
        crc8r,
        crc16,
        crc16r,
        crc32,
        crc32r,
        sum8,
        sum16,
        msum8,
        msum16,
        xor8;

    }
}

