/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.database;

import dk.hkj.database.DataBase;
import dk.hkj.database.DataRow;
import dk.hkj.main.Main;
import dk.hkj.main.PopupChartLayout;
import dk.hkj.main.PopupGridPanel;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.script.Functions;
import dk.hkj.script.Script;
import dk.hkj.util.MathUtil;
import dk.hkj.vars.Var;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;

public class ScriptFunctions {
    public static ScriptFunctions scriptFunctions = null;
    private DataBase db = null;
    private int columnDateTime = -1;
    private int columnTime = -1;

    private ScriptFunctions(DataBase db) {
        this.db = db;
    }

    public void tableChanged() {
        this.columnDateTime = this.db.header().getIndex("dateTime");
        this.columnTime = this.db.header().getIndex("time");
    }

    private int getColumn(Var v) {
        if (v.canInt()) {
            return v.asInt();
        }
        return this.db.header().getIndex(v.asString());
    }

    private Var createDate(double value) {
        return Var.createValue(new Date((long)(value * 1000.0)));
    }

    public void addFunctions() {
        this.tableChanged();
        Functions.gf().add(new Functions.Func("tableRows"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 0) {
                    1.invalidNumberOfParams(script, "");
                }
                return Var.createValue(ScriptFunctions.this.db.rows());
            }
        });
        Functions.gf().add(new Functions.Func("tableColumns"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 0) {
                    2.invalidNumberOfParams(script, "");
                }
                return Var.createValue(ScriptFunctions.this.db.columns());
            }
        });
        Functions.gf().add(new Functions.Func("tableColumnUnit"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    3.invalidNumberOfParams(script, "column");
                }
                int column = -1;
                column = params.get(0).canInt() ? params.get(0).asInt() : ScriptFunctions.this.db.header().getIndex(params.get(0).asString());
                return Var.createValue(column < 0 ? "" : ((ScriptFunctions)ScriptFunctions.this).db.format().get((int)column).unit);
            }
        });
        Functions.gf().add(new Functions.Func("tableColumnFormat"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 2 && params.size() != 3) {
                    4.invalidNumberOfParams(script, "column,value{,useUnit}");
                }
                int column = -1;
                column = params.get(0).canInt() ? params.get(0).asInt() : ScriptFunctions.this.db.header().getIndex(params.get(0).asString());
                String s = "";
                if (column < 0) {
                    s = ValueFormat.formatD2.formatDisplay(params.get(1).asDouble());
                } else {
                    s = ScriptFunctions.this.db.format().formatDisplay(column, params.get(1).asDouble());
                    if (params.size() == 3 && params.get(2).asBoolean()) {
                        s = String.valueOf(s) + ((ScriptFunctions)ScriptFunctions.this).db.format().get((int)column).unit;
                    }
                }
                return Var.createValue(s);
            }
        });
        Functions.gf().add(new Functions.Func("tableSample"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    5.invalidNumberOfParams(script, "index");
                }
                int index = params.get(0).asInt();
                int column = ScriptFunctions.this.db.header().getIndex("time");
                if (column >= 0) {
                    return Var.createValue(Double.toString(ScriptFunctions.this.db.getValue(index, column)));
                }
                return Var.createValue("#" + index);
            }
        });
        Functions.gf().add(new Functions.Func("tableTimeIndex"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    6.invalidNumberOfParams(script, "time");
                }
                if (ScriptFunctions.this.columnTime < 0) {
                    return Var.createValue(-1);
                }
                return Var.createValue(ScriptFunctions.this.db.findSampleIndex(ScriptFunctions.this.columnTime, params.get(0).asDouble()));
            }
        });
        Functions.gf().add(new Functions.Func("table"){

            @Override
            public Var execute(Script script, List<Var> params) {
                Var v = null;
                switch (params.size()) {
                    case 1: {
                        DataRow data = ScriptFunctions.this.db.getRow(params.get(0).asInt());
                        v = Var.createArray();
                        int i = 0;
                        while (i < ScriptFunctions.this.db.columns()) {
                            if (i == ScriptFunctions.this.columnDateTime) {
                                v.addVar(ScriptFunctions.this.createDate(data.getValue(i)));
                            } else {
                                v.addVar(Var.createValue(data.getValue(i)));
                            }
                            ++i;
                        }
                        break;
                    }
                    case 2: {
                        int column = ScriptFunctions.this.getColumn(params.get(1));
                        double data = ScriptFunctions.this.db.getValue(params.get(0).asInt(), column);
                        if (column == ScriptFunctions.this.columnDateTime) {
                            v = ScriptFunctions.this.createDate(data);
                            break;
                        }
                        v = Var.createValue(data);
                        break;
                    }
                    default: {
                        7.invalidNumberOfParams(script, "row{,column}");
                    }
                }
                return v;
            }
        });
        Functions.gf().add(new Functions.Func("tableColumn"){

            @Override
            public Var execute(Script script, List<Var> params) {
                Var v = null;
                switch (params.size()) {
                    case 1: {
                        int column = ScriptFunctions.this.getColumn(params.get(0));
                        v = Var.createValue(ScriptFunctions.this.db.getColumn(column));
                        break;
                    }
                    case 2: {
                        int column = ScriptFunctions.this.getColumn(params.get(0));
                        int start = ScriptFunctions.this.getColumn(params.get(1));
                        double[] vv = ScriptFunctions.this.db.getColumn(column);
                        v = Var.createValue(Arrays.copyOfRange(vv, start, vv.length));
                        break;
                    }
                    case 3: {
                        int column = ScriptFunctions.this.getColumn(params.get(0));
                        int start = ScriptFunctions.this.getColumn(params.get(1));
                        int end = ScriptFunctions.this.getColumn(params.get(2));
                        v = Var.createValue(Arrays.copyOfRange(ScriptFunctions.this.db.getColumn(column), start, end));
                        break;
                    }
                    default: {
                        8.invalidNumberOfParams(script, "column{,start{,end}}");
                    }
                }
                return v;
            }
        });
        Functions.gf().add(new Functions.Func("tableColumnName"){

            @Override
            public Var execute(Script script, List<Var> params) {
                Var v = null;
                switch (params.size()) {
                    case 0: {
                        v = Var.createArray();
                        int i = 0;
                        while (i < ScriptFunctions.this.db.columns()) {
                            v.addVar(Var.createValue(ScriptFunctions.this.db.header().getColumnName(i)));
                            ++i;
                        }
                        break;
                    }
                    case 1: {
                        v = Var.createValue(ScriptFunctions.this.db.header().getColumnName(ScriptFunctions.this.getColumn(params.get(0))));
                        break;
                    }
                    default: {
                        9.invalidNumberOfParams(script, "{column}");
                    }
                }
                return v;
            }
        });
        Functions.gf().add(new Functions.Func("tableColumnIdentifier"){

            @Override
            public Var execute(Script script, List<Var> params) {
                Var v = null;
                switch (params.size()) {
                    case 0: {
                        v = Var.createArray();
                        int i = 0;
                        while (i < ScriptFunctions.this.db.columns()) {
                            v.addVar(Var.createValue(ScriptFunctions.this.db.header().getColumnNameAsIdentifier(i)));
                            ++i;
                        }
                        break;
                    }
                    case 1: {
                        v = Var.createValue(ScriptFunctions.this.db.header().getColumnNameAsIdentifier(ScriptFunctions.this.getColumn(params.get(0))));
                        break;
                    }
                    default: {
                        10.invalidNumberOfParams(script, "{column}");
                    }
                }
                return v;
            }
        });
        Functions.gf().add(new Functions.Func("tableMax"){

            @Override
            public Var execute(Script script, List<Var> params) {
                int column = 0;
                int start = 0;
                int end = ScriptFunctions.this.db.rows() - 1;
                boolean reverse = false;
                switch (params.size()) {
                    case 1: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        break;
                    }
                    case 2: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        break;
                    }
                    case 3: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        end = params.get(2).asInt();
                        break;
                    }
                    case 4: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        end = params.get(2).asInt();
                        reverse = params.get(3).asBoolean();
                        break;
                    }
                    default: {
                        11.invalidNumberOfParams(script, "column{,start{,end{,reverse}}}");
                    }
                }
                double v = -1.7976931348623157E308;
                int index = -1;
                if (reverse) {
                    int i = end;
                    while (i >= start) {
                        if (ScriptFunctions.this.db.getValue(i, column) > v) {
                            index = i;
                            v = ScriptFunctions.this.db.getValue(i, column);
                        }
                        --i;
                    }
                } else {
                    int i = start;
                    while (i <= end) {
                        if (ScriptFunctions.this.db.getValue(i, column) > v) {
                            index = i;
                            v = ScriptFunctions.this.db.getValue(i, column);
                        }
                        ++i;
                    }
                }
                return Var.createValue(index);
            }
        });
        Functions.gf().add(new Functions.Func("tableMin"){

            @Override
            public Var execute(Script script, List<Var> params) {
                int column = 0;
                int start = 0;
                int end = ScriptFunctions.this.db.rows() - 1;
                boolean reverse = false;
                switch (params.size()) {
                    case 1: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        break;
                    }
                    case 2: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        break;
                    }
                    case 3: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        end = params.get(2).asInt();
                        break;
                    }
                    case 4: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        end = params.get(2).asInt();
                        reverse = params.get(3).asBoolean();
                        break;
                    }
                    default: {
                        12.invalidNumberOfParams(script, "column{,start{,end{,reverse}}}");
                    }
                }
                double v = Double.MAX_VALUE;
                int index = -1;
                if (reverse) {
                    int i = end;
                    while (i >= start) {
                        if (ScriptFunctions.this.db.getValue(i, column) < v) {
                            index = i;
                            v = ScriptFunctions.this.db.getValue(i, column);
                        }
                        --i;
                    }
                } else {
                    int i = start;
                    while (i <= end) {
                        if (ScriptFunctions.this.db.getValue(i, column) < v) {
                            index = i;
                            v = ScriptFunctions.this.db.getValue(i, column);
                        }
                        ++i;
                    }
                }
                return Var.createValue(index);
            }
        });
        Functions.gf().add(new Functions.Func("tableValue"){

            @Override
            public Var execute(Script script, List<Var> params) {
                int column = 0;
                int start = 0;
                int end = ScriptFunctions.this.db.rows() - 1;
                boolean reverse = false;
                double target = 0.0;
                switch (params.size()) {
                    case 2: {
                        target = params.get(0).asDouble();
                        column = ScriptFunctions.this.getColumn(params.get(1));
                        break;
                    }
                    case 3: {
                        target = params.get(0).asDouble();
                        column = ScriptFunctions.this.getColumn(params.get(1));
                        start = params.get(2).asInt();
                        break;
                    }
                    case 4: {
                        target = params.get(0).asDouble();
                        column = ScriptFunctions.this.getColumn(params.get(1));
                        start = params.get(2).asInt();
                        end = params.get(3).asInt();
                        break;
                    }
                    case 5: {
                        target = params.get(0).asDouble();
                        column = ScriptFunctions.this.getColumn(params.get(1));
                        start = params.get(2).asInt();
                        end = params.get(3).asInt();
                        reverse = params.get(4).asBoolean();
                        break;
                    }
                    default: {
                        13.invalidNumberOfParams(script, "value,column{,start{,end{,reverse}}}");
                    }
                }
                int index = -1;
                if (reverse) {
                    double v = ScriptFunctions.this.db.getValue(end, column);
                    int i = end - 1;
                    while (i >= start) {
                        double v1 = ScriptFunctions.this.db.getValue(i, column);
                        if (v1 <= target && v > target || v1 >= target && v < target) {
                            index = i;
                            double v2 = ScriptFunctions.this.db.getValue(i + 1, column);
                            if (!(Math.abs(v2 - target) < Math.abs(v1 - target))) break;
                            index = i + 1;
                            break;
                        }
                        --i;
                    }
                } else {
                    double v = ScriptFunctions.this.db.getValue(start, column);
                    int i = start + 1;
                    while (i <= end) {
                        double v1 = ScriptFunctions.this.db.getValue(i, column);
                        if (v1 <= target && v > target || v1 >= target && v < target) {
                            index = i;
                            double v2 = ScriptFunctions.this.db.getValue(i - 1, column);
                            if (!(Math.abs(v2 - target) < Math.abs(v1 - target))) break;
                            index = i - 1;
                            break;
                        }
                        ++i;
                    }
                }
                return Var.createValue(index);
            }
        });
        Functions.gf().add(new Functions.Func("tableTopPeak"){

            @Override
            public Var execute(Script script, List<Var> params) {
                int column = 0;
                int start = 0;
                int end = ScriptFunctions.this.db.rows() - 1;
                boolean reverse = false;
                switch (params.size()) {
                    case 1: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        break;
                    }
                    case 2: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        break;
                    }
                    case 3: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        end = params.get(2).asInt();
                        break;
                    }
                    case 4: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        end = params.get(2).asInt();
                        reverse = params.get(3).asBoolean();
                        break;
                    }
                    default: {
                        14.invalidNumberOfParams(script, "column{,start{,end{,reverse}}}");
                    }
                }
                int index = -1;
                double max = -1.7976931348623157E308;
                double min = Double.MAX_VALUE;
                int n = start;
                while (n <= end) {
                    double v = ScriptFunctions.this.db.getValue(n, column);
                    if (v > max) {
                        max = v;
                    }
                    if (v < min) {
                        min = v;
                    }
                    ++n;
                }
                double dv = (max - min) * 0.05;
                if (reverse) {
                    boolean up = false;
                    double v = ScriptFunctions.this.db.getValue(end, column);
                    int n2 = end - 1;
                    while (n2 >= start) {
                        double v1 = ScriptFunctions.this.db.getValue(n2, column);
                        if (v1 > v) {
                            v = v1;
                            index = n2;
                            up = true;
                        } else if (v1 + dv < v && up) break;
                        --n2;
                    }
                } else {
                    boolean up = false;
                    double v = ScriptFunctions.this.db.getValue(start, column);
                    int n3 = start + 1;
                    while (n3 <= end) {
                        double v1 = ScriptFunctions.this.db.getValue(n3, column);
                        if (v1 > v) {
                            v = v1;
                            index = n3;
                            up = true;
                        } else if (v1 + dv < v && up) break;
                        ++n3;
                    }
                }
                return Var.createValue(index);
            }
        });
        Functions.gf().add(new Functions.Func("tableBottomPeak"){

            @Override
            public Var execute(Script script, List<Var> params) {
                int column = 0;
                int start = 0;
                int end = ScriptFunctions.this.db.rows() - 1;
                boolean reverse = false;
                switch (params.size()) {
                    case 1: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        break;
                    }
                    case 2: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        break;
                    }
                    case 3: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        end = params.get(2).asInt();
                        break;
                    }
                    case 4: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        end = params.get(2).asInt();
                        reverse = params.get(3).asBoolean();
                        break;
                    }
                    default: {
                        15.invalidNumberOfParams(script, "column{,start{,end{,reverse}}}");
                    }
                }
                int index = -1;
                double max = -1.7976931348623157E308;
                double min = Double.MAX_VALUE;
                int n = start;
                while (n <= end) {
                    double v = ScriptFunctions.this.db.getValue(n, column);
                    if (v > max) {
                        max = v;
                    }
                    if (v < min) {
                        min = v;
                    }
                    ++n;
                }
                double dv = (max - min) * 0.05;
                if (reverse) {
                    boolean up = false;
                    double v = ScriptFunctions.this.db.getValue(end, column);
                    int n2 = end - 1;
                    while (n2 >= start) {
                        double v1 = ScriptFunctions.this.db.getValue(n2, column);
                        if (v1 < v) {
                            v = v1;
                            index = n2;
                            up = true;
                        } else if (v1 - dv > v && up) break;
                        --n2;
                    }
                } else {
                    boolean up = false;
                    double v = ScriptFunctions.this.db.getValue(start, column);
                    int n3 = start + 1;
                    while (n3 <= end) {
                        double v1 = ScriptFunctions.this.db.getValue(n3, column);
                        if (v1 < v) {
                            v = v1;
                            index = n3;
                            up = true;
                        } else if (v1 - dv > v && up) break;
                        ++n3;
                    }
                }
                return Var.createValue(index);
            }
        });
        Functions.gf().add(new Functions.Func("tableRaise"){

            @Override
            public Var execute(Script script, List<Var> params) {
                int step;
                int column = 0;
                int start = 0;
                int end = ScriptFunctions.this.db.rows() - 1;
                switch (params.size()) {
                    case 1: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        break;
                    }
                    case 2: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        break;
                    }
                    case 3: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        end = params.get(2).asInt();
                        break;
                    }
                    default: {
                        16.invalidNumberOfParams(script, "column{,start{,end}}");
                    }
                }
                int index = -1;
                int span = (end - start) / 2000;
                if (span < 2) {
                    span = 2;
                }
                if ((step = span / 10) < 1) {
                    step = 1;
                }
                double rrRef = 0.0;
                boolean log = Support.chartScales.getScale(this.name).isLog();
                int n = start;
                while (n <= end) {
                    double rr;
                    double[] vv = ScriptFunctions.this.db.getColumnRange(n - span, n + span, column);
                    if (log) {
                        int j = 0;
                        while (j < vv.length) {
                            vv[j] = vv[j] <= Support.systemSettings.chartLowLog ? Support.systemSettings.chartLowLog : Math.log10(vv[j]);
                            ++j;
                        }
                    }
                    if ((rr = MathUtil.slope(vv)) > rrRef) {
                        rrRef = rr;
                        index = n;
                    }
                    n += step;
                }
                return Var.createValue(index);
            }
        });
        Functions.gf().add(new Functions.Func("tableFall"){

            @Override
            public Var execute(Script script, List<Var> params) {
                int step;
                int column = 0;
                int start = 0;
                int end = ScriptFunctions.this.db.rows() - 1;
                switch (params.size()) {
                    case 1: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        break;
                    }
                    case 2: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        break;
                    }
                    case 3: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        end = params.get(2).asInt();
                        break;
                    }
                    default: {
                        17.invalidNumberOfParams(script, "column{,start{,end}}");
                    }
                }
                int index = -1;
                int span = (end - start) / 2000;
                if (span < 2) {
                    span = 2;
                }
                if ((step = span / 10) < 1) {
                    step = 1;
                }
                double rrRef = 0.0;
                boolean log = Support.chartScales.getScale(this.name).isLog();
                int n = start;
                while (n <= end) {
                    double rr;
                    double[] vv = ScriptFunctions.this.db.getColumnRange(n - span, n + span, column);
                    if (log) {
                        int j = 0;
                        while (j < vv.length) {
                            vv[j] = vv[j] <= Support.systemSettings.chartLowLog ? Support.systemSettings.chartLowLog : Math.log10(vv[j]);
                            ++j;
                        }
                    }
                    if ((rr = MathUtil.slope(vv)) < rrRef) {
                        rrRef = rr;
                        index = n;
                    }
                    n += step;
                }
                return Var.createValue(index);
            }
        });
        Functions.gf().add(new Functions.Func("tableCalcMax"){

            @Override
            public Var execute(Script script, List<Var> params) {
                int column = 0;
                int start = 0;
                int end = ScriptFunctions.this.db.rows() - 1;
                switch (params.size()) {
                    case 1: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        break;
                    }
                    case 2: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        break;
                    }
                    case 3: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        end = params.get(2).asInt();
                        break;
                    }
                    default: {
                        18.invalidNumberOfParams(script, "column{,start{,end}}");
                    }
                }
                double v = -1.7976931348623157E308;
                int i = start;
                while (i <= end) {
                    if (ScriptFunctions.this.db.getValue(i, column) > v) {
                        v = ScriptFunctions.this.db.getValue(i, column);
                    }
                    ++i;
                }
                return Var.createValue(v);
            }
        });
        Functions.gf().add(new Functions.Func("tableCalcRange"){

            @Override
            public Var execute(Script script, List<Var> params) {
                int column = 0;
                int start = 0;
                int end = ScriptFunctions.this.db.rows() - 1;
                switch (params.size()) {
                    case 1: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        break;
                    }
                    case 2: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        break;
                    }
                    case 3: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        end = params.get(2).asInt();
                        break;
                    }
                    default: {
                        19.invalidNumberOfParams(script, "column{,start{,end}}");
                    }
                }
                double mx = -1.7976931348623157E308;
                double mi = Double.MAX_VALUE;
                int i = start;
                while (i <= end) {
                    if (ScriptFunctions.this.db.getValue(i, column) > mx) {
                        mx = ScriptFunctions.this.db.getValue(i, column);
                    }
                    if (ScriptFunctions.this.db.getValue(i, column) < mi) {
                        mi = ScriptFunctions.this.db.getValue(i, column);
                    }
                    ++i;
                }
                return Var.createValue(mx - mi);
            }
        });
        Functions.gf().add(new Functions.Func("tableTime"){

            @Override
            public Var execute(Script script, List<Var> params) {
                double v = 0.0;
                if (ScriptFunctions.this.columnTime > 0) {
                    v = ScriptFunctions.this.db.getValue(ScriptFunctions.this.db.rows() - 1, ScriptFunctions.this.columnTime);
                }
                return Var.createValue(v);
            }
        });
        Functions.gf().add(new Functions.Func("tableCalcMin"){

            @Override
            public Var execute(Script script, List<Var> params) {
                int column = 0;
                int start = 0;
                int end = ScriptFunctions.this.db.rows() - 1;
                switch (params.size()) {
                    case 1: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        break;
                    }
                    case 2: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        break;
                    }
                    case 3: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        end = params.get(2).asInt();
                        break;
                    }
                    default: {
                        21.invalidNumberOfParams(script, "column{,start{,end}}");
                    }
                }
                double v = Double.MAX_VALUE;
                int i = start;
                while (i <= end) {
                    if (ScriptFunctions.this.db.getValue(i, column) < v) {
                        v = ScriptFunctions.this.db.getValue(i, column);
                    }
                    ++i;
                }
                return Var.createValue(v);
            }
        });
        Functions.gf().add(new Functions.Func("tableCalcAvg"){

            @Override
            public Var execute(Script script, List<Var> params) {
                int column = 0;
                int start = 0;
                int end = ScriptFunctions.this.db.rows() - 1;
                switch (params.size()) {
                    case 1: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        break;
                    }
                    case 2: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        break;
                    }
                    case 3: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        end = params.get(2).asInt();
                        break;
                    }
                    default: {
                        22.invalidNumberOfParams(script, "column{,start{,end}}");
                    }
                }
                double v = 0.0;
                int i = start;
                while (i <= end) {
                    v += ScriptFunctions.this.db.getValue(i, column);
                    ++i;
                }
                return Var.createValue(v / (double)(end - start + 1));
            }
        });
        Functions.gf().add(new Functions.Func("tableCalcSum"){

            @Override
            public Var execute(Script script, List<Var> params) {
                int column = 0;
                int start = 0;
                int end = ScriptFunctions.this.db.rows() - 1;
                switch (params.size()) {
                    case 1: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        break;
                    }
                    case 2: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        break;
                    }
                    case 3: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        end = params.get(2).asInt();
                        break;
                    }
                    default: {
                        23.invalidNumberOfParams(script, "column{,start{,end}}");
                    }
                }
                double v = 0.0;
                int i = start;
                while (i <= end) {
                    v += ScriptFunctions.this.db.getValue(i, column);
                    ++i;
                }
                return Var.createValue(v);
            }
        });
        Functions.gf().add(new Functions.Func("tableCalcRMS"){

            @Override
            public Var execute(Script script, List<Var> params) {
                int column = 0;
                int start = 0;
                int end = ScriptFunctions.this.db.rows() - 1;
                switch (params.size()) {
                    case 1: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        break;
                    }
                    case 2: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        break;
                    }
                    case 3: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        end = params.get(2).asInt();
                        break;
                    }
                    default: {
                        24.invalidNumberOfParams(script, "column{,start{,end}}");
                    }
                }
                double v = 0.0;
                int i = start;
                while (i <= end) {
                    v += ScriptFunctions.this.db.getValue(i, column) * ScriptFunctions.this.db.getValue(i, column);
                    ++i;
                }
                return Var.createValue(Math.sqrt(v / (double)(end - start + 1)));
            }
        });
        Functions.gf().add(new Functions.Func("tableCalcSlope"){

            @Override
            public Var execute(Script script, List<Var> params) {
                int column = 0;
                int start = 0;
                int end = ScriptFunctions.this.db.rows() - 1;
                switch (params.size()) {
                    case 1: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        break;
                    }
                    case 2: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        break;
                    }
                    case 3: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        end = params.get(2).asInt();
                        break;
                    }
                    default: {
                        25.invalidNumberOfParams(script, "column{,start{,end}}");
                    }
                }
                double v = MathUtil.slope(ScriptFunctions.this.db.getColumnRange(start, end + 1, column));
                return Var.createValue(v);
            }
        });
        Functions.gf().add(new Functions.Func("tableCalcStdDev"){

            @Override
            public Var execute(Script script, List<Var> params) {
                int column = 0;
                int start = 0;
                int end = ScriptFunctions.this.db.rows() - 1;
                switch (params.size()) {
                    case 1: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        break;
                    }
                    case 2: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        break;
                    }
                    case 3: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        end = params.get(2).asInt();
                        break;
                    }
                    default: {
                        26.invalidNumberOfParams(script, "column{,start{,end}}");
                    }
                }
                double v = MathUtil.stddev(ScriptFunctions.this.db.getColumnRange(start, end + 1, column));
                return Var.createValue(v);
            }
        });
        Functions.gf().add(new Functions.Func("tableCalcTimeSum"){

            @Override
            public Var execute(Script script, List<Var> params) {
                int column = 0;
                int start = 0;
                int end = ScriptFunctions.this.db.rows() - 1;
                switch (params.size()) {
                    case 1: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        break;
                    }
                    case 2: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        break;
                    }
                    case 3: {
                        column = ScriptFunctions.this.getColumn(params.get(0));
                        start = params.get(1).asInt();
                        end = params.get(2).asInt();
                        break;
                    }
                    default: {
                        27.invalidNumberOfParams(script, "column{,start{,end}}");
                    }
                }
                if (ScriptFunctions.this.columnTime < 0) {
                    Var.createValue(Double.NaN);
                }
                double timeSum = 0.0;
                double time = ScriptFunctions.this.db.getValue(start, ScriptFunctions.this.columnTime);
                int i = start + 1;
                while (i <= end) {
                    double t1 = ScriptFunctions.this.db.getValue(i, ScriptFunctions.this.columnTime);
                    timeSum += ScriptFunctions.this.db.getValue(i, column) * (t1 - time);
                    time = t1;
                    ++i;
                }
                return Var.createValue(timeSum);
            }
        });
        Functions.gf().add(new Functions.Func("tableInitHeader"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 1) {
                    28.invalidNumberOfParams(script, "columnNames");
                }
                String columnNames = params.get(0).asString().trim();
                ScriptFunctions.this.db.initColumnNams(columnNames);
                Support.math.disableAll();
                Main.changeDevicesOrTable(Support.UpdateType.ColumnsTable);
                Support.clearExporter();
                Support.paneChart.annotations.clear();
                Support.paneHistogram.annotations.clear();
                PopupGridPanel.systemStateChanged();
                PopupChartLayout.closeAll();
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("tableAddRow"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != ScriptFunctions.this.db.columns()) {
                    29.invalidNumberOfParams(script, "Number of params must match number of columns");
                }
                DataRow dr = ScriptFunctions.this.db.getNewRow();
                int i = 0;
                while (i < params.size()) {
                    double v = params.get(i).asDouble();
                    dr.setValue(i, v);
                    ++i;
                }
                ScriptFunctions.this.db.addRow(dr);
                return null;
            }
        });
        Functions.gf().add(new Functions.Func("tableAddCSVText"){

            @Override
            public Var execute(Script script, List<Var> params) {
                if (params.size() != 3) {
                    30.invalidNumberOfParams(script, "csv,columnNames,addIndex");
                }
                ArrayList<String> list = new ArrayList<String>();
                String[] stringArray = params.get(0).asString().split("[\\r\\n]+");
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (!(line = line.trim()).isEmpty()) {
                        list.add(line);
                    }
                    ++n2;
                }
                String columnNames = params.get(1).asString().trim();
                boolean addIndex = params.get(2).asBoolean();
                ScriptFunctions.this.db.loadFromList(list, columnNames.isEmpty() ? null : columnNames, addIndex);
                Support.math.disableAll();
                Main.changeDevicesOrTable(Support.UpdateType.ColumnsTable);
                Support.clearExporter();
                Support.paneChart.annotations.clear();
                Support.paneHistogram.annotations.clear();
                PopupGridPanel.systemStateChanged();
                PopupChartLayout.closeAll();
                return null;
            }
        });
    }

    public static ScriptFunctions get() {
        if (scriptFunctions == null) {
            scriptFunctions = new ScriptFunctions(Support.dataBase);
        }
        return scriptFunctions;
    }
}

