/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.database;

import dk.hkj.database.DataBase;
import dk.hkj.database.DataRow;
import dk.hkj.main.PopupFFTView;
import dk.hkj.util.StringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;

public class Importer {
    private DataBase db = null;
    private final int MinMatchLength = 2;
    private List<Column> columns = null;
    private DataBase importDB = null;
    private int refColumnIndex = -1;
    private int importRefColumnIndex = -1;
    private int indexColumnIndex = -1;
    private int timeColumnIndex = -1;
    private int importTimeColumnIndex = -1;
    private DataBase.Slope slope = null;
    private double tolerance = 0.0;
    private String errorMessage = "";
    Double ofs = null;

    public Importer(DataBase db) {
        this.db = db;
    }

    public static List<String> loadHeaders(File file) throws IOException {
        if (file == null) {
            return null;
        }
        DataBase importDB = new DataBase();
        FileInputStream is = new FileInputStream(file);
        InputStreamReader isw = new InputStreamReader(is);
        try (BufferedReader br = new BufferedReader(isw);){
            importDB.header.load(br);
            List<String> list = importDB.header.getColumnsList();
            return list;
        }
    }

    public static List<String> loadHeaders(String fname) {
        try {
            return Importer.loadHeaders(new File(fname));
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private boolean setupColumnNames(List<String> dataColumns) {
        for (String n : dataColumns) {
            this.columns.add(new Column(n));
        }
        int n = 0;
        for (Column c : this.columns) {
            if (c.minNameIndex <= n) continue;
            n = c.minNameIndex;
        }
        for (Column c : this.columns) {
            c.adjustName(n);
            c.addName();
            if (c.isValid()) continue;
            return false;
        }
        this.timeColumnIndex = this.db.header().getTimeColumn();
        this.indexColumnIndex = this.db.header().getIndexColumn();
        this.importTimeColumnIndex = this.importDB.header().getTimeColumn();
        return true;
    }

    public DataBase.Slope getSlope(DataBase db, int columnIndex) {
        DataBase.Slope s = db.getSlope(columnIndex, this.tolerance);
        if (s != DataBase.Slope.unspecified) {
            return s;
        }
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        int i = 1;
        while (i < db.rows()) {
            double v = db.getValue(i, columnIndex);
            if (v > max) {
                max = v;
            }
            if (v < min) {
                min = v;
            }
            ++i;
        }
        double r = max - min;
        this.tolerance = r / 1000.0;
        while (this.tolerance < r / 100.0) {
            s = db.getSlope(columnIndex, this.tolerance);
            if (s != DataBase.Slope.unspecified) {
                return s;
            }
            this.tolerance *= 2.0;
        }
        return DataBase.Slope.unspecified;
    }

    public String importData(String fname, String refColumn, List<String> dataColumns) {
        try {
            return this.importData(new File(fname), refColumn, dataColumns);
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
            return "File not found";
        }
    }

    private boolean isAbove(double v, double ref) {
        if (this.slope == DataBase.Slope.increasing) {
            return v > ref;
        }
        return v < ref;
    }

    private boolean isBelow(double v, double ref) {
        if (this.slope == DataBase.Slope.increasing) {
            return v < ref;
        }
        return v > ref;
    }

    private boolean isAboveEqual(double v, double ref) {
        if (this.slope == DataBase.Slope.increasing) {
            return v >= ref;
        }
        return v <= ref;
    }

    private boolean isBelowEqual(double v, double ref) {
        if (this.slope == DataBase.Slope.increasing) {
            return v <= ref;
        }
        return v >= ref;
    }

    private boolean inside(double v, double ref1, double ref2) {
        return this.isAboveEqual(v, ref1) && this.isBelowEqual(v, ref2);
    }

    public boolean addRowsBySlope() {
        int ii = 0;
        double scale = 0.0;
        int i = 0;
        while (i < this.db.rows()) {
            double ref = this.db.getValue(i, this.refColumnIndex);
            while (ii < this.importDB.rows() && this.isBelow(this.importDB.getValue(ii, this.importRefColumnIndex), ref)) {
                ++ii;
            }
            if (ii >= this.importDB.rows()) {
                return true;
            }
            double importRefBefore = this.importDB.getValue(ii > 0 ? ii - 1 : ii, this.importRefColumnIndex);
            double importRefAfter = this.importDB.getValue(ii, this.importRefColumnIndex);
            if (this.isBelowEqual(importRefBefore, ref) || i == 0 && this.inside(importRefBefore, ref, this.db.getValue(i + 1, this.refColumnIndex))) {
                scale = 1.0;
                if (Math.abs(importRefAfter - importRefBefore) > 1.0E-10) {
                    scale = (ref - importRefBefore) / (importRefAfter - importRefBefore);
                }
                DataRow row = this.db.getRow(i);
                DataRow importRowBefore = this.importDB.getRow(ii > 0 ? ii - 1 : ii);
                DataRow importRowAfter = this.importDB.getRow(ii);
                for (Column c : this.columns) {
                    double before = importRowBefore.getValue(c.importColumnIndex);
                    double after = importRowAfter.getValue(c.importColumnIndex);
                    double v = (after - before) * scale + before;
                    row.setValue(c.destColumnIndex, v);
                }
            }
            ++i;
        }
        if (scale > 0.5) {
            ++ii;
        }
        while (ii < this.importDB.rows()) {
            DataRow row = this.db.addRow(Double.NaN);
            DataRow importRow = this.importDB.getRow(ii);
            if (this.indexColumnIndex >= 0) {
                row.setValue(this.indexColumnIndex, this.db.getValue(this.db.rows() - 2, this.indexColumnIndex) + 1.0);
            }
            if (this.timeColumnIndex >= 0) {
                double dt = 1.0;
                if (this.importTimeColumnIndex >= 0 && ii > 0 && (dt = importRow.getValue(this.importTimeColumnIndex) - this.importDB.getValue(ii - 1, this.importTimeColumnIndex)) <= 0.001) {
                    dt = 1.0;
                }
                row.setValue(this.timeColumnIndex, this.db.getValue(this.db.rows() - 2, this.timeColumnIndex) + dt);
            }
            row.setValue(this.refColumnIndex, importRow.getValue(this.importRefColumnIndex));
            for (Column c : this.columns) {
                double v = importRow.getValue(c.importColumnIndex);
                row.setValue(c.destColumnIndex, v);
            }
            ++ii;
        }
        return true;
    }

    private boolean importTableBySlope(List<String> dataColumns) throws IOException {
        this.tolerance = 0.0;
        this.slope = this.getSlope(this.db, this.refColumnIndex);
        if (this.slope == DataBase.Slope.unspecified) {
            return this.errorCannotMatch();
        }
        if (this.slope != this.getSlope(this.importDB, this.importRefColumnIndex)) {
            return this.errorCannotMatch();
        }
        if (!this.setupColumnNames(dataColumns)) {
            return false;
        }
        double db0 = this.db.getValue(0, this.refColumnIndex);
        double dbx = this.db.getValue(this.db.rows() - 1, this.refColumnIndex);
        double imp0 = this.importDB.getValue(0, this.importRefColumnIndex);
        double impx = this.importDB.getValue(this.importDB.rows() - 1, this.importRefColumnIndex);
        if (this.slope == DataBase.Slope.increasing ? db0 > impx || dbx < imp0 : db0 < impx || dbx > imp0) {
            return this.errorNoOverlap();
        }
        return this.addRowsBySlope();
    }

    private boolean loadImportDataBase(File file, String refColumn) throws IOException {
        this.importDB = new DataBase();
        this.importDB.load(file);
        if (this.importDB.rows() < 2 || this.importDB.columns() < 2) {
            this.errorMessage = "Import database is empty or do not exist";
            return false;
        }
        this.importRefColumnIndex = this.importDB.header().getIndex(refColumn);
        if (this.importRefColumnIndex < 0) {
            return this.errorColumnNotFound("Import", refColumn);
        }
        return true;
    }

    private boolean loadTable(File file, String refColumn, List<String> dataColumns) throws IOException {
        String rc = refColumn;
        int ii = rc.indexOf(47);
        if (ii >= 0) {
            rc = rc.substring(0, ii);
        }
        boolean found = false;
        for (String n : dataColumns) {
            ii = n.indexOf(47);
            if (ii >= 0) {
                n = n.substring(0, ii);
            }
            if (!n.equalsIgnoreCase(rc)) continue;
            found = true;
        }
        if (!found) {
            dataColumns.add(0, refColumn);
        }
        int i = dataColumns.size() - 1;
        while (i >= 0) {
            if (dataColumns.get(i).equalsIgnoreCase("index") || dataColumns.get(i).equalsIgnoreCase("time")) {
                dataColumns.remove(i);
            }
            --i;
        }
        if (!this.loadImportDataBase(file, refColumn)) {
            return false;
        }
        this.columns = new ArrayList<Column>();
        this.db.addExtraColumn("index");
        if (this.importDB.header().getIndex("time") >= 0) {
            dataColumns.add(0, "time");
        }
        if (!this.setupColumnNames(dataColumns)) {
            return false;
        }
        int n = 0;
        while (n < this.importDB.rows()) {
            DataRow importRow = this.importDB.getRow(n);
            DataRow row = this.db.addRow();
            row.setValue(this.indexColumnIndex, (double)n);
            for (Column c : this.columns) {
                row.setValue(c.destColumnIndex, importRow.getValue(c.importColumnIndex));
            }
            ++n;
        }
        return true;
    }

    public String importData(File file, String refColumn, List<String> dataColumns) throws IOException {
        if (dataColumns.size() == 0) {
            return "No columns specified";
        }
        this.tolerance = 0.0;
        if (this.db.rows() == 0) {
            this.loadTable(file, refColumn, dataColumns);
        } else {
            this.importTable(file, refColumn, dataColumns);
        }
        this.db.format.assign();
        PopupFFTView.databaseModified();
        this.db.dataBaseTableModel.changeNotification();
        return this.errorMessage;
    }

    private String toLetters(List<SlopePoint> list) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < list.size()) {
            SlopePoint sp = list.get(i);
            sb.append(sp.asLetter());
            ++i;
        }
        return sb.toString();
    }

    private double defineTolerance(DataBase db, int column) {
        double max = -1.7976931348623157E308;
        double min = Double.MAX_VALUE;
        int i = 0;
        while (i < db.rows()) {
            double v = db.getValue(i, column);
            if (v > max) {
                max = v;
            }
            if (v < min) {
                min = v;
            }
            ++i;
        }
        return (max - min) * 0.1;
    }

    private List<SlopePoint> findSlopePoints(DataBase db, int column) {
        ArrayList<SlopePoint> list = new ArrayList<SlopePoint>();
        SlopePointType spt = SlopePointType.Undef;
        double vv = db.getValue(0, column);
        SlopePoint lastMax = null;
        SlopePoint lastMin = null;
        int i = 1;
        while (i < db.rows()) {
            double v = db.getValue(i, column);
            if (lastMax != null && spt != SlopePointType.Max && lastMax.value > v + this.tolerance) {
                list.add(lastMax);
                spt = SlopePointType.Max;
                lastMax = null;
            }
            if (lastMin != null && spt != SlopePointType.Min && lastMin.value < v - this.tolerance) {
                list.add(lastMin);
                spt = SlopePointType.Min;
                lastMin = null;
            }
            if (v > 0.0 && vv < 0.0 && spt == SlopePointType.Min) {
                list.add(new SlopePoint(i, SlopePointType.ZeroUp, v));
            }
            if (v < 0.0 && vv > 0.0 && spt == SlopePointType.Max) {
                list.add(new SlopePoint(i, SlopePointType.ZeroDown, v));
            }
            if (v > vv) {
                if (lastMax == null) {
                    lastMax = new SlopePoint(i, SlopePointType.Max, v);
                }
                if (v > lastMax.value) {
                    lastMax.value = v;
                    lastMax.index = i;
                }
            }
            if (v < vv) {
                if (lastMin == null) {
                    lastMin = new SlopePoint(i, SlopePointType.Min, v);
                }
                if (v < lastMin.value) {
                    lastMin.value = v;
                    lastMin.index = i;
                }
            }
            vv = v;
            ++i;
        }
        return list;
    }

    private boolean checkMatch(List<SlopePoint> ref, int refofs, List<SlopePoint> imp, int impofs, int len) {
        int i = 0;
        while (i < len) {
            if (ref.get((int)(refofs + i)).type != imp.get((int)(impofs + i)).type) {
                return false;
            }
            double vref = ref.get((int)(refofs + i)).value;
            double vimp = imp.get((int)(impofs + i)).value;
            if (vref < vimp - this.tolerance || vref > vimp + this.tolerance) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private MergeParams match(List<SlopePoint> ref, List<SlopePoint> imp) {
        String s;
        String sref = this.toLetters(ref);
        String simp = this.toLetters(imp);
        int refofs = -1;
        int impofs = -1;
        int matchLength = 0;
        if (simp.length() < 2 || sref.length() < 2) {
            return null;
        }
        int i = 0;
        while (i < sref.length() - 1) {
            s = sref.substring(i);
            if (simp.startsWith(s)) {
                if (!this.checkMatch(ref, i, imp, 0, s.length()) || !this.checkRatio(ref, i, imp, 0, s.length())) break;
                refofs = i;
                impofs = 0;
                matchLength = s.length();
                break;
            }
            ++i;
        }
        i = 0;
        while (i < simp.length() - 1) {
            s = simp.substring(i);
            if (sref.startsWith(s) && this.checkMatch(ref, 0, imp, i, s.length()) && this.checkRatio(ref, 0, imp, i, s.length())) {
                if (s.length() <= matchLength) break;
                refofs = 0;
                impofs = i;
                matchLength = s.length();
                break;
            }
            ++i;
        }
        if (matchLength > 0) {
            int n1 = ref.get((int)(refofs + matchLength - 1)).index - ref.get((int)refofs).index;
            int n2 = imp.get((int)(impofs + matchLength - 1)).index - imp.get((int)impofs).index;
            if (ref.get((int)refofs).type != imp.get((int)impofs).type) {
                return null;
            }
            double slope = (double)n2 / (double)n1;
            return new MergeParams(ref.get((int)refofs).index, imp.get((int)impofs).index, slope);
        }
        return null;
    }

    private boolean errorMissingValue(String db, int index) {
        this.errorMessage = "Missing value in " + db + " at column " + index + " import terminated";
        return false;
    }

    private boolean errorEmptyField(String db) {
        this.errorMessage = "Field name is missing in " + db;
        return false;
    }

    private boolean errorColumnNotFound(String db, String name) {
        this.errorMessage = "Column " + name + " not found in " + db;
        return false;
    }

    private boolean errorColumnNotCreated(String db, String name) {
        this.errorMessage = "Column " + name + " could not be created in " + db;
        return false;
    }

    private boolean errorNoOverlap() {
        this.errorMessage = "Current data and import data references do not overlap";
        return false;
    }

    private boolean errorCannotMatch() {
        this.errorMessage = "Cannot match reference column between current data and import data";
        return false;
    }

    private MergeParams findPatternMinMax() {
        List<SlopePoint> refList = this.findSlopePoints(this.db, this.refColumnIndex);
        List<SlopePoint> importList = this.findSlopePoints(this.importDB, this.importRefColumnIndex);
        return this.match(refList, importList);
    }

    private boolean importTable(File file, String refColumn, List<String> dataColumns) throws IOException {
        int jj;
        String importRefColumn = refColumn;
        int j = refColumn.indexOf(47);
        if (j >= 0) {
            importRefColumn = refColumn.substring(0, j);
            refColumn = refColumn.substring(j + 1);
        }
        this.refColumnIndex = this.db.header().getIndex(refColumn);
        int i = 0;
        while (i < this.db.rows()) {
            if (Double.isNaN(this.db.getValue(i, this.refColumnIndex))) {
                return this.errorMissingValue("Reference", i);
            }
            ++i;
        }
        if (this.refColumnIndex < 0) {
            return this.errorColumnNotFound("Reference", refColumn);
        }
        this.columns = new ArrayList<Column>();
        if (!this.loadImportDataBase(file, importRefColumn)) {
            return false;
        }
        i = 0;
        while (i < this.importDB.rows()) {
            if (Double.isNaN(this.importDB.getValue(i, this.importRefColumnIndex))) {
                return this.errorMissingValue("Import", i);
            }
            ++i;
        }
        this.tolerance = Math.min(this.defineTolerance(this.db, this.refColumnIndex), this.defineTolerance(this.importDB, this.importRefColumnIndex));
        MergeParams mp = this.findPatternMinMax();
        if (mp == null && (mp = this.findPatternRegular()) == null) {
            return this.importTableBySlope(dataColumns);
        }
        if (!this.setupColumnNames(dataColumns)) {
            return false;
        }
        double dt = 1.0;
        if (this.timeColumnIndex >= 0) {
            dt = (this.db.getValue(this.db.rows() - 1, this.timeColumnIndex) - this.db.getValue(0, this.timeColumnIndex)) / (double)this.db.rows();
        }
        int ii = 0;
        while ((jj = mp.getImportColumn(ii)) < this.importDB.rows()) {
            if (jj >= 0) {
                DataRow row;
                if (ii < this.db.rows() && jj < this.importDB.rows()) {
                    double importRefAfter;
                    row = this.db.getRow(ii);
                    double ref = row.getValue(this.refColumnIndex);
                    int jj0 = jj - 1;
                    if (jj0 < 0) {
                        jj0 = jj++;
                    }
                    DataRow importRowBefore = this.importDB.getRow(jj0);
                    DataRow importRowAfter = this.importDB.getRow(jj);
                    double importRefBefore = importRowBefore.getValue(this.importRefColumnIndex);
                    double scale = (ref - importRefBefore) / ((importRefAfter = importRowAfter.getValue(this.importRefColumnIndex)) - importRefBefore);
                    if (Double.isNaN(scale)) {
                        scale = 1.0;
                    } else if (scale < -1.0) {
                        scale = -1.0;
                    } else if (scale > 1.0) {
                        scale = 1.0;
                    }
                    for (Column c : this.columns) {
                        double before = importRowBefore.getValue(c.importColumnIndex);
                        double after = importRowAfter.getValue(c.importColumnIndex);
                        double v = (after - before) * scale + before;
                        row.setValue(c.destColumnIndex, v);
                    }
                } else {
                    if (jj >= this.importDB.rows()) break;
                    row = this.db.addRow(Double.NaN);
                    DataRow importRow = this.importDB.getRow(jj);
                    if (this.indexColumnIndex >= 0) {
                        row.setValue(this.indexColumnIndex, this.db.getValue(this.db.rows() - 2, this.indexColumnIndex) + 1.0);
                    }
                    if (this.timeColumnIndex >= 0) {
                        double t = this.db.getValue(this.db.rows() - 2, this.timeColumnIndex) + dt;
                        row.setValue(this.timeColumnIndex, t);
                    }
                    if (this.refColumnIndex != this.indexColumnIndex && this.refColumnIndex != this.timeColumnIndex) {
                        row.setValue(this.refColumnIndex, importRow.getValue(this.importRefColumnIndex));
                    }
                    for (Column c : this.columns) {
                        row.setValue(c.destColumnIndex, importRow.getValue(c.importColumnIndex));
                    }
                }
            }
            ++ii;
        }
        return true;
    }

    private int findImportRefValue(double value, int startIndex) {
        int foundIndex = -1;
        double dv = Double.MAX_VALUE;
        int i = startIndex;
        while (i < this.importDB.rows()) {
            double v = this.importDB.getValue(i, this.importRefColumnIndex);
            double dd = Math.abs(v - value);
            if (dd < dv) {
                foundIndex = i;
                dv = Math.abs(v - value);
            } else if (dd > dv && dd > this.tolerance && dv < this.tolerance) {
                return foundIndex;
            }
            ++i;
        }
        if (dv < this.tolerance) {
            return foundIndex;
        }
        return -1;
    }

    private void improveRefPoint(SlopePoint rsp, SlopePoint isp, int dir) {
        double delta = Math.abs(this.db.getValue(rsp.index, this.refColumnIndex) - this.importDB.getValue(isp.index, this.importRefColumnIndex));
        boolean improving = false;
        do {
            improving = false;
            double nextValue = this.db.getValue(rsp.index + dir, this.refColumnIndex);
            double d1 = Math.abs(nextValue - this.importDB.getValue(isp.index, this.importRefColumnIndex));
            if (!(d1 < delta)) continue;
            rsp.value = nextValue;
            rsp.index += dir;
            improving = true;
            delta = d1;
        } while (improving);
    }

    private List<SlopePoint> matchingList(List<SlopePoint> refList, int refStartPoint) {
        ArrayList<SlopePoint> importList = new ArrayList<SlopePoint>();
        int start = 0;
        int i = refStartPoint;
        while (i < refList.size()) {
            int n = this.findImportRefValue(refList.get((int)i).value, start);
            if (n < 0) break;
            double v = this.importDB.getValue(n, this.importRefColumnIndex);
            importList.add(new SlopePoint(n, SlopePointType.RefPoint, v));
            start = n + 1;
            ++i;
        }
        return importList;
    }

    private boolean checkRatio(List<SlopePoint> refList, int ofsref, List<SlopePoint> importList, int ofsImport, int n) {
        SlopePoint ref0 = refList.get(ofsref);
        SlopePoint imp0 = importList.get(ofsImport);
        Double slope = null;
        int i = 1;
        while (i + ofsref < refList.size() && i + ofsImport < importList.size() && i < n) {
            SlopePoint ref1 = refList.get(ofsref + i);
            SlopePoint imp1 = importList.get(ofsImport + i);
            int refn = ref1.index - ref0.index;
            int impn = imp1.index - imp0.index;
            double limit = 3.0 / (double)Math.min(refn, impn);
            if (slope == null) {
                slope = (double)impn / (double)refn;
            } else {
                double s1 = (double)impn / (double)refn;
                double s = s1 / slope;
                if (s < 1.0 - limit || s > 1.0 + limit) {
                    return false;
                }
            }
            ref0 = ref1;
            imp0 = imp1;
            ++i;
        }
        return true;
    }

    private MergeParams findPatternRegular() {
        ArrayList<SlopePoint> refList = new ArrayList<SlopePoint>();
        List<Object> importList = new ArrayList();
        Double vv = null;
        int i = 0;
        while (i < 100) {
            int index = i * (this.db.rows() - 1) / 99;
            double v = this.db.getValue(index, this.refColumnIndex);
            if (vv == null) {
                refList.add(new SlopePoint(index, SlopePointType.RefPoint, v));
                vv = v;
            } else if (v > vv + this.tolerance || v < vv - this.tolerance) {
                refList.add(new SlopePoint(index, SlopePointType.RefPoint, v));
                vv = v;
            }
            ++i;
        }
        if (refList.size() < 6) {
            return null;
        }
        i = 0;
        while (i < refList.size() - 3) {
            importList = this.matchingList(refList, i);
            if (importList.size() >= 3) {
                this.improveRefPoint((SlopePoint)refList.get(i), (SlopePoint)importList.get(0), 1);
                this.improveRefPoint((SlopePoint)refList.get(i + importList.size() - 1), (SlopePoint)importList.get(importList.size() - 1), -1);
                int j = 0;
                while (j < importList.size()) {
                    ++j;
                }
                if (!this.checkRatio(refList, i, importList, 0, importList.size())) {
                    return null;
                }
                int n1 = ((SlopePoint)refList.get((int)(i + importList.size() - 1))).index - ((SlopePoint)refList.get((int)i)).index;
                int n2 = ((SlopePoint)importList.get((int)(importList.size() - 1))).index - ((SlopePoint)importList.get((int)0)).index;
                double slope = (double)n2 / (double)n1;
                return new MergeParams(((SlopePoint)refList.get((int)i)).index, ((SlopePoint)importList.get((int)0)).index, slope);
            }
            ++i;
        }
        return null;
    }

    private class Column {
        String importName = null;
        String destName = null;
        int importColumnIndex = -1;
        int destColumnIndex = -1;
        int minNameIndex = 0;

        Column(String name) {
            int i = name.indexOf(47);
            if (i >= 0) {
                this.importName = name.substring(0, i);
                this.destName = name.substring(i + 1);
            } else {
                this.importName = name;
                this.destName = name;
            }
            while (((Importer)Importer.this).db.header.getIndex(String.valueOf(this.destName) + (this.minNameIndex == 0 ? "" : "_" + this.minNameIndex)) >= 0) {
                ++this.minNameIndex;
            }
            this.importColumnIndex = Importer.this.importDB.header().getIndex(this.importName);
        }

        public void adjustName(int n) {
            this.destName = String.valueOf(this.destName) + (n == 0 ? "" : "_" + n);
        }

        public void addName() {
            Importer.this.db.addExtraColumn(this.destName, Double.NaN);
            this.destColumnIndex = Importer.this.db.header().getIndex(this.destName);
        }

        public boolean isValid() {
            if (this.destName.isEmpty()) {
                return Importer.this.errorEmptyField("Reference");
            }
            if (this.importName.isEmpty()) {
                return Importer.this.errorEmptyField("Import");
            }
            if (this.importColumnIndex < 0) {
                return Importer.this.errorColumnNotFound("Import", this.importName);
            }
            if (this.destColumnIndex < 0) {
                return Importer.this.errorColumnNotCreated("Reference", this.destName);
            }
            return true;
        }

        public String toString() {
            return String.valueOf(this.importName) + "/" + this.destName + "  " + this.importColumnIndex + "/" + this.destColumnIndex;
        }
    }

    private class MergeParams {
        int refIndex = 0;
        int importIndex = 0;
        double indexSlope = 0.0;

        MergeParams(int refIndex, int importIndex, double indexSlope) {
            this.refIndex = refIndex;
            this.importIndex = importIndex;
            this.indexSlope = indexSlope;
        }

        public int getImportColumn(int index) {
            return (int)((double)(index - this.refIndex) * this.indexSlope + 0.5) + this.importIndex;
        }

        public String toString() {
            return String.valueOf(this.refIndex) + "  " + this.importIndex + "  " + this.indexSlope;
        }
    }

    private class SlopePoint {
        int index;
        SlopePointType type;
        double value;

        SlopePoint(int index, SlopePointType type, double value) {
            this.index = index;
            this.type = type;
            this.value = value;
        }

        public char asLetter() {
            switch (this.type) {
                case Max: {
                    return 'T';
                }
                case Min: {
                    return 'B';
                }
                case Undef: {
                    return '?';
                }
                case ZeroDown: {
                    return 'D';
                }
                case ZeroUp: {
                    return 'U';
                }
                case RefPoint: {
                    return 'R';
                }
            }
            return '?';
        }

        public String toString() {
            return "SlopePoint: " + this.index + "  " + (Object)((Object)this.type) + " " + StringUtil.formatDoubleEE(this.value);
        }
    }

    private static enum SlopePointType {
        Max,
        Min,
        ZeroDown,
        ZeroUp,
        Undef,
        RefPoint;

    }
}

