/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.database;

import dk.hkj.database.DataBase;
import dk.hkj.main.Support;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Header
implements Iterable<String> {
    private List<String> header = new ArrayList<String>();
    private List<String> filteredHeader = new ArrayList<String>();
    private Map<String, Integer> headerMap = new HashMap<String, Integer>();
    private DataBase db;
    private static String[] excludeColumns = new String[]{"index", "time", "timeStamp", "minutes", "localTime", "dateTime"};
    private static String[] timeColumns = new String[]{"time", "timeStamp", "localTime", "Math.time"};
    private static String[] indexColumns = new String[]{"index"};

    public Header(DataBase db) {
        this.db = db;
    }

    public String toString() {
        return this.header.toString();
    }

    public static boolean isExcludeColumn(String column) {
        String[] stringArray = excludeColumns;
        int n = excludeColumns.length;
        int n2 = 0;
        while (n2 < n) {
            String ss = stringArray[n2];
            if (ss.equalsIgnoreCase(column)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isTimeColumn(String column) {
        String[] stringArray = timeColumns;
        int n = timeColumns.length;
        int n2 = 0;
        while (n2 < n) {
            String ss = stringArray[n2];
            if (ss.equalsIgnoreCase(column)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isTimeColumn(int column) {
        return Header.isTimeColumn(this.getColumnName(column));
    }

    protected synchronized boolean addExtraColumn(String columnName) {
        if (this.headerMap.get(columnName) != null) {
            return false;
        }
        this.header.add(columnName);
        this.updateMap();
        return true;
    }

    public static boolean isIndexColumn(String column) {
        String[] stringArray = indexColumns;
        int n = indexColumns.length;
        int n2 = 0;
        while (n2 < n) {
            String ss = stringArray[n2];
            if (ss.equalsIgnoreCase(column)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public boolean isIndexColumn(int column) {
        return Header.isIndexColumn(this.getColumnName(column));
    }

    public int getTimeColumn() {
        int i = 0;
        while (i < this.header.size()) {
            String[] stringArray = timeColumns;
            int n = timeColumns.length;
            int n2 = 0;
            while (n2 < n) {
                String ss = stringArray[n2];
                if (ss.equalsIgnoreCase(this.header.get(i))) {
                    return i;
                }
                ++n2;
            }
            ++i;
        }
        return -1;
    }

    public int getDomainColumn() {
        int i = Support.dataBase.header().getTimeColumn();
        if (i < 0) {
            i = Support.dataBase.header().getIndexColumn();
        }
        return i;
    }

    public String getTimeColumnName() {
        int i = 0;
        while (i < this.header.size()) {
            String[] stringArray = timeColumns;
            int n = timeColumns.length;
            int n2 = 0;
            while (n2 < n) {
                String ss = stringArray[n2];
                if (ss.equalsIgnoreCase(this.header.get(i))) {
                    return ss;
                }
                ++n2;
            }
            ++i;
        }
        return "";
    }

    public int getIndexColumn() {
        int i = 0;
        while (i < this.header.size()) {
            String[] stringArray = indexColumns;
            int n = indexColumns.length;
            int n2 = 0;
            while (n2 < n) {
                String ss = stringArray[n2];
                if (ss.equalsIgnoreCase(this.header.get(i))) {
                    return i;
                }
                ++n2;
            }
            ++i;
        }
        return -1;
    }

    public String getIndexColumnName() {
        int i = 0;
        while (i < this.header.size()) {
            String[] stringArray = indexColumns;
            int n = indexColumns.length;
            int n2 = 0;
            while (n2 < n) {
                String ss = stringArray[n2];
                if (ss.equalsIgnoreCase(this.header.get(i))) {
                    return ss;
                }
                ++n2;
            }
            ++i;
        }
        return "";
    }

    public int[] getDataColumns() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < this.header.size()) {
            boolean exclude = false;
            String[] stringArray = excludeColumns;
            int n = excludeColumns.length;
            int n2 = 0;
            while (n2 < n) {
                String ss = stringArray[n2];
                if (ss.equalsIgnoreCase(this.header.get(i))) {
                    exclude = true;
                }
                ++n2;
            }
            if (!exclude) {
                list.add(i);
            }
            ++i;
        }
        int[] v = new int[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            v[i2] = (Integer)list.get(i2);
            ++i2;
        }
        return v;
    }

    public int[] getSystemColumns() {
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < this.header.size()) {
            boolean include = false;
            String[] stringArray = excludeColumns;
            int n = excludeColumns.length;
            int n2 = 0;
            while (n2 < n) {
                String ss = stringArray[n2];
                if (ss.equalsIgnoreCase(this.header.get(i))) {
                    include = true;
                }
                ++n2;
            }
            if (include) {
                list.add(i);
            }
            ++i;
        }
        int[] v = new int[list.size()];
        int i2 = 0;
        while (i2 < list.size()) {
            v[i2] = (Integer)list.get(i2);
            ++i2;
        }
        return v;
    }

    public List<String> getDataColumnsList() {
        ArrayList<String> list = new ArrayList<String>();
        int[] nArray = this.getDataColumns();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            list.add(this.getColumnName(i));
            ++n2;
        }
        return list;
    }

    public List<String> getSystemColumnsList() {
        ArrayList<String> list = new ArrayList<String>();
        int[] nArray = this.getSystemColumns();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            list.add(this.getColumnName(i));
            ++n2;
        }
        return list;
    }

    public List<String> getColumnsList() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(this.header);
        return list;
    }

    public String getHeaderLine() {
        char deli = this.db.getDelimeter();
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < this.header.size()) {
            if (sb.length() > 0) {
                sb.append(deli);
            }
            if (deli == '\t') {
                sb.append(this.header.get(i));
            } else {
                sb.append('\"');
                sb.append(this.header.get(i));
                sb.append('\"');
            }
            ++i;
        }
        return sb.toString();
    }

    protected void save(BufferedWriter bw) throws IOException {
        bw.write(this.getHeaderLine());
        bw.write("\r\n");
    }

    private String generateTitleRow() {
        StringBuilder sb = new StringBuilder();
        sb.append("// ");
        int i = 0;
        while (i < this.header.size()) {
            if (sb.length() > 3) {
                sb.append(", ");
            }
            sb.append(this.header.get(i));
            ++i;
        }
        sb.append("\n");
        return sb.toString();
    }

    protected void saveJavaInt(BufferedWriter bw) throws IOException {
        bw.write(this.generateTitleRow());
        bw.write("static final int data[][]={\n");
    }

    protected void saveJavaLong(BufferedWriter bw) throws IOException {
        bw.write(this.generateTitleRow());
        bw.write("static final long data[][]={\n");
    }

    protected void saveJavaFloat(BufferedWriter bw) throws IOException {
        bw.write(this.generateTitleRow());
        bw.write("static final float data[][]={\n");
    }

    protected void saveJavaDouble(BufferedWriter bw) throws IOException {
        bw.write(this.generateTitleRow());
        bw.write("static final double data[][]={\n");
    }

    private DataBase.FileFormat findFileFormat(String line) {
        boolean insideQuote = false;
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            switch (c) {
                case '\"': {
                    insideQuote = !insideQuote;
                    break;
                }
                case ';': {
                    if (!insideQuote) {
                        return DataBase.FileFormat.euro;
                    }
                }
                case '\t': {
                    if (insideQuote) break;
                    return DataBase.FileFormat.tab;
                }
            }
            ++i;
        }
        return DataBase.FileFormat.us;
    }

    protected void load(String line) {
        this.db.fileFormat = this.findFileFormat(line);
        char deli = this.db.getDelimeter();
        boolean insideQuote = false;
        int j = 0;
        int i = 0;
        while (i < line.length()) {
            char c = line.charAt(i);
            if (c == '\"') {
                boolean bl = insideQuote = !insideQuote;
            }
            if (!insideQuote && c == deli) {
                String s = line.substring(j, i).trim();
                if (s.length() > 0 && s.charAt(0) == '\"') {
                    s = s.substring(1, s.length() - 1);
                }
                this.header.add(s);
                j = i + 1;
            }
            ++i;
        }
        String s = line.substring(j).trim();
        if (s.length() > 0 && s.charAt(0) == '\"') {
            s = s.substring(1, s.length() - 1);
        }
        this.header.add(s);
        this.updateMap();
    }

    protected void load(BufferedReader br) throws IOException {
        this.load(br.readLine());
    }

    public Header(DataBase db, List<String> columnNames) {
        this.db = db;
        this.header.addAll(columnNames);
        this.updateMap();
    }

    public void clear() {
        this.header.clear();
        this.filteredHeader.clear();
        this.headerMap.clear();
    }

    public void addHeader(String columnName) {
        this.header.add(columnName);
        this.updateMap();
    }

    public void addHeaders(List<String> columnNames) {
        this.header.addAll(columnNames);
        this.updateMap();
    }

    private void updateMap() {
        this.headerMap.clear();
        this.filteredHeader.clear();
        int i = 0;
        while (i < this.header.size()) {
            this.headerMap.put(this.header.get(i), i);
            this.filteredHeader.add(Support.filterToIdentifierWithPoint(this.header.get(i)));
            ++i;
        }
        if (this.db != null) {
            this.db.formatChanged = true;
        }
    }

    public boolean isDigital(String name) {
        Integer i = this.headerMap.get(name);
        return i == null;
    }

    public int getIndex(String name) {
        Integer i = this.headerMap.get(name);
        if (i == null) {
            i = name.lastIndexOf(32);
            if (i >= 0) {
                i = this.headerMap.get(name.substring(0, i));
            }
            if (i == null) {
                return -1;
            }
        }
        return i;
    }

    public String getColumnName(int index) {
        if (index < 0) {
            return "SampleNo";
        }
        return this.header.get(index);
    }

    public String getColumnNameAsIdentifier(int index) {
        if (index < 0) {
            return "SampleNo";
        }
        return this.filteredHeader.get(index);
    }

    public int columns() {
        return this.header.size();
    }

    public List<String> getSections() {
        ArrayList<String> list = new ArrayList<String>();
        int[] nArray = this.getDataColumns();
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            String s = this.header.get(i);
            int j = s.indexOf(46);
            if (j >= 0) {
                s = s.substring(0, j);
                boolean found = false;
                for (String ss : list) {
                    if (!ss.equals(s)) continue;
                    found = true;
                    break;
                }
                if (!found) {
                    list.add(s);
                }
            }
            ++n2;
        }
        list.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        return list;
    }

    public List<String> getOptionalColumns(boolean withSections) {
        ArrayList<String> list = new ArrayList<String>();
        String index = this.getIndexColumnName();
        String time = this.getTimeColumnName();
        for (String column : this.header) {
            int j = column.indexOf(46);
            if (column.equals(time) || column.equals(index) || withSections && j >= 0) continue;
            list.add(column);
        }
        list.sort(new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        });
        if (withSections) {
            list.addAll(this.getSections());
        }
        return list;
    }

    @Override
    public Iterator<String> iterator() {
        return this.header.iterator();
    }
}

