/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.database;

import dk.hkj.database.DataBase;
import dk.hkj.database.Header;
import dk.hkj.main.DeviceInterface;
import dk.hkj.main.InterfaceThreads;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import java.util.ArrayList;
import java.util.List;

public class Format {
    private List<ValueFormat> valueFormats = new ArrayList<ValueFormat>();
    private DataBase db;

    protected Format(DataBase db) {
        this.db = db;
    }

    public void addFormat(ValueFormat format) {
        if (format == null) {
            throw new RuntimeException("null value format");
        }
        this.valueFormats.add(format);
    }

    public void clear() {
        this.valueFormats.clear();
    }

    public ValueFormat get(int column) {
        if (column < 0) {
            return new ValueFormat("Index", "", ValueFormat.formatInt);
        }
        if (column >= this.valueFormats.size()) {
            return new ValueFormat("", "", ValueFormat.formatD4);
        }
        return this.valueFormats.get(column);
    }

    public int justify(int column) {
        return this.get((int)column).format.justify();
    }

    public String formatDisplay(int column, double value) {
        return this.get((int)column).format.formatDisplay(value);
    }

    public String formatFile(int column, double value) {
        return this.get((int)column).format.formatFile(value);
    }

    public static ValueFormat findValueFormat(String name) {
        int i = name.lastIndexOf(95);
        if (i >= 0 && name.substring(i + 1).matches("[0-9]+")) {
            name = name.substring(0, i);
        }
        i = name.indexOf(46);
        String handle = "";
        if (i > 0) {
            handle = name.substring(0, i);
            ValueFormat vf = null;
            if (handle.equals("Math")) {
                vf = Support.math.getValueFormat(name.substring(i + 1));
            } else {
                List<DeviceInterface> dil = InterfaceThreads.findDeviceInterfaceListAnyHandle(handle);
                for (DeviceInterface di : dil) {
                    vf = di.getExistingValueFormat(name.substring(i + 1));
                    if (vf != null) break;
                }
            }
            if (vf != null) {
                return vf;
            }
        }
        if (Header.isTimeColumn(name)) {
            return new ValueFormat(name, "s", ValueFormat.formatTime);
        }
        if (Header.isIndexColumn(name)) {
            return new ValueFormat(name, "", ValueFormat.formatInt);
        }
        if (name.equals("dateTime")) {
            return new ValueFormat(name, "", ValueFormat.formatDateTime);
        }
        return new ValueFormat(name, "", ValueFormat.formatD2);
    }

    protected void addExtraColumn() {
        while (this.valueFormats.size() < this.db.header.columns()) {
            this.valueFormats.add(Format.findValueFormat(this.db.header.getColumnName(this.valueFormats.size())));
        }
    }

    public void assign() {
        this.clear();
        int i = 0;
        while (i < this.db.header().columns()) {
            this.valueFormats.add(Format.findValueFormat(this.db.header.getColumnName(i)));
            ++i;
        }
    }
}

