/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.database;

import dk.hkj.database.DataBase;
import dk.hkj.database.DataRow;
import dk.hkj.main.Main;
import dk.hkj.main.Support;
import dk.hkj.main.ValueFormat;
import dk.hkj.script.Script;
import dk.hkj.util.FileUtil;
import dk.hkj.util.StringUtil;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class Exporter
implements TableModel,
Iterable<ColumnExport> {
    private List<ColumnExport> columnExport = new ArrayList<ColumnExport>();
    private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private List<ColumnChangeListener> columnChangeListeners = new ArrayList<ColumnChangeListener>();
    private DataBase db = null;
    private DataBase.DataBaseRange range = Support.dataBase.getRange();
    private ReduceFormat reduceFormat = ReduceFormat.AllData;
    private int samples = 10000;
    private String firstEntry = "";
    private String lastEntry = "";
    private String changeColumn = "";
    private double changeValue = 0.0;
    private int domainColumn;
    private int outputRow = 0;
    private String formula = "";
    private static Exporter exporter = null;
    private Script script = null;
    private boolean formulaError = false;
    private final String deliReplacement = "#OROPERATOR#";
    private Column[] column;
    private static String[] exportFormatText = new String[]{"Full", "- Full", "Display", "Custom", "ymdhms", "ymd h:m:s", "ymd", "h:m:s", "Short", "System", "Long", "Split", "Split system", "Reindex"};

    public static synchronized Exporter getExporter() {
        if (exporter == null) {
            exporter = new Exporter(Support.dataBase, Support.dataBase.header().getDomainColumn());
        }
        return exporter;
    }

    public void addChangeListener(ColumnChangeListener arg0) {
        this.columnChangeListeners.add(arg0);
    }

    private void fireChange() {
        for (ColumnChangeListener l : this.columnChangeListeners) {
            l.update();
        }
    }

    public static synchronized void resetExporter() {
        exporter = null;
    }

    public String getFormatName(ExportFormat ef) {
        int i = 0;
        ExportFormat[] exportFormatArray = ExportFormat.values();
        int n = exportFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ExportFormat e = exportFormatArray[n2];
            if (e == ef) {
                return exportFormatText[i];
            }
            ++i;
            ++n2;
        }
        return "";
    }

    private String getFormat() {
        StringBuilder sb = new StringBuilder();
        sb.append("first:");
        sb.append(this.firstEntry);
        sb.append("|");
        sb.append("last:");
        sb.append(this.lastEntry);
        sb.append("|");
        sb.append("reduce:");
        sb.append(this.reduceFormat.name());
        sb.append("|");
        sb.append("samples:");
        sb.append(this.samples);
        sb.append("|");
        sb.append("column:");
        sb.append(this.changeColumn);
        sb.append("|");
        sb.append("change:");
        sb.append(this.changeValue);
        sb.append("|");
        sb.append("formula:");
        sb.append(this.formula.replace("|", "#OROPERATOR#"));
        sb.append("|");
        return sb.toString();
    }

    public void moveUp(int row) {
        if (row <= 0) {
            return;
        }
        ColumnExport ce = this.columnExport.remove(row - 1);
        this.columnExport.add(row, ce);
    }

    public void moveDown(int row) {
        if (row < 0 || row >= this.columnExport.size() - 1) {
            return;
        }
        ColumnExport ce = this.columnExport.remove(row);
        this.columnExport.add(row + 1, ce);
    }

    private void setFormat(String line) {
        for (Support.ConfigLineElement element : new Support.ConfigLineSplitter(line)) {
            if (element.name.equalsIgnoreCase("first")) {
                this.firstEntry = element.value.trim();
                continue;
            }
            if (element.name.equalsIgnoreCase("last")) {
                this.lastEntry = element.value.trim();
                continue;
            }
            if (element.name.equalsIgnoreCase("reduce")) {
                this.setReduceFormat(element.value.trim());
                continue;
            }
            if (element.name.equalsIgnoreCase("samples")) {
                this.samples = Integer.parseInt(element.value.trim());
                continue;
            }
            if (element.name.equalsIgnoreCase("column")) {
                this.changeColumn = element.value.trim();
                continue;
            }
            if (element.name.equalsIgnoreCase("change")) {
                this.changeValue = StringUtil.parseDoubleEE(element.value);
                continue;
            }
            if (!element.name.equalsIgnoreCase("formula")) continue;
            this.setFormula(element.value.replace("#OROPERATOR#", "|"));
        }
    }

    private boolean isExportColumn(String name) {
        for (ColumnExport ce : this.columnExport) {
            if (!ce.originalName.equals(name)) continue;
            return true;
        }
        return false;
    }

    public void adjustColumns() {
        int i = this.columnExport.size() - 1;
        while (i >= 0) {
            if (this.db.header().getIndex(this.columnExport.get((int)i).originalName) < 0) {
                this.columnExport.remove(i);
            }
            --i;
        }
        for (String columnName : this.db.header()) {
            if (this.isExportColumn(columnName)) continue;
            ColumnExport ce = new ColumnExport(columnName);
            ce.export = false;
            this.columnExport.add(ce);
        }
        this.changeNotification();
    }

    public String getFirstEntry() {
        return this.firstEntry;
    }

    public String getLastEntry() {
        return this.lastEntry;
    }

    public void setRange(String first, String last) {
        this.firstEntry = first;
        this.lastEntry = last;
        this.range = this.db.getRange(this.domainColumn, first, last);
    }

    public ReduceFormat getReduceFormat() {
        return this.reduceFormat;
    }

    public void setReduceFormat(ReduceFormat reduceFormat) {
        this.reduceFormat = reduceFormat;
    }

    public void setReduceFormat(String reduceFormat) {
        ReduceFormat[] reduceFormatArray = ReduceFormat.values();
        int n = reduceFormatArray.length;
        int n2 = 0;
        while (n2 < n) {
            ReduceFormat rf = reduceFormatArray[n2];
            if (rf.name().equalsIgnoreCase(reduceFormat)) {
                this.setReduceFormat(rf);
                return;
            }
            ++n2;
        }
    }

    public String getChangeColumn() {
        return this.changeColumn;
    }

    public void setChangeColumn(String column) {
        this.changeColumn = column;
    }

    public double getChangeValue() {
        return this.changeValue;
    }

    public void setChangeValue(double changeValue) {
        this.changeValue = Math.abs(changeValue);
    }

    public int getSamples() {
        return this.samples;
    }

    public void setFormula(String formula) {
        this.formula = formula == null ? "" : formula.trim();
    }

    public String getFormula() {
        return this.formula;
    }

    public boolean isFormulaError() {
        return this.formulaError;
    }

    public void setSamples(int samples) {
        if (samples < 10) {
            samples = 10;
        }
        this.samples = samples;
    }

    public double getActualTime() {
        return this.range.timespan();
    }

    public Exporter(DataBase db, int domainColumn) {
        this.db = db;
        this.domainColumn = domainColumn;
        for (String s : db.header()) {
            this.columnExport.add(new ColumnExport(s));
        }
    }

    public void setColumns(List<String> columns) {
        this.columnExport.clear();
        for (String s : columns) {
            if (s.endsWith(".")) {
                for (String ss : this.db.header().getDataColumnsList()) {
                    if (!ss.startsWith(s)) continue;
                    this.columnExport.add(new ColumnExport(ss));
                }
                continue;
            }
            if (this.db.header().getIndex(s) < 0) continue;
            this.columnExport.add(new ColumnExport(s));
        }
        this.changeNotification();
    }

    public void setColumnsExclude(List<String> columns) {
        for (String s : columns) {
            ColumnExport ce;
            if (s.endsWith(".")) {
                for (String ss : this.db.header().getDataColumnsList()) {
                    ColumnExport ce2;
                    if (!ss.startsWith(s) || (ce2 = this.getExportColumn(ss)) == null) continue;
                    ce2.export = false;
                }
                continue;
            }
            if (this.db.header().getIndex(s) < 0 || (ce = this.getExportColumn(s)) == null) continue;
            ce.export = false;
        }
        this.changeNotification();
    }

    public void setColumn(String name, String newName, String format, String customFormat) {
        if (this.db.header().getIndex(name) < 0) {
            return;
        }
        ColumnExport ce = this.getExportColumn(name);
        if (ce == null) {
            ce = new ColumnExport(name);
            this.columnExport.add(ce);
        }
        ce.exportName = newName != null ? newName : "";
        ce.setFormat(format);
        ce.customFormat = customFormat != null && ce.format.equals((Object)ExportFormat.Custom) ? customFormat : "";
        ce.export = true;
        this.changeNotification();
    }

    public void setReduceByAveraging1(int samples) {
        this.setReduceFormat(ReduceFormat.ReduceByAveraging);
        Exporter.getExporter().setSamples(samples);
    }

    public void setReduceOnChange1(String column, double change) {
        if (this.db.header().getIndex(column) < 0) {
            return;
        }
        this.setReduceFormat(ReduceFormat.ReduceOnChange);
        Exporter.getExporter().setChangeColumn(column);
        Exporter.getExporter().setChangeValue(change);
    }

    private ColumnExport getExportColumn(String name) {
        for (ColumnExport e : this.columnExport) {
            if (!e.getOriginalName().equals(name)) continue;
            return e;
        }
        return null;
    }

    private String getHeader() {
        StringBuilder sb = new StringBuilder();
        Column[] columnArray = this.column;
        int n = this.column.length;
        int n2 = 0;
        while (n2 < n) {
            Column c = columnArray[n2];
            if (sb.length() > 0) {
                sb.append(this.db.getDelimeter());
            }
            sb.append(c.getColumnName(this.db.getDelimeter() != '\t'));
            ++n2;
        }
        sb.append("\r\n");
        return sb.toString();
    }

    private String getData(int row) {
        StringBuilder sb = new StringBuilder();
        DataRow data = this.db.getRow(row);
        Column[] columnArray = this.column;
        int n = this.column.length;
        int n2 = 0;
        while (n2 < n) {
            Column c = columnArray[n2];
            if (sb.length() > 0) {
                sb.append(this.db.getDelimeter());
            }
            sb.append(c.getData(data));
            ++n2;
        }
        sb.append("\r\n");
        return sb.toString();
    }

    private void saveSampling(BufferedWriter bw) throws IOException {
        int first = this.range.getFirstIndex();
        int last = this.range.getLastIndex();
        long nn = last - first - 1;
        int n = (int)nn;
        if (n > this.samples) {
            n = this.samples;
        }
        int i = 0;
        while (i < n) {
            bw.append(this.getData((int)((long)first + (long)i * nn / (long)(n - 1))));
            ++this.outputRow;
            ++i;
        }
    }

    private void saveAveraging(BufferedWriter bw) throws IOException {
        int first = this.range.getFirstIndex();
        int last = this.range.getLastIndex();
        long nn = last - first;
        double[] buffer = new double[this.column.length];
        if ((long)this.samples > nn) {
            this.samples = (int)nn;
        }
        int avgCnt = 0;
        int saveLine = 1;
        int saveCnt = (int)((long)saveLine * nn / (long)this.samples) + first;
        int row = first;
        while (row < last) {
            DataRow data = this.db.getRow(row);
            int j = 0;
            while (j < this.column.length) {
                int n = j;
                buffer[n] = buffer[n] + data.getValue(this.column[j].index);
                ++j;
            }
            ++avgCnt;
            if (row >= saveCnt) {
                j = 0;
                while (j < this.column.length) {
                    if (j > 0) {
                        bw.append(this.db.getDelimeter());
                    }
                    bw.append(this.column[j].formatData(buffer[j] / (double)avgCnt));
                    buffer[j] = 0.0;
                    ++j;
                }
                bw.append("\r\n");
                ++this.outputRow;
                avgCnt = 0;
                saveCnt = (int)((long)(++saveLine) * nn / (long)this.samples) + first;
            }
            ++row;
        }
        if (avgCnt > 0) {
            int j = 0;
            while (j < this.column.length) {
                if (j > 0) {
                    bw.append(this.db.getDelimeter());
                }
                bw.append(this.column[j].formatData(buffer[j] / (double)avgCnt));
                buffer[j] = 0.0;
                ++j;
            }
            bw.append("\r\n");
        }
    }

    private void saveChanging(BufferedWriter bw) throws IOException {
        int first = this.range.getFirstIndex();
        int last = this.range.getLastIndex();
        long nn = last - first - 1;
        int n = (int)nn;
        int columnIndex = this.db.header().getIndex(this.changeColumn);
        if (columnIndex < 0) {
            return;
        }
        double vv = this.db.getValue(0, columnIndex) + this.changeValue * 10.0;
        int i = 0;
        while (i < n) {
            double v = this.db.getValue(i, columnIndex);
            if (Math.abs(v - vv) >= this.changeValue || i == n - 1) {
                vv = v;
                if (bw != null) {
                    bw.append(this.getData(first + i));
                }
                ++this.outputRow;
            }
            ++i;
        }
        if (bw != null) {
            bw.append(this.getData(n));
        }
        ++this.outputRow;
    }

    public boolean calcFormula(int row) {
        this.script.getLocalVars().clear();
        try {
            double[] data = Support.dataBase.getRow(row).getRow();
            int i = 0;
            while (i < Support.dataBase.header().columns()) {
                String name = Support.dataBase.header().getColumnNameAsIdentifier(i);
                double value = data[i];
                this.script.getLocalVars().getCreate(name).set(value);
                ++i;
            }
            return this.script.expression(this.formula).asBoolean();
        }
        catch (Exception exception) {
            this.formulaError = true;
            return false;
        }
    }

    private void saveFormula(BufferedWriter bw) throws IOException {
        if (this.script == null) {
            this.script = new Script();
        }
        this.formulaError = false;
        int first = this.range.getFirstIndex();
        int last = this.range.getLastIndex();
        long nn = last - first - 1;
        int n = (int)nn;
        int i = 0;
        while (i <= n) {
            if (this.calcFormula(first + i)) {
                if (bw != null) {
                    bw.append(this.getData(first + i));
                }
                ++this.outputRow;
            }
            ++i;
        }
    }

    public int getActualSamples() {
        ReduceFormat rf = this.reduceFormat;
        int max = this.range.getLastIndex() - this.range.getFirstIndex();
        if ((rf == ReduceFormat.ReduceBySampling || rf == ReduceFormat.ReduceByAveraging) && this.samples > max) {
            rf = ReduceFormat.AllData;
        }
        this.outputRow = 0;
        switch (rf) {
            case AllData: {
                return this.range.samples();
            }
            case ReduceBySampling: {
                return this.samples;
            }
            case ReduceByAveraging: {
                return this.samples;
            }
            case ReduceOnChange: {
                try {
                    this.saveChanging(null);
                }
                catch (IOException iOException) {}
                return this.outputRow;
            }
            case ReduceByFormula: {
                try {
                    this.saveFormula(null);
                }
                catch (IOException iOException) {}
                return this.outputRow;
            }
        }
        return 0;
    }

    public void export(File file) throws IOException {
        int n = 0;
        for (ColumnExport ce : this.columnExport) {
            if (!ce.export) continue;
            ++n;
        }
        this.column = new Column[n];
        n = 0;
        for (ColumnExport ce : this.columnExport) {
            if (!ce.export) continue;
            this.column[n++] = new Column(ce);
        }
        FileOutputStream os = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter(os);
        try (BufferedWriter bw = new BufferedWriter(osw, 32768);){
            bw.append(this.getHeader());
            ReduceFormat rf = this.reduceFormat;
            int max = this.range.getLastIndex() - this.range.getFirstIndex();
            if ((rf == ReduceFormat.ReduceBySampling || rf == ReduceFormat.ReduceByAveraging) && this.samples > max) {
                rf = ReduceFormat.AllData;
            }
            switch (rf) {
                case AllData: {
                    this.outputRow = 0;
                    int i = this.range.getFirstIndex();
                    while (i < this.range.getLastIndex()) {
                        bw.append(this.getData(i));
                        ++this.outputRow;
                        ++i;
                    }
                    break;
                }
                case ReduceBySampling: {
                    this.saveSampling(bw);
                    break;
                }
                case ReduceByAveraging: {
                    this.saveAveraging(bw);
                    break;
                }
                case ReduceOnChange: {
                    this.saveChanging(bw);
                }
                case ReduceByFormula: {
                    this.saveFormula(bw);
                }
            }
        }
    }

    public boolean canReload() {
        for (ColumnExport ce : this.columnExport) {
            if (ce.canReload()) continue;
            return false;
        }
        return true;
    }

    public boolean exportReload() {
        if (!this.canReload()) {
            return false;
        }
        try {
            File f = File.createTempFile("TestControllerExport", ".csv");
            try {
                this.export(f);
                this.db.load(f);
                Support.chartTitle = null;
                Support.math.disableAll();
                Main.changeDevicesOrTable(Support.UpdateType.ColumnsTable);
                Support.clearExporter();
            }
            finally {
                f.delete();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
    }

    public ColumnExport get(int no) {
        return this.columnExport.get(no);
    }

    @Override
    public void addTableModelListener(TableModelListener arg0) {
        this.listeners.add(arg0);
    }

    public void changeNotification() {
        for (TableModelListener ml : this.listeners) {
            ml.tableChanged(new TableModelEvent(this));
        }
    }

    @Override
    public Class<?> getColumnClass(int column) {
        switch (column) {
            case 0: {
                return String.class;
            }
            case 1: {
                return Boolean.class;
            }
            case 2: {
                return String.class;
            }
            case 3: {
                return JComboBox.class;
            }
            case 4: {
                return String.class;
            }
        }
        return null;
    }

    @Override
    public int getColumnCount() {
        return 5;
    }

    @Override
    public String getColumnName(int column) {
        switch (column) {
            case 0: {
                return "Column";
            }
            case 1: {
                return "Include";
            }
            case 2: {
                return "Export name";
            }
            case 3: {
                return "Format";
            }
            case 4: {
                return "Custom format";
            }
        }
        return null;
    }

    @Override
    public int getRowCount() {
        return this.columnExport.size();
    }

    @Override
    public Object getValueAt(int row, int column) {
        ColumnExport ce = this.columnExport.get(row);
        switch (column) {
            case 0: {
                return ce.originalName;
            }
            case 1: {
                return ce.export;
            }
            case 2: {
                return ce.exportName;
            }
            case 3: {
                return this.getFormatName(ce.format);
            }
            case 4: {
                return ce.format == ExportFormat.Custom ? ce.customFormat : "-";
            }
        }
        return null;
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        ColumnExport ce = this.columnExport.get(row);
        switch (column) {
            case 0: {
                return false;
            }
            case 1: {
                return true;
            }
            case 2: {
                return true;
            }
            case 3: {
                return true;
            }
            case 4: {
                return ce.format == ExportFormat.Custom;
            }
        }
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener arg0) {
        this.listeners.remove(arg0);
    }

    @Override
    public void setValueAt(Object value, int row, int column) {
        ColumnExport ce = this.columnExport.get(row);
        switch (column) {
            case 1: {
                ce.export = (Boolean)value;
                break;
            }
            case 2: {
                ce.exportName = ((String)value).trim();
                break;
            }
            case 3: {
                ce.setFormat((String)value);
                break;
            }
            case 4: {
                ce.customFormat = ((String)value).trim();
            }
        }
        this.fireChange();
    }

    @Override
    public Iterator<ColumnExport> iterator() {
        return this.columnExport.iterator();
    }

    public void saveFormatToFile(File file) {
        ArrayList<String> list = new ArrayList<String>();
        list.add(this.getFormat());
        for (ColumnExport ce : this.columnExport) {
            list.add(ce.toString());
        }
        try {
            FileUtil.writeFile(file, list);
        }
        catch (IOException iOException) {}
    }

    public void loadFormatFromFile(File file) {
        try {
            List<String> list = FileUtil.readFileAsList(file);
            this.columnExport.clear();
            for (String line : list) {
                if ((line = line.trim()).length() <= 0 || line.startsWith(";") || !line.contains("|")) continue;
                if (line.startsWith("first")) {
                    this.setFormat(line);
                    continue;
                }
                this.columnExport.add(new ColumnExport(line));
            }
            this.adjustColumns();
        }
        catch (IOException iOException) {}
    }

    public int includedColumns() {
        int n = 0;
        for (ColumnExport ce : this.columnExport) {
            if (!ce.export) continue;
            ++n;
        }
        return n;
    }

    public boolean isInSequence() {
        int i = 0;
        for (ColumnExport ce : this.columnExport) {
            int j = this.db.header().getIndex(ce.originalName);
            if (j < i) {
                return false;
            }
            i = j;
        }
        return true;
    }

    public int isNonDefault() {
        int n = 0;
        for (ColumnExport ce : this.columnExport) {
            if (!ce.export || ce.isDefault()) continue;
            ++n;
        }
        return n;
    }

    public List<String> generateScript() {
        StringBuilder sb;
        ArrayList<String> list = new ArrayList<String>();
        boolean allColumnFormats = false;
        boolean model = false;
        int col = this.db.header().columns();
        if (col == 0) {
            return list;
        }
        list.add("#ExportInit");
        if (this.includedColumns() == col && this.isInSequence() && this.isNonDefault() == 0) {
            list.add("#ExportColumns");
            allColumnFormats = true;
            model = true;
        } else if (this.includedColumns() <= col - 4 || !this.isInSequence()) {
            if (this.isNonDefault() > col / 3 || this.includedColumns() > 12) {
                list.add("#ExportColumns");
                allColumnFormats = true;
            } else {
                sb = new StringBuilder();
                for (ColumnExport ce : this.columnExport) {
                    if (!ce.export) continue;
                    if (sb.length() > 0) {
                        sb.append(' ');
                    }
                    sb.append(ce.originalName);
                }
                sb.insert(0, "#ExportColumns ");
                list.add(sb.toString());
            }
        } else if (this.includedColumns() != col) {
            sb = new StringBuilder();
            for (ColumnExport ce : this.columnExport) {
                if (ce.export) continue;
                if (sb.length() > 0) {
                    sb.append(' ');
                }
                sb.append(ce.originalName);
            }
            sb.insert(0, "#ExportColumnsExclude ");
            list.add(sb.toString());
        }
        for (ColumnExport ce : this.columnExport) {
            if (!ce.export || !allColumnFormats && ce.isDefault()) continue;
            list.add(ce.generateScript(model));
        }
        if (model || this.firstEntry.length() > 0 || this.lastEntry.length() > 0) {
            list.add("#ExportSamples " + Support.conditionalQuote(this.firstEntry) + " " + Support.conditionalQuote(this.lastEntry));
        }
        switch (this.reduceFormat) {
            case AllData: {
                if (!model) break;
                list.add("#ExportReduce " + this.reduceFormat.name());
                break;
            }
            case ReduceByAveraging: {
                list.add("#ExportReduce " + this.reduceFormat.name() + " " + this.samples);
                break;
            }
            case ReduceBySampling: {
                list.add("#ExportReduce " + this.reduceFormat.name() + " " + this.samples);
                break;
            }
            case ReduceOnChange: {
                list.add("#ExportReduce " + this.reduceFormat.name() + " " + this.changeColumn + " " + StringUtil.formatDoubleEE(this.changeValue, false));
                break;
            }
            case ReduceByFormula: {
                list.add("#ExportReduce " + this.reduceFormat.name() + " " + this.formula);
            }
        }
        list.add("#ExportTable myFileName");
        return list;
    }

    private class Column {
        int index;
        ColumnExport ce;
        char point;
        private DateFormat sdf;
        private DateFormat sdfSplit;
        private DecimalFormat df;

        Column(ColumnExport ce) {
            this.point = Exporter.this.db.getDecimalPoint();
            this.sdf = null;
            this.sdfSplit = null;
            this.df = null;
            this.index = Exporter.this.db.header().getIndex(ce.originalName);
            this.ce = ce;
            if (ce.format == ExportFormat.Custom) {
                if (ce.originalName.equalsIgnoreCase("dataTime")) {
                    this.sdf = new SimpleDateFormat(ce.customFormat);
                } else {
                    this.df = new DecimalFormat(ce.customFormat);
                    DecimalFormatSymbols dfs = this.df.getDecimalFormatSymbols();
                    dfs.setDecimalSeparator(this.point);
                    this.df.setDecimalFormatSymbols(dfs);
                }
            } else if (ce.format == ExportFormat.ymdhms) {
                this.sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            } else if (ce.format == ExportFormat.ymd_hms) {
                this.sdf = new SimpleDateFormat("yyyyMMdd HH:mm:ss");
            } else if (ce.format == ExportFormat.hms) {
                this.sdf = new SimpleDateFormat("HH:mm:ss");
            } else if (ce.format == ExportFormat.ymd) {
                this.sdf = new SimpleDateFormat("yyyyMMdd");
            } else if (ce.format == ExportFormat.SystemShort) {
                this.sdf = SimpleDateFormat.getDateTimeInstance(3, 3);
            } else if (ce.format == ExportFormat.System) {
                this.sdf = SimpleDateFormat.getDateTimeInstance(2, 2);
            } else if (ce.format == ExportFormat.SystemLong) {
                this.sdf = SimpleDateFormat.getDateTimeInstance(1, 1);
            } else if (ce.format == ExportFormat.Split) {
                this.sdf = new SimpleDateFormat("yyyyMMdd");
                this.sdfSplit = new SimpleDateFormat("HH:mm:ss");
            } else if (ce.format == ExportFormat.SplitSystem) {
                this.sdf = SimpleDateFormat.getDateInstance(2);
                this.sdfSplit = SimpleDateFormat.getTimeInstance(2);
            } else {
                ExportFormat cfr_ignored_0 = ce.format;
            }
        }

        public String getColumnName(boolean quote) {
            StringBuilder sb = new StringBuilder();
            if (this.ce.format == ExportFormat.Split || this.ce.format == ExportFormat.SplitSystem) {
                if (this.ce.isDigital()) {
                    ValueFormat.ValueFormatterDigital vfd = (ValueFormat.ValueFormatterDigital)((Exporter)Exporter.this).db.format().get((int)this.index).format;
                    int i = 0;
                    while (i < vfd.digitalValues()) {
                        if (vfd.getValueName(i) != null) {
                            if (i != 0) {
                                sb.append(Exporter.this.db.getDelimeter());
                            }
                            if (quote) {
                                sb.append("\"");
                            }
                            sb.append(this.ce.exportName.length() == 0 ? this.ce.originalName : this.ce.exportName);
                            sb.append(" ");
                            sb.append(vfd.getValueName(i));
                            if (quote) {
                                sb.append("\"");
                            }
                        }
                        ++i;
                    }
                } else if (this.ce.isDateTime()) {
                    if (quote) {
                        sb.append("\"");
                    }
                    sb.append("date");
                    if (quote) {
                        sb.append("\"");
                    }
                    sb.append(Exporter.this.db.getDelimeter());
                    if (quote) {
                        sb.append("\"");
                    }
                    sb.append("timeOfDay");
                    if (quote) {
                        sb.append("\"");
                    }
                }
            } else {
                if (quote) {
                    sb.append("\"");
                }
                sb.append(this.ce.exportName.length() == 0 ? this.ce.originalName : this.ce.exportName);
                if (quote) {
                    sb.append("\"");
                }
            }
            return sb.toString();
        }

        public String formatData(double data) {
            switch (this.ce.getFormat()) {
                case Full: {
                    String s = ((Exporter)Exporter.this).db.format.formatFile(this.index, data);
                    if (this.point != '.') {
                        s = s.replace('.', this.point);
                    }
                    return s;
                }
                case MinusFull: {
                    String s = ((Exporter)Exporter.this).db.format.formatFile(this.index, -data);
                    if (this.point != '.') {
                        s = s.replace('.', this.point);
                    }
                    return s;
                }
                case Reindex: {
                    return Integer.toString(Exporter.this.outputRow);
                }
                case Display: {
                    String s = ((Exporter)Exporter.this).db.format.formatDisplay(this.index, data);
                    if (this.point != '.') {
                        s = s.replace('.', this.point);
                    }
                    if (this.ce.isDigital()) {
                        s = "\"" + s.trim() + "\"";
                    }
                    return s;
                }
                case Custom: 
                case ymdhms: 
                case ymd_hms: 
                case ymd: 
                case hms: 
                case SystemShort: 
                case System: 
                case SystemLong: {
                    if (this.sdf != null) {
                        return this.sdf.format((long)(data * 1000.0));
                    }
                    if (this.df != null) {
                        return this.df.format(data);
                    }
                    return "";
                }
                case Split: 
                case SplitSystem: {
                    if (this.ce.isDigital()) {
                        ValueFormat.ValueFormatterDigital vfd = (ValueFormat.ValueFormatterDigital)((Exporter)Exporter.this).db.format().get((int)this.index).format;
                        StringBuilder sb = new StringBuilder();
                        int i = 0;
                        while (i < vfd.digitalValues()) {
                            if (vfd.getValueName(i) != null) {
                                long v = (long)data;
                                if (sb.length() > 0) {
                                    sb.append(Exporter.this.db.getDelimeter());
                                }
                                sb.append((v & (long)(1 << i)) != 0L ? 1 : 0);
                            }
                            ++i;
                        }
                        return sb.toString();
                    }
                    if (this.sdfSplit == null) break;
                    return String.valueOf(this.sdf.format((long)(data * 1000.0))) + Exporter.this.db.getDelimeter() + this.sdfSplit.format((long)(data * 1000.0));
                }
            }
            return "";
        }

        public String getData(DataRow data) {
            return this.formatData(data.getValue(this.index));
        }
    }

    public static interface ColumnChangeListener {
        public void update();
    }

    public class ColumnExport {
        String originalName;
        String exportName;
        boolean export;
        ExportFormat format;
        String customFormat;

        ColumnExport(String line) {
            if (line.contains("|")) {
                for (Support.ConfigLineElement element : new Support.ConfigLineSplitter(line)) {
                    if (element.name.equalsIgnoreCase("OriginalName")) {
                        this.originalName = element.value.trim();
                        continue;
                    }
                    if (element.name.equalsIgnoreCase("exportName")) {
                        this.exportName = element.value.trim();
                        continue;
                    }
                    if (element.name.equalsIgnoreCase("export")) {
                        this.export = !element.value.trim().equals("0");
                        continue;
                    }
                    if (element.name.equalsIgnoreCase("format")) {
                        this.setFormat(element.value.trim());
                        continue;
                    }
                    if (!element.name.equalsIgnoreCase("custom")) continue;
                    this.customFormat = element.value.trim();
                }
            } else {
                this.originalName = line;
                this.exportName = "";
                this.export = true;
                this.format = ExportFormat.Full;
                this.customFormat = "";
            }
        }

        public boolean isDefault() {
            return this.exportName.length() == 0 && this.format.equals((Object)ExportFormat.Full);
        }

        private boolean m(String originalName, String exportName) {
            if (exportName.length() == 0) {
                return true;
            }
            return originalName.equals(exportName);
        }

        public boolean canReload() {
            if (!this.export) {
                return true;
            }
            if (this.format.equals((Object)ExportFormat.Custom)) {
                return false;
            }
            if (this.originalName.equals("dateTime")) {
                return this.format.equals((Object)ExportFormat.Full) || this.format.equals((Object)ExportFormat.System) && this.m(this.originalName, this.exportName);
            }
            if (this.originalName.equals("time")) {
                return (this.format.equals((Object)ExportFormat.Full) || this.format.equals((Object)ExportFormat.Display)) && this.m(this.originalName, this.exportName);
            }
            if (this.originalName.equals("index")) {
                return this.m(this.originalName, this.exportName);
            }
            return !this.format.equals((Object)ExportFormat.Display) || !this.isDigital();
        }

        public String generateScript(boolean model) {
            StringBuilder sb = new StringBuilder();
            sb.append("#ExportColumn ");
            sb.append(this.originalName);
            if (model || this.exportName.length() > 0) {
                sb.append(' ');
                sb.append(Support.conditionalQuote(this.exportName));
            } else if (!this.format.equals((Object)ExportFormat.Full)) {
                sb.append(" \"\"");
            }
            if (model || !this.format.equals((Object)ExportFormat.Full)) {
                sb.append(' ');
                sb.append(this.format.name());
                if (this.format.equals((Object)ExportFormat.Custom)) {
                    sb.append(' ');
                    sb.append(Support.conditionalQuote(this.customFormat));
                }
            }
            return sb.toString();
        }

        public boolean isDigital() {
            int i = Exporter.this.db.header().getIndex(this.originalName);
            if (i < 0) {
                return false;
            }
            return ((Exporter)Exporter.this).db.format().get((int)i).format.digitalValues() > 0;
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public String getExportName() {
            return this.exportName;
        }

        public boolean isExport() {
            return this.export;
        }

        public ExportFormat getFormat() {
            return this.format;
        }

        public String getCustomFormat() {
            return this.customFormat;
        }

        public void setFormat(String value) {
            this.format = ExportFormat.Full;
            if (value == null || value.isEmpty()) {
                return;
            }
            int i = 0;
            ExportFormat[] exportFormatArray = ExportFormat.values();
            int n = exportFormatArray.length;
            int n2 = 0;
            while (n2 < n) {
                ExportFormat ef = exportFormatArray[n2];
                if (value.equalsIgnoreCase(ef.toString()) || value.equalsIgnoreCase(exportFormatText[i])) {
                    this.format = ef;
                    return;
                }
                ++i;
                ++n2;
            }
        }

        public boolean isDateTime() {
            return this.originalName.equals("dateTime");
        }

        public boolean isTime() {
            return this.originalName.equals("time");
        }

        public boolean isIndex() {
            return this.originalName.equals("index");
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("originalName:");
            sb.append(this.originalName);
            sb.append("|");
            sb.append("exportName:");
            sb.append(this.exportName);
            sb.append("|");
            sb.append("export:");
            sb.append(this.export ? 1 : 0);
            sb.append("|");
            sb.append("format:");
            sb.append(this.format.name());
            sb.append("|");
            sb.append("custom:");
            sb.append(this.customFormat);
            sb.append("|");
            return sb.toString();
        }
    }

    public static enum ExportFormat {
        Full,
        MinusFull,
        Display,
        Custom,
        ymdhms,
        ymd_hms,
        ymd,
        hms,
        SystemShort,
        System,
        SystemLong,
        Split,
        SplitSystem,
        Reindex;

    }

    public static enum ReduceFormat {
        AllData,
        ReduceBySampling,
        ReduceByAveraging,
        ReduceOnChange,
        ReduceByFormula;

    }
}

