/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.database;

import dk.hkj.database.DataBase;
import dk.hkj.util.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class DataRow {
    private double[] data;
    private DataBase db;
    private int rowIndex = -1;
    private static DateFormat df = null;

    protected DataRow(DataBase db, double fillValue) {
        this.db = db;
        this.data = new double[db.columns()];
        int i = 0;
        while (i < db.columns()) {
            this.data[i] = fillValue;
            ++i;
        }
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    void setRowIndex(int index) {
        this.rowIndex = index;
    }

    protected synchronized void addExtraColumn(double fillValue) {
        double[] newData = new double[this.data.length + 1];
        System.arraycopy(this.data, 0, newData, 0, this.data.length);
        newData[this.data.length] = fillValue;
        this.data = newData;
    }

    public void setAllValue(double value) {
        int i = 0;
        while (i < this.data.length) {
            this.data[i] = value;
            ++i;
        }
    }

    public String getDataRowLine() {
        StringBuilder sb = new StringBuilder();
        char deli = this.db.getDelimeter();
        char point = this.db.getDecimalPoint();
        int i = 0;
        while (i < this.data.length) {
            if (sb.length() > 0) {
                sb.append(deli);
            }
            String s = this.db.format.formatFile(i, this.data[i]);
            if (point != '.') {
                s = s.replace('.', point);
            }
            sb.append(s);
            ++i;
        }
        return sb.toString();
    }

    protected void save(BufferedWriter bw) throws IOException {
        bw.write(this.getDataRowLine());
        bw.write("\r\n");
    }

    protected void saveJavaInt(BufferedWriter bw, boolean last) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int i = 0;
        while (i < this.data.length) {
            long v;
            if (sb.length() > 1) {
                sb.append(",");
            }
            if ((v = Math.round(this.data[i])) > Integer.MAX_VALUE) {
                sb.append(Integer.MAX_VALUE);
            } else if (v < Integer.MIN_VALUE) {
                sb.append(Integer.MIN_VALUE);
            } else {
                sb.append((int)v);
            }
            ++i;
        }
        sb.append("}");
        if (!last) {
            sb.append(",");
        }
        sb.append("\n");
        bw.write(sb.toString());
    }

    protected void saveJavaLong(BufferedWriter bw, boolean last) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int i = 0;
        while (i < this.data.length) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            long v = Math.round(this.data[i]);
            sb.append((long)Math.round(v));
            sb.append("L");
            ++i;
        }
        sb.append("}");
        if (!last) {
            sb.append(",");
        }
        sb.append("\n");
        bw.write(sb.toString());
    }

    protected void saveJavaFloat(BufferedWriter bw, boolean last) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int i = 0;
        while (i < this.data.length) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append((float)this.data[i]);
            sb.append("F");
            ++i;
        }
        sb.append("}");
        if (!last) {
            sb.append(",");
        }
        sb.append("\n");
        bw.write(sb.toString());
    }

    protected void saveJavaDouble(BufferedWriter bw, boolean last) throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        int i = 0;
        while (i < this.data.length) {
            if (sb.length() > 1) {
                sb.append(",");
            }
            sb.append(this.data[i]);
            ++i;
        }
        sb.append("}");
        if (!last) {
            sb.append(",");
        }
        sb.append("\n");
        bw.write(sb.toString());
    }

    protected boolean load(String line) {
        char deli = this.db.getDelimeter();
        if (line == null) {
            return false;
        }
        String[] fields = line.split("" + deli);
        int i = 0;
        while (i < fields.length) {
            block9: {
                try {
                    this.data[i] = i == this.db.loadTimeDateColumn ? (double)df.parse(fields[i]).getTime() / 1000.0 : (i == this.db.loadTimeColumn ? StringUtil.parseHMS(fields[i]) : Double.parseDouble(fields[i].replace(',', '.')));
                }
                catch (Exception exception) {
                    this.data[i] = Double.NaN;
                    if (this.db.rows() == 0 && this.db.header().getIndex("dateTime") == i) {
                        try {
                            this.db.loadTimeDateColumn = this.db.header().getIndex("dateTime");
                            df = SimpleDateFormat.getDateTimeInstance(2, 2);
                            this.data[i] = (double)df.parse(fields[i]).getTime() / 1000.0;
                        }
                        catch (ParseException parseException) {
                            this.db.loadTimeDateColumn = -1;
                        }
                    }
                    if (this.db.loadTimeColumn >= 0 || !fields[i].contains(":") || this.db.header().getIndex("time") != i) break block9;
                    try {
                        this.db.loadTimeColumn = this.db.header().getIndex("time");
                        this.data[i] = StringUtil.parseHMS(fields[i]);
                    }
                    catch (Exception exception2) {
                        this.db.loadTimeDateColumn = -1;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    protected boolean load(BufferedReader br) throws IOException {
        return this.load(br.readLine());
    }

    public synchronized void setValue(int column, double value) {
        if (column < 0) {
            return;
        }
        this.data[column] = value;
    }

    public synchronized void setValue(String column, double value) {
        int c = this.db.header.getIndex(column);
        this.data[c] = value;
    }

    public synchronized double[] getRow() {
        return this.data;
    }

    public synchronized double getValue(int column) {
        if (column < 0) {
            return this.rowIndex;
        }
        if (column >= this.data.length) {
            return Double.NaN;
        }
        return this.data[column];
    }

    public synchronized double getValue(String column) {
        int c = this.db.header.getIndex(column);
        if (c >= this.data.length) {
            return Double.NaN;
        }
        return this.data[c];
    }
}

