/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.database;

import dk.hkj.database.DataBase;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableModel;

public class DataBaseTableModel
implements TableModel {
    private DataBase db;
    private List<TableModelListener> listeners = new ArrayList<TableModelListener>();
    private JTable table = null;
    private boolean includeChanged = false;
    private List<Integer> includeColumns = new ArrayList<Integer>();

    public DataBaseTableModel(DataBase db) {
        this.db = db;
    }

    private void resetIncludedColumns() {
        this.includeColumns.clear();
        int i = 0;
        while (i < this.db.columns()) {
            this.includeColumns.add(i);
            ++i;
        }
    }

    public void includeAllColumns() {
        this.resetIncludedColumns();
        this.includeChanged = true;
        this.changeNotification();
    }

    public void includeColumns(String headerMask) {
        this.includeColumns.clear();
        int i = 0;
        while (i < this.db.columns()) {
            if (this.db.header.getColumnName(i).matches(headerMask)) {
                this.includeColumns.add(i);
            }
            ++i;
        }
        this.includeChanged = true;
        this.changeNotification();
    }

    public void includeColumns(List<String> list) {
        this.includeColumns.clear();
        int i = 0;
        while (i < this.db.columns()) {
            String cname = this.db.header.getColumnName(i);
            boolean found = false;
            for (String s : list) {
                if (!s.equals(cname) && !cname.startsWith(String.valueOf(s) + ".")) continue;
                found = true;
                break;
            }
            if (found) {
                this.includeColumns.add(i);
            }
            ++i;
        }
        this.includeChanged = true;
        this.changeNotification();
    }

    public void setTable(JTable table) {
        this.table = table;
    }

    @Override
    public int getColumnCount() {
        return this.db == null ? 0 : this.includeColumns.size();
    }

    @Override
    public String getColumnName(int col) {
        if (col >= this.includeColumns.size()) {
            return "";
        }
        return this.db == null ? "" : this.db.header.getColumnName(this.includeColumns.get(col));
    }

    @Override
    public int getRowCount() {
        return this.db == null ? 0 : this.db.rows();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (col >= this.includeColumns.size()) {
            return 0;
        }
        return this.db == null ? "" : this.db.format.formatDisplay(this.includeColumns.get(col), this.db.getValue(row, this.includeColumns.get(col)));
    }

    @Override
    public void addTableModelListener(TableModelListener arg0) {
        this.listeners.add(arg0);
    }

    @Override
    public Class<?> getColumnClass(int col) {
        return String.class;
    }

    @Override
    public boolean isCellEditable(int arg0, int arg1) {
        return false;
    }

    @Override
    public void removeTableModelListener(TableModelListener arg0) {
        int i = this.listeners.size() - 1;
        while (i >= 0) {
            if (this.listeners.get(i) == arg0) {
                this.listeners.remove(i);
            }
            --i;
        }
    }

    @Override
    public void setValueAt(Object arg0, int arg1, int arg2) {
    }

    public void columnChanged(int column) {
        for (TableModelListener ml : this.listeners) {
            ml.tableChanged(new TableModelEvent(this, 0, this.db.rows() - 1));
        }
    }

    private void sendNotifications() {
        if (this.db.formatChanged) {
            this.db.formatChanged = false;
            this.resetIncludedColumns();
            for (TableModelListener ml : this.listeners) {
                ml.tableChanged(new TableModelEvent(this, -1));
            }
        }
        if (this.includeChanged) {
            this.includeChanged = false;
            for (TableModelListener ml : this.listeners) {
                ml.tableChanged(new TableModelEvent(this, -1));
            }
        }
        if (this.db.rows() > 0) {
            for (TableModelListener ml : this.listeners) {
                ml.tableChanged(new TableModelEvent(this, this.db.rows() - 1));
            }
        }
        if (this.table != null) {
            this.table.addNotify();
        }
    }

    public void changeNotification() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.sendNotifications();
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DataBaseTableModel.this.sendNotifications();
                }
            });
        }
    }
}

