/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.database;

import dk.hkj.database.DataBaseTableModel;
import dk.hkj.database.DataRow;
import dk.hkj.database.Format;
import dk.hkj.database.Header;
import dk.hkj.main.PopupChartLayout;
import dk.hkj.main.PopupFFTView;
import dk.hkj.main.Support;
import dk.hkj.util.StringUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class DataBase
implements Iterable<DataRow> {
    protected final int OPTIMIZE_LIMIT = 30000;
    protected Header header = new Header(this);
    protected Format format = new Format(this);
    private List<DataRow> dataRows = new ArrayList<DataRow>();
    protected DataBaseTableModel dataBaseTableModel = new DataBaseTableModel(this);
    protected boolean formatChanged = false;
    protected FileFormat fileFormat = DecimalFormatSymbols.getInstance().getDecimalSeparator() == ',' ? FileFormat.euro : FileFormat.us;
    protected int optimizeFactor = 0;
    protected int optimizeCount = 0;
    protected int loadTimeDateColumn = -1;
    protected int loadTimeColumn = -1;

    public FileFormat getFileFormat() {
        return this.fileFormat;
    }

    public String toString() {
        return "Columns: " + this.columns() + "  Rows: " + this.rows();
    }

    public void startOptimizer() {
        if (this.optimizeFactor != 0 || this.rows() > 0) {
            return;
        }
        this.optimizeFactor = 1;
        this.optimizeCount = 0;
    }

    public boolean isOptimizing() {
        return this.optimizeFactor > 1;
    }

    public Slope getSlope(int columnIndex) {
        if (this.rows() < 2) {
            return Slope.unspecified;
        }
        double tol = Math.abs(this.getValue(0, columnIndex) - this.getValue(this.rows() - 1, columnIndex)) / 500.0;
        return this.getSlope(columnIndex, tol);
    }

    public Slope getSlope(int columnIndex, double tol) {
        double vv = this.getValue(0, columnIndex);
        int n = this.rows();
        if (n > 30) {
            n = Math.min(200, this.rows() / 5);
        }
        if (n <= 1) {
            return Slope.unspecified;
        }
        if (Math.abs(this.getValue(this.rows() - 1, columnIndex) - vv) <= Math.abs(tol) * 99.0) {
            return Slope.unspecified;
        }
        Slope s = Slope.unspecified;
        int j = 0;
        int fail = 0;
        int i = 1;
        while (i < this.rows()) {
            double v = this.getValue(i, columnIndex);
            if (v > vv + tol) {
                if (s == Slope.decreasing) {
                    return Slope.unspecified;
                }
                s = Slope.increasing;
                vv = v;
                ++j;
            } else if (v < vv - tol) {
                if (s == Slope.increasing) {
                    return Slope.unspecified;
                }
                s = Slope.decreasing;
                vv = v;
                ++j;
            }
            if (i % n == 0) {
                if (j == 0) {
                    ++fail;
                }
                j = 0;
            }
            ++i;
        }
        return fail > n / 3 ? Slope.unspecified : s;
    }

    private synchronized boolean addExtraColumnInternal(String columnName, double fillValue) {
        if (this.header.addExtraColumn(columnName)) {
            int i = 0;
            while (i < this.rows()) {
                this.dataRows.get(i).addExtraColumn(fillValue);
                ++i;
            }
            this.format.addExtraColumn();
            this.formatChanged = true;
            return true;
        }
        return false;
    }

    public boolean addExtraColumn(String columnName) {
        if (this.addExtraColumnInternal(columnName, 0.0)) {
            PopupFFTView.databaseModified();
            this.dataBaseTableModel.changeNotification();
            return true;
        }
        return false;
    }

    public boolean addExtraColumn(String columnName, double fillValue) {
        if (this.addExtraColumnInternal(columnName, fillValue)) {
            PopupFFTView.databaseModified();
            this.dataBaseTableModel.changeNotification();
            return true;
        }
        return false;
    }

    public char getDelimeter() {
        if (this.fileFormat == FileFormat.euro) {
            return ';';
        }
        if (this.fileFormat == FileFormat.us) {
            return ',';
        }
        return '\t';
    }

    public char getDecimalPoint() {
        if (this.fileFormat == FileFormat.euro || this.fileFormat == FileFormat.ctab) {
            return ',';
        }
        if (this.fileFormat == FileFormat.us) {
            return '.';
        }
        return '.';
    }

    public void setFileFormat(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    public Header header() {
        return this.header;
    }

    public Format format() {
        return this.format;
    }

    private synchronized void clearInternal() {
        this.header.clear();
        this.format.clear();
        this.dataRows.clear();
        this.optimizeFactor = 0;
        this.optimizeCount = 0;
        this.formatChanged = true;
    }

    public void clear() {
        this.clearInternal();
        PopupFFTView.databaseModified();
        this.dataBaseTableModel.changeNotification();
    }

    public synchronized int columns() {
        return this.header.columns();
    }

    public synchronized int rows() {
        return this.dataRows.size();
    }

    public synchronized DataRow getRow(int row) {
        DataRow r = this.dataRows.get(row);
        r.setRowIndex(row);
        return r;
    }

    public synchronized DataRow getLastRow() {
        if (this.rows() == 0) {
            return null;
        }
        return this.getRow(this.rows() - 1);
    }

    public double getValue(int row, int column) {
        return this.dataRows.get(row).getValue(column);
    }

    public DataBaseTableModel getTableDataModel() {
        return this.dataBaseTableModel;
    }

    public void save(File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter(os);
        try (BufferedWriter bw = new BufferedWriter(osw, 32768);){
            this.header.save(bw);
            int i = 0;
            while (i < this.rows()) {
                this.dataRows.get(i).save(bw);
                ++i;
            }
        }
    }

    public void saveJavaInt(File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter(os);
        try (BufferedWriter bw = new BufferedWriter(osw, 32768);){
            this.header.saveJavaInt(bw);
            int i = 0;
            while (i < this.rows()) {
                this.dataRows.get(i).saveJavaInt(bw, i == this.rows() - 1);
                ++i;
            }
            bw.write("};\n");
        }
    }

    public void saveJavaLong(File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter(os);
        try (BufferedWriter bw = new BufferedWriter(osw, 32768);){
            this.header.saveJavaLong(bw);
            int i = 0;
            while (i < this.rows()) {
                this.dataRows.get(i).saveJavaLong(bw, i == this.rows() - 1);
                ++i;
            }
            bw.write("};\n");
        }
    }

    public void saveJavaFloat(File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter(os);
        BufferedWriter bw = new BufferedWriter(osw, 32768);
        try {
            this.header.saveJavaFloat(bw);
            int i = 0;
            while (i < this.rows()) {
                this.dataRows.get(i).saveJavaFloat(bw, i == this.rows() - 1);
                ++i;
            }
        }
        finally {
            bw.write("};\n");
            bw.close();
        }
    }

    public void saveJavaDouble(File file) throws IOException {
        FileOutputStream os = new FileOutputStream(file);
        OutputStreamWriter osw = new OutputStreamWriter(os);
        BufferedWriter bw = new BufferedWriter(osw, 32768);
        try {
            this.header.saveJavaDouble(bw);
            int i = 0;
            while (i < this.rows()) {
                this.dataRows.get(i).saveJavaDouble(bw, i == this.rows() - 1);
                ++i;
            }
        }
        finally {
            bw.write("};\n");
            bw.close();
        }
    }

    public void save(String fname) {
        try {
            this.save(new File(fname));
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
    }

    public void load(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        InputStreamReader isw = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isw, 32768);
        this.loadTimeDateColumn = -1;
        this.loadTimeColumn = -1;
        this.clear();
        try {
            this.header.load(br);
            boolean eof = false;
            do {
                DataRow dr;
                boolean bl = eof = !(dr = this.getNewRow()).load(br);
                if (eof) continue;
                this.addRowInternal(dr);
            } while (!eof);
        }
        finally {
            br.close();
        }
        this.format.assign();
        PopupFFTView.databaseModified();
        this.dataBaseTableModel.changeNotification();
        Support.paneChart.annotations.clear();
        Support.paneHistogram.annotations.clear();
        PopupChartLayout.closeAll();
    }

    public void initColumnNams(String columnNames) {
        this.loadTimeDateColumn = -1;
        this.loadTimeColumn = -1;
        this.clear();
        this.header.load(columnNames);
        this.format.assign();
        PopupFFTView.databaseModified();
        this.dataBaseTableModel.changeNotification();
    }

    public void loadFromList(List<String> data, String columnNames, boolean addIndex) {
        this.loadTimeDateColumn = -1;
        this.loadTimeColumn = -1;
        this.clear();
        if (data.size() == 0 || data.get(0).trim().isEmpty()) {
            return;
        }
        if (columnNames == null) {
            this.header.load(data.get(0));
            data.remove(0);
        } else {
            this.header.load(columnNames);
        }
        int n = 0;
        boolean eof = false;
        while (n < data.size()) {
            DataRow dr;
            String line = data.get(n++);
            if (addIndex) {
                line = String.valueOf(Integer.toString(n)) + this.getDelimeter() + line;
            }
            boolean bl = eof = !(dr = this.getNewRow()).load(line);
            if (eof) continue;
            this.addRowInternal(dr);
        }
        this.format.assign();
        PopupFFTView.databaseModified();
        this.dataBaseTableModel.changeNotification();
    }

    public void load(String fname) {
        try {
            this.load(new File(fname));
        }
        catch (IOException e) {
            e.printStackTrace(System.out);
        }
    }

    public synchronized DataRow addRow() {
        DataRow r = new DataRow(this, 0.0);
        this.addRowInternal(r);
        return r;
    }

    public synchronized DataRow addRow(double fillValue) {
        DataRow r = new DataRow(this, fillValue);
        this.addRowInternal(r);
        return r;
    }

    public DataRow getNewRow() {
        return new DataRow(this, 0.0);
    }

    public DataRow getNewRow(double fillValue) {
        return new DataRow(this, fillValue);
    }

    private synchronized void addRowInternal(DataRow dataRow) {
        dataRow.setRowIndex(this.rows());
        if (this.optimizeFactor > 0) {
            ++this.optimizeCount;
            if (this.optimizeCount >= this.optimizeFactor) {
                this.dataRows.add(dataRow);
                if (this.dataRows.size() > 30000) {
                    ArrayList<DataRow> newDataRows = new ArrayList<DataRow>();
                    int i = 0;
                    while (i < this.rows()) {
                        if (i % 3 == 0) {
                            newDataRows.add(this.dataRows.get(i));
                        }
                        ++i;
                    }
                    this.dataRows = newDataRows;
                    this.optimizeFactor *= 3;
                }
                this.optimizeCount = 0;
            }
        } else {
            this.dataRows.add(dataRow);
        }
    }

    public void addRow(DataRow dataRow) {
        this.addRowInternal(dataRow);
        this.dataBaseTableModel.changeNotification();
    }

    public synchronized double[] getColumn(int column) {
        if (column < 0) {
            return null;
        }
        double[] v = new double[this.dataRows.size()];
        int i = 0;
        while (i < this.dataRows.size()) {
            v[i] = this.dataRows.get(i).getValue(column);
            ++i;
        }
        return v;
    }

    public synchronized double[] getColumnRange(int first, int last, int column) {
        if (column < 0) {
            return null;
        }
        if (first >= last) {
            first = 0;
            last = this.rows();
        }
        if (first < 0) {
            first = 0;
        }
        if (last > this.rows()) {
            last = this.rows();
        }
        double[] v = new double[last - first];
        int i = 0;
        while (i < last - first) {
            v[i] = this.dataRows.get(i + first).getValue(column);
            ++i;
        }
        return v;
    }

    public synchronized double[] getColumnRange(DataBaseRange range, int column) {
        return this.getColumnRange(range.getFirstIndex(), range.getLastIndex(), column);
    }

    public double[] getColumn(String column) {
        return this.getColumn(this.header.getIndex(column));
    }

    public synchronized double[][] getSeriesFull(int[] index, int[] mask, double bitLow, double bitHigh) {
        double[][] series = new double[index.length][this.rows()];
        int i = 0;
        while (i < this.rows()) {
            DataRow dataRow = this.dataRows.get(i);
            int j = 0;
            while (j < index.length) {
                series[j][i] = mask[j] == 0 ? (index[j] < 0 ? (double)i : dataRow.getValue(index[j])) : (((int)dataRow.getValue(index[j]) & mask[j]) != 0 ? bitHigh : bitLow);
                ++j;
            }
            ++i;
        }
        return series;
    }

    public synchronized double[][] getSeriesRange(DataBaseRange range, int[] index, int[] mask, double bitLow, double bitHigh) {
        int last;
        int first = range.getFirstIndex();
        if (first >= (last = range.getLastIndex())) {
            first = 0;
            last = this.rows();
        }
        double[][] series = new double[index.length][last - first];
        int n = 0;
        int i = first;
        while (i < last) {
            DataRow dataRow = this.dataRows.get(i);
            int firstIndex = 0;
            if (index[0] < 0) {
                firstIndex = 1;
                series[0][n] = i;
            }
            int j = firstIndex;
            while (j < index.length) {
                series[j][n] = mask[j] == 0 ? (index[j] < 0 ? (double)i : dataRow.getValue(index[j])) : (((int)dataRow.getValue(index[j]) & mask[j]) != 0 ? bitHigh : bitLow);
                ++j;
            }
            ++n;
            ++i;
        }
        return series;
    }

    public synchronized double[][] getSeries(DataBaseRange range, int seriesSize, int[] index, int[] mask, double bitLow, double bitHigh) {
        int dataRange;
        int last;
        int first = range.getFirstIndex();
        if (first >= (last = range.getLastIndex())) {
            first = 0;
            last = this.rows();
        }
        int outputRange = dataRange = last - first;
        if (seriesSize > 0 && seriesSize < outputRange) {
            outputRange = seriesSize;
        }
        double[][] series = new double[index.length][outputRange];
        if (this.rows() == 0) {
            return series;
        }
        int n = 0;
        int iii = 0;
        while (iii < outputRange) {
            int s = (int)((long)iii * (long)dataRange / (long)outputRange) + first;
            DataRow dataRow = this.dataRows.get(s);
            int firstIndex = 0;
            if (index[0] < 0) {
                firstIndex = 1;
                series[0][n] = s;
            }
            int j = firstIndex;
            while (j < index.length) {
                series[j][n] = mask[j] == 0 ? (index[j] < 0 ? (double)s : dataRow.getValue(index[j])) : (((int)dataRow.getValue(index[j]) & mask[j]) != 0 ? bitHigh : bitLow);
                ++j;
            }
            ++n;
            ++iii;
        }
        return series;
    }

    public synchronized double[][] getSeries(DataBaseRange range, int seriesSize, List<String> columns, double bitLow, double bitHigh) {
        int[] index = new int[columns.size()];
        int[] mask = new int[columns.size()];
        int i = 0;
        while (i < columns.size()) {
            String name = columns.get(i);
            int j = name.indexOf(32);
            if (j >= 0) {
                index[i] = this.header.getIndex(name.substring(0, j));
                mask[i] = this.format.get((int)i).format.getMask(name.substring(j + 1));
            } else {
                index[i] = this.header.getIndex(name);
                mask[i] = 0;
            }
            ++i;
        }
        return this.getSeries(range, seriesSize, index, mask, bitLow, bitHigh);
    }

    public double[][] getSeries(DataBaseRange range, int seriesSize, String domainAxis, String rangeAxis, double bitLow, double bitHigh) {
        ArrayList<String> cols = new ArrayList<String>();
        cols.add(domainAxis);
        cols.add(rangeAxis);
        return this.getSeries(range, seriesSize, cols, bitLow, bitHigh);
    }

    public double[][] getSeries(DataBaseRange range, int seriesSize, int domainAxis, int rangeAxis, int mask, double bitLow, double bitHigh) {
        int[] index = new int[2];
        int[] maskA = new int[2];
        index[0] = domainAxis;
        index[1] = rangeAxis;
        maskA[0] = 0;
        maskA[1] = mask;
        return this.getSeries(range, seriesSize, index, maskA, bitLow, bitHigh);
    }

    public int findSampleIndex(int column, double value) {
        double dv1;
        boolean again;
        if (column < 0) {
            return (int)value;
        }
        int l = 0;
        int r = this.rows() - 1;
        int row = 0;
        while (l < r) {
            row = (l + r) / 2;
            double v = this.dataRows.get(row).getValue(column);
            if (v < value) {
                l = row + 1;
                continue;
            }
            if (v > value) {
                r = row - 1;
                continue;
            }
            return row;
        }
        if (row < 0) {
            row = 0;
        } else if (row >= this.rows()) {
            row = this.rows();
        }
        double dv = Math.abs(this.dataRows.get(row).getValue(column) - value);
        if (row > 1) {
            do {
                again = false;
                dv1 = Math.abs(this.dataRows.get(row - 1).getValue(column) - value);
                if (!(dv1 < dv)) continue;
                --row;
                dv = dv1;
                again = true;
            } while (again && row > 1);
        }
        if (row < this.rows() - 2) {
            do {
                again = false;
                dv1 = Math.abs(this.dataRows.get(row + 1).getValue(column) - value);
                if (!(dv1 < dv)) continue;
                ++row;
                dv = dv1;
                again = true;
            } while (again && row < this.rows() - 2);
        }
        return row;
    }

    public int findSampleIndex(String column, double value) {
        return this.findSampleIndex(this.header.getIndex(column), value);
    }

    public DataBaseRange getRange() {
        return new DataBaseRange();
    }

    public DataBaseRange getRange(int timeColumn, String first, String last) {
        return new DataBaseRange(timeColumn, first, last);
    }

    public DataBaseRange getRange(int first, int last) {
        return new DataBaseRange(first, last);
    }

    public DataBaseRange getRangePosition(int timeColumn, String first) {
        return new DataBaseRange(timeColumn, first);
    }

    @Override
    public Iterator<DataRow> iterator() {
        return this.dataRows.iterator();
    }

    public class DataBaseRange {
        protected double first;
        protected double last;
        protected int domainColumn = -1;
        protected DataBaseRangeType firstType;
        protected DataBaseRangeType lastType;

        DataBaseRange() {
            this.firstType = DataBaseRangeType.None;
            this.lastType = DataBaseRangeType.None;
            this.domainColumn = DataBase.this.header().getTimeColumn();
        }

        DataBaseRange(int domainColumn, String first) {
            this.lastType = DataBaseRangeType.None;
            this.domainColumn = domainColumn;
            if (first == null || first.length() == 0) {
                this.firstType = DataBaseRangeType.None;
            } else if (first.contains("#") || domainColumn < 0) {
                this.firstType = DataBaseRangeType.Samples;
                this.first = Double.parseDouble(first.replace("#", ""));
            } else {
                this.firstType = DataBaseRangeType.Time;
                this.first = StringUtil.parseHMS(first);
            }
        }

        DataBaseRange(int domainColumn, String first, String last) {
            this.domainColumn = domainColumn;
            if (first == null || first.trim().length() == 0) {
                this.firstType = DataBaseRangeType.None;
            } else if (first.contains("#") || domainColumn < 0) {
                this.firstType = DataBaseRangeType.Samples;
                this.first = Double.parseDouble(first.replace("#", "").trim());
            } else {
                this.firstType = DataBaseRangeType.Time;
                this.first = StringUtil.parseHMS(first);
            }
            if (last == null || last.trim().length() == 0) {
                this.lastType = DataBaseRangeType.None;
            } else if (last.contains("#") || domainColumn < 0) {
                if (last.contains("w")) {
                    this.last = Double.parseDouble(last.replace("#", "").replace("w", "").trim());
                    this.lastType = DataBaseRangeType.WidthSamples;
                } else {
                    this.last = Double.parseDouble(last.replace("#", "").trim());
                    this.lastType = DataBaseRangeType.Samples;
                }
            } else if (last.contains("w")) {
                this.last = StringUtil.parseHMS(last.replace("w", ""));
                this.lastType = DataBaseRangeType.WidthTime;
            } else {
                this.last = StringUtil.parseHMS(last);
                this.lastType = DataBaseRangeType.Time;
            }
        }

        DataBaseRange(int first, int last) {
            this.firstType = DataBaseRangeType.Samples;
            this.lastType = DataBaseRangeType.Samples;
            this.first = first;
            this.last = last;
            this.domainColumn = DataBase.this.header().getTimeColumn();
        }

        public int getFirstIndex() {
            switch (this.firstType) {
                case None: {
                    return 0;
                }
                case Time: {
                    int index = DataBase.this.findSampleIndex(this.domainColumn, this.first < 0.0 ? DataBase.this.getValue(DataBase.this.rows() - 1, this.domainColumn) + this.first : this.first);
                    if (index >= DataBase.this.rows() || index <= 0) {
                        index = 0;
                    }
                    return index;
                }
                case Samples: {
                    int index = (int)(this.first < 0.0 ? (double)DataBase.this.rows() + this.first : this.first);
                    if (index >= DataBase.this.rows() || index <= 0) {
                        index = 0;
                    }
                    return index;
                }
            }
            return 0;
        }

        private double getFirstTime() {
            switch (this.firstType) {
                case None: {
                    return 0.0;
                }
                case Time: {
                    return this.first < 0.0 ? DataBase.this.getValue(DataBase.this.rows() - 1, this.domainColumn) + this.first : this.first;
                }
                case Samples: {
                    return DataBase.this.getValue(this.getFirstIndex(), this.domainColumn);
                }
            }
            return 0.0;
        }

        public int getLastIndex() {
            switch (this.lastType) {
                case None: {
                    return DataBase.this.rows();
                }
                case Time: {
                    int index = DataBase.this.findSampleIndex(this.domainColumn, this.last < 0.0 ? DataBase.this.getValue(DataBase.this.rows() - 1, this.domainColumn) + this.last : this.last);
                    if (index >= DataBase.this.rows() || index <= 0) {
                        index = DataBase.this.rows();
                    }
                    return index;
                }
                case Samples: {
                    int index = (int)(this.last < 0.0 ? (double)DataBase.this.rows() + this.last : this.last);
                    if (index >= DataBase.this.rows() || index <= 0) {
                        index = DataBase.this.rows();
                    }
                    return index;
                }
                case WidthTime: {
                    int index = DataBase.this.findSampleIndex(this.domainColumn, this.last + this.getFirstTime()) + 1;
                    if (index >= DataBase.this.rows() || index <= 0) {
                        index = DataBase.this.rows();
                    }
                    return index;
                }
                case WidthSamples: {
                    int index = this.getFirstIndex() + (int)this.last + 1;
                    if (index >= DataBase.this.rows() || index <= 0) {
                        index = DataBase.this.rows();
                    }
                    return index;
                }
            }
            return DataBase.this.rows();
        }

        public int samples() {
            return this.getLastIndex() - this.getFirstIndex();
        }

        public double timespan() {
            return DataBase.this.getValue(this.getLastIndex() - 1, this.domainColumn) - DataBase.this.getValue(this.getFirstIndex(), this.domainColumn);
        }
    }

    private static enum DataBaseRangeType {
        None,
        Time,
        Samples,
        WidthTime,
        WidthSamples;

    }

    public static enum FileFormat {
        tab,
        euro,
        us,
        ctab;

    }

    public static enum Slope {
        unspecified,
        increasing,
        decreasing;

    }
}

