/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.csv;

import dk.hkj.csv.CSVLine;
import java.util.Arrays;

public class CSVSelect {
    private int[] columns = null;
    private CSVLine allColumnNames = null;

    public CSVSelect() {
    }

    public CSVSelect(String columns, CSVLine fields) {
        this.defineColumns(columns, fields);
    }

    private int indexOf(String name, CSVLine headers) {
        int i = 0;
        while (i < headers.size()) {
            if (name.trim().equalsIgnoreCase(((String)headers.get(i)).trim())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public void defineColumns(int[] columns) {
        this.allColumnNames = null;
        this.columns = columns;
    }

    public void defineColumns(String columns, CSVLine fields) {
        if (columns == null || fields == null) {
            return;
        }
        this.defineColumns(columns.split("[;,]"), fields);
    }

    public void defineColumns(String[] columns, CSVLine fields) {
        this.columns = new int[columns.length];
        int n = 0;
        this.allColumnNames = fields;
        int i = 0;
        while (i < columns.length) {
            this.columns[n] = this.indexOf(columns[i], fields);
            if (this.columns[n] >= 0) {
                ++n;
            }
            ++i;
        }
        this.columns = Arrays.copyOf(this.columns, n);
    }

    public CSVLine select(CSVLine fields) {
        if (this.columns == null || fields == null || fields.size() == 0) {
            return fields;
        }
        CSVLine selected = new CSVLine(this.columns.length);
        int i = 0;
        while (i < this.columns.length) {
            selected.add((String)fields.get(this.columns[i]));
            ++i;
        }
        return selected;
    }

    public CSVLine getAllColumnNames() {
        return this.allColumnNames;
    }

    public int size() {
        return this.columns == null ? 0 : this.columns.length;
    }
}

