/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.csv;

import dk.hkj.csv.CSVLine;

public class CSVParser {
    private char deli = '\u0000';
    private boolean trim = false;
    private char quote = (char)34;

    public CSVParser(char deli, char quote, boolean trim) {
        this.trim = trim;
        this.deli = deli;
        this.quote = quote;
    }

    public CSVParser(char deli, boolean trim) {
        this.trim = trim;
        this.deli = deli;
    }

    public CSVParser() {
    }

    public void setTrim(boolean trim) {
        this.trim = trim;
    }

    public boolean getTrim() {
        return this.trim;
    }

    public void setQuote(char quote) {
        this.quote = quote;
    }

    public char getQuote() {
        return this.quote;
    }

    public void setDeli(char deli) {
        this.deli = deli;
    }

    public char getDeli() {
        return this.deli;
    }

    public CSVLine parseLine(String line) {
        return this.parseLine(line, this.trim, this.deli);
    }

    private String parseNumber(String number) {
        if (this.deli != ';') {
            return number;
        }
        int i = 0;
        while (i < number.length()) {
            char c = number.charAt(i);
            if (!Character.isDigit(c) && c != '.' && c != ',' && c != '-') {
                return number;
            }
            ++i;
        }
        return number.replace(".", "").replace(',', '.');
    }

    private CSVLine parseLine(String line, boolean trim, char deli) {
        if (deli == '\u0000') {
            int semicolon = 0;
            int comma = 0;
            int point = 0;
            int tab = 0;
            int i = 0;
            while (i < line.length()) {
                switch (line.charAt(i)) {
                    case ',': {
                        ++comma;
                        break;
                    }
                    case ';': {
                        ++semicolon;
                        break;
                    }
                    case '.': {
                        ++point;
                        break;
                    }
                    case '\t': {
                        ++tab;
                    }
                }
                ++i;
            }
            int n = Math.max(comma, Math.max(semicolon, tab));
            deli = n == comma && semicolon >= n - 1 & semicolon > 0 && point == 0 ? (char)59 : (n == comma ? (char)44 : (n == semicolon ? (char)59 : (n == tab ? (char)9 : (char)59)));
            this.deli = deli;
        }
        CSVLine list = new CSVLine();
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < line.length()) {
            char c;
            if ((c = line.charAt(i++)) == this.quote && sb.length() == 0) {
                do {
                    if ((c = line.charAt(i++)) == this.quote) {
                        if (i >= line.length() || line.charAt(i) != this.quote) continue;
                        ++i;
                        sb.append(this.quote);
                        c = '\u0000';
                        continue;
                    }
                    sb.append(c);
                } while (i < line.length() && c != this.quote);
                continue;
            }
            if (c == deli) {
                String item = this.parseNumber(sb.toString());
                list.add(trim ? item.trim() : item);
                sb.setLength(0);
                continue;
            }
            sb.append(c);
        }
        if (sb.length() > 0) {
            String item = this.parseNumber(sb.toString());
            list.add(trim ? item.trim() : item);
        }
        return list;
    }

    public static String doubleChar(String str, char c) {
        int i = str.indexOf(c);
        if (i < 0) {
            return str;
        }
        return str;
    }
}

