/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.csv;

import dk.hkj.csv.CSVLine;

public class CSVGenerator {
    private char deli = (char)44;
    private char quote = (char)34;
    private boolean quoteNumbers = false;
    private boolean quoteText = false;
    private char decimalPoint = '\u0000';
    private StringBuilder sb = new StringBuilder();
    private String numberSet = "[,.-0-9]*";

    public CSVGenerator(char deli, char quote) {
        this.deli = deli;
        this.quote = quote;
    }

    public CSVGenerator(char deli) {
        this.deli = deli;
    }

    public CSVGenerator() {
    }

    public void setQuote(char quote) {
        this.quote = quote;
    }

    public char getQuote() {
        return this.quote;
    }

    public void setDeli(char deli) {
        this.deli = deli;
    }

    public char getDeli() {
        return this.deli;
    }

    public void setDecimalPoint(char decimalPoint) {
        this.decimalPoint = decimalPoint;
    }

    public char getDecimalPoint() {
        return this.decimalPoint;
    }

    public void setQuoteNumbers(boolean quoteNumbers) {
        this.quoteNumbers = quoteNumbers;
    }

    public boolean getQuoteNumbers() {
        return this.quoteNumbers;
    }

    public boolean getQuoteText() {
        return this.quoteText;
    }

    private void buildNumberSet() {
        this.numberSet = this.deli == ',' ? "[.-0-9]*" : "[.,-0-9]*";
    }

    public void setQuoteText(boolean quoteText) {
        this.quoteText = quoteText;
    }

    public String generate(CSVLine list) {
        return this.internalGenerate(list);
    }

    private boolean isNumber(String value) {
        return value.matches(this.numberSet);
    }

    private void append(String item) {
        if (this.sb.length() != 0) {
            this.sb.append(this.deli);
        }
        if (this.isNumber(item)) {
            if (this.quoteNumbers) {
                this.sb.append(this.quote);
            }
            if (this.decimalPoint != '\u0000' && this.decimalPoint != '.') {
                item = item.replace('.', this.decimalPoint);
            }
            if (this.decimalPoint != '\u0000' && this.decimalPoint != ',') {
                item = item.replace(',', this.decimalPoint);
            }
            this.sb.append(item);
            if (this.quoteNumbers) {
                this.sb.append(this.quote);
            }
        } else if (this.quoteText || item.indexOf(this.deli) >= 0 || item.indexOf(this.quote) >= 0) {
            this.sb.append(this.quote);
            item = item.replaceAll("[" + String.valueOf(this.quote) + "]", String.valueOf(String.valueOf(this.quote)) + String.valueOf(this.quote));
            this.sb.append(item);
            this.sb.append(this.quote);
        } else {
            this.sb.append(item);
        }
    }

    private String internalGenerate(CSVLine list) {
        this.sb.setLength(0);
        if (this.decimalPoint == this.deli) {
            throw new RuntimeException("Decimal point and delimeter must be different, they are both " + this.deli + " now");
        }
        for (String item : list) {
            this.append(item);
        }
        return this.sb.toString();
    }
}

