/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.csv;

import dk.hkj.csv.CSVDataParser;
import dk.hkj.csv.CSVLine;
import dk.hkj.csv.CSVParser;
import dk.hkj.csv.CSVSelect;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class CSVFile
implements Iterable<CSVLine> {
    private List<CSVLine> list;
    private CSVParser parser = null;

    public void setParser(CSVParser parser) {
        this.parser = parser;
    }

    public int loadFile(File file) throws IOException {
        return this.loadFile(file, null);
    }

    public int loadFile(File file, String fields) throws IOException {
        this.list = new ArrayList<CSVLine>();
        int n = 0;
        try (BufferedReader br = new BufferedReader(new FileReader(file), 131072);){
            CSVParser parser;
            if (this.parser == null) {
                this.parser = new CSVParser();
            }
            CSVLine dataFields = null;
            while (br.ready()) {
                dataFields = this.parser.parseLine(br.readLine());
                if (dataFields == null || dataFields.size() <= 0) continue;
                this.list.add(dataFields);
                ++n;
            }
            if (fields != null && fields.length() > 0 && (dataFields = (parser = new CSVParser()).parseLine(fields)) != null && dataFields.size() > 0) {
                this.list.add(0, dataFields);
                ++n;
            }
        }
        return n;
    }

    public CSVLine get(int index) {
        return this.list.get(index);
    }

    public int size() {
        return this.list.size();
    }

    public CSVFile getWithoutHeader() {
        CSVFile newList = new CSVFile();
        newList.list = new ArrayList<CSVLine>(this.list.size() - 1);
        int i = 0;
        while (i < this.list.size() - 1) {
            newList.list.add(this.list.get(i + 1));
            ++i;
        }
        return newList;
    }

    @Override
    public Iterator<CSVLine> iterator() {
        return this.list.iterator();
    }

    public void sortNumber(String columns, boolean decreasing) {
        CSVLine headers = this.list.get(0);
        this.list.remove(0);
        final CSVSelect select = new CSVSelect(columns, headers);
        final CSVDataParser parser = new CSVDataParser();
        Collections.sort(this.list, new Comparator<CSVLine>(){

            @Override
            public int compare(CSVLine o1, CSVLine o2) {
                double[] v1 = parser.parseToDouble(select.select(o1));
                double[] v2 = parser.parseToDouble(select.select(o2));
                int i = 0;
                while (i < v1.length) {
                    if (v1[i] > v2[i]) {
                        return 1;
                    }
                    if (v1[i] < v2[i]) {
                        return -1;
                    }
                    ++i;
                }
                return 0;
            }
        });
        this.list.add(0, headers);
    }

    public void sortString(String columns, boolean decreasing) {
        CSVLine headers = this.list.get(0);
        this.list.remove(0);
        final CSVSelect select = new CSVSelect(columns, headers);
        final CSVDataParser parser = new CSVDataParser();
        Collections.sort(this.list, new Comparator<CSVLine>(){

            @Override
            public int compare(CSVLine o1, CSVLine o2) {
                String[] v1 = parser.parseToString(select.select(o1));
                String[] v2 = parser.parseToString(select.select(o2));
                int i = 0;
                while (i < v1.length) {
                    int j = v1[i].compareToIgnoreCase(v2[i]);
                    if (j != 0) {
                        return j;
                    }
                    ++i;
                }
                return 0;
            }
        });
        this.list.add(0, headers);
    }
}

