/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.csv;

import dk.hkj.csv.CSVFile;
import dk.hkj.csv.CSVLine;
import dk.hkj.csv.CSVSelect;
import dk.hkj.script.Script;
import dk.hkj.vars.Var;
import java.util.Arrays;

public class CSVDataParser {
    char decimalPoint = '\u0000';
    private Script script = null;

    public char getDecimalPoint() {
        return this.decimalPoint;
    }

    public void setDecimalPoint(char decimalPoint) {
        this.decimalPoint = decimalPoint;
    }

    private void guessDecimalPoint(CSVLine fields) {
        int comma = 0;
        int point = 0;
        for (String s : fields) {
            int i = 0;
            while (i < s.length()) {
                switch (s.charAt(i)) {
                    case ',': {
                        ++comma;
                        break;
                    }
                    case '.': {
                        ++point;
                    }
                }
                ++i;
            }
        }
        this.decimalPoint = comma > point ? (char)44 : (char)46;
    }

    public double[] parseToDouble(CSVLine fields) {
        if (this.decimalPoint == '\u0000') {
            this.guessDecimalPoint(fields);
        }
        double[] data = new double[fields.size()];
        int i = 0;
        while (i < fields.size()) {
            String value = (String)fields.get(i);
            if (this.decimalPoint != '.' && this.decimalPoint != '\u0000') {
                value = value.replace(this.decimalPoint, '.');
            }
            value = value.replace(',', '.');
            data[i] = Double.valueOf(value);
            ++i;
        }
        return data;
    }

    public int[] parseToInt(CSVLine fields) {
        int[] data = new int[fields.size()];
        int i = 0;
        while (i < fields.size()) {
            String value = (String)fields.get(i);
            data[i] = Integer.valueOf(value);
            ++i;
        }
        return data;
    }

    public String[] parseToString(CSVLine fields) {
        String[] data = new String[fields.size()];
        int i = 0;
        while (i < fields.size()) {
            data[i] = (String)fields.get(i);
            ++i;
        }
        return data;
    }

    public double[][] parseToDouble(CSVFile list, CSVSelect select, String columnsFilter) {
        return this.parseToDouble(list, select, list.size(), columnsFilter);
    }

    private boolean isFilter(CSVLine entry, CSVLine headers, String filter) {
        int i = 0;
        while (i < headers.size()) {
            this.script.addLocalVar(Var.createValueAuto((String)headers.get(i), (String)entry.get(i)));
            ++i;
        }
        return this.script.expression(filter).asBoolean();
    }

    public double[][] parseToDouble(CSVFile list, CSVSelect select, int entries, String columnsFilter) {
        if (entries <= 0 || entries > list.size()) {
            entries = list.size();
        }
        Object data = new double[entries][];
        if (columnsFilter != null && columnsFilter.length() > 0) {
            this.script = new Script();
            int nn = 0;
            int n = 0;
            while (n < entries) {
                CSVLine fields = list.get(n);
                if (this.isFilter(fields, select.getAllColumnNames(), columnsFilter)) {
                    data[nn] = this.parseToDouble(select.select(fields));
                    ++nn;
                }
                ++n;
            }
            data = (double[][])Arrays.copyOf(data, nn);
        } else {
            int n = 0;
            while (n < entries) {
                CSVLine fields = list.get(n);
                data[n] = this.parseToDouble(select.select(fields));
                ++n;
            }
        }
        return data;
    }

    public double[][] parseToDoubleIgnoreEmpty(CSVFile list, CSVSelect select, int entries, String columnsFilter) {
        boolean noFilter;
        if (entries <= 0 || entries > list.size()) {
            entries = list.size();
        }
        Object data = new double[entries][];
        boolean bl = noFilter = columnsFilter == null || columnsFilter.length() == 0;
        if (!noFilter) {
            this.script = new Script();
        }
        int nn = 0;
        int n = 0;
        while (n < entries) {
            CSVLine allFields = list.get(n);
            CSVLine fields = select.select(allFields);
            boolean isEmpty = false;
            int i = 0;
            while (i < fields.size() && !isEmpty) {
                isEmpty = ((String)fields.get(i)).trim().length() == 0;
                ++i;
            }
            if (!isEmpty && (noFilter || this.isFilter(allFields, select.getAllColumnNames(), columnsFilter))) {
                data[nn] = this.parseToDouble(fields);
                ++nn;
            }
            ++n;
        }
        data = (double[][])Arrays.copyOf(data, nn);
        return data;
    }

    public int[][] parseToInt(CSVFile list, CSVSelect select) {
        int[][] data = new int[list.size()][];
        int n = 0;
        for (CSVLine fields : list) {
            data[n] = this.parseToInt(select.select(fields));
            ++n;
        }
        return data;
    }

    public String[][] parseToString(CSVFile list, CSVSelect select) {
        String[][] data = new String[list.size()][];
        int n = 0;
        for (CSVLine fields : list) {
            data[n] = this.parseToString(select.select(fields));
            ++n;
        }
        return data;
    }

    public double[][] parseToDouble(CSVFile list, String columns, String columnsFilter) {
        return this.parseToDouble(list.getWithoutHeader(), new CSVSelect(columns, list.get(0)), columnsFilter);
    }

    public double[][] parseToDouble(CSVFile list, String columns, int entries, String columnsFilter) {
        return this.parseToDouble(list.getWithoutHeader(), new CSVSelect(columns, list.get(0)), entries, columnsFilter);
    }

    public double[][] parseToDoubleIgnoreEmpty(CSVFile list, String columns, String columnsFilter) {
        return this.parseToDoubleIgnoreEmpty(list.getWithoutHeader(), new CSVSelect(columns, list.get(0)), 0, columnsFilter);
    }

    public double[][] parseToDoubleIgnoreEmpty(CSVFile list, String columns, int entries, String columnsFilter) {
        return this.parseToDoubleIgnoreEmpty(list.getWithoutHeader(), new CSVSelect(columns, list.get(0)), entries, columnsFilter);
    }

    public int[][] parseToInt(CSVFile list, String columns) {
        return this.parseToInt(list.getWithoutHeader(), new CSVSelect(columns, list.get(0)));
    }

    public String[][] parseToString(CSVFile list, String columns) {
        return this.parseToString(list.getWithoutHeader(), new CSVSelect(columns, list.get(0)));
    }

    public double[][] smoothValue(double[][] source, int index, int avgPoints) {
        if (source == null || source.length == 0 || source[0] == null || source[0].length == 0) {
            return source;
        }
        double[][] dest = new double[source.length][source[0].length];
        int n = avgPoints / 2;
        if (n == 0) {
            ++n;
        }
        int j = 0;
        while (j < source[0].length) {
            int i;
            if (j == index) {
                i = 0;
                while (i < source.length) {
                    double sum = 0.0;
                    int x = 0;
                    int k = i - n;
                    while (k <= i + n) {
                        if (k >= 0 && k < source.length) {
                            sum += source[k][j];
                            ++x;
                        }
                        ++k;
                    }
                    dest[i][j] = sum / (double)x;
                    ++i;
                }
            } else {
                i = 0;
                while (i < source.length) {
                    dest[i][j] = source[i][j];
                    ++i;
                }
            }
            ++j;
        }
        return dest;
    }

    public double[][] swapArray(double[][] source) {
        if (source == null || source.length == 0 || source[0] == null || source[0].length == 0) {
            return source;
        }
        double[][] dest = new double[source[0].length][source.length];
        int i = 0;
        while (i < source.length) {
            int j = 0;
            while (j < source[0].length) {
                dest[j][i] = source[i][j];
                ++j;
            }
            ++i;
        }
        return dest;
    }
}

