/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.comm;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.LXIInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.main.Support;
import dk.hkj.util.CharacterEscapes;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class VXI11Discovery {
    static final int RPC_PORT = 111;
    private DatagramSocket socket = null;
    private List<Device> devices = null;
    private Set<DeviceQuery> addressQueryInProgress = Collections.synchronizedSet(new HashSet());
    private Set<String> addressFound = Collections.synchronizedSet(new HashSet());
    static byte[] rpc_GETPORT;

    static {
        byte[] byArray = new byte[56];
        byArray[2] = 3;
        byArray[3] = -24;
        byArray[11] = 2;
        byArray[13] = 1;
        byArray[14] = -122;
        byArray[15] = -96;
        byArray[19] = 2;
        byArray[23] = 3;
        byArray[41] = 6;
        byArray[42] = 7;
        byArray[43] = -81;
        byArray[47] = 1;
        byArray[51] = 6;
        rpc_GETPORT = byArray;
    }

    public synchronized String findDeviceAddress(String id, String serialNumber) {
        id = id.toLowerCase();
        serialNumber = (serialNumber = serialNumber.toLowerCase().trim()).startsWith("sn:") ? serialNumber.substring(3).trim() : null;
        String[] s = id.split("[,]");
        String manufacturer = s[0].trim().toLowerCase();
        String model = s[1].trim().toLowerCase();
        for (Device d : this.devices) {
            if (!manufacturer.toLowerCase().contains(d.manufacturer.toLowerCase()) || !model.toLowerCase().contains(d.model.toLowerCase())) continue;
            if (serialNumber != null && serialNumber.length() > 0) {
                if (!serialNumber.equalsIgnoreCase(d.serialNumber)) continue;
                this.devices.remove(d);
                return d.address;
            }
            this.devices.remove(d);
            return d.address;
        }
        return "";
    }

    private void poll() {
        try {
            DatagramPacket p = new DatagramPacket(rpc_GETPORT, rpc_GETPORT.length);
            p.setPort(111);
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            ArrayList<InetAddress> iaList = new ArrayList<InetAddress>();
            while (interfaces.hasMoreElements()) {
                NetworkInterface networkInterface = interfaces.nextElement();
                try {
                    if (networkInterface.isLoopback()) continue;
                    if (!networkInterface.isUp()) {
                    }
                }
                catch (SocketException socketException) {}
                continue;
                for (InterfaceAddress ifa : networkInterface.getInterfaceAddresses()) {
                    InetAddress ia = ifa.getBroadcast();
                    if (ia == null) continue;
                    iaList.add(ia);
                    p.setAddress(ia);
                    try {
                        this.socket.send(p);
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        catch (SocketException socketException) {}
    }

    public synchronized void resetDiscovery() {
        this.devices = null;
    }

    public synchronized void discover() {
        if (this.devices != null) {
            return;
        }
        try {
            this.devices = Collections.synchronizedList(new ArrayList());
            this.socket = new DatagramSocket(null);
            this.socket.setReceiveBufferSize(10000);
            this.socket.setBroadcast(true);
            this.poll();
            CommInterface.sleep(50);
            this.poll();
            CommInterface.sleep(50);
            this.poll();
            while (true) {
                byte[] buf = new byte[1000];
                DatagramPacket p = new DatagramPacket(buf, buf.length);
                this.socket.setSoTimeout(1000);
                this.socket.receive(p);
                if (p.getLength() < 28) continue;
                int b = p.getData()[26] | p.getData()[27];
                String address = ((InetSocketAddress)p.getSocketAddress()).getAddress().getHostAddress();
                if (b == 0 || this.addressFound.contains(address)) continue;
                this.addressFound.add(address);
                this.addressQueryInProgress.add(new DeviceQuery(address));
            }
        }
        catch (SocketException socketException) {
        }
        catch (IOException iOException) {}
        long time = System.currentTimeMillis() + 2000L;
        while (this.addressQueryInProgress.size() > 0 && System.currentTimeMillis() < time) {
            CommInterface.sleep(50);
        }
        this.socket.close();
    }

    public synchronized List<String> getDeviceList(String filter) {
        ArrayList<String> list = new ArrayList<String>();
        this.resetDiscovery();
        this.discover();
        for (Device d : this.devices) {
            if (filter != null && filter.length() != 0 && !d.id.toLowerCase().contains(filter.toLowerCase())) continue;
            list.add(String.valueOf(d.address) + "\t" + d.toString() + (d.getDeviceDefinition() != null ? "\t\tSupported" : ""));
        }
        list.sort(null);
        return list;
    }

    public synchronized List<Device> getDevices() {
        this.resetDiscovery();
        this.discover();
        return this.devices;
    }

    public synchronized void listDevices() {
        this.resetDiscovery();
        this.discover();
        for (Device d : this.devices) {
            System.out.println(String.valueOf(d.address) + "  " + d.toString());
        }
    }

    public class Device {
        String id;
        String manufacturer;
        String model;
        String serialNumber;
        String version;
        String address;

        Device(String address, String id) {
            this.address = address;
            this.id = id;
            String[] s = id.split("[,]");
            this.manufacturer = s[0].trim();
            this.model = s[1].trim();
            this.serialNumber = s[2].trim();
            this.version = s[3].trim();
        }

        Device(String address, String manufacturer, String model, String serial, String version) {
            this.address = address;
            this.manufacturer = manufacturer.trim();
            this.model = model.trim();
            this.serialNumber = serial.trim();
            this.version = version.trim();
            this.id = String.valueOf(this.manufacturer) + ", " + this.model + ", " + this.serialNumber + ", " + this.version;
        }

        public ManageDeviceDefinitions.DeviceDefinition getDeviceDefinition() {
            List<ManageDeviceDefinitions.PortType> list;
            ManageDeviceDefinitions.DeviceDefinition def = Support.manageDeviceDefinitions.findDeviceDefintionFromManufacturerModel(this.manufacturer, this.model);
            if (def != null && ((list = def.getPortList()).contains((Object)ManageDeviceDefinitions.PortType.LXI) || list.contains((Object)ManageDeviceDefinitions.PortType.Socket))) {
                return def;
            }
            return null;
        }

        public ManageDeviceDefinitions.DeviceDefinition getDeviceDefinition(String manufacturer, String model) {
            List<ManageDeviceDefinitions.PortType> list;
            ManageDeviceDefinitions.DeviceDefinition def = Support.manageDeviceDefinitions.findDeviceDefintionFromManufacturerModel(manufacturer, model);
            if (def != null && ((list = def.getPortList()).contains((Object)ManageDeviceDefinitions.PortType.LXI) || list.contains((Object)ManageDeviceDefinitions.PortType.Socket))) {
                return def;
            }
            return null;
        }

        public String getSerialAddress() {
            if (this.serialNumber == null || this.serialNumber.length() == 0) {
                return "";
            }
            return "sn:" + this.serialNumber;
        }

        public String toString() {
            return this.id;
        }
    }

    private class DeviceQuery
    extends Thread {
        private String address = null;

        public DeviceQuery(String address) {
            this.address = address;
            this.setDaemon(true);
            this.start();
        }

        private String getParam(String data, String tag) {
            int i = data.indexOf("<" + tag + ">");
            int j = data.indexOf("</" + tag + ">");
            if (i >= 0 && j > i) {
                return CharacterEscapes.fromHTML(data.substring(i + tag.length() + 2, j));
            }
            return "";
        }

        private boolean checkUrl(String path) {
            HttpURLConnection con = null;
            try {
                URL url = new URL("http://" + this.address + path);
                con = (HttpURLConnection)url.openConnection();
                con.setRequestMethod("GET");
                con.setConnectTimeout(500);
                con.setReadTimeout(500);
                con.getInputStream();
                con.connect();
                if (con.getResponseCode() >= 200 && con.getResponseCode() < 300) {
                    byte[] buffer = new byte[4000];
                    int n = con.getInputStream().read(buffer);
                    String s = new String(buffer, 0, n);
                    VXI11Discovery.this.devices.add(new Device(this.address, this.getParam(s, "Manufacturer"), this.getParam(s, "Model"), this.getParam(s, "SerialNumber"), this.getParam(s, "FirmwareRevision")));
                    return true;
                }
            }
            catch (Exception exception) {
            }
            finally {
                if (con != null) {
                    con.disconnect();
                }
            }
            return false;
        }

        @Override
        public void run() {
            block11: {
                boolean found = false;
                try {
                    found = this.checkUrl("/lxi/identification/");
                    if (!found) {
                        found = this.checkUrl("/lxi/identification");
                    }
                    if (found) break block11;
                    LXIInterface ci = null;
                    try {
                        ci = new LXIInterface(this.address);
                        try {
                            ((CommInterface)ci).open();
                            String id = ci.writeRead("*idn?", 1000);
                            if (id != null && id.length() > 0 && (id = id.trim()).split("[,]").length >= 4) {
                                VXI11Discovery.this.devices.add(new Device(this.address, id));
                            }
                        }
                        catch (Exception exception) {}
                    }
                    finally {
                        if (ci != null) {
                            ((CommInterface)ci).close();
                        }
                        VXI11Discovery.this.addressQueryInProgress.remove(this);
                    }
                }
                finally {
                    VXI11Discovery.this.addressQueryInProgress.remove(this);
                }
            }
        }
    }
}

