/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.comm;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.HidClass;
import dk.hkj.devices.LoadDeviceConfig;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.util.StringUtil;
import dk.hkj.util.ThreadGate;
import java.util.Arrays;
import org.hid4java.HidDevice;
import org.hid4java.HidManager;
import org.hid4java.HidServices;
import org.hid4java.HidServicesListener;
import org.hid4java.HidServicesSpecification;
import org.hid4java.ScanMode;
import org.hid4java.event.HidServicesEvent;

public class UsbHidInterfaceHidIO
extends HidClass
implements HidServicesListener {
    private ReaderThread rt = new ReaderThread();
    private byte[] lastData = null;
    private int packetLength = 0;
    private HidDevice hidDevice = null;

    public UsbHidInterfaceHidIO(int vendor, int product, LoadDeviceConfig.LoadDevice ld) {
        this.vendor = vendor;
        this.product = product;
        this.ld = ld;
    }

    @Override
    public ManageDeviceDefinitions.PortType getPortType() {
        return ManageDeviceDefinitions.PortType.USBHID;
    }

    @Override
    public String getName() {
        return "HIDv" + StringUtil.hex4(this.vendor) + "p" + StringUtil.hex4(this.product);
    }

    @Override
    public void open() {
        HidServicesSpecification hidServicesSpecification = new HidServicesSpecification();
        hidServicesSpecification.setAutoShutdown(true);
        hidServicesSpecification.setScanInterval(500);
        hidServicesSpecification.setPauseInterval(5000);
        hidServicesSpecification.setScanMode(ScanMode.SCAN_AT_FIXED_INTERVAL_WITH_PAUSE_AFTER_WRITE);
        HidServices hidServices = HidManager.getHidServices(hidServicesSpecification);
        hidServices.start();
        hidServices.addHidServicesListener(this);
        for (HidDevice hidDevice : hidServices.getAttachedHidDevices()) {
            if (this.debugLog) {
                this.logLog("Found HID: " + StringUtil.hex4(hidDevice.getVendorId()) + " " + StringUtil.hex4(hidDevice.getProductId()) + "  " + StringUtil.hexString(hidDevice.getSerialNumber()));
            }
            if ((hidDevice.getVendorId() & 0xFFFF) != (this.vendor & 0xFFFF) || (hidDevice.getProductId() & 0xFFFF) != (this.product & 0xFFFF)) continue;
            this.usbSerialNo = hidDevice.getSerialNumber();
            if (!this.UsbSerialMatch(this.ld)) continue;
            hidDevice.open();
            this.hidDevice = hidDevice;
            if (!this.debugLog) break;
            this.logLog("Found usb device: " + hidDevice.getPath());
            break;
        }
    }

    @Override
    public void close() {
    }

    @Override
    public byte[] writeReadData(byte[] data, int timeout) {
        byte[] d;
        if (this.rt.isReading()) {
            if (!this.rt.isTimeout()) {
                return this.lastData;
            }
            return null;
        }
        if (this.rt.hasData()) {
            this.lastData = this.rt.getData();
        }
        this.rt.requestRead(data, this.packetLength);
        if (timeout > 0 && (d = this.rt.getData(timeout)) != null) {
            this.lastData = d;
        }
        return this.lastData;
    }

    @Override
    public boolean write(String msg) {
        return false;
    }

    @Override
    public boolean isData() {
        return false;
    }

    @Override
    public String read() {
        return null;
    }

    @Override
    public String read(int timeout) {
        return null;
    }

    @Override
    public boolean isOpen() {
        return this.hidDevice != null && this.hidDevice.isOpen();
    }

    @Override
    public void hidDeviceAttached(HidServicesEvent event) {
    }

    @Override
    public void hidDeviceDetached(HidServicesEvent event) {
    }

    @Override
    public void hidFailure(HidServicesEvent event) {
    }

    @Override
    public boolean writeData(byte[] data) {
        return false;
    }

    @Override
    public byte[] readData(int timeout) {
        return null;
    }

    @Override
    public byte[] readData() {
        return null;
    }

    @Override
    public byte[] writeReadData(byte[] data) {
        return null;
    }

    @Override
    public void setPacketFormat(CommDataInterface.PacketFormat packetFormat) {
        this.packetLength = 0;
    }

    @Override
    public void setPacketFormat(CommDataInterface.PacketFormat packetFormat, int packetLength) {
        this.packetLength = packetLength;
    }

    @Override
    public void setPacketFormat(CommDataInterface.PacketFormat packetFormat, byte packetStart, int packetLength) {
        this.packetLength = packetLength;
    }

    @Override
    public void setPacketFormat(CommDataInterface.PacketFormat packetFormat, byte packetStart, byte packetStartMask, int packetLength) {
        this.packetLength = packetLength;
    }

    @Override
    public void setAnswerTimeout(int timeout) {
    }

    @Override
    public void setPacketFormat(CommDataInterface.PacketFormat packetFormat, byte[] packetStart, int packetLength) {
        this.packetLength = packetLength;
    }

    @Override
    public void setPacketFormat(CommDataInterface.PacketFormat packetFormat, byte[] packetStart, byte[] packetEnd, int count) {
        this.packetLength = 0;
    }

    private static class ReadRequest {
        int bytes;
        byte[] request;

        ReadRequest(int bytes, byte[] request) {
            this.bytes = bytes;
            this.request = request;
        }
    }

    protected class ReaderThread
    extends Thread {
        private ThreadGate<ReadRequest, byte[]> gate = new ThreadGate();
        private long startTime = 0L;
        private boolean done = false;

        public ReaderThread() {
            this.setDaemon(true);
            this.setName("USBHID Reader");
            this.start();
        }

        public byte[] getData(int timeout) {
            return this.gate.waitResult(timeout);
        }

        public boolean hasData() {
            return this.gate.isResult();
        }

        public byte[] getData() {
            return this.gate.waitResult();
        }

        public boolean isReading() {
            return this.gate.isBusy();
        }

        public boolean isTimeout() {
            return this.startTime + (long)UsbHidInterfaceHidIO.this.timeout < System.currentTimeMillis();
        }

        public boolean requestRead(byte[] data, int bytes) {
            this.gate.request(new ReadRequest(bytes, data));
            return true;
        }

        @Override
        public void run() {
            while (!this.done) {
                ReadRequest readRequest = this.gate.waitRequest();
                byte[] data = new byte[readRequest.bytes];
                try {
                    if (!UsbHidInterfaceHidIO.this.hidDevice.isOpen()) {
                        UsbHidInterfaceHidIO.this.hidDevice.open();
                    }
                    UsbHidInterfaceHidIO.this.hidDevice.setNonBlocking(false);
                    if (readRequest.request != null || readRequest.request.length > 0) {
                        UsbHidInterfaceHidIO.this.hidDevice.write(readRequest.request, readRequest.request.length, (byte)0);
                        if (UsbHidInterfaceHidIO.this.debugLog) {
                            UsbHidInterfaceHidIO.this.logLog("Tx: " + StringUtil.hexN(readRequest.request));
                        }
                    }
                    this.startTime = System.currentTimeMillis();
                    data = new byte[readRequest.bytes];
                    int n = UsbHidInterfaceHidIO.this.hidDevice.read(data, UsbHidInterfaceHidIO.this.timeout);
                    data = n < 0 ? new byte[]{} : Arrays.copyOf(data, n);
                }
                catch (Exception exception) {}
                if (UsbHidInterfaceHidIO.this.debugLog) {
                    UsbHidInterfaceHidIO.this.logLog("Rx: " + StringUtil.hexN(data));
                }
                this.gate.postResult(data);
            }
        }
    }
}

