/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.comm;

import dk.hkj.comm.CommDataInterface;
import dk.hkj.comm.HidClass;
import dk.hkj.devices.LoadDeviceConfig;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.util.ByteBuffer;
import dk.hkj.util.StringUtil;
import dk.hkj.util.ThreadGate;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.hid4java.HidDevice;
import org.hid4java.HidManager;
import org.hid4java.HidServices;
import org.hid4java.HidServicesSpecification;
import org.hid4java.ScanMode;

public class UsbHidInterfaceFile
extends HidClass {
    private final int MAX_THREADS = 100;
    private File IOFile = null;
    private ReaderThread rt = new ReaderThread();
    private byte[] lastData = null;
    private int threadCount = 0;
    private int packetLength = 0;

    @Override
    public ManageDeviceDefinitions.PortType getPortType() {
        return ManageDeviceDefinitions.PortType.USBHID;
    }

    public UsbHidInterfaceFile(int vendor, int product, LoadDeviceConfig.LoadDevice ld) {
        this.vendor = vendor;
        this.product = product;
        this.ld = ld;
    }

    @Override
    public String getName() {
        String n = this.usbSerialNoAsAddress();
        return "HIDv" + StringUtil.hex4(this.vendor) + "p" + StringUtil.hex4(this.product) + (n.length() > 0 ? "-" + n : "");
    }

    @Override
    public void open() {
        this.IOFile = null;
        HidServicesSpecification hidServicesSpecification = new HidServicesSpecification();
        hidServicesSpecification.setAutoShutdown(true);
        hidServicesSpecification.setScanInterval(500);
        hidServicesSpecification.setPauseInterval(5000);
        hidServicesSpecification.setScanMode(ScanMode.SCAN_AT_FIXED_INTERVAL_WITH_PAUSE_AFTER_WRITE);
        HidServices hidServices = HidManager.getHidServices(hidServicesSpecification);
        for (HidDevice hidDevice : hidServices.getAttachedHidDevices()) {
            if (this.debugLog) {
                this.logLog("Found HID: " + StringUtil.hex4(hidDevice.getVendorId()) + " " + StringUtil.hex4(hidDevice.getProductId()) + "  " + StringUtil.hexString(hidDevice.getSerialNumber()));
            }
            if ((hidDevice.getVendorId() & 0xFFFF) != (this.vendor & 0xFFFF) || (hidDevice.getProductId() & 0xFFFF) != (this.product & 0xFFFF)) continue;
            this.usbSerialNo = hidDevice.getSerialNumber();
            if (!this.UsbSerialMatch(this.ld)) continue;
            this.IOFile = new File(hidDevice.getPath());
            if (!this.debugLog) break;
            this.logLog("Found usb device: " + hidDevice.getPath());
            break;
        }
    }

    @Override
    public void close() {
        this.IOFile = null;
        this.rt.done = true;
    }

    @Override
    public byte[] writeReadData(byte[] data, int timeout) {
        byte[] d;
        if (this.rt.isReading()) {
            if (!this.rt.isTimeout()) {
                return this.lastData;
            }
            this.rt.done = true;
            this.log("Timeout");
            if (this.threadCount < 100) {
                this.rt = new ReaderThread();
            } else {
                return null;
            }
        }
        if (this.rt.hasData()) {
            this.lastData = this.rt.getData();
        }
        this.rt.requestRead(data, this.packetLength);
        if (timeout > 0 && (d = this.rt.getData(timeout)) != null) {
            this.lastData = d;
        }
        return this.lastData;
    }

    @Override
    public boolean write(String msg) {
        return false;
    }

    @Override
    public boolean isData() {
        return false;
    }

    @Override
    public String read() {
        return null;
    }

    @Override
    public String read(int timeout) {
        return null;
    }

    @Override
    public boolean isOpen() {
        return this.IOFile != null;
    }

    @Override
    public boolean writeData(byte[] data) {
        return false;
    }

    @Override
    public byte[] readData(int timeout) {
        byte[] d;
        if (this.rt.isReading()) {
            if (!this.rt.isTimeout()) {
                return this.lastData;
            }
            this.rt.done = true;
            this.log("Timeout");
            if (this.threadCount < 100) {
                this.rt = new ReaderThread();
            } else {
                return null;
            }
        }
        if (this.rt.hasData()) {
            this.lastData = this.rt.getData();
        }
        this.rt.requestRead(new byte[0], this.packetLength);
        if (timeout > 0 && (d = this.rt.getData(timeout)) != null) {
            this.lastData = d;
        }
        return this.lastData;
    }

    @Override
    public byte[] readData() {
        return null;
    }

    @Override
    public byte[] writeReadData(byte[] data) {
        return null;
    }

    @Override
    public void setPacketFormat(CommDataInterface.PacketFormat packetFormat) {
        this.packetLength = 0;
    }

    @Override
    public void setPacketFormat(CommDataInterface.PacketFormat packetFormat, int packetLength) {
        this.packetLength = packetLength;
    }

    @Override
    public void setPacketFormat(CommDataInterface.PacketFormat packetFormat, byte packetStart, int packetLength) {
        this.packetLength = packetLength;
    }

    @Override
    public void setPacketFormat(CommDataInterface.PacketFormat packetFormat, byte packetStart, byte packetStartMask, int packetLength) {
        this.packetLength = packetLength;
    }

    @Override
    public void setAnswerTimeout(int timeout) {
    }

    @Override
    public void setPacketFormat(CommDataInterface.PacketFormat packetFormat, byte[] packetStart, int packetLength) {
        this.packetLength = packetLength;
    }

    @Override
    public void setPacketFormat(CommDataInterface.PacketFormat packetFormat, byte[] packetStart, byte[] packetEnd, int count) {
        this.packetLength = 0;
    }

    private static class ReadRequest {
        int bytes;
        byte[] request;

        ReadRequest(int bytes, byte[] request) {
            this.bytes = bytes;
            this.request = request;
        }
    }

    class ReaderThread
    extends Thread {
        private ThreadGate<ReadRequest, byte[]> gate = new ThreadGate();
        private long startTime = 0L;
        private boolean done = false;

        public ReaderThread() {
            this.setPriority(10);
            this.setDaemon(true);
            this.setName("USBHID reader");
            this.start();
        }

        public byte[] getData(int timeout) {
            return this.gate.waitResult(timeout);
        }

        public boolean hasData() {
            return this.gate.isResult();
        }

        public byte[] getData() {
            return this.gate.waitResult();
        }

        public boolean isReading() {
            return this.gate.isBusy();
        }

        public boolean isTimeout() {
            return this.startTime + (long)UsbHidInterfaceFile.this.timeout < System.currentTimeMillis();
        }

        public boolean requestRead(byte[] data, int bytes) {
            this.gate.request(new ReadRequest(bytes, data));
            return true;
        }

        @Override
        public void run() {
            UsbHidInterfaceFile usbHidInterfaceFile = UsbHidInterfaceFile.this;
            usbHidInterfaceFile.threadCount = usbHidInterfaceFile.threadCount + 1;
            ByteBuffer bb = new ByteBuffer();
            while (!this.done) {
                FileOutputStream os;
                FileInputStream is;
                block12: {
                    ReadRequest readRequest = this.gate.waitRequest();
                    is = null;
                    os = null;
                    try {
                        is = new FileInputStream(UsbHidInterfaceFile.this.IOFile);
                        if (readRequest.request.length > 0) {
                            os = new FileOutputStream(UsbHidInterfaceFile.this.IOFile, true);
                            os.write(readRequest.request);
                            if (UsbHidInterfaceFile.this.debugLog) {
                                UsbHidInterfaceFile.this.logLog("TxHID: " + StringUtil.hexN(readRequest.request));
                            }
                        }
                        this.startTime = System.currentTimeMillis();
                        int n = 1;
                        while (bb.getSize() < readRequest.bytes && n > 0 && is != null && is.getChannel().isOpen()) {
                            byte[] buffer = new byte[readRequest.bytes];
                            n = is.read(buffer);
                            bb.append(buffer, 0, n);
                        }
                    }
                    catch (Exception exception) {
                        if (!UsbHidInterfaceFile.this.debugLog) break block12;
                        UsbHidInterfaceFile.this.logLog("Comm failed");
                    }
                }
                byte[] b = bb.getAsArray();
                bb.clear();
                if (UsbHidInterfaceFile.this.debugLog) {
                    UsbHidInterfaceFile.this.logLog("RxHID: " + StringUtil.hexN(b));
                }
                this.gate.postResult(b);
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {}
                    is = null;
                }
                if (os == null) continue;
                try {
                    os.close();
                }
                catch (IOException iOException) {}
                os = null;
            }
            UsbHidInterfaceFile usbHidInterfaceFile2 = UsbHidInterfaceFile.this;
            usbHidInterfaceFile2.threadCount = usbHidInterfaceFile2.threadCount - 1;
        }
    }
}

