/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.comm;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.util.ByteBuffer;
import dk.hkj.util.StringUtil;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.concurrent.LinkedBlockingQueue;

public class UDPInterface
extends CommInterface {
    private final int BUFFER_SIZE = 2000;
    private String address;
    private InetAddress iaddress;
    private int port;
    protected DatagramSocket socket = null;
    protected boolean lastCharWasCR = false;
    private ReaderThread readerThread = null;
    private LinkedBlockingQueue<byte[]> queue = new LinkedBlockingQueue();
    protected static int charFiller = 1000;

    public UDPInterface(String address, int port) {
        this.port = port;
        this.address = address;
        try {
            this.iaddress = InetAddress.getByName(address);
        }
        catch (UnknownHostException unknownHostException) {}
    }

    protected UDPInterface(UDPInterface si) {
        this.socket = si.socket;
        this.port = si.port;
        this.address = si.address;
        try {
            this.iaddress = InetAddress.getByName(this.address);
        }
        catch (UnknownHostException unknownHostException) {}
        this.debugLog = si.debugLog;
    }

    @Override
    public ManageDeviceDefinitions.PortType getPortType() {
        return ManageDeviceDefinitions.PortType.UDP;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public String getName() {
        return this.address;
    }

    @Override
    public void flush() {
        this.queue.clear();
    }

    @Override
    public synchronized void open() {
        try {
            this.socket = new DatagramSocket(this.port);
            this.socket.setSoTimeout(20);
            this.readerThread = new ReaderThread();
        }
        catch (IOException iOException) {
            this.close();
        }
        this.log("Open");
    }

    @Override
    public synchronized void close() {
        try {
            if (this.socket != null) {
                SerialInterface.sleep(30);
                this.socket.close();
                this.readerThread.interrupt();
                this.socket = null;
            }
        }
        catch (Exception exception) {
            this.socket = null;
        }
    }

    @Override
    public synchronized boolean write(String msg) {
        block4: {
            try {
                if (this.isOpen()) break block4;
                this.open();
                if (this.isOpen()) break block4;
                return false;
            }
            catch (IOException iOException) {
                this.close();
                return false;
            }
        }
        this.log("Tx: ", msg);
        ByteBuffer bb = new ByteBuffer();
        bb.append(msg);
        bb.append(this.eol);
        DatagramPacket p = new DatagramPacket(bb.getAsArray(), bb.getSize(), this.iaddress, this.port);
        this.socket.send(p);
        if (this.debugLog) {
            this.logLog("Tx: <" + StringUtil.printableString(String.valueOf(msg) + this.eol) + "> " + StringUtil.hexString(String.valueOf(msg) + this.eol));
        }
        return true;
    }

    @Override
    public synchronized boolean isData() {
        return this.queue.size() > 0;
    }

    @Override
    public synchronized String read() {
        return this.read(this.timeout);
    }

    @Override
    public synchronized String read(int timeout) {
        if (!this.isOpen()) {
            return null;
        }
        long finalTime = System.currentTimeMillis() + (long)timeout;
        try {
            while (finalTime > System.currentTimeMillis()) {
                if (this.isData()) {
                    byte[] b = this.queue.take();
                    String s = new String(b, "ascii");
                    this.log("Rx: ", s);
                    if (this.debugLog) {
                        this.logLog("Rx: <" + StringUtil.printableString(s) + "> " + StringUtil.hexString(s));
                    }
                    return s;
                }
                SerialInterface.sleep(1);
            }
        }
        catch (IOException | InterruptedException e) {
            this.close();
            System.out.println("  Socket read exception:");
            e.printStackTrace(System.out);
        }
        this.log("   Rx timeout " + timeout + "ms");
        if (this.debugLog) {
            this.logLog("Rx timeout " + timeout + "ms");
        }
        return null;
    }

    @Override
    public synchronized String writeRead(String msg, int timeout) {
        this.flush();
        if (!this.write(msg)) {
            return null;
        }
        String s = this.read(timeout / 2);
        if (s == null) {
            this.write(msg);
            s = this.read(timeout / 2);
            if (s == null) {
                System.out.println("Timeout, retry failed");
            }
        }
        return s;
    }

    @Override
    public synchronized boolean isOpen() {
        return this.socket != null && !this.socket.isClosed();
    }

    @Override
    public int getSerialId() {
        if (!this.isOpen()) {
            return -1;
        }
        byte[] adr = this.socket.getInetAddress().getAddress();
        long n = 0L;
        int i = 0;
        while (i < adr.length) {
            n = n * 256L + (long)adr[i];
            ++i;
        }
        return (int)(n % 100L);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " " + this.address;
    }

    private class ReaderThread
    extends Thread {
        ReaderThread() {
            this.setDaemon(true);
            this.setName("UDP reader thread " + UDPInterface.this.port);
            this.start();
        }

        @Override
        public void run() {
            while (UDPInterface.this.socket != null && !UDPInterface.this.socket.isClosed()) {
                byte[] buf = new byte[2000];
                DatagramPacket p = new DatagramPacket(buf, buf.length);
                try {
                    UDPInterface.this.socket.receive(p);
                    if (!p.getAddress().equals(UDPInterface.this.iaddress) || p.getLength() <= 0) continue;
                    UDPInterface.this.queue.put(Arrays.copyOf(buf, p.getLength()));
                }
                catch (IOException iOException) {
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

