/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.comm;

import dk.hkj.comm.SocketInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.util.StringUtil;
import java.io.IOException;

public class TelnetInterface
extends SocketInterface {
    private static final int WILL = 251;
    private static final int WONT = 252;
    private static final int DO = 253;
    private static final int DONT = 254;
    private static final int IAC = 255;

    public TelnetInterface(String address, int port) {
        super(address, port);
        System.out.println("Telnet");
    }

    @Override
    public ManageDeviceDefinitions.PortType getPortType() {
        return ManageDeviceDefinitions.PortType.Telnet;
    }

    @Override
    protected int charReader() throws IOException {
        int c = this.is.read();
        if (c == 255) {
            c = this.is.read();
            if (c == 255) {
                return 255;
            }
            switch (c) {
                case 251: 
                case 252: 
                case 253: 
                case 254: {
                    this.processCommand(c);
                    return charFiller;
                }
                case 255: {
                    return 255;
                }
            }
            System.out.println("Telnet: " + StringUtil.hex2(c));
            return charFiller;
        }
        return c;
    }

    private void processCommand(int c) throws IOException {
        int opt = this.is.read();
        System.out.println(String.valueOf(StringUtil.hex2(c)) + "  " + StringUtil.hex2(opt));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized boolean isData() {
        try {
            int c;
            while (true) {
                if (this.is.available() <= 0) {
                    return false;
                }
                c = this.charReader();
                if (c == charFiller || c == 0) continue;
                if (!this.lastCharWasCR || c != 10) break;
                this.lastCharWasCR = false;
            }
            this.bb.append((char)c);
            return true;
        }
        catch (IOException iOException) {
            this.close();
            return false;
        }
    }
}

