/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.comm;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.LayerInterface;

public class StreamingInterface
extends LayerInterface {
    private String lastMessage = "0";
    private long lastTime = 0L;
    private long rate = 0L;
    public String outputMessage = null;
    public String idnResponse = "???";

    public StreamingInterface(CommInterface ci) {
        super(ci);
    }

    @Override
    public void open() {
        super.open();
        Runnable r = new Runnable(){

            @Override
            public void run() {
                while (StreamingInterface.this.originalCommInterface.isOpen()) {
                    StreamingInterface.this.readFromSerialPort();
                }
            }
        };
        Thread t = new Thread(r);
        t.setPriority(8);
        t.start();
    }

    protected synchronized void setMessage(String msg) {
        this.lastMessage = msg;
        long t = System.currentTimeMillis();
        this.rate = t - this.lastTime;
        this.lastTime = t;
    }

    protected void readFromSerialPort() {
        try {
            this.originalCommInterface.debugLog = false;
            String data = this.originalCommInterface.read(300);
            if (data != null) {
                this.setMessage(data);
            }
        }
        catch (Exception exception) {}
    }

    protected boolean stdCommands(String msg) {
        if (msg.equalsIgnoreCase("*idn?")) {
            this.outputMessage = this.idnResponse;
            return true;
        }
        if (msg.equalsIgnoreCase("rate?")) {
            this.outputMessage = Long.toString(this.rate);
            return true;
        }
        if (msg.equalsIgnoreCase("value?")) {
            this.outputMessage = System.currentTimeMillis() - this.lastTime < 2000L ? this.lastMessage : null;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean write(String msg) {
        return this.stdCommands(msg);
    }

    @Override
    public boolean isData() {
        return this.outputMessage != null;
    }

    @Override
    public String read() {
        return this.read(300);
    }

    @Override
    public synchronized String read(int timeout) {
        String s = this.outputMessage;
        this.outputMessage = null;
        return s;
    }
}

