/*
 * Decompiled with CFR 0.152.
 */
package dk.hkj.comm;

import dk.hkj.comm.CommInterface;
import dk.hkj.comm.SerialInterface;
import dk.hkj.comm.SocketPacketInterface;
import dk.hkj.devices.ManageDeviceDefinitions;
import dk.hkj.util.ByteBuffer;
import dk.hkj.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.Socket;

public class SocketInterface
extends CommInterface {
    private final int MAX_REOPEN = 10;
    private final int MAX_TIMEOUT = 5;
    private String address;
    private int port;
    protected Socket socket = null;
    protected InputStream is = null;
    protected OutputStream os = null;
    protected ByteBuffer bb = new ByteBuffer();
    protected boolean lastCharWasCR = false;
    protected int timeoutCount = 0;
    protected int reopenCount = 0;
    protected static int charFiller = 1000;

    public SocketInterface(String address, int port) {
        this.port = port;
        this.address = address;
    }

    protected SocketInterface(SocketInterface si) {
        this.socket = si.socket;
        this.port = si.port;
        this.address = si.address;
        this.is = si.is;
        this.os = si.os;
        this.debugLog = si.debugLog;
    }

    @Override
    public ManageDeviceDefinitions.PortType getPortType() {
        return ManageDeviceDefinitions.PortType.Socket;
    }

    @Override
    public SocketPacketInterface getDataInterface() {
        SocketPacketInterface spi = new SocketPacketInterface(this);
        this.socket = null;
        return spi;
    }

    @Override
    public String getAddress() {
        return this.address;
    }

    @Override
    public String getName() {
        return this.address;
    }

    protected int charReader() throws IOException {
        return this.is.read();
    }

    private void printChar(int c) {
        System.out.print("{");
        if (c >= 32) {
            System.out.print((char)c);
        } else {
            System.out.print(StringUtil.hex2(c));
        }
        System.out.print("}");
    }

    private boolean openLocal() {
        try {
            this.socket = new Socket();
            this.socket.connect(new InetSocketAddress(this.address, this.port), 500);
            this.socket.setSoTimeout(20);
            this.is = this.socket.getInputStream();
            this.os = this.socket.getOutputStream();
        }
        catch (IOException iOException) {
            this.close();
            return false;
        }
        return true;
    }

    @Override
    public void flush() {
        try {
            this.bb.clear();
            while (this.isOpen() && this.is.available() > 0) {
                this.charReader();
            }
        }
        catch (IOException iOException) {}
    }

    @Override
    public synchronized void open() {
        if (!this.openLocal()) {
            SerialInterface.sleep(50);
            this.openLocal();
        }
        this.log("Open");
    }

    @Override
    public synchronized void close() {
        try {
            if (this.socket != null) {
                SerialInterface.sleep(30);
                this.socket.close();
                this.socket = null;
            }
        }
        catch (IOException iOException) {
            this.socket = null;
        }
    }

    @Override
    public synchronized byte[] readBin(int count, int timeout) {
        ByteBuffer bb;
        block4: {
            bb = new ByteBuffer(count);
            if (this.isOpen()) break block4;
            return null;
        }
        try {
            int n = 0;
            int oldTimeout = this.socket.getSoTimeout();
            this.socket.setSoTimeout(timeout);
            byte[] b = new byte[1000];
            do {
                n = this.is.read(b, 0, Math.min(count, b.length));
                bb.append(b, 0, n);
            } while ((count -= n) > 0 && n >= 0);
            this.socket.setSoTimeout(oldTimeout);
            return bb.getAsArray();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.close();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public synchronized byte[] writeReadBin(String msg, int count, int timeout) {
        try {
            if (!this.isOpen()) {
                if (this.reopenCount >= 10) {
                    return null;
                }
                ++this.reopenCount;
                this.open();
                if (!this.isOpen()) {
                    return null;
                }
            }
            if (msg != null) {
                this.log("Tx: ", msg);
                this.os.write(msg.getBytes(this.charset));
                if (this.debugLog) {
                    this.logLog("Tx: <" + StringUtil.printableString(msg) + "> " + StringUtil.hexString(msg));
                }
            }
            long time = System.currentTimeMillis();
            while (true) {
                if (this.is.available() >= count) {
                    byte[] b = new byte[count];
                    this.is.read(b, 0, count);
                    this.log("Rx: ", new String(b, this.charset));
                    if (this.debugLog) {
                        this.logLog("Rx: <" + StringUtil.printableString(new String(b, this.charset)) + "> " + StringUtil.hexN(b));
                    }
                    return b;
                }
                if (System.currentTimeMillis() - time > (long)timeout) {
                    return null;
                }
                SocketInterface.sleep(1);
            }
        }
        catch (IOException iOException) {
            this.close();
            return null;
        }
    }

    @Override
    public synchronized boolean writeBin(String msg) {
        block7: {
            try {
                if (this.isOpen()) break block7;
                if (this.reopenCount < 10) {
                    ++this.reopenCount;
                    this.open();
                    if (!this.isOpen()) {
                        return false;
                    }
                    break block7;
                }
                return false;
            }
            catch (IOException iOException) {
                this.close();
                return false;
            }
        }
        if (msg != null) {
            this.log("Tx: ", msg);
            this.os.write(msg.getBytes("ISO-8859-1"));
            if (this.debugLog) {
                this.logLog("Tx: <" + StringUtil.printableString(msg) + "> " + StringUtil.hexString(msg));
            }
        }
        return true;
    }

    @Override
    public synchronized boolean write(String msg) {
        block6: {
            try {
                if (this.isOpen()) break block6;
                if (this.reopenCount < 10) {
                    ++this.reopenCount;
                    this.open();
                    if (!this.isOpen()) {
                        return false;
                    }
                    break block6;
                }
                return false;
            }
            catch (IOException iOException) {
                this.close();
                return false;
            }
        }
        this.log("Tx: ", msg);
        this.os.write((String.valueOf(msg) + this.eol).getBytes(this.charset));
        if (this.debugLog) {
            this.logLog("Tx: <" + StringUtil.printableString(String.valueOf(msg) + this.eol) + "> " + StringUtil.hexString(String.valueOf(msg) + this.eol));
        }
        return true;
    }

    @Override
    public synchronized boolean isData() {
        block3: {
            try {
                if (!this.lastCharWasCR || this.is.available() <= 0) break block3;
                this.lastCharWasCR = false;
                int c = this.charReader();
                if (c == charFiller || c == 0 || c == 10) break block3;
                this.bb.append((char)c);
                return true;
            }
            catch (IOException iOException) {
                this.close();
                return false;
            }
        }
        return this.is.available() > 0;
    }

    @Override
    public synchronized String read() {
        return this.read(this.timeout);
    }

    @Override
    public synchronized String read(int timeout) {
        if (!this.isOpen()) {
            return null;
        }
        if (this.bb.getSize() == 1 && this.bb.byteAt(0) == 13) {
            this.lastCharWasCR = true;
            this.bb.clear();
            return "";
        }
        long finalTime = System.currentTimeMillis() + (long)timeout;
        try {
            while (finalTime > System.currentTimeMillis()) {
                if (this.is.available() > 0) {
                    int c = this.charReader();
                    if (c == charFiller || c == 0) continue;
                    if (c == 10 && this.lastCharWasCR) {
                        this.lastCharWasCR = false;
                        continue;
                    }
                    if (c == 13 || c == 10) {
                        this.lastCharWasCR = c == 13;
                        String s = this.bb.toString();
                        this.log("Rx: ", s);
                        if (this.debugLog) {
                            this.logLog("Rx: <" + StringUtil.printableString(s) + "> " + StringUtil.hexString(String.valueOf(s) + String.valueOf((char)c)));
                        }
                        this.bb.clear();
                        this.timeoutCount = 0;
                        this.reopenCount = 0;
                        return s;
                    }
                    this.lastCharWasCR = false;
                    this.bb.append((char)c);
                    continue;
                }
                SerialInterface.sleep(1);
            }
        }
        catch (IOException e) {
            this.close();
            System.out.println("  Socket read exception:");
            e.printStackTrace(System.out);
        }
        ++this.timeoutCount;
        if (this.timeoutCount > 5) {
            this.close();
        }
        this.log("   Rx timeout " + timeout + "ms   In buffer: " + this.bb.toString());
        if (this.debugLog) {
            this.logLog("Rx timeout " + timeout + "ms   In buffer: " + this.bb.toString());
        }
        return null;
    }

    @Override
    public synchronized boolean isOpen() {
        return this.socket != null && !this.socket.isClosed() && this.socket.isConnected() && !this.socket.isOutputShutdown() && !this.socket.isInputShutdown();
    }

    @Override
    public int getSerialId() {
        if (!this.isOpen()) {
            return -1;
        }
        byte[] adr = this.socket.getInetAddress().getAddress();
        long n = 0L;
        int i = 0;
        while (i < adr.length) {
            n = n * 256L + (long)adr[i];
            ++i;
        }
        return (int)(n % 100L);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + " " + this.address;
    }
}

